/*------------- Telecommunications & Signal Processing Lab --------------
                          McGill University
Module:
  void CAprcorr (struct Stats_F *StatsA, struct Stats_F *StatsB,
  		 struct Stats_T *StatsT)

Purpose:
  Print SNR values for two files

Description:
  This prints SNR values for two files.  Three types of SNR are printed: the
  conventional SNR, gain adjusted SNR and segmental SNR.  In addition,
  the number of differing samples and maximum difference is printed.

Parameters:
  ->  struct Stats_F *
  StatsA -       Structure containing the statistics for file A
  ->  struct Stats_F *
  StatsB -       Structure containing the statistics for file A
  ->  struct Stats_T *
  StatsB -       Structure containing the cross-statistics

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.1 $  $Date: 1994/01/16 16:33:09 $

-----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAprcorr.c 1.1 1994/01/16 AFsp-V1R2 $";

#include <math.h>		/* log10 */
#include "CompAudio.h"

#define DB(x)		(10.0 * log10 (x))

void
CAprcorr (StatsA, StatsB, StatsT)

     struct Stats_F *StatsA;
     struct Stats_F *StatsB;
     struct Stats_T *StatsT;

{
  double denom;
  double SF;
  double SNRdB;
  double SSNR;

/* Conventional SNR */
  if (StatsA->Sx2 > 0.0) {
    denom = StatsA->Sx2 - 2.0 * StatsT->Sxy + StatsB->Sx2;
    if (denom != 0.0)
      printf (" SNR      = %-8.5g dB\n", DB(StatsA->Sx2 / denom));

    /* Gain optimized SNR */
    if (StatsB->Sx2 > 0.0)
      SF = StatsT->Sxy / StatsB->Sx2;
    else
      SF = 1.0;
    denom = StatsA->Sx2 * StatsB->Sx2 - StatsT->Sxy * StatsT->Sxy;
    if (denom != 0.0) {
      SNRdB = DB ((StatsA->Sx2 * StatsB->Sx2) / denom);
      printf (" SNR      = %-8.5g dB", SNRdB);
      printf ("  (Gain factor for File B = %.5g)\n", SF);
    }
    else {
      printf (" File A = %.5g * File B\n", SF);
    }

    /* Segmental SNR */
    if (StatsT->Nseg > 0) {
      SSNR = DB (pow (10.0, (StatsT->SNRlog/StatsT->Nseg)) - 1.0);
      printf (" Seg. SNR = %-8.5g dB (16 ms segments)\n", SSNR);
    }

  }

  /* Number of differing samples */
  printf (" No. differing samples = %d", StatsT->Ndiff);
  printf (" (%d runs)\n", StatsT->Nrun);
  printf (" Max. difference = %.5g\n", StatsT->Diffmax);
}
