/*------------- Telecommunications & Signal Processing Lab -------------
                           McGill University

Module:
  void CAoptions (int argc, const char *argv, int *delayL, int *delayU,
                  char FnameA[], FnameB[])

Purpose:
  Decode options for CompAudio

Description:
  This routine decodes options for CompAudio.

Parameters:
  ->  int
  argc -	Number of command line arguments
  ->  const char * []
  argv -	Pointers to argument strings
  <-  int *
  delayL -	Starting delay
  <-  int *
  delayU -	End delay
  <-  char [MXSTRING+1]
  NHparms -	Parameters for headerless input files, default ""
  <-  char [FILENAME_MAX+1]
  FnameA -      First filename, with at most FILENAME_MAX characters
  <-  char [FILENAME_MAX+1]
  FnameB -	Second filename (can be null), with at most FILENAME_MAX
		characters

Author / revision:
  P. Kabal  Copyright (C) 1994
  $Revision: 1.11 $  $Date: 1994/02/11 01:29:15 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: CAoptions.c 1.11 1994/02/11 AFsp-V1R2 $";

#include <stdlib.h>		/* prototype for exit */
#include <stdio.h>
#include <libtsp.h>
#include "CompAudio.h"

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS	0	/* Normally in stdlib.h */
#endif

#define	NOPT	((sizeof OptTable / sizeof OptTable[0]) - 1)

/* Option tables and usage message */
static const char *nullTable[] = { NULL };
static const char *OptTable[] = {
  "-d**:", "--d*elay=*",
  "-P**:", "--p*arameters=*",
  "-h", "--h*elp",
  "-v", "--v*ersion",
  "--",
  NULL
};
static const char Usage[] = "\
Usage: %s [options] AFileA [AFileB]\n\
Options:\n\
  -d DL:DU, --delay=DL:DU       Specify a delay range.\n\
  -P PARMS, --parameters=PARMS  Parameters for headerless input files.\n\
  -h, --help                    Print this message and exit.\n\
  -v, --version                 Print the version number and exit.";

void
CAoptions (argc, argv, delayL, delayU, NHparms, FnameA, FnameB)

     int argc;
     const char *argv[];
     int *delayL;
     int *delayU;
     char NHparms[MXSTRING+1];
     char FnameA[FILENAME_MAX+1];
     char FnameB[FILENAME_MAX+1];
{
  int State;
  const char *OptArg;
  const char **optt;

  int n;
  int nF;
  int delL;
  int delU;

/* Default values */
  delL = 0;
  delU = 0;
  NHparms[0] = '\0';

/* Initialization */
  UTsetProg (PROGRAM);
  nF = 0;

/* Decode options */
  State = 0;
  optt = OptTable;
  while (1) {
    n = UTgetOption (&State, argc, argv, optt, &OptArg);
    if (n == -1)
      break;
    switch (n) {
    case 0:
      /* Filename argument */
      ++nF;
      if (nF > 2)
	UTerrorHalt ("%s: Too many filenames specified", PROGRAM);
      if (nF == 1)
	STcopyMax (OptArg, FnameA, FILENAME_MAX);
      else if (nF == 2)
	STcopyMax (OptArg, FnameB, FILENAME_MAX);
      break;
    case 1:
    case 2:
      /* Delay specification */
      if (STdecRange (OptArg, &delL, &delU) || delL > delU)
	UTerrorHalt ("%s: Invalid range specification", PROGRAM);
      break;
    case 3:
    case 4:
      /* Headerless input parameters */
      STcopyMax (OptArg, NHparms, MXSTRING);
      break;
    case NOPT-4:
    case NOPT-3:
      /* Help */
      UTwarn (Usage, PROGRAM);
      exit (EXIT_SUCCESS);
      break;
    case NOPT-2:
    case NOPT-1:
      /* Version */
      printf ("%s: %s\n", PROGRAM, VERSION);
      exit (EXIT_SUCCESS);
      break;
    case NOPT:
      /* Stop interpreting options */
      optt = nullTable;
      break;
    default:
      /* Option error */
      UTerrorHalt (Usage, PROGRAM);
      break;
    }
  }

/* Error check*/
  if (nF < 1)
    UTerrorHalt ("%s: No files specified", PROGRAM);

/* Return values */
  if (nF == 1)
    FnameB[0] = '\0';
  *delayL = delL;
  *delayU = delU;
}
