#include "nodes.h"

/*			BEST_NODE_

    The constructor sets the node's F-value to 0.

*/

BEST_NODE_::BEST_NODE_()
{
    f = 0;
}



/*			GET_F

    Return F-value of node.

*/

int BEST_NODE_::get_f() const
{
    return(f);
}


/*			SET_F

    Set F-value of node.
*/

void BEST_NODE_::set_f(int val)
{
    f = val;
}



/*                     EVAL

    Determines the order of two nodes based on their f-values, i.e., 
    if node A has got a lower f-value than node B this means that node A
    ranks before B (nodes are ordered in order of ascending f-values
    because a lower f-value means that the node is closer to the goal).

*/

int BEST_NODE_::eval(const SVOBJECT_ &other) const
{
    return(f - ((BEST_NODE_ &)other).get_f());
}
