#include "list.h"

LIST_ITERATOR_::LIST_ITERATOR_(LIST_ &li)
{
    mine = &li;
    current = li.head;
}


VOBJECT_ *LIST_ITERATOR_::getitem()
{
    return(current ? current->getdata() : NULL);
}


VOBJECT_ *LIST_ITERATOR_::getfirst()
{
    current = mine->head;
    return(current ? current->getdata() : NULL);
}
 

VOBJECT_ *LIST_ITERATOR_::getlast()
{
    current = mine->tail;
    return(current ? current->getdata() : NULL);
}
 

VOBJECT_ *LIST_ITERATOR_::getnext() 
{
    if (current == NULL || current->getnext() == NULL)
	return(NULL);

    current = current->getnext();
    return(current->getdata());
}


VOBJECT_ *LIST_ITERATOR_::getprev() 
{
    if (current == NULL || current->getprev() == NULL)
	return(NULL);

    current = current->getprev();
    return(current->getdata());
}


/*                      REMOVE

    removes the current node and moves on to the next node, or to the
    previous node if current node is the tail node of the list.

*/

void LIST_ITERATOR_::remove(int dstr)
{
    LIST_NODE_
	*tmp;

    if (!current)
	return;

    if (current == mine->tail)
	tmp = current->getprev();
    else
	tmp = current->getnext();

    mine->remove_node(current, dstr);
    current = tmp;
}

