#ifndef _list_H_
#define _list_H_

#include <stdio.h>
#include "object.h"


/*                    LIST_NODE_

    Class LIST_NODE_ defines objects that make up a linked list, it should
    be used in conjuntion with class LIST_. Class LIST_NODE_ stores data
    in the form of pointers to VOBJECT_'s. A special feature of this class
    is that the data may or may not be deleted when the LIST_NODE_ pointing
    to this data gets destroyed. This behaviour depends on the value of
    the static variable NODE_::destroy, which is set by class LIST_.

*/
     
#define DEALLOC 0
#define NODEALLOC 1

class LIST_NODE_
{
    public:
        LIST_NODE_();
        LIST_NODE_(VOBJECT_ &);
        LIST_NODE_(VOBJECT_ &, LIST_NODE_ *, LIST_NODE_ *);
        ~LIST_NODE_();
        void setdata(VOBJECT_ &);
        VOBJECT_ *getdata() const;
        void setnext(LIST_NODE_ *);
        LIST_NODE_ *getnext() const;
        void setprev(LIST_NODE_ *);
        LIST_NODE_ *getprev() const;
        static int destroy;	        // should data be deleted when
    private:				// listnode is destroyed?
        VOBJECT_ *data;			// pointer to data field
        LIST_NODE_ *next,
                   *prev;
};


/*
		    LIST_

    Class LIST_ creates an un-ordered list of (pointers to) VOBJECT_'s.
    This means that objects that are to be stored in a LIST_ object must 
    derived from class VOBJECT_.

    When objects are removed from a list (by calling, e.g, remove_head())
    they may be kept or destroyed, i.e., get deallocated. This behaviour 
    depends on the value passed to the remove_ and clear() functions, the
    default value is NODEALLOC: don't destroy the object.

    Similarly, objects may be kept or destroyed when the destructor of the
    list is called, this behaviour depends on the value that is initially
    passed to LIST_'s constructor, or on the value passed to setdestruct(int):
    DEALLOC_ON_DESTRUCT or NO_DEALLOC_ON_DESTRUCT, by default the objects
    in the list will get deallocated when LIST_'s destructor is called.

*/ 

#define DEALLOC_ON_DESTRUCT 0
#define NO_DEALLOC_ON_DESTRUCT 1

class LIST_
{
    friend class LIST_ITERATOR_;

    public:
        LIST_(int dstr = DEALLOC_ON_DESTRUCT);
		      // deallocate objects on destruct, default 
        ~LIST_();

        void addtohead(VOBJECT_ &);
        void addtotail(VOBJECT_ &);

        VOBJECT_ *gethead() const;
	VOBJECT_ *gettail() const;
	int getcount() const;
        VOBJECT_ *lookup(VOBJECT_ &);

        void remove_head(int destroy = NODEALLOC);
		       // destroy : DEALLOC = object gets deallocated
		       // NODEALLOC = don't deallocate object, default
        void remove_tail(int destroy = NODEALLOC);
        void remove_found(int destroy = NODEALLOC);
	void clear(int destroy = NODEALLOC);

	void setdestruct(int);          // get value of deallocondestr
	int getdestruct() const;	// set value of deallocondestr

    protected:         // protected because SORTEDLIST_ needs access
	void remove_node(LIST_NODE_ *, int dstr);

	LIST_NODE_ *head,
                   *tail,
                   *found;
        int nodecount,
	    deallocondestr;
};



/*
                  SORTEDLIST_

   Class SORTEDLIST_ creates an ordered list of (pointers to) SVOBJECT_ 's.
   Therefore, objects to be stored in a SORTEDLIST_ object muct be derived
   from class SVOBJECT_. Class SORTEDLIST_ is derived from class LIST_.

*/

class SORTEDLIST_ : public LIST_
{
    public:
        SORTEDLIST_(int dstr = DEALLOC_ON_DESTRUCT);
        void insert(SVOBJECT_ &);
};



/*
		  LIST_ITERATOR_

    Class LIST_ITERATOR_ iterates through the objects stored in a list.
    While walking through the list objects may be removed, by calling
    remove(), see also list.h! When an object is removed the current
    pointer of the list iterator moves on one node (or back one node if it
    is located on the last node).

*/

class LIST_ITERATOR_
{
    public:
	LIST_ITERATOR_(LIST_ &);
	VOBJECT_ *getfirst();
	VOBJECT_ *getlast();
	VOBJECT_ *getnext();
	VOBJECT_ *getprev();
	VOBJECT_ *getitem();
	void remove(int destroy = NODEALLOC);
		// remove current object and move on one node
    private:
	LIST_ *mine;
	LIST_NODE_ *current;
};

#endif
