#include "demo6.h"

PUZZLE_::PUZZLE_(PNODE_ *start, PNODE_ *target)
    :BIDEPTH_GRAPH_(start, target, 4)
{
}


PNODE_::PNODE_(const char *b, int empty_x, int empty_y)
{
    char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        *(p + i) = *(b + i);

    x = empty_x;
    y = empty_y;
}


PNODE_::PNODE_(const char *b, int old_x, int old_y, int new_x, int new_y)
{
    char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        *(p + i) = *(b + i);

    board[old_x][old_y] = board[new_x][new_y];
    board[new_x][new_y] = 0;

    x = new_x;
    y = new_y;
}


void PNODE_::display() const
{
    int
        row,
        col;

    for (row = 0; row < 3; row++)
    {
        for (col = 0; col < 3; col++)
            printf("%d ", board[row][col]);
        putchar('\n');
    }
    putchar('\n');
}


int PNODE_::equal(const VOBJECT_ &other) const
{
     if (x != ((const PNODE_ &)other).get_x()
          && y != ((const PNODE_ &)other).get_y())
            return(0);
    return(compare_board(((const PNODE_ &)other).get_board()));
}


int PNODE_::get_x() const
{
    return(x);
}


int PNODE_::get_y() const
{
    return(y);
}


const char *PNODE_::get_board() const
{
    return(*board);
}


int PNODE_::compare_board(const char *b) const
{
    const char
        *p = *board;
    int
        i;

    for (i = 0; i <= 8; i++)
        if (*(p + i) != *(b + i))
            return(0);

    return(1);
}


NODE_ *PNODE_::do_operator(int index) const
{
    switch(index)
    {
        case 0:
            return(do_left());
        case 1:
            return(do_right());
        case 2:
            return(do_up());
    }
    return(do_down());
}


PNODE_ *PNODE_::do_left() const
{
    if (!y)
        return(NULL);

    return(new PNODE_(*board, x, y, x, y - 1));
}


PNODE_ *PNODE_::do_right() const
{
    if (y == (2))
        return(NULL);

    return(new PNODE_(*board, x, y, x, y + 1));
}


PNODE_ *PNODE_::do_up() const
{
    if (!x)
        return(NULL);

    return(new PNODE_(*board, x, y, x - 1, y));
}


PNODE_ *PNODE_::do_down() const
{
    if (x == (2))
        return(NULL);

    return(new PNODE_(*board, x, y, x + 1, y));
}


int main()
{
    char
        start[3][3] = {
                        {1, 3, 4},
                        {8, 0, 2},
                        {7, 6, 5},
                      };

    char
        goal[3][3] = {
                        {1, 2, 3},
                        {8, 0, 4},
                        {7, 6, 5},
                    };

    PUZZLE_
        puzzle(new PNODE_(*start, 1, 1), new PNODE_(*goal, 1, 1));

    puzzle.generate();
    return(1);
}
