#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "graph.h"


/*                  DEMO5

    In this problem we want to find the shortest route from city
    X to city Y. Therefore, we design a class PATH_ derived from
    class UNICOST_GRAPH which performs a uniform cost search
    and consequently we need to implement function compute_g().

    Because of the nature of this problem we don't make use
    of function do_operator(), buf of expand() instead.

*/




/*		    ROUTE_

    We define a struct ROUTE_ to be able to easily store the
    'map info': pairs of cities and the distance between them.

*/

typedef struct ROUTE_
{
    char
        *from,
        *to;
    int
        distance;
} ROUTE_;



/*                    CITY_

    Class CITY_ defines objects that represent the cities that are
    visited during the search. Since we want to perform a uniform
    cost search we must derive class CITY_ from class UNI_NODE_.

*/

class CITY_ : public UNI_NODE_
{
    public:
        CITY_(const char *, int);
        const char *getcity() const;
        int getdist() const;

// implementation of virtual functions
        int equal(const VOBJECT_ &) const;
        void display() const;
        NODE_ *expand(int) const;
    private:
        const char
            *city;       // current city visited
        int
            dist;        // distance from city X, the city directly next to
                         // this city, to this city
};


class PATH_ : public UNICOST_GRAPH_
{
    public:
        PATH_(CITY_ *start, CITY_ *target);
        int compute_g(const NODE_ &);
};


