/*******************************************************************/
/*****     PCROBOTS.H - Header file for PCROBOTS.OBJ routines ******/
/*******************************************************************/
/*****         PCROBOTS was written by P.D.Smith - 1992       ******/
/*******   Email addresses : psmithb@cix.compulink.co.uk    ********/
/*******                     paul@wolf.demon.co.uk          ********/
/*******                     100023.25@compuserve.com       ********/
/*******************************************************************/

/* '#define'd values returned by 'get_local_map' */
#define ARENA_FREE  0
#define ARENA_WALL  1
#define ARENA_DAMAGE    3
#define ARENA_REFUEL    30

/* '#define'd values returned by 'get_shell_status' */
#define SHELL_MISSED   0
#define SHELL_HIT_WALL  1
#define SHELL_CLOSE_BLAST 2
#define SHELL_NEAR_MISS 3
#define SHELL_DIRECT_HIT 4

#ifdef __cplusplus
extern "C" {
#endif
void	swaptask(void);
void	movement(int speed,int angle);
int 	scan(int angle,int res,int near *range);
int   	shoot(int angle,int range);
void	get_remote_map(char far *buffer,int x,int y);

void	getxy(int near *x,int near *y);
int   	transmit(int target,int data);
int   	receive(int near *source,int near *data);
int   	damage(void);
int   	speed(void);
int   	battery(void);
long	ticks(void);
long	l_sin(int angle);
long	l_cos(int angle);
long	l_tan(int angle);
int 	l_atan(long ratio);
long	l_sqrt(long square);
void	set_pattern(const char far *pattern);
void	debug_flag(int flag_no,int flag_set);
void	buy_armour(int units);
void	buy_shells(unsigned int units);
int   	shells_left(void);
void	get_local_map(char far *buffer);
void	invisibility(int invis_flag);
int   	get_shell_status(void);
int	is_invisible(void);
int	l_atan2(int y,int x);
int     get_robot_id(void);
void    register_iff(char far *iff_str);
int     check_iff(int id);
void    register_name(char far *name_str);
int     find_name(int start_id,char far *name_str);

int 	configure(int speed, int manouevre,int range,
		  int armour,int acceleration,
		  int invisibility);

#ifdef __cplusplus
}
#endif
