;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER -*-

;;;; Indirect proof mechanism for LTRE
;;;; Version 7, 4/4/90

;;; Copyright (c) 1986, 1987, 1988, 1989, 1990 Kenneth D. Forbus, 
;;; University of Illinois, Johan de Kleer and Xerox Corporation.  
;;; All rights reserved.

;; This code exploits the assumption controller to 
;; construct indirect proofs by assuming the negation of a fact
;; and looking for a contradiction.

(proclaim '(special *LTRE*))

(defun show (fact &optional (*LTRE* *LTRE*))
  (unless (known? fact)
    (with-contradiction-handler (ltre-ltms *ltre*)
      #'(lambda (contradictions ltms &aux assumptions)
	  ltms
	  (setq assumptions (assumptions-of-clause (car contradictions)))
	  (let ((the-node (find (datum-tms-node (referent fact T))
				assumptions)))
	    (when the-node
	      (let ((status (tms-node-label the-node)))
		(retract-assumption the-node)
		(add-nogood the-node status assumptions)))))
      ;; Assume the negation
       (assuming `((not ,fact)) *LTRE* (run-rules)))
   (known? fact)))

(defun negated-form? (form)
  (and (listp form) (eq (car form) 'NOT)))

;;;; Example of indirect proof

(defun ip1 ()
  (in-ltre (create-ltre "Indirect Proof Example"))
  (assert! '(or p q) 'user)
  (assert! '(implies p r) 'user)
  (assert! '(implies q r) 'user)
  (show 'r))
