;; -*- Lisp -*-

;;;; Simple test cases for JTRE 
;;;; Version 7, 4/3/90

;;; Copyright (c) 1989, 1990 Kenneth D. Forbus, University of Illinois,
;;; Johan de Kleer and Xerox Corporation.
;;; All rights reserved.

(defun test1 ()
  (In-jtre (create-jtre "Test One"))
  (dolist (form '((rule ((:intern (foo ?x) :var ?f :test (numberp ?x))
			 (:intern (bar ?y) :var ?g :test (numberp ?y)))
			(rassert! (mumble ?x ?y) (Test-intern ?f ?g)))
		  (format t "~% :INTERN rule defined okay.")
		  (rule ((:in (foo ?x) :var ?f :test (not (numberp ?x)))
			 (:in (bar ?y) :var ?g :test (not (numberp ?y))))
			(rassert! (grumble ?x ?y) (Test-in ?f ?g)))
		  (format t "~% :IN rule defined okay.")
		  (referent '(foo 1) t)
		  (cond ((fetch '(foo 1)) (format t "~% Referent worked okay."))
			(t (error "Referent failed.")))
		  (referent '(bar 1) t)
		  (run-rules)
		  (format t "~% No errors during attempted rule execution.")
		  (cond ((fetch '(mumble 1 1)) (format t "~%:INTERN rule fired okay."))
			(t (error "~% :INTERN rule failed to fire.")))
		  (referent '(foo a) t)
		  (referent '(bar a) t)
		  (run-rules)
		  (when (some #'(lambda (fact) (in? fact))
			      (fetch '(grumble ?p ?q)))
			(format t "~%Premature triggering of :IN rule."))
		  (uassume! '(foo a) ':user)
		  (uassume! '(bar a) ':user)
		  (cond ((in? '(grumble a a)) (format t "~% :IN rule worked okay."))
			(t (format t "~%:IN rule failed to fire.")))
		  (uassume! '(foo 1) ':user)
		  (uassume! '(bar 1) ':user)
		  (unless (in? '(mumble 1 1))
			  (format t "~% Reference or JTMS failure.")))
		:OKAY)
	  (print (eval form))))
