;; -*- Lisp -*-

;;;; Blocks world rules for ATRE

(in-package "USER")

;; Copyright (c) 1986, 1987, 1988, 1989, 1990, 1991 Kenneth D. Forbus, 
;;   Northwestern University, and Johan de Kleer, Xerox Corporation.  
;; All rights reserved.

(Rule-File "BlocksWorld")

;;; First enforce constraints of the domain.

(rule :intern ((not ?fact) ?fact)  ;; The basic consistency test.
      (rnogood! :neg-def ?fact (not ?fact)))

(rule :intern ((on ?obj ?s1) :var ?f1
	       (on ?obj ?s2) :var ?f2
	       :test (not (equal ?s1 ?s2)))
      ;Something cannot be two places at once
      (rnogood! :PLACE-EXCLUSION ?f1 ?f2))

(rule :intern ((on ?obj1 ?s) :var ?f1
	       (on ?obj2 ?s) :var ?f2
	       :test (and (not (equal ?obj1 ?obj2))
			  (not (equal ?s 'TABLE))))
      ;Only one thing can be on top of a block at any time.
      (rnogood! :TOP-EXCLUSION ?f1 ?f2))

(rule :intern ((clear ?obj) :var ?f1
	       (on ?other ?obj) :var ?f2)
      ;;Something cannot be clear if something else is on top of it.
      (rnogood! :TOP-CLEAR-EXCLUSION ?f1 ?f2))

(rule :intern ((on ?a ?b) :var ?f1) ;; Base case for ABOVE
      (rassert! (above ?a ?b) (:ABOVE-BASE-CASE ?f1)))

(rule :intern ((above ?a ?b) :var ?f1
	       (above ?b ?c) :var ?f2) ;; ABOVE is transitive
      (rassert! (above ?a ?c) (:ABOVE-TRANSITIVE ?f1 ?f2)))

(rule :intern ((above ?a ?a) :var ?f1) ;; ABOVE is anti-reflexive
      (rnogood! :ABOVE-ANTIREFLEXIVE  ?f1))

(rule :intern ((above ?a ?b) :var ?f1
	       (above ?b ?a) :var ?f2) ;; ABOVE is anti-symmetric
      (rnogood! :ABOVE-ANTISYMMETRIC ?f1 ?f2))

;;;; Defining HOLDING
(rule :intern ((holding ?obj) :var ?f1
	       (clear ?obj) :var ?f2)
      ;if you are holding it then it is not clear
      (rnogood! :CLEAR-HOLDING-EXCLUSION ?f1 ?f2))

(rule :intern ((holding ?o1) :var ?f1
	       (holding ?o2) :var ?f2
	       :test (not (equal ?o1 ?o2)))
      ;; You can only hold one thing at a time
      (rnogood! :MULTIPLE-HOLD-EXCLUSION ?f1 ?f2))

(rule :intern ((holding ?obj) :var ?f1
	       (on ?other ?obj) :var ?f2)
      ; You cannot hold a block that has something on it.
      (rnogood! :SINGLE-BLOCK-HOLDING ?f1 ?f2))

(rule :intern ((holding ?obj) :var ?f1
	       (on ?obj ?other) :var ?f2)
      ;; When you are holding something, it is not on anything else.
      (rnogood! :HOLDING-IN-AIR ?f1 ?f2))

(rule :intern ((hand-empty) :var ?f1
	       (holding ?obj) :var ?f2)
      ;; Your hand isn't empty if it is holding something
      (rnogood! :EMPTY-HOLDING-MUTEX ?f1 ?f2))

;;;; Operators (from Nilsson)

(defoperator (Pickup ?x)
	     :preconditions ((on ?x Table)
			     (clear ?x)
			     (hand-empty))
	     :delete-list  ((on ?x Table)
			     (clear ?x)
			     (hand-empty))
	     :add-list ((holding ?x)))

(defoperator (Putdown ?x)
	     :preconditions ((holding ?x))
	     :delete-list ((holding ?x))
	     :add-list ((on ?x Table)
			(clear ?x)
			(hand-empty)))

(defoperator (Stack ?x ?y)
	     :preconditions ((holding ?x)
			     (clear ?y))
	     :test (not (eq ?y 'TABLE))
	     :delete-list ((holding ?x)
			   (clear ?y))
	     :add-list ((hand-empty)
			(on ?x ?y)
			(clear ?x)))

(defoperator (Unstack ?x ?y)
	     :preconditions ((hand-empty)
			     (clear ?x)
			     (on ?x ?y))
	     :test (not (eq ?y 'TABLE))
	     :delete-list ((hand-empty)
			   (clear ?x)
			   (on ?x ?y))
	     :add-list ((holding ?x)
			(clear ?y)))
