;; -*- Mode: LISP; -*-

;;;; LTRE -- a version of TRE which uses the LTMS
;;; Last edited 1/29/93, by KDF

;;; Copyright (c) 1989, 1990, 1991 Kenneth D. Forbus, Northwestern University,
;;; Johan de Kleer and Xerox Corporation.
;;; All rights reserved.

;;; See the file legal.txt for a paragraph stating scope of permission
;;; and disclaimer of warranty.  The above copyright notice and that
;;; paragraph must be included in any separate copy of this file.

(in-package :COMMON-LISP-USER)

(defvar *ltre-path*
  #+ILS "/u/bps/code/ltms/"
  #+PARC "virgo:/virgo/dekleer/bps/code/ltms/"
  #+MCL "Macintosh HD:BPS:ltms:")

(defvar *ltre-files*
  '("ltms"      ;; LTMS
    "linter"    ;; Interface
    "ldata"     ;; Database
    "lrules"    ;; Rule system
    "unify"     ;; Unifier
    "funify"    ;; Open-coding of unification
    "cwa"       ;; Closed-world assumption mechanism
    "dds"))     ;; Dependency-directed search facility

;;; The file setrule.lisp should also be compiled for efficiency.
;;; It can only be compiled after an LTRE has been created.

(defun compile-ltre ()
  (compile-load-files *ltre-files* *ltre-path*)
  (unless (and (boundp '*ltre*)
               (not (null *ltre*)))
    (create-ltre "DUMMY"))
  (compile-load-files '("setrule") *ltre-path*))

