#include <stdio.h>
#include "rng.h"

#define NUMTRIALS 250
#define NUMTESTS 9

struct params {
  char typ;
  double par1,par2,par3;
} testdat[NUMTESTS]={
  {'U',-10.0,10.0,0.0},
  {'N',15.0,2.0,0.0},
  {'L',0.0,10.e-4,3.0},
  {'E',4.0,0.0,0.0},
  {'B',5.0,1.0,0.0},
  {'B',2.0,2000.0,0.0},
  {'B',2.5,25.0,0.0},
  {'G',2.0,550.0,0.0},
  {'G',11.0,1.0,0.0}};



main()
{

  double res[NUMTESTS][NUMTRIALS];
  int datanum[NUMTESTS];
  
  register int i, j;

  setup_rng(NUMTESTS);


  for (i=0; i< NUMTESTS; i++) {
    datanum[i]=setup_distribution(testdat[i].typ,testdat[i].par1,
				  testdat[i].par2,testdat[i].par3);
    if (datanum[i]== ERROR || datanum[i] == PARAMETER_ERROR) {
      printf("test_rng: Error when called with parameters %c, %g, %g, %g\n",
	     testdat[i].typ, testdat[i].par1, testdat[i].par2,
	     testdat[i].par3);
      exit(datanum[i]);
    }
  }

  for (j=0; j < NUMTRIALS ; j++) 
    for (i=0; i < NUMTESTS; i++) 
      res[i][j] = draw_distribution(datanum[i]);
      

  for (i=0; i < NUMTESTS; i++) {
    printf("\nDistribution %c, %g, %g, %g\n", testdat[i].typ,
	   testdat[i].par1, testdat[i].par2, testdat[i].par3);

    for (j=0; j < NUMTRIALS; j++) {
      if (j % 6 == 5 ) printf("%g\n", res[i][j]);
      else printf("%g  ", res[i][j]);
    }
    printf("\n\n");
  }

  exit(2);

}
