/* Header file describing calling sequences for rng package */

/* Copyright 1989 Russell G. Almond
   License is granted to copy this program for education or research
   purposes, with the restriction that no portion of this program may
   be copied without also copying this notice.  All other rights
   reserved.  */
 

#define RNG()		(random()/((double) 0x7FFFFFFF))
				/* uses C library rather than lisp */
				/* function, this could be change at */
				/* more overhead cost.  My guess is */
				/* that most lisps use the system */
				/* random number generator anyway. */
#define ERROR 		-1
#define PARAMETER_ERROR -2
#define OK		 0


extern int setup_rng();		/* (num_dist) */
/* int num_dist; */

extern int cleanup_rng();

				/* setup_distribution */
/* This takes 4 arguments.  The first is a distribution type */
 /* represented by a character, the remaning three are assumed to be */
 /* parameters of the distribution.  One or more of the parameters may */
 /* be ignored depending on the distribution type. It returns an index */
 /* into the RNG_TABLE of the address of its distribution description */
 /* block.  */
/* Note, there is not necessarily a one to one correspondence between */
 /* the distribution type and the drawing and setup function for that */
 /* method.  The setup_distribution function selects drawing methods */
 /* based on the parameters. */
/* Currently supported types and drawing methods: */
 /* U -- draw_uniform (2 parameters) */
 /* N -- draw_normal (2 parameters) */
 /* L -- draw_lognormal (3? parameters) */
 /* E -- draw_exponential (1 parameter) */
 /* B -- draw_beta1 (2 parameters) -- either parameter equals 1 */
 /* B -- draw_betain (2 parameters) -- one parameter is an interger */
 /* less than GAMMA_METHOD_MAX, the other is bigger than BETA_METHOD_MIN */
 /* B -- draw_beta (2 parameters) -- otherwise */
 /* G -- draw_gammai (2 paramters) -- first parameter is an integer */
 /* less than GAMMA_METHOD_MAX */
 /* G -- draw_gamma (2 paramters) -- otherwise */
extern int setup_distribution(); /* (typ, par1, par2, par3) */
/* char typ; */
/* double par1, par2, par3; */

extern double draw_distribution(); /* (dist_num) */
/* int dist_num; */

