;;; search.lisp -- more functions for manipulating graphs and hyper graphs
;;; 
;;; Theses are functions for manipulating graphs and hyper graphs in a
;;; way that is useful in belief functions.
;;;
;;; Copyright 1986 Russell G. Almond
;;; License is granted to copy this program for education or research
;;; purposes, with the restriction that no portion of this program may
;;; be copied without also copying this notice.  All other rights
;;; reserved. 


;;; 2/25/92 Essentially abandoned for version 1.2 and no documentation
;;; has been provided.  Basically, those parts of it which work have
;;; been moved to graphs and the remaining code is in unknown
;;; condition.  That which looks to be worthwhile will be ported over
;;; to Graf. --- RGA

;(provide 'search)
(in-package :graphs)
(bel-require :structures "structures")
(bel-require :graphs "graphs")
;(use-package '(basic sets))
;(export '(mc-search count-neighbors one-step test-list
;		    one-ff one-sc-tff one-ff-tsc
;		    find-goal a*-do full-graphp
;		    a*-pause *open* *close* expand-state ucost
;		    make-decision-state clean-list full-graphp
;		    decision-state-deleted decision-state-size
;		    decision-state-graph decision-state-cost-to-go
;		    lex-m))
;;; requires that the function "node-size" be imported.

;;; This is a version of layered list especially designed for testing
;;; deletion order programs.
(defun test-list (core-routine graph)
  (declare (function  core-routine (graph) list)
	   (type graph graph))
  (let ((leaves (remove-if-not #'(lambda (#1=#:x) (leaf-p #1# graph))
			      (graph-nodes graph))))
    (cond ((null (graph-nodes graph)) nil)
	  ((null leaves) (apply core-routine (list graph)))
	  (t (append leaves (test-list core-routine
			     (s-delete-list leaves graph)))))))


;;; MC-search -- maximum cardinality search as described in Lauritzen
;;; and Spiegelhalter.  This takes a graph and returns a maximum
;;; cardinatlity deletion order.
(defun mc-search (graph)
  (declare (type graph graph))
  (mc-search-aux (list (car (graph-nodes graph)))
		 (cdr (graph-nodes graph))
		 graph))

;;; mc-search-aux -- preforms mc-search by recursion
(defun mc-search-aux (labeled-nodes unlabeled-nodes graph)
  (declare (list labeled-nodes) (list unlabeled-nodes)
	   (type graph graph))
  (if (null unlabeled-nodes) labeled-nodes
    (let* ((most-neighbors
	    (apply #'max (mapcar #'(lambda (#1=#:x)
				     (count-neighbors #1# labeled-nodes graph))
				 unlabeled-nodes)))
	   (next-el
	    (find-if #'(lambda (#1#)
			 (eql most-neighbors
			      (count-neighbors #1# labeled-nodes graph)))
		     unlabeled-nodes)))
      (mc-search-aux (cons next-el labeled-nodes)
		     (remove next-el unlabeled-nodes :test #'equal)
		     graph))))

		 

;;; count-neighbors -- count the labeled neighbors of a graph
(defun count-neighbors (node labeled graph)
  (declare (list labeled) (type graph graph))
  (let ((n-list (neighbors node graph)))
    (count-if #'(lambda (#1=#:x) (member #1# n-list :test #'equal)) labeled)))



;;; one-step -- finds core by one-step look ahead method (smallest cliques)
(defun one-step (graph)
  (declare (type graph graph))
  (if (null (graph-nodes graph)) nil
    (let* ((smallest-clique
	    (reduce #'min (mapcar #'(lambda (node)
				      (node-size (closure node graph)))
				  (graph-nodes graph))))
	   (next-deletion
	    (find-if #'(lambda (#1=#:x)
			 (eql smallest-clique
			      (node-size (closure #1# graph))))
		     (graph-nodes graph))))
;;      (print smallest-clique)
;;      (print (remove-if-not
;;	      #'(lambda (#1#)
;;		  (eql smallest-clique (node-size (closure #1# graph))))
;;	      (graph-nodes graph)))
;;      (terpri)
      (cons next-deletion (test-list #'one-step (r-delete next-deletion graph))))))


;;; one-ff -- finds core by one-step (fewest fill-ins) method
(defun one-ff (graph)
  (declare (type graph graph))
  (if (null (graph-nodes graph)) nil
    (let* ((fewest-fillins
	    (reduce #'min
		    (mapcar #'(lambda (nod)
				(length (fill-ins nod graph)))
			     (graph-nodes graph))))
	   (next-deletion
	    (find-if #'(lambda (nod)
			 (eql fewest-fillins
			      (length (fill-ins nod graph))))
		     (graph-nodes graph))))
;;      (print fewest-fillins)
;;      (print (remove-if-not
;;	      #'(lambda (nod)
;;		  (eql fewest-fillins (length (fill-ins nod graph))))
;;	      (graph-nodes graph)))
;;      (terpri)
      (cons next-deletion (test-list #'one-ff (r-delete next-deletion graph))))))


;;; fill-ins -- find the list of fill-ins corresponding to selecting a
;;; point in a graph.
(defun fill-ins (node graph)
  (declare (type graph graph))
  (remove-if #'(lambda (#1=#:x) (member #1# (graph-edges graph) :test #'equal))
	     (reduce-edge (neighbors node graph))))

;;; one-ff-tsc -- finds core by one-step (fewest fill-ins) method
;;; ties broken by smallest cliques size
(defun one-ff-tsc (graph)
  (declare (type graph graph))
  (if (null (graph-nodes graph)) nil
    (let* ((fewest-fillins
	     (reduce #'min
		     (mapcar #'(lambda (nod)
				 (length (fill-ins nod graph)))
			     (graph-nodes graph))))
	   (possible-deletions
	    (remove-if-not #'(lambda (nod)
			       (eql fewest-fillins
				    (length (fill-ins nod graph))))
			   (graph-nodes graph)))
	   (smallest-clique
	    (reduce #'min (mapcar #'(lambda (node)
				      (node-size (closure node graph)))
				  possible-deletions)))
	   (next-deletion
	    (find-if #'(lambda (#1=#:x)
			 (eql smallest-clique
			      (node-size (closure #1# graph))))
		     possible-deletions)))	   
;;      (print fewest-fillins)
;;      (print possible-deletions)
;;      (print smallest-clique)
;;      (print next-deletion)	   
;;      (terpri)
      (cons next-deletion (test-list #'one-ff-tsc (r-delete next-deletion graph))))))


;;; one-sc-tff -- finds core by one-step (smallest clique) method
;;; ties broken by fewest-fill-ins.
(defun one-sc-tff (graph)
  (declare (type graph graph))
  (if (null (graph-nodes graph)) nil
    (let* ((smallest-clique
	    (reduce #'min (mapcar #'(lambda (node)
				      (node-size (closure node graph)))
				  (graph-nodes graph))))
	   (possible-deletions
	    (remove-if-not #'(lambda (#1=#:x)
			       (eql smallest-clique
				    (node-size (closure #1# graph))))
			   (graph-nodes graph)))
	   (fewest-fillins
	    (reduce #'min
		    (mapcar #'(lambda (nod)
				(length (fill-ins nod graph)))
			    possible-deletions)))
	   (next-deletion
	    (find-if #'(lambda (nod)
			 (eql fewest-fillins
			      (length (fill-ins nod graph))))
		     possible-deletions))
	   )
;;      (print smallest-clique)
;;      (print possible-deletions)
;;      (print fewest-fillins)
;;      (print next-deletion)	   
;;      (terpri)
      (cons next-deletion (test-list #'one-sc-tff (r-delete next-deletion graph))))))


;;; A* - search (This finds the minimum cost tree)

;;; decision-state --  This is the state information for a branch
;;; point of a A* search
(defstruct decision-state
  (deleted nil :type list)
  (graph (make-graph) :type graph)
  (size 0 :type fixnum)
  (cost-to-go 0 :type fixnum))


(defvar *open* nil)
(defvar *close* nil)

;;; a*-do -- This program sets up and runs the a* deletion order
;;; It accepts one argument, the graph with which it is to start
(defun a*-do (graph)
  (declare (type graph graph) (special *open*) (special *close*))
  (setq *close* nil)
  (setq *open* (list (make-decision-state :deleted nil
					  :graph graph
					  :size 0
					  :cost-to-go (ucost graph)))
	)
  (find-goal))



;;; find-goal -- This program does the main a* loop
;;; The algorithm works as follows:
;;;  1) Set up OPEN and CLOSE
;;;  2) Loop
;;;     2a) If open is empty, end with failure
;;;         If the car of OPEN is complete, end with success
;;;     2b) Remove the First node from open, Expand that node
;;;         add its succesors to open
(defun find-goal ( &aux (a*-pause nil))
  (declare (special *open*) (special *close*) (special a*-pause))
  (LOOP (princ "Expanding first node on list") (terpri)
	(princ (car *open*)) (terpri)
	(cond ((null *open*) (return nil))
	      (a*-pause (princ "Stop for checkpoint: (find-goal) continues")
			(terpri) (return nil))
	      ((null (graph-nodes (decision-state-graph (car *open*))))
	       (return (reverse (decision-state-deleted (car *open*))))))
	(setq *open* (delete-duplicates
		      (merge 'list (clean-list (expand-state (car *open*)))
			     (cdr *open*)
			     #'< :key #'(lambda (#1=#:x)
					  (+ (decision-state-size #1#)
					     (decision-state-cost-to-go #1#))))
		      :key #'decision-state-deleted :test #'equal-set))
	))



;;; clean-list --- this function removes duplicates from the open or
;;; new element list as appropriate
(defun clean-list (new)
  (declare (list new) (special *close*))
  (cond ((endp new) nil)
	((and (member (decision-state-deleted (car new))
		      *close* :test #'equal-set
		      :key #'decision-state-deleted)
	      (not (< (decision-state-size (car new))
		      (decision-state-size
		       (find (decision-state-deleted (car new))
			     *close* :test #'equal-set
			     :key #'decision-state-deleted)))))
	 (clean-list (cdr new)))
	(t (cons (car new) (clean-list (cdr new))))))


;;; expand-state -- this function expands a decision state into a list
;;; of new decision states.
(defun expand-state (state)
  (declare (type decision-state state) (special *close*))
  (push state *close*)
  (if (full-graphp (decision-state-graph state))
      (list (make-decision-state
	     :deleted (append (graph-nodes (decision-state-graph state))
			      (decision-state-deleted state))
	     :graph (make-graph)
	     :size (+ (decision-state-size state)
		      (ash 1 (node-size
			      (closure (car (graph-nodes
					     (decision-state-graph state)))
				       (decision-state-graph state)))))
	     :cost-to-go 0))
    (sort 
     (mapcar #'(lambda (node)
		 (let ((rgraph (r-delete node (decision-state-graph state))))
		   (make-decision-state
		    :deleted (cons node (decision-state-deleted state))
		    :graph rgraph
		    :size (+ (decision-state-size state)
			     (ash 1  (node-size
				      (closure node
					       (decision-state-graph state)))))
		    :cost-to-go (ucost rgraph)
		    )))
	     (graph-nodes (decision-state-graph state)))
     #'< :key #'(lambda (st) (+ (decision-state-size st)
				(decision-state-cost-to-go st))))))




;;; ucost -- This function returns an underestimate of the cost to go
;;; based on the number of nodes left.
(defun ucost (graph)
  (declare (type graph graph))
  (do ((clist (sort (mapcar #'(lambda (node)
			   (length (closure node graph)))
		       (graph-nodes graph))
		     #'< )
	       (cdr clist))
	(cost 0))
       ((>= (car clist) (length clist))
	(+ cost (ash 1 (ash 1 (length clist)))))
       (setq cost  (+ cost (ash 1 (ash 1 (car clist)))))))

  


;;; FULL-GRAPHP -- this function tests a graph to see if it is
;;; complete (i.e., all nodes connected).
(defun full-graphp (graph)
  (declare (type graph graph))
  (let ((n (length (graph-nodes graph))))
    (= (* n (1- n) 1/2) (length (remove-duplicates
				 (mapcan #'reduce-edge (graph-edges graph))
				 :test #'equal)))))

    
		     



	
	       
;|*
;  	((not (member (decision-state-deleted (car new))
;		      open :test #'equal-set
;		      :key #'decision-state-deleted))
;	 (cons (car new) (clean-list (cdr new) open)))
;	((< (decision-state-size (car new)) ;if new node is better path
;	    (decision-state-size (find (decision-state-deleted (car new))
;				       open :test #'equal-set
;				       :key #'decision-state-deleted)))
;	 (cons (car new) (clean-list (cdr new)
;				     (remove (decision-state-deleted (car new))
;					     open :test #'equal-set
;					     :key #'decision-state-deleted))))
;
;*|


;;; LEX-M --This reproduces the lex-m routine from Rose, Tarjan and
;;; Lueker
;;; This routine sets up special variables and calls lex-m-aux which
;;; is tail recursive.
(defun lex-m (graph &aux *adj*)
  (declare (special *adj*))		;reproduces adjecency tables
  (map nil #'(lambda (node)
	       (setf (get node :lex-label) 1)
	       (setf (get '*adj* node) (neighbors node graph)))
	(graph-nodes graph))
  (lex-m-aux 1 (graph-nodes graph)))


;;; lex-m-aux -- This routine does the main loop of the lex-m
;;; algorithm.  It accepts two arguments, the number k (which is the
;;; maximum label) and the list of nodes in the graph.  The graphical
;;; structure is implicitly stored in the adjacency matrix, *adj*.
;;; It first selects a node to delete (nu-node) and then re-assigns
;;; labels based on the procedure described in Rose et al.
(defun lex-m-aux (k node-list &aux reach)
  (declare (number k) (list node-list))
  ;;select
  (if (eql (length node-list) 1) node-list ;base case
    (let* ((nu-node (car node-list))
	   (other-nodes (remove nu-node node-list)))
      (map nil #'(lambda (node) (setf (get node :lex-reached) nil))
	    other-nodes)
      (setq reach (gensym "R"))		;initializes reach for this level
      (map nil #'(lambda (w-node)
		   (setf (get '*adj* w-node)
			 (remove nu-node (get '*adj* w-node)))
		   (push w-node (get reach (get w-node :lex-label)))
		   (setf (get w-node :lex-reached) t)
		   (incf (get w-node :lex-label) .5))
	    (get '*adj* nu-node))
      ;;search
      (dotimes (j (1+ k))
	 (loop (unless (get reach j) (return))
	    (let ((w-node (pop (get reach j))))
	      (map nil
	       #'(lambda (z-node)
		   (unless (get z-node :lex-reached)
		       (setf (get z-node :lex-reached) t)
		       (if (> (get z-node :lex-label) j)
			   (progn
			     (push z-node (get reach
					       (get z-node :lex-label)))
			     (incf (get z-node :lex-label) .5))
			 (push z-node (get reach j)))))
	       (get '*adj* w-node)))))
      ;;sort 
      (cons nu-node
	    (apply #'lex-m-aux (lex-m-sort k other-nodes))))))



		      
    
;;; lex-m-sort -- sorts and re-labels the nodes.
;;; returns a list consisting of the maximum new label and the nodes
;;; in label order.
(defun lex-m-sort (k node-list)
  (declare (number k) (list node-list))
  (if (zerop k) (list 0 nil)
    (let* ((other-nodes			;sub-list containing nodes
					;labeled <k
	    (member (find k node-list :test #'>
			  :key #'(lambda (#1=#:x) (get #1# :lex-label)))
		    node-list))		
	   (k-nodes (ldiff node-list other-nodes))
	   (h-nodes (remove-if #'(lambda (#1#)
				   (= k (get #1# :lex-label)))
			       k-nodes)) 
	   (l-nodes (delete-if-not #'(lambda (#1#)
				       (= k (get #1# :lex-label)))
				   k-nodes))
	   (recursive-call (lex-m-sort (1- k) other-nodes))
	   (l-value (if l-nodes (1+ (car recursive-call))
		      (car recursive-call)))
	   (h-value (if h-nodes (1+ l-value) l-value)))
      (list h-value
	    (append (mapc #'(lambda (#1#) (setf (get #1# :lex-label) h-value))
			  h-nodes)
		    (mapc #'(lambda (#1#) (setf (get #1# :lex-label) l-value))
			  l-nodes)
		    (cadr recursive-call))))))
;;; provide when loaded
(bel-provide :search)