;;; Script for building manual pages.  Requires JAM's definitions
;;; stuff.  


; load BELIEF pacakage
;(load-belief-package :belief t :nuke t :belq t)
;(load-belief-package :prob t :nuke t)

; load definitions
;(load "/belgica-2g/jam/az/definitions/load")
;(load "/belgica-2g/almond/definitions/print")


(defparameter *belief-files* '("arithmatic" "belief-init"
			       "belief-package" "belq" "bymachine"
			       "computations" "distbel" "distprob"
			       "franzinit" "graphs" "lowdist"
			       "lowread" "monte" "potentials"
			       "probread" "read" "readnuke" "search"
			       "sets" "structures" "utils"))

(defparameter *defs* (df:read-definitions-from-files *belief-files*))

(df:print-definitions
 (sort (remove-if-not #'df:exported-definition? *defs*)
       #'df:definition-alpha<)
 "belief-ref-manual.tex")



(df:print-definitions
 (sort
  (remove-if-not #'(lambda (d)
		     (and (df:exported-definition? d)
			  (typep d '(or df:global-variable-definition
				     df:package-definition
				     df:macro-definition
				     df:Generic-Function-Definition
				     df:Function-Definition
				     df:User-Type-Definition))))
		 *defs*)
  #'df:definition-alpha<)
 "belief-user-manual.tex")

;(defparameter *cb1*
;     (br::make-class-browser
;      (cons (find-class 'df:Definition) (az:all-subclasses 'df:Definition))
;      :slate (slate:make-slate :width 820 :height 732
;			       :left 320 :top 150
;			       :backing-store :always)))

