

;;; add these function to your own lisp-init file to auto-load the
;;; belief packages when you call (load-bel <filename>)

;;; This contains the home of the BELIEF package code
(defvar bel-home
;    (make-pathname			; :host "hustat" :device "xy0d"
;				:directory :root "beglica-2g" "almond"
;						 "belief1.2" "lisp")
;		                :directory "~almond/belief1.2/lisp/"
;				; :type "lisp"
;				))
    #p"/thyme/users/almond/belief1.2/lisp/"
    "Location to search for belief function code")
;;; note change type to "lisp" or "bin" to use uncompiled or compiled
;;; under default conditions files respectively.  


;;; New declaration to exploit az:documentation stuff.  
;;; For use with the az definitions package we define a declaration
;;; specifier :returns which produces declarations for the return of a
;;; function 
(declaim (declaration :returns))


;;; Provide and require mechanism: no longer standard in X13J3 Common
;;; Lisp.  We provide our own.
(defvar *belief-modules* nil "Modules of the belief package")

;; in the provide mechanism, if something has been reloaded
;; (redefiend) everything after it should be reloaded to make sure all
;; pointers are correct (this is true with xlisp object system, and
;; I'm not sure what all else).  Setting optional arguement (noreload)
;; to true cancels this feature.  
(defun bel-provide (tag &optional (noreload t))
  (declare (type (or Symbol String) tag) (type (member T NIL) noreload)
	   (:returns (type LIST *belief-modules*)))
  "Works like provide only (1) uses *belief-modules* instead of
*modules* and (2) if noreload is nil, strips later read files off of
*beleief-modules*  so any dependent file is re-read"
  (let ((tail (member tag *belief-modules* :test #'equal)))
    (if tail (setq *belief-modules* (if noreload *belief-modules* tail))
      (push tag *belief-modules*))))

(defun bel-require (tag &optional file-name)
  (declare (type (or Symbol String) tag)
	   (type (or Pathname String) file-name)
	   (:returns (type (member T NIL))))
  "Behaves like require (CLTL-1) only:  (1) uses list *belief-modules*
and (2) merges pathname with variable bel::home."
  (unless (member tag *belief-modules*)
	  (load (merge-pathnames
		 (if file-name file-name
		   (if (symbolp tag) (symbol-name tag)
		     tag))
		 user::bel-home))))


;;; now can load required files, in particular, package definitions.

(bel-require :belief-package "belief-package")
(bel-require :belief-init "belief-init")

;;; Set up [] and {} as matching parenthesis (for constructing ps-sets
;;; and other nested lists.


;; read-match, reads to the next matching closing parenthesis ),], or}
;; respectively.  
(defun read-match (stream char)
   (declare (type Stream stream) (type Character char)
	     (:returns (type List)))
   "closing paren sensitive list reader."
   (read-delimited-list (case char (#\( #\)) (#\[ #\]) (#\{ #\}))
			stream t))

;; set up {} and [] as macro characters
(set-macro-character #\{ #'read-match nil)
(set-macro-character #\} (get-macro-character #\)))
(set-macro-character #\[ #'read-match nil)
(set-macro-character #\] (get-macro-character #\)))




(defvar *belief-format* t		;defaults to belief format
  "Should belief functions (t) or potentials (nil) be used as a default")




;;; load-belief-package
;;; auto-loading function loads various parts of the belief package.
;;; If neither :belief nor :prob is specified, :belief is loaded by
;;; default.  The function :belq causes the user package to use the
;;; belief package, and may cause strange results when switching back
;;; and forth between belief and prob modes.
;; This should be wrapped in a (eval-when (compile load eval))
(defun load-belief-package (&key belief prob belq cost search nuke clay)
  (declare (type (member T NIL) belief prob belq cost search nuke clay)
	   (:returns (type (member T NIL))))
  "Loads various modules of the belief package:
	:belief, :prob --- belief and probability mode.  If neither is
set, then :belief is loaded by default.  To load both you must
explicitly set both to T.
	:belq --- belief function Mobius xform and alternate
representations
	:cost --- unimplimented stuff for utilities/costs
	:search --- alternative strategies for building tree of
cliques
	:nuke --- 2nd order belief function and poisson models for
risk assessment problems, including Monte Carlo stuff.
	:clay --- prototype link to jam's az graphical display tools.
 (Not distributed)"
  (if (and (null belief) (null prob)) (setq belief t))
  (when prob (bel-require :probread "probread")
	(when nuke (bel-require :distprob "distprob"))
	(setq *belief-format* nil))
  (when belief (bel-require :read "read")
	(when nuke (bel-require :distbel "distbel"))
	(setq *belief-format* t))
  (bel-require :computations "computations")
  (when belq (bel-require :belp "belq")
	(mode:bel-mode 'user))
  (if search (bel-require :search "search"))
  (if cost (bel-require :cost "cost"))
  (when nuke (bel-require :readnuke "readnuke")
	(bel-require :monte "monte"))
  (when clay (bel-require :clayjam "../clay/load")
	(bel-require :claybel "../clay/claybel"))
  (use-package '(shell basic graphs inherited subshell)))

;;; These constants are used by the basic package to initialize the
;;; size of the hash table
;;; Global constants -- later versions should query for these
(in-package :basic)
(defparameter *maxvars* 5 "Maximum number of variables to combine over")
(defparameter *maxvals* 2 "Maximum number of values taken on by one variable")
(in-package :user)

;;; load-functions for data bases.

;; load-bel load a belief function data base (in belief mode)
(defun load-bel (filename &key nuke clay)
  (declare (type (or Pathname String) filename)
	   (type (member T NIL) nuke clay))
  "Loads rule bases after first loading belief package (belief mode) stuff.  
	:nuke --- also load monte carlo stuff for risk assessment
	:clay --- also load connection to JAM's az graph display (not
supported or distributed)."
  (load-belief-package :belief t :nuke nuke :clay clay)
  (load filename)
  (princ "Functions: do-it redo-it undo-it ppnode ppmessages ppval ppall")
  (terpri))



;; load-prob load data base in prob mode.
(defun load-prob (filename &key nuke clay)
  (declare (type (or Pathname String) filename)
	   (type (member T NIL) nuke clay))
  "Loads rule bases after first loading belief package (prob mode) stuff.  
	:nuke --- also load monte carlo stuff for risk assessment
	:clay --- also load connection to JAM's az graph display (not
supported or distributed)."
  (load-belief-package :belief nil :prob t :nuke nuke :clay clay)
  (load filename)
  (princ "Functions: do-it redo-it undo-it ppnode ppmessages ppval ppall")
  (terpri))

;;; low probabilities, use long precision
(setq *read-default-float-format* 'long-float)


;;; Random state setting routine.  This "randomly" initializes the
;;; random state. 
;;; See Steele, Section 12.9 for information on how to use a fixed
;;; seed
(setq *random-state* (make-random-state t))

;;; kludge for read-macros in Franz (Extended) Common Lisp


(if  nil ;(equal "Allegro CL" (lisp-implementation-type))
(defun franz-kludge ()
    "Sets read macro characters; workaround for Allegro CL multiple tables"
	(set-macro-character #\{ #'read-match nil)
	(set-macro-character #\} (get-macro-character #\)))
	(set-macro-character #\[ #'read-match nil)
	(set-macro-character #\] (get-macro-character #\)))
	(set-dispatch-macro-character #\# #\? #'will::|#?-reader|)
	(set-dispatch-macro-character #\# #\! #'will::|#!-reader|))
;else (ordinary lisps)
(defun franz-kludge () ))

