
;;; Copyright 1992 Russell G. Almond
;;; License is granted to copy this program for education or research
;;; purposes, with the restriction that no portion of this program may
;;; be copied without also copying this notice.  All other rights
;;; reserved. 

;;; Franz Allegro interface


(cltl1:require :foreign)

;;; Allegro doesn't map '-' to '_' when doing name conversion.
;;; Produce a new version of convert-to-lang which does.
(defun convert-to-lang (sym &key (language :c))
  (declare (type Symbol sym) (type (member :c :fortran) language)
	   (:returns (type String sym-name)))
  "Converts lisp name to c name substituting '_' for '-'"
  (ff:convert-to-lang (string-downcase (substitute #\_ #\-
						   (symbol-name sym)
						   :test #'char-equal))
		      :language language))
;;; Note: Allegro requires that the function be loaded before it is
;;; defined. 

(load (namestring (merge-pathnames "../rng.o" user::bel-home))
      :system-libraries '("m"))


;; setup-rng
(ff:defforeign 'setup-rng :language :c :return-type :integer
	    :arguments '(integer) :convert-symbol #'convert-to-lang)

;; cleanup-rng
(ff:defforeign 'cleanup-rng :language :c :return-type :integer
	       :convert-symbol #'convert-to-lang )

;; setup-distribution
(ff:defforeign 'setup-distribution :language :c
	    :return-type :integer
  :arguments '(character double-float double-float double-float)
  :convert-symbol #'convert-to-lang) 



;; draw-distribution
(ff:defforeign 'draw-distribution :language :c
	    :return-type :double-float :arguments '(fixnum)
	    :convert-symbol #'convert-to-lang )

(defmacro protected-eval (form)
  "Protected evalution:  needed in every lisp."
  `(excl:errorset ,form t))


;; End of Allegro definitions
(bel-provide :byAllegro)


