;;; belief-package.lisp --- package junk for the belief package.

;;; Copyright 1991 Russell G. Almond
;;; License is granted to copy this program for education or research
;;; purposes, with the restriction that no portion of this program may
;;; be copied without also copying this notice.  All other rights
;;; reserved. 


;;; Damn Steele anyway!  
;;; Well, due to X13J3 standards, the package
;;; system for common lisp has been compeletely re-written.
;;; This file collects all of the package specifications in one place,
;;; which is probably just as well because it defines important things
;;; about the structure of the program that may be useful to know.  


;;; Furthermore the provide/require mechanism has been completely
;;; re-written.  This file defines a belief package specific
;;; provide/require called bel-provide and bel-require.  This is
;;; probably just as well because we would like belief package loading
;;; to be isolated from other package loading.

;;; 2/22/92 --- Trying to add CMU lisp compatability.  CMU lisp does
;;; not conform to X13J3 standards on names for "common-lisp" and
;;; "common-lisp-user" packages.  Added switches to take care of that.
;;; Also, CMU lisp signals an error if the same symbol appears twice
;;; in a :export description.  I've therefore commented out all
;;; duplicate references.  This make take some twiddling for people
;;; who only want a subset of the material.


;;; MORE ABOUT THE COMMON LISP PACKAGE SYSTEM THAN MAN WAS MEANT TO
;;; KNOW.  One important thing to remember about the package system is
;;; that a symbol's package is determined at read time, not eval time.
;;; That means that changing the package use list only affect new
;;; forms read in, not forms already bound in function definitions.
;;; Thus if you change the usage of the shell package from :bel to
;;; :prob this will only effect newly defined (or redefined)
;;; functions, not older existing functions.  

;;Backwards compatability.  To conform to earlier versions of Common
;;LISP (1984) standard, a defpackage macro must be explicitly defined.
;;A publicly available version is available in
;;borrowed/defpackage.lisp


;;;;;;;;;; ****  Modes **** ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Basicly the BELIEF-package has two modes, belief--where all values
;;; (nodes of tree of cliques, and edges of model-graph) are belief
;;; functions, and prob--where all values are potentials.  A package
;;; can have one of four different modes:  belief -- it directly uses
;;; the belief package, prob -- it directly uses the prob package,
;;; none-- it uses neither package, or inherited--it inherits certain
;;; functions which deal with generalized values from the current
;;; *rules-package*.  Generally, the user package and the shell
;;; package should be of type inherited in order for the use-rules
;;; mechanism to function correctly.  The system makes some attempt to
;;; change the mode of the user package from belief or prob to the
;;; mode of the new rules, but this is not always done  (in
;;; particular, if a new rules base of the opposite mode is loaded,
;;; the mode of the user package may not change.)


;;; The following table describes the packages defined as part of the
;;; BELIEF-package.  The format is:

;;;	<package>[<nicknames>] (<files in that package>) <description>
;;;		(<package use list>)
;;;     utils (utils, bymachine) misc. utilities
;;;	   ()
;;;     basic (structures) defines structures
;;;	   ()
;;;     graphs (graphs, search) graph structures
;;;	    (basic, shell::node-size)
;;;     bel-low[sets,common] (sets, lowread, lowdist) ps-set and
;;;     attribute functions other low level functions
;;;	  (basic, graphs)
;;;     bel[ief] (artithmatic,read,belq, moreread, disbel)
;;;	      belief function arithmatic and reading
;;;	      (basic,sets,graphs,utils)
;;;     prob (potentials, probread, distprob) potential arithmatic and
;;;	  reading
;;;	  (basic,sets,graphs,utils)
;;;	inherited[mode,will] (belief-init) Mapping for mode dependent functions
;;;       ()
;;;	subshell (readnuke) Mode independent read macros
;;;	  (will)
;;;    *rules-package* [User rules package] (User Rule Base)
;;;	  (basic, graphs *mode-package* {belief|prob}, subshell)
;;;    shell (computations, cost, monte) basic interface commands
;;;	  (shell, basic, graphs *rules-package* *mode-package* [belief|prob])
;;;    common-lisp-user (lisp-init belief-init) User Workspace, contains
;;;	 specialized commands for loading belief functions
;;;	 (shell, basic, graphs *rules-package* *mode-package*[belief|prob]) 
;;;

;; Bug patch for CMU lisp
#+CMU(rename-package :lisp :cl '(:lisp :common-lisp))
#+CMU(rename-package :user :cl-user '(:user :common-lisp-user))

;;; Package by package definitions:

;; first add a trivial definition of the inherited package because there
;; will be forward references to it.

(defpackage :inherited (:nicknames #:mode #:will)
  (:intern #:node-size))

;; 	utils
;; files: utils.lisp --- generally useful utilities and extensions
;;        bymachine.lisp --- machine/locally dependent code
(defpackage :utils
  (:use #:common-lisp)
  (:import-from :user #:bel-provide #:bel-require)
  ;; from utils
  (:export #:glue-names #:add-count #:make-pairs #:over-common-cdrs #:pair+
	   #:iota binomial #:! #:add+  #:elt-array #:set-elt-array
	   #:as-vector #:as-array #:float-array #:long-float #:linear-comb
	   #:2+ #:3+ #:4+ #:5+ #:6+ #:7+ #:8+ #:9+ #:10+ #:11+ #:12+ #:13+
	   #:fifo-list #:make-fifo-list #:fifo-list-p #:fifo-head
	   #:fifo-last #:fifo-pop #:fifo-append)
  ;; from bymachine
  (:export #:protected-eval #:set-up-rng #:set-up-dist #:draw-dist
	   #:clean-up-rng))



;;     basic 
;; files: structures.lisp --- defines structures
(defpackage :basic
  (:use :common-lisp)
  (:import-from :user #:bel-provide #:bel-require)
  (:intern #:*ps-set-hash-table*)
  (:export #:*maxvars* #:*maxvals*
	   #:graph #:make-graph #:copy-graph #:graph-p #:graph-nodes
	   #:graph-edges 
	   #:ps-set #:ps-set-p #:mt-ps-set #:mt-set #:**frame**
	   #:ps-set-sym-p #:ps-set-sym-val #:vacuous
	   #:m-value #:make-m-value #:copy-m-value #:m-value-p #:m-value-m
	   #:m-value-element
	   #:val #:make-val #:copy-val #:val-p #:val-frame
	   #:belief-function #:make-belief-function #:copy-belief-function
	   #:belief-function-p
	   #:belief-function-frame #:belief-function-ms
	   #:pot #:make-pot #:copy-pot #:pot-p #:pot-frame #:pot-array
	   #:distribution #:make-distribution #:copy-distribution
	   #:distribution-p #:dist-draw-function #:dist-setup-function
	   #:dist-nominal-function 
	   #:dist-rng-calls-per-draw #:dist-rng-data-1 #:dist-rng-data-2 
	   #:interval #:make-interval #:copy-interval #:interval-p
	   #:interval-upper #:interval-lower
	   #:uniform #:make-uniform #:copy-uniform #:uniform-p
	   #:uniform-upper #:uniform-lower
	   #:beta-dist #:make-beta-dist #:copy-beta-dist #:beta-dist-p
	   #:beta-events #:beta-trials
	   #:gamma-dist #:make-gamma-dist #:copy-gamma-dist #:gamma-dist-p
	   #:gamma-events #:gamma-time
	   #:mixture-dist #:make-mixture-dist #:copy-mixture-dist
	   #:mixture-dist-p 
	   #:mix-of #:mix-total-weight
	   #:lognormal-dist #:make-lognormal-dist #:copy-lognormal-dist
	   #:lognormal-dist-p #:lognorm-offset #:lognorm-median
	   #:lognorm-error-factor
	   ))


;;     graphs 
;; files: graphs.lisp --- graph definitions/algorithsm
;;        search.lisp --- tree construction heuristics
;; uses: basic, mode::node-size --- the cost function for the size of
;; a node may well depend on the *mode* of the system!  Therefore, it
;; is explicitly imported from above.
(defpackage :graphs
  (:use :basic :common-lisp)
  (:import-from :user #:bel-provide #:bel-require)
  (:import-from  :mode #:node-size )
  ;; graphs
  (:export #:valid-graphp #:hyper-graphp #:graph-2-p #:skeleton #:reduce-edge
	   #:neighbors #:neighborp #:closure #:s-delete #:s-2-delete 
	   #:r-delete #:r-2-delete #:equal-graph #:add-node #:add-edge
	   #:equal-set #:layered-list #:core-list #:leaf-p #:s-delete-list
	   #:one-sc-tff #:test-list #:fast-ff #:one-ff
	   #:prop-graph-2-graph #:graph-2-prop-graph)
  ;; search
  (:export #:mc-search #:count-neighbors #:one-step 
	   ;#:one-ff #:one-sc-tff #:test-list
	   #:one-ff-tsc
	   #:find-goal #:a*-do #:full-graphp
	   #:a*-pause #:*open* #:*close* #:expand-state #:ucost
	   #:make-decision-state #:clean-list #:full-graphp
	   #:decision-state-deleted #:decision-state-size
	   #:decision-state-graph #:decision-state-cost-to-go
	   #:lex-m))


;;    bel-low	[sets]	[common] 
;; files: sets.lisp --- TS -set maniputation functions
;; 	  lowread.lisp --- TS-set related read macros
;; 	  lowdist.lisp --- Low level distribution functions
;; uses:  (basic, graphs)
(defpackage :bel-low
  (:nicknames #:sets #:commonb)
  (:use :basic :common-lisp)
  (:import-from :user #:bel-provide #:bel-require)
  ;; sets.lisp
  (:export #:ps-set-equal #:ps-set-subsetp #:ps-set-member #:ps-set-complement
	   #:explode-ps-set #:sort-ps-set #:normalize-ps-set
	   #:get-ps-set-sym #:fget-ps-set-sym #:new-ps-set-symbol
	   #:ps-index #:frame-size #:ps-sym-intersect #:show-variable)
  (:import-from :basic #:*ps-set-hash-table*)
  ;;lowread.lisp
  (:use  :basic :graphs :utils)
  (:export #:defatt #:*true-false-values* #:*model-graph* #:*val-list*
	   #:set-up-if #:set-up-ifor #:set-up-iff #:set-up-iffor
	   #:clean-attribute-list #:clean-attribute
	   #:logical-true #:logical-false #:logical-unknown
	   #:logical-nand #:logical-or #:logical-and #:logical-nor
	   #:logical-xor  #:print-ps-set #:reset-model
	   #:attribute-to-frame #:get-number #:*sink-list* 
	   #:*failure-values*)
  ;;lowdist.lisp
  (:export #:draw-default #:draw-mix #:draw #:setup-default
	   #:setup-mix #:setup #:setup-all #:nominal #:nominal-default 
	   #:nominal-mix #:*parent-list* #:*default-rate-default*
	   #:*default-max-failures* #:*child-list* 
	   )
  ;; defined elsewhere (usually rule base dependent variables from
  ;; :shell package)
  (:export #:*save-messages* #:save-sink-values* #:save-values*
	   #:*iteration-count* )
  )



;;     bel	[belief]
;; files: artithmatic --- combination and projection
;; 	  read.lisp --- belief function read macros
;;	  belq.lisp --- Fast Mobius transform to other representations
;;	  moreread.lisp --- more (optional) read macros
;;	  distbel.lisp ---  belief function (random interval) distributions
;; uses:  (basic,sets,graphs,utils)
;(provide 'arithmatic)
(defpackage :belief (:nicknames :bel)
  (:import-from :user #:bel-provide #:bel-require)
  ;; arithmatic.lisp
  (:use :basic :bel-low :utils :graphs :common-lisp)
  (:export #:@^ #:@v #:@-> #:@+ #:@+2 #:|| #:-><- #:ppval #:make-vacuous
	   #:direct-sum #:conflict-bel-fun #:normalize-bel-fun
	   #:approx-zerop #:ppbel #:node-size #:reset-zero-tol #:mix
	   #:copy-change-frame)
  ;; read.lisp
  (:export #:defatt #:reset-model
	   ;inherited from lowread.lisp
	   #:defbel #:defif #:defand #:defor #:defifor #:defis 
	   #:defnand #:defnor #:defxor #:defiff #:defiffor #:defbelcond
	   #:defbel-nograph
	  )
  ;; belq.lisp
  (:export #:bel-m-frame #:bel-m-m-array #:make-bel-m #:bel-m-p
	  #:bel-q-frame #:bel-q-q-array #:make-bel-q #:bel-q-p
	  #:bel-bel-frame #:bel-bel-bel-array #:make-bel-bel #:bel-bel-p
	  #:bel-pl-frame #:bel-pl-pl-array #:make-bel-pl #:bel-pl-p
	  #:belfun-to-bsam #:bsam-to-belfun #:norm-m #:@-
	  #:m->bel #:bel->m #:m->q #:q->m #:q+q #:q-q #:bel->pl #:pl->bel
	  #:pl->q #:q->pl
	  #:print-bel #:print-m #:print-q #:print-pl
	  #:get-bel #:get-pl #:get-q #:get-m #:E^ #:Ev #:E^v
	  #:sing-bp #:inc-bp #:dec-bp)
  ;; moreread.lisp --- no longer used
  ;; distbel.lisp
  (:export #:draw #:draw-default #:draw-interval #:draw-uniform #:draw-beta
	       #:draw-gamma #:draw-mix #:draw-lognorm
	  #:setup #:setup-default #:setup-interval #:setup-uniform #:setup-beta
	       #:setup-gamma #:setup-mix #:setup-lognorm #:setup-all
	  #:impute-poisson #:impute-poisson-data #:impute-poisson-disc
	  #:impute-binomial #:impute-binomial-data #:sink-get-att-value
	  #:sink-get-param-value 
	  #:nominal #:nominal-default #:nominal-mix #:nominal-interval
	          #:nominal-uniform #:nominal-beta #:nominal-gamma
		  #:nominal-lognorm
	  #:impute #:impute-mix
	  )
;; draw, draw-default and draw-mix are inherited from lowdist
;; as are setup, setup-default, setup-mix and  setup-all
;; *parent-list* is inherited from lowdist
  )
;; located in rules package, but initialized here are
;;  *min-input* *condition-ratio* *att-penalty* *zero-tol*


;;     prob
;; files:  potentials.lisp --- combination and projection
;;  	  probread.lisp --- potential read macros
;;	  distprob.lisp --- probability distributions
;; uses::(basic,utils, sets,graphs)
(defpackage :prob (:nicknames :potentials)
  (:use :basic :bel-low :utils :common-lisp :graphs)
  (:import-from :user #:bel-provide #:bel-require)
  ;; potentials.lisp
  (:export #:@^ #:@v #:@-> #:@+ #:@+2 #:|| #:-><- #:ppval #:make-vacuous
	   #:direct-sum #:constant-pot #:normalize-pot
	   #:approx-zerop #:pppot #:node-size #:reset-zero-tol
	   #:copy-change-frame #:mix)
  ;; probread.lisp
  (:export #:defatt #:reset-model ;inherited from lowread.lisp
	   #:defpot #:defif #:defand #:defor #:defifor #:defis 
	   #:defnand #:defnor #:defxor #:defiff #:defiffor #:defpotcond
	   )
  ;; distprob.lisp
  (:export #:draw #:draw-default #:draw-interval #:draw-uniform #:draw-beta
	   	#:draw-gamma #:draw-mix #:draw-lognorm
	   #:setup #:setup-default #:setup-interval #:setup-uniform
	   	#:setup-beta #:setup-gamma #:setup-mix
		#:setup-lognorm #:setup-all 
	   #:impute-poisson #:impute-poisson-data #:impute-poisson-disc
	   	#:impute-binomial #:impute-binomial-data 
	   #:sink-get-att-value #:sink-get-param-value
	   #:nominal #:nominal-defaul #:nominal-mix #:nominal-interval
	   	#:nominal-uniform #:nominal-beta #:nominal-gamma
		#:nominal-lognorm
	   #:impute #:impute-mix
	  )
  ;; draw, draw-default and draw-mix are inherited from lowdist
  ;; as are setup, setup-default, setup-mix and  setup-all
  ;; *parent-list* is inherited from lowdist
  )
;; the following have initial values defined here, the real constants
;; are avaliable only in the *rules-package* (through #? and #!)
;;  *min-input* *condition-ratio* *att-penalty* *zero-tol*


;; inherited	[mode]  [will]
;; depending on value of *mode-package* will call functions from the
;; belief or prob package.  This is a package for dispatched
;; functions.  
;; export list is dynamically built in belief-init.lisp
(defpackage :inherited
  (:use :common-lisp)
  (:import-from :user #:bel-provide #:bel-require)
  (:export #:*rules-package* #:*mode-package* 
	  #:new-rules #:use-rules #:bel-mode #:prob-mode #:inherit-mode
	  #:no-mode
	  ;#:|#?-reader| #:|#!-reader|
					;generally not needed and
					;cause trouble in cmu-lisp
	  )
  (:import-from :user *belief-format*))

#+Allegro
(eval-when (compile load eval) 
	   (if (equal "Allegro CL" (lisp-implementation-type))
	       (import 'tpl::*prompt* :mode)))
;;; The file belief-init.lisp also defines external symbols of this
;;; package.  In particular all of the symbols in *inherited-funs* and
;;; *inherited-macs* are exported.  They are also defined to be
;;; dispatching functions or macros.  Dispatching functions call a
;;; function in the package indicated by the current mode.
;;; Dispatching macros call a macro expansion function defined by the
;;; package indicated by the current mode.


;;; Inherited Values are slightly different.  Values are not external
;;; symbols of the inherited package, instead they are external
;;; symbols of the rules package.  Packages in inherited mode take
;;; their value from the current rules package.  When a new rules
;;; package is created, these values are initialized according to the
;;; current mode.  
;;; For this reason the #? and #! macros are defined.  See
;;; belief-init.lisp for more details.

;;	subshell 
;; files: readnuke.lisp --- reliability (fault tree) read macros
;; uses:  (will)
(defpackage :subshell
  (:use :utils :will :basic :graphs :common-lisp)
  (:import-from :user #:bel-provide #:bel-require)
  (:export #:defparent #:defchild #:repeatdef #:repeatdef2 #:repeatdef3 
	   #:repeatdef4 #:n-syms
	   #:defandpoi #:deforpoi #:defreducepoi #:defval #:defsink
	   #:defandbin #:deforbin)
  (:import-from :commonb #:get-number #:logical-unknown)
  )

;;    *rules-package* 
;;    this is a user defined package created by the user when a rule
;;    base is loaded.
;; It uses: (basic, graphs, inherited {belief|prob}, subshell)
;; for more details, look at the functions new-rules and use-rules in
;; the belief-init files.  Also symbols indicated with #? or #! point
;; to symbols in this package.

;;    shell
;; files: computations.lisp --- fusion and probagation algorithm
;;  	  cost.lisp --- experimental cost functions
;;        monte.lisp --- basic interface commands
;; uses  (shell, basic, graphs *rules-package* *mode-package* [belief|prob])
(defpackage :shell
  (:import-from :user #:bel-provide #:bel-require)
  (:import-from :sets #:show-variable)
  ;;computations.lisp
  (:use :utils :basic :graphs :inherited :common-lisp)
  (:export #:process-node #:sum-over #:ppconflict #:do-it #:make-tree
	   #:set-up-tree #:change-node #:update-tree #:augment-tree
	   #:build-tree #:conflict-node #:marginal-node #:redo-it
	   #:undo-it #:undo-it! #:restore-node #:restore-node!
	   #:ppnode #:ppmessages #:ppall
	   #:*explore-margins* #:set-it-up #:propagate-up
	   #:propagate-down  #:in-to-root
	   #:*pick-root* #:find-new-values #:kill-all-messages
	   #:mark-all-messages #:show-variable
	   #:reload-tree #:@@+ #:@@+2 #:@@->)
  ;;cost.lisp --- not currently used
  ;;monte.lisp
  (:use :subshell :utils)
  (:export #:mc-loop #:mc-up-loop #:mc-sim-loop #:*sink-store-function*
	   #:simulate-down #:draw-sources #:record-sinks 
	   #:*sink-stream* #:open-sink-file #:mark-sink-file
	   #:close-sink-file  #:*break-on-up* #:*break-on-down*
	   #:*break-on-draw* #:*break-on-cycle*
	   #:*default-iterations* #:*last-iteration* #:mc-setup
	   #:sink-node-handler #:restore-nominals #:gc-every-n-times
	   #:*mc-gc-hook* #:*gc-every-n* #:*gc-counter*
	   #:find-sink-sources #:record-sink-nodes
	   #:kill-sink-values #:mark-sink-values
	   #:kill-child-values #:mark-child-values
	   #:kill-parent-values #:mark-parent-values
	   ))





;;    common-lisp-user [user]
;; files: lisp-init.lisp --- belief function loading functions
;;        belief-init.lisp --- belief function initialization
;;  uses: (after loading)
;;	 (shell, basic, graphs *rules-package* inherited {belief|prob})
;; the listed packages are added to the user package inheritance list.


(bel-provide :belief-package)

