;;; Compile and load UCPOP if no defsystem available

" All rights reserved. Use of this software is permitted for non-commercial
  research purposes, and it may be copied only for that use.  All copies must
  include this copyright message.  This software is made available AS IS, and
  neither the authors nor the University of Washington make any warranty about
  the software or its performance.

  When you first acquire this software please send mail to 
  bug-ucpop@cs.washington.edu; the same address should be used for problems."



(defpackage "UCPOP")
(defpackage "VARIABLE")

(defparameter *ucpop-dir* "/projects/ai/planners/ucpop/")

(defun LOAD-UCPOP ()
  (load (concatenate 'string *ucpop-dir* "variable"))
  (load (concatenate 'string *ucpop-dir* "struct"))
  (load (concatenate 'string *ucpop-dir* "plan-utils"))
  (load (concatenate 'string *ucpop-dir* "ucpop"))
  (when (find-package 'clim)
    (load (concatenate 'string *ucpop-dir* "vcr")))
  (load (concatenate 'string *ucpop-dir* "choose"))
  (load (concatenate 'string *ucpop-dir* "rules"))
  (load (concatenate 'string *ucpop-dir* "scr"))
  (load (concatenate 'string *ucpop-dir* "interface")) 
  (load (concatenate 'string *ucpop-dir* "domains")) 
  (load (concatenate 'string *ucpop-dir* "controllers")))


(defun COMPILE-UCPOP ()
  (load-ucpop)
  (compile-file (concatenate 'string *ucpop-dir* "variable"))
  (compile-file (concatenate 'string *ucpop-dir* "struct"))
  (compile-file (concatenate 'string *ucpop-dir* "plan-utils"))
  (compile-file (concatenate 'string *ucpop-dir* "ucpop"))
  (when (find-package 'clim)
    (compile-file (concatenate 'string *ucpop-dir* "vcr")))
  (compile-file (concatenate 'string *ucpop-dir* "choose"))
  (compile-file (concatenate 'string *ucpop-dir* "rules"))
  (compile-file (concatenate 'string *ucpop-dir* "scr"))
  (compile-file (concatenate 'string *ucpop-dir* "interface"))
  (compile-file (concatenate 'string *ucpop-dir* "domains"))
  (compile-file (concatenate 'string *ucpop-dir* "controllers"))
  (load-ucpop) )



