;;;; -*- Mode: Emacs-Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-mode-defaults.el
;;;; Author          : Frank Ritter
;;;; Created On      : Wed Jun 20
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Oct 22 16:38:05 1991
;;;; Update Count    : 69
;;;; 
;;;;
;;;;		     How to load GNU Emacs Soar mode
;;;;
;;;;	Details on a default set of commands to load and use soar mode.
;;;; Novice users with vanilla tastes can just always load this, more 
;;;; advanced users will want to cut and paste the commands out of this
;;;; into their .emacs files
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	Variables that must be set
;;;; 	ii.	How to set keybindings and hooks
;;;;	iii.	Load associated code
;;;;	iv.	Grungy things you have to do
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;
;;;	i.	Variables that must be set
;;;
;;; If you insert this into your .emacs, this is a section of active code that 
;;; you can not comment out or remove.

;; this says where soar-mode lives
;; does not get ending /
(setq soar-mode-home-directory
      "/afs/cs/project/soar/5.2/emacs/soar/4.1")

;; these should be extracted from the running soar process,
;; but we set them here
(setq soar-version-number "5.2.2")

;; tags should include taql code too...
(setq soar-default-tags-table "DEFAULT-TAGS")


;;;
;;;	ii.	Variables that can be set
;;;
;;;  These variables are shown with their default values.  If you want to 
;;;  change their values, copy this file (or portions of this file) to your
;;;  directory or insert it into your .emacs file.

;; you need to define the image name to be in your unix path, or to be 
;; an alias which runs Soar.  "Soar5" is the default
;; (setq soar-image-name "Soar5")

;; If t, soar commands print descriptions into soar-diversion-buffer (*glide*) 
;; buffer.  If nil, dumps into *soar* buffer.
;; (setq soar-print-into-diversion-p t)

;; T if you want all lisp loading output (as opposed to soar production)
;; in the inferior Soar buffer rather than in a
;; pop-up window.  You should probably also set comint-always-scroll to T
;; as well so that output is always visible.

;; (setq lisp-no-popper nil)  ;default is nil
;; (setq comint-always-scroll nil) ;default is nil

;; Print out the month in insert-date-string as letters, and in
;; 30-Oct-91 order, rather than as 10-30-91.
;; (setq insert-date-with-month-name nil)  ; default is nil

;; Set to nil if you don't want C-x-o to skip pop-up buffers,
;; such as *Buffer Menu* or *Help*. Default is t.
;; (setq popper-buffers-to-skip t)

;; Pop to the CMS (continuous match set) buffer if it is being written 
;; to (default nil).
;; (setq pop-to-cms nil)

;; if this is C-^, it is also C-6 unshifted
;; (setq soar-command-prefix "\C-c")

;; If this is t (default), erase the diversion buffer each time you use it.
;; (setq soar-erase-diversion-buffer-p t)

;; Name of the diversion buffer.
;; (setq soar-diversion-buffer-name "*glide*")

;; Popup the diversion buffer if t (the default) something gets put in there.
;; (setq soar-popup-diversion-buffer-p t)

;; make-header-hooks contains a list of what to put on the header when
;; make-header is called.  The default is shown below.
;;
;; (setq make-header-hooks 
;;       '(;; a top line with mode  comes for free
;;         ;; a divisor line        comes for free
;;         header-blank
;;         header-file-name
;;         header-author
;;         header-creation-date
;;         header-modification-author
;;         header-modification-date
;;         header-update-count
;;         soar-version
;;         taql-version
;;         ;;Put PURPOSE and TOC near top
;;         header-blank
;;         header-purpose
;;         header-toc
;;         header-copyright
;;         ;;Generally want either RCS stuff or header-history
;;         ;;at CMU and elsewhere, fewer users and fewer non-hacky use RCS,
;;         header-divisor-line
;;         header-status
;;         header-history
;;         ;;header-rcs-locker
;;         ;;;;header-rcs-header
;;         ;;header-rcs-log
;;         ;; divisor line        comes for free
;;         ))


;;;
;;; 	ii.	How to set keybindings and hooks
;;;
;;; If you wish to change the keybindings or add to them for buffers 
;;; in soar-mode, put the changes on the soar-mode-hook in your .emacs
;;; file with code comparable to the code below.  Similar code could be
;;; put on the inferior-soar-mode-hook for buffers running Soar.
;;;
;;; For example, 
;;; Define C-c C-t to run my favorite command in inferior lisp mode:
;;;

;; Example set up for stuff to do when putting a buffer into soar-mode
;(setq soar-mode-hook
;     '((lambda ()
;         (visit-tags-table soar-default-tags-table)
;         (define-key soar-mode-map "\C-c\C-t" 'favorite-cmd)
;        )))

;; Example of how to set soar-hook, and what you can put on it, which gets
;; gets called when an inferior (running) Soar starts up.
;;

;(if (not (boundp 'soar-hook)) (setq soar-hook nil))
;;; soar-hook gets called after ilisp inits, but before soar gets called
;(setq soar-hook
;   (append soar-hook
;      '((lambda () 
;         ;; use C-6 instead of C-c as command prefix
;         (setq soar-command-prefix "\C-6")
;         ;; start by visiting a tags table
;         (visit-tags-table "/afs/cs/project/soar/5.2/0/lib/TAGS")
;         ;; ask which soar I want iff don't have a live one
;         (if (and (not (comint-check-proc "*soar*"))
;                (y-or-n-p
;                 "Use (perhaps) local copy of Soar5+sx(y) or Soar5 (n)? "))
;             (setq ilisp-program 
;                   "/afs/cs/project/soar/5.2/src/sx/new/Soar5+sx.acli"))
;
;        ;; or just always use a single version
;        (setq ilisp-program
;           "/afs/cs.cmu.edu/project/soar/5.2/2/bin/pmax/mach/franz/Soar5")))
;           ;; set my header notice
;        (setq header-copyright-notice "Copyright 1991, Frank Ritter.")
;     ))))


;;;
;;;	iii.	Load associated code
;;;
;;; utilities/taql-indent-line.el provides code to indent TC's correctly
;;; when using soar- or taql-mode (but is not automatically loaded by
;;; soar-mode).
;;; 
;;; (e.g., Set up ilisp so you can find it w/o soar-mode.)
;;; We believe that if you don't use ilisp alone, that you could comment or
;;; cut this out to save space. (But I wouldn't do that if I were you.)
;;;

;; To load utilities/taql-indent-line iff it has not been loaded.
;; Cut this into your soar-mode-hook, if you wish.
;; (require 'taql-indent-line)

;; some handy things for working on just lisp that you are carrying around
;; too, let's not let them go to waste:
(autoload 'run-ilisp "ilisp" "Select a new inferior LISP." t)
(autoload 'allegro   "ilisp" "Inferior Allegro Common LISP." t)

;; set the ilisp-command-prefix in case you are headed into ilisp first
(setq ilisp-prefix  "\C-c")

;; relative pathname off of soar-mode
(setq soar-ilisp-subdirectory "ilisp/4.11")

(setq load-path 
      (cons (concat soar-mode-home-directory "/" soar-ilisp-subdirectory)
            load-path))

;;; This makes reading a lisp file load in ilisp.
(if (not (boundp 'lisp-mode-hook)) 
    (setq lisp-mode-hook nil))
(setq lisp-mode-hook
      (cons '(lambda () (require 'ilisp))
            lisp-mode-hook))



;;;
;;;	iv.	Grungy things you have to do
;;;
;;; This is live code that you have to have, but that you don't have to
;;; understand if you leave it alone.
;;;

(defvar soar-file-types
   '("\\.soar"  
     "\\.soar5"))

;; Put files that end in .soar into soar-mode
;; remove comment to do it for .Soar files too
(if (not (assoc "\\.soar" auto-mode-alist))
    (set-default 'auto-mode-alist
             (append 
                (mapcar '(lambda (x)
                           (cons x 'soar-mode))
                         soar-file-types)
                auto-mode-alist)
    ))

(setq load-path
     (cons (expand-file-name soar-mode-home-directory)
           load-path))

;;; make calling  {run-soar, soar, soar-mode} load the mode code.
(mapcar 
 '(lambda (x) (autoload (car x) "soar" (car (cdr x)) t))
 '((run-soar  "Starting up an inferior (buffer) soar process.")
   (soar  "Another way to start up an inferior (buffer) soar process.")
   (soar-mode "When editing a file of Soar productions or lisp code.")
   ))

;;;; This should be covered by the new  use-soar-mode-if-available  variable.
;;; If taql-mode is around, put .taql files into soar-mode as the major
;;; mode when they start up, with taql-mode behind
;;; This works if soar-mode is loaded second.
;(if (assoc "\\.taql" auto-mode-alist)
;    (set-default 'auto-mode-alist
;             (append
;                (mapcar '(lambda (x)
;                           (cons x 'soar-and-taql-mode))
;                         '("\\.taql$"))
;                auto-mode-alist)
;    ))
