;;;; -*- Mode: Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : default.sx-init.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Thu Aug 23 13:01:27 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Mar 20 16:19:00 1992
;;;; Update Count    : 104
;;;; Soar Version    : 5.2.2
;;;; Taql Version    : 3.1.4
;;;; 
;;;; PURPOSE
;;;; 	Example init code either put in .sx-init.lisp, or loaded from
;;;; there.  Currently also used in the scs25 NL-soar demo.  None of this
;;;; should bomb, but not all the variables are necessarily used at this time
;;;; or in your system.
;;;;
;;;; TABLE OF CONTENTS
;;;;	I.	User setable variables
;;;; 	II.	Problem-space creation
;;;; 	III.	Some code for running demos
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; necessary if you don't preface variable and command names with sx:
;; otherwise all variables in this file are sx:
(eval-when (eval load compile)
  (in-package "SX"))

;;;
;;;	I.	Some user setable variables
;;; 
;;; Remove the comments around the ones you want to change, and set their
;;; new values as indicated by the comments.

;; When T (default nil), chunks beep when they fire.
;; (setq sx:chunk-beep-on-fire nil)

;; If t (default is nil), user is assumed to know how to use static menu,
;; and is not prompted with what to do each time.
;; (setf static-menu-expert nil)

;;; default locations of problem-spaces
;; (setq sx:*ps-locations*
;;       '( (65 . 85) 
;;          (65 . 210)
;;          (65 . 335)
;;          (65 . 460)
;;          (65 . 585)
;;          (65 . 710)
;;          (65 . 835)
;; 	 (300 . 85) 
;; 	 (325 . 210)
;; 	 (325 . 335)
;; 	 (325 . 460)
;; 	 (325 . 585)
;; 	 (325 . 710)
;;         (325 . 835)  ))
;; this is also necessary if you change the initial-goal-location:
;; (setq sx:initial-goal-location (first sx:*ps-locations*))


;;; user variables for setting up snapshots
;; (setf sx:snap-print-command "lpr")
;; (setf sx:snap-dump-directory "/tmp/")
;; (setf sx:snap-dump-file "sx-dump")

;; Directory to put dumped file of static PS's in.
;; (setq sx:static-dump-directory "/tmp/")

;; Operators to never display, or to display just once
;; (setf sx:*show-never-op-names* nil)
;; (setf sx:*show-never-ps-names* nil)
;; (setf sx:*show-once-op-names* nil)

;; (push "wait"  sx:*show-once-op-names*)
;; (push "wait"  sx:*show-never-ps-names*)

;; Set the auto-scroll whenever you wish
;; (set-auto-scroll t)

;; Set the always-update whenever you wish
;; (set-always-update t)

;; Max time in ms for a double click
;; (setf sx:double-click-time 1000)

;; Should problem spaces come up anchored by default (initially nil)
;; (setf sx:*default-ps-anchored* nil)

;; Show goals' ids
;;(setq sx:default-goal-id-visible nil)

;; Show problem spaces' ids
;(setq sx:default-problem-space-id-visible t)

;; Show state's ids
;(setq sx:default-state-id-visible nil)

;; Show chunk's ids when they fire or are created
;(setq sx:default-chunk-id-visible nil)

;; Show operator's ids (t is default)
;(setq sx:default-operator-id-visible t)

;; Uses more memory but prettier (nil is default)
;(setf sx:double-buffer-windows-p nil)

;; MODIFYING THE TRACE
;; You can make the trace get smaller by (1) setting tab-size to 2
;; (or even 1), and making the goal-leader correspodingly smaller.
;; (2) Setting pgs-real-tab to t has the trace move over a tab after printing
;; out the dc, rather than to col 4 (what soar does now).  (3) you can not
;; printout the pscm object's ids by setting pgs-pscm-id to nil.
;;
;; (setq pgs-tab-size 3)
;; (setq pgs-goal-leader "==>")
;; (setq pgs-real-tab nil)
;; (setq pgs-pscm-id t)


;; Make the menus disappear after selection (nil is default)
;; can only be set in init file this way; otherwise must be done via menu
;(setf sx:menus-disappear-after-selection nil)

;; make some new commands for the DSI command interpreter
;(setq opal:*grepl-conditions*
;      (append  '(
;  ((opal:grepl-test :sx sx)
;   ":sx, :user, :soar will set the package to the keyword (or symbol)."
;   (in-package "SX"))
;  ((opal:grepl-test :soar soar)
;   nil
;   (in-package "SOAR"))
;  ((opal:grepl-test :user user)
;   nil
;   (in-package "USER"))
;   )
;               opal::*grepl-conditions*))

;; GC PARAMETERS
;; It is not clear to us at this point that changing your GC parameters
;; is worth while for relatively small images.  The SX image, despite its
;; apparent size, does not appear to be aided by such changes.


;;;
;;; 	II.	Example problem-space creation
;;;
;;;  Normal users would be well served to comment this out...
	 
;(defun create-nl-demo-problem-spaces nil 
;  "Create the problem-spaces for the CMU SCS-25 demo"
;  ;; this gets called in demo-load.lisp when you are running nl-soar
;  (interactive-create-problem-space 'top-ps nil
;           :anchored t)
;  (interactive-create-problem-space comprehension 'nil
;           :anchored t)
;  (interactive-create-problem-space 'language nil
;           :anchored t)
;  (interactive-create-problem-space 'link nil
;           :anchored t)
;  (interactive-create-problem-space 'constraint-check nil
;           :anchored t)
;  (interactive-create-problem-space 'referent nil
;           :anchored t)
;  (interactive-create-problem-space 'exhaustion nil
;           :anchored t)
;  (s-value sx::exhaustion :invisible t)
; )

;;;
;;; 	III.	Some code for running demos
;;;

;(in-package "USER")
;
;(defun redemo ()
; (init-soar)
; (excise-chunks)
; (d 1))

;; export them in case you're in the sx package

;(in-package "SX")

;(defun run-demo () (user::run-demo))
;(defun reinit () (user::reinit))
