;;;; -*- Mode: lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : build-sx.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul 13 15:36:14 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed May 20 18:12:13 1992
;;;; Update Count    : 263
;;;; Soar Version    : 5.2.2
;;;; Taql Version    : 3.1.4
;;;; 
;;;; PURPOSE
;;;; 	Loads all the parts to the sx until sem can get a handle on it.
;;;; This version goes with DSI release 5.1b
;;;; TABLE OF CONTENTS
;;;;	i.	Test for Soar 5.2.1
;;;;	ii.	Making it a released version
;;;;	I.	constants and parameters (external to this file)
;;;;	II.	Variables internal to this file
;;;;	III.	Build-sx
;;;;	IV.	Helper code for build-sx
;;;;	V.	Load and Go?
;;;; 	
;;;; 
;;;; Copyright 1990, Carnegie Mellon University, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimized:  doc-strings; not-compiled

(eval-when (load eval compile)
  (in-package "USER")
  (soarresetsyntax))

;; Useful for lucid machines with small initial memories
;; (change-memory-management :growth-limit 1024)
;; (change-memory-management :expand 200)




;;;
;;;	i.	Test for Soar 5.2.1
;;;

#-soar5(error "The DSI code only runs with Soar 5.2.1 or higher, please upgrade
to the new system, or push soar5 onto the features list and continue
at your own risk.")

;;;
;;;	ii.	Making it a released version
;;;

;; (Comment this out when building test images at CMU.)
(if (not (member :release-sx *features*))
    (push :release-sx *features*))

(if (not (member :release-garnet *features*))
    (push :release-garnet *features*))


;;;
;;;	IA.	Constants and parameters you must modify
;;;
;;; These are the variables that are site dependent.  You *must* set them
;;; outside of CMU.

;; (1) Tell SX where the SX soarce code lives
(setf SX::*sx-directory*
      #+release-sx "/afs/cs.cmu.edu/project/soar/5.2/src/sx/5.4/"
      #-release-sx "/afs/cs/project/soar/5.2/src/sx/5.4")
      ;; (These are exported vars, but not at this point, so use ::)


;; (2) Where the source goes when it is compiled locally, not used with Soar
;; engineering man (SEM) software system.
(defparameter SX::*sx-output-directory*
  #+(and mach pmax allegro)
      "/afs/cs/project/soar/5.2/src/sx/5.4/"  ;xlib/pmax/mach/franz/
  #-(and mach pmax allegro)
      "/afs/cs/project/soar/5.2/src/sx/5.4/"
    )

;; Command to print files on your system.
(setf SX::snap-print-command "lpr")


;; Where TAQL lives locally.
;; (does not end with a /)
(setf soar::taql-home-directory "/usr/misc/.Soar5/lib/taql/3.1.4")


;;;
;;;	IB.	Constants and parameters you might have to modify
;;;
;;; These variables are site dependent, but should be covered by
;;; their default values.   You might need to set them to something
;;; different outside of CMU.

;; This gets displayed all the time, and used by SEM when loading at CMU.
;; This should be set when moving to the released directory to something
;; like "5.3.1".
(defconstant sx-version "5.4")

;; Where to put any images you make.
(setf SX::*default-sx-image-name* "/afs/cs/user/ritter/sx/new/Soar5+sx.acli")


(setf Garnet-Bitmap-PathName
      #-release-sx "/afs/cs/project/soar/garnet/1.4/src/bitmaps/1.4/"
      #+release-sx sx::*sx-directory*)

;; Where sxl loads files get loaded from, probably same as sx-directory.
(setf SX::*sxl-directory* sx::*sx-directory*)

;;; ****************************************************************
;;;  Installer:  Note: no variables need to be changed below here
;;; ****************************************************************


;;;
;;;	II.	Variables internal to this file
;;;


;;;
;;;	III.	Build-sx
;;;

; approximate sizes and times:
;  lisp+clx      meg and 5 min.
;      +garnet   meg and 10 min load
;      +soar     meg and    min load

;;  We do this so garnet can load it's bitmaps
#+lucid(cd SX::*sx-directory*)
#+allegro(chdir SX::*sx-directory*)

(defun build-sx (&optional &key (compilep t) (local-load t))
#-release-sx
 "Load and set up the SX part of the DSI."
 (lispsyntax)
 (format t "~%; remember,  :local-load T/nil, :compilep T/nil")
 ;; basic utilities
 (and (fboundp 'soarresetsyntax) (soarresetsyntax))
 (gc t) ; cleanup after function load 
 (format t "~%; **** Loading Soar and if neccesary, sem ****")
 (if (not local-load)
     (sx-load-sem))
 (sx-load-garnet compilep local-load)
 (sx-load-sx compilep local-load)
 (format t "~%; Note: when running on other hosts with output to your console,
; type to a shell: xhost machine-name")
  (format t "~%; Type (dump-sx) if you want to dump an image.")
)


;;;
;;;	IV.	Helper code for build-sx
;;;

(defun sx-load-clx (local-load)
#-release-sx
 "Load the Common Lisp X package appropriately for Garnet and SX."
 ;; they can't load it on their own, *this* code must be used
 (and (fboundp 'lispsyntax) (lispsyntax)) 
 (cond (local-load
          #+:ALLEGRO-V4.0 (cltl1:require 'clx)
          #-:ALLEGRO-V4.0 (require 'clx))
       (t #+:ALLEGRO-V4.0 (cltl1:require 'clx)
          #-:ALLEGRO-V4.0 (require 'clx))))

(defun sx-load-sx (compilep local-load)
  "Load the sx code itself."
  (format t "~%;;;;  Loading SX proper, expect to see some redefinitions. ;;;;")
  ;; lucid at speed 2 or lower gets stuck
  #+lucid (proclaim '(optimize (compilation-speed 3)))
  (and (fboundp 'lispsyntax) (lispsyntax))
  (cond (local-load (if compilep
                        (load-and-compile-file "all-sx")
                        (smart-load "all-sx")))
        (t (and (not (member :sem *features*))
                (not local-load)
                (sx-load-sem))
           (load "/afs/cs/project/soar/5.2/src/sx/5.4/module.lisp")
           (cond (compilep
                  (soarresetsyntax)
                  (apply (find-symbol "SOURCE-NEWER-COMPILE-MODULE"
                                      (find-package "SEM"))
                         (list sx-version "sx" "src")))
                 (t
                  (apply (find-symbol "LOAD-MODULE" (find-package "SEM"))
                         (list sx-version "sx" "src"))))) )
  (and (fboundp 'soarsyntax) (soarsyntax))
  (format t "~%;  Finished sx proper.")
  )

(defun sx-load-garnet (compilep local-load)
#-release-sx
  "Load garnet for the SX."
  (lispsyntax)
  (sx-load-clx local-load)
  (and (fboundp 'soarresetsyntax) (soarresetsyntax))
  (if local-load
      (if compilep
         (progn 
           (load-and-compile-file "g1") 
           (load-and-compile-file "g2")
           (load-and-compile-file "g3"))
         (progn
           (smart-load "g1")
           (smart-load "g2")
           (smart-load "g3")))
     (if compilep
         (apply (find-symbol "SOURCE-NEWER-COMPILE-SYSTEM" (find-package 'sem) )
                (list "src" "1.4" "garnet" "soar"))
         (apply (find-symbol "LOAD-SYSTEM" (find-package 'sem) )
                (list "src" "1.4" "garnet" "soar")) ))
 )


(defun load-and-compile-file (file)
  (and (fboundp 'lispsyntax) (lispsyntax))
  (smart-load (concatenate 'string sx::*sx-directory* file))
  (and (fboundp 'lispsyntax) (lispsyntax))  
  (smart-compile-file (concatenate 'string sx::*sx-directory* file) nil))

(defun smart-compile-file (afile output-file)
#-release-sx"Compiles afile (a file name w/o extension) only if necessary
returns nil if doesn't need compiled"
 (let* ((file-name (namestring afile))
        (lisp-date (if (probe-file (concatenate 'string file-name 
                                                 ".lisp"))
                       (file-write-date (probe-file (concatenate 'string file-name 
                                                 ".lisp")))))
        (bin-date (if (probe-file (concatenate 'string file-name 
                                                 #+allegro ".fasl"
                                                 #+lucid ".sbin"))
                   (file-write-date (probe-file (concatenate 'string file-name 
                                                 #+allegro ".fasl"
                                                 #+lucid ".sbin"))))))
   (if (and lisp-date
            (or (not bin-date)
                (< bin-date lisp-date)))
       (if output-file
           (compile-file afile :output-file output-file)
           (compile-file afile)))))

(defun smart-load (afile &key (verbose *load-verbose*) (print nil)
                              if-does-not-exist)
#-release-sx
 "Loads lastest version of afile (afile name w/o extension), favors
compiled version if same write date."
 (declare (ignore if-does-not-exist))
 (let* ((file-name (namestring afile))
        (lisp-date (file-write-date (concatenate 'string file-name ".lisp")))
        (bin-date (if (probe-file (concatenate 'string file-name 
                                                 #+allegro ".fasl"
                                                 #+lucid ".sbin"))
                   (file-write-date (probe-file (concatenate 'string file-name 
                                                 #+allegro ".fasl"
                                                 #+lucid ".sbin"))) )))
   (if (or (and (not lisp-date) bin-date)
           (and (numberp bin-date) (numberp lisp-date)
                (>= bin-date lisp-date)))
       (load (concatenate 'string file-name #+allegro ".fasl"
                                            #+lucid ".sbin")
             :verbose verbose :print print)
       (load (concatenate 'string file-name #+allegro ".lisp"
                                            #+lucid ".lisp")
             :verbose verbose :print  print))))

(defun sx-load-sem ()
#-release-sx
  "Load SEM however you need to"
  (format t "~%;  **** Loading SEM. ****")
  (and (fboundp 'soarresetsyntax) (soarresetsyntax))
   ;; from scratch for now, fasl later
   ;;(load "/afs/cs/project/soar/sem/1/src/sem/new/sem.lisp")
  (load (concatenate 'string "/afs/cs/project/soar/sem/3/src/sem/new/"
                      "pmax/mach" "/franz/sem.fasl"))
  (and (fboundp 'soarsyntax) (soarsyntax))
  (format t "~%;**** SEM loaded ****")
)



;;;
;;;	V.	Load and Go?
;;;

(format t "To load the SX part of the DSI:
   (build-sx &optional &key (compilep t) (local-load t))~%")

(if  (y-or-n-p "Start to load and compile the SX part of the DSI
  (build-sx :compilep t :local-load t) ? ")
     (build-sx :compilep t :local-load t))

nil


#|

;;;
;;;		  Insightful, but dead code
;;;
;
;
;(defmacro sxl (file)
; `(load ,(format nil "~~/sx/new/~a" file)))
;
;
;(defun sx-load-soar (&optional &key (compilep nil))
; "Now will be starting with Soar as an image."
;   (and (fboundp 'soarresetsyntax) (soarresetsyntax))
;   ;; the hard way to compile a real soar system
;   (sx-load-sem)
;   ;; This (sem:load-system "src" "4.5" "soar" "") comes out as =>
;   (apply (find-symbol "SOURCE-NEWER-COMPILE-SYSTEM" (find-package 'sem))
;             (list "src" "5.1" "soar" ""))
;          (list "src" "5.1/1/bin" "soar" "")
;          ;expects soar.lisp &sem loaded  buil-image
;   ;; the simple way to compile and load your own Soar5, copy the big file, 
;   ;; compile it, load it.
;   (smart-compile-file "/afs/cs/project/soar/4.5/src/sx/Soar5" nil)
;   (smart-load "/afs/cs/project/soar/4.5/src/sx/Soar5")
;  ; Tom recommends this patch set
;   "/afs/cs/project/soar/5.1/1/lib/Soar5.patches.of.4.Mar.90.lisp"
;  (cond ((boundp 'soar::*version-number*)) ; soar's loaded
;          (t  (smart-compile-file "/afs/cs/project/soar/4.5/src/sx/Soar5" nil)
;           (smart-load "/afs/cs/project/soar/4.5/src/sx/Soar5")
;           (load 
;             "/afs/cs/project/soar/5.1/1/bin/pmax/mach/franz/Soar5.patches.of.4.Mar.90.fasl")
;            ))
; (format t "~%; Soar system loaded. ~%")
;)
;
;To run a demo:
;1. Best to run in an emacs, in Olin's cmulisp mode.  Set up your .emacs file
;   like /afs/cs/user/ritter/.emacs
;2. esc-x soar
;3. (load "/afs/cs/project/soar/utc/nl/scs25-demo/build-sx.lisp")
;4. (sx) starts up the sx read-eval-print-loop
;5. call (sx::run-demo)
;
;
;(defun sx-load-demo ()
; "load the latest demo code"
; (load "/afs/cs/project/soar/utc/nl/scs25-demo/demo.soar")
;)

|#
