%{

/****************************************************************************
 *
 * MODULE:  make.lex
 *
 ****************************************************************************
 *
 * Abstract:
 *    Provides specifications to Lex for the lexical analyzer.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Merged with ParaOPS5 4.3.
 *    12 May 89 V2.0  Dirk Kalp
 *                    Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    25 Jun 89 V4.3  Dirk Kalp
 *                    Change global routine names to have "ops_" prefix. This
 *                    is to prevent conflicts with system and user defined
 *                    names at link time.
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *    23 Sep 88 V3.1  Anurag Acharya
 *
 *			Cleaned up the specification - mainly moving some of
 *			the recognition into my C code ( from lex specs )
 *			The specs that got zapped this way were mostly
 *			the ones that scanned the input stream till a given
 *			character appeared. This kinda stuff doesn't need 
 * 			all the power of lex and taking it out saves a lot of
 *			table space - I managed to get rid of more than half 
 *			the table space, about 10 K.
 *			Details:
 *			  * moved scan into C for comments, "double quote"
 *			    quoted atoms and bar quoted atoms 
 *			  * merged the recognition of "//" and the quoted
 *			    atom that occurs after that.
 *			  * added a routine to scan the input stream till a
 *			     a given character occurs.
 *			  * generalized the spec for floating point numbers -
 *			    to reduce the complexity of recognizing 'em.
 *			    now, it recognizes extra patterns like " . ", but
 *			    flags error anyway - anything to simplify.
 *
 *    13 Aug 88 V3.0  Dirk Kalp
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *                    Added this module header.     
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 *
 ****************************************************************************/

#include "global.h"
#include "y.tab.h"


/* Forward Declarations:
 *    These routines return values other than the standard integer and
 *    their return types are given here for other routines in this module
 *    that call them before they are defined.
 */
void  ScanTillAndRetain();

int flagmake;
int MakeInputChar;
%}
number    [-+]?[0-9]+\.?
notnumber [-a-zA-Z0-9\_\!\@\#\$\%\&\*\<\>\:\+\/]
exp       [Ee][-+]?[0-9]+
%%
[ \t]+ 	;
[\n]	{ MakeInputLineNum++;}
";"     {
  	  for (MakeInputChar = input(); 
	       ((char) MakeInputChar != '\n') && (MakeInputChar != EOF);
	       MakeInputChar = input());
 	  MakeInputLineNum++;
	}

"^"	{ return ('^');}
"("	{flagmake = 1;  return ('(');}
")"	{flagmake = 0;  return (')');}
"//"	{ 
	  int i;
	  char c;

	  for ( MakeInputChar = input(), i = 0; 
		MakeInputChar != EOF; 
		MakeInputChar = input(), i++ )
	   {
		c = (char) MakeInputChar;
		
		if ( c == '\n' )
		  {
		   MakeInputLineNum++;
		   MakeInputChar = 1;
		  }

		if (( c == ' ' ) || ( c == '\n' ) || ( c == '\t' ))
		  break;
	
		yylval.sval[i] = c;
	   }
	   yylval.sval[i] = '\0';

	   return(ATOM);
	  }
make 	{
  	  if (flagmake) {flagmake = 0; return(MAKE);}
	  else { strcpy(yylval.sval,yytext); return(ATOM);}
	}

{number}   {
	     yylval.ival = atoi(yytext);
	     return(FIXNUM);
	    }

[-+]?[0-9]*\.[0-9]*({exp})?  {
			yylval.ival = 0;
	 		ops_warn("Floating point numbers not supported...\n");
	 		return(FIXNUM);
		   		}

\"	 {
	   ScanTillAndRetain('\"');
	   return(ATOM);
	 }

"|"     {
	   ScanTillAndRetain('|');
	   return(ATOM);
	}

({notnumber})+ {
	   strcpy(yylval.sval,yytext);return(ATOM);
 	 }
%%

static
void
ScanTillAndRetain(c)
char c;
{
  int i;
  int bufchar;
	  
	  for ( bufchar = input(), i = 0;
		(((char) bufchar) != c) && (bufchar != EOF);
		bufchar = input(), i++)
	   {
		yylval.sval[i] = (char) bufchar;

		if ( ((char) bufchar) == '\n') 
		  MakeInputLineNum++;
	    }

	   yylval.sval[i] = '\0';
}

