
/****************************************************************************
 *
 * MODULE:  global.h
 *
 ****************************************************************************
 *
 * Abstract:
 *    Global declarations.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    16 Aug 89 V5.0  Anurag Acharya
 *                    Integrated the uniprocessor version
 *    15 Aug 89       Anurag Acharya
 *                    Enclosed the lock declarations in conditional conmpilation
 *                    sections(#ifndef UNIPROC_VERSION)
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Update for CParaOPS5 Version 4.0 P4.3.
 *    15 May 89 V3.0  Dirk Kalp
 *                    Remove macros for lock operations. Move lock definitions
 *                    for the hash based token memory to psm_locks.c. Define new
 *                    lock macros in psm_locks.h.
 *    12 May 89 V2.0  Dirk Kalp
 *                    Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    14 Feb 89 V4.1  Dirk Kalp
 *                    Added "AttPtrList" and "is_vecatt" fields to symbol table
 *                    records in order to support the standard OPS5 style of
 *                    printing wmes with attribute name followed by value.
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *     1 Oct 88 V3.1  Dirk Kalp
 *                    Added "NodeidList" and "Func_addr" fields to symbol table
 *                    records in order to support the OPS5 top level user
 *                    interface cmds "matches" and "call".
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    Increase max number of CEs permitted in LHS from 64
 *                    to 256 (corresponding compiler change made in ../lhs).
 *                    Redefine alpha_cell and beta_cell to have token part
 *                    at end of structure to allow for variable size token
 *                    part (to save space instead of always allocating size
 *                    256) and, in turn, permit Rete assembly code to access
 *                    the fields in the structure with uniform offsets.
 *                    Added global free lists for the alpha and beta cells
 *                    to allow system reinitialization to reclaim memory
 *                    used for the cells in the hash tables (Note: Each
 *                    match process continues to maintain its own local
 *                    free lists across system initializations.).
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *    17 Sep 86       Dirk Kalp
 *    28 Aug 86       Dirk Kalp
 *    31 Jul 86
 *    27 Jul 86
 *    23 Jul 86 V1.0  Dirk Kalp
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/

#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "psm_locks.h"


#define RUSAGE_SELF 0
#define RUSAGE_CHILDREN -1



typedef char            *string;

typedef char             string128[128];
typedef char             string256[256];


#define TRUE           1
#define FALSE          0

typedef unsigned short  boolean;

#define LongwordSize 4	     /* Size in bytes of longword */
#define PointerSize  4	     /* Size in bytes of pointer  */



#define LEX            0     /* LEX conflict resolution. */
#define MEA            1     /* MEA conflict resolution. */


#define WMEDELNDX      0     /* Wme deleted or not index  */
#define WMEMINNDX      1     /* Smallest legal wme index. */
#define WMEMAXNDX      127   /* Biggest legal wme index.  */
#define WMETIMETAG     128   /* Time tag index.           */
#define WMELENGTH      129   /* Index of the length field.  */
#define WMESIZE        130   /* How many slots to allocate. */

#define NULLTIMETAG    0     /* Invalid value for a time tag of a wme. */
#define MINTIMETAG     1     /* Smallest value for a time tag of a wme. */

#define DELWM          0     /* Wme is NOT in working memory  */
#define INWM	       1     /* Wme is IN working memory      */

typedef long  OpsVal;        /* A value stored in a wme field. */

typedef struct wme_struct
        {
         OpsVal            wme[WMESIZE]; /* A working memory element. */
         struct wme_struct *flink;       /* Forward link in working memory. */
         struct wme_struct *blink;       /* Backward link in working memory. */
        }
        wmerec, *wmeptr;

typedef int   Symbol;        /* A number representing a symbolic constant. */

typedef struct symtab_struct
        {
         string  SymName;      /* Pointer to the symbol name. */
         Symbol  SymId;        /* Unique number assigned to the symbol. */
         int     OpsBind;      /* Binding if symbol is attribute name. */
         int     *NodeidList;  /* If name is prod, points to list of nodeids, terminated by -1. */
         int     Func_addr;    /* If external func name, holds addr of the function. */
         boolean pbreak;       /* TRUE if production has its breakpoint set. */
         int     *AttPtrList;  /* If it's a classname, points to list of attribute ptrs, terminated by 0. */
         boolean is_vecatt;    /* TRUE if name is a vector attribute. */
         struct symtab_struct  *next;
        }
        symrec, *symptr;

#define INVALIDBINDING     -1     /* An invalid attribute binding. */




#define DIRIN          1     /* Add wme/token to wm or a node memory. */
#define DIROUT         0     /* Delete wme/token from wm or a node memory. */

#define MAXCECOUNT     256   /* Max # of condition elements in a production. */



typedef wmeptr  wmeptrvec[MAXCECOUNT];  /* A vector of wme pointers. */



#define MEM_HASHTABLE_SIZE	4096		/* corresponding define is in ../lhs/defs.h  */
#define HKEY_MASK  (MEM_HASHTABLE_SIZE - 1)


typedef struct acell_struct
        {
         struct acell_struct  *next;
 	 int		       nodeid;
         wmeptr                pWme;     /* Points to a wme. */
        }
        alpha_cell;


typedef struct bcell_struct
        {
         struct bcell_struct  *next;
	 int		      nodeid;
         int                  refcount; /* # of bindings to wmes in rmem. */
         int                  toksize;  /* # of wmes in the token vector. */
         wmeptrvec            token;    /* Vector of wme addresses. */
        }
        beta_cell;


typedef union
        {
         alpha_cell *AlphaPtr;
	 beta_cell  *BetaPtr;
	 wmerec     *WmePtr;
	 int        *Ptr;
	} DataPtr;



#define TASK_QUEUE_SIZE	  32*4096


typedef struct tq_cell_struct
        {
	 int     direction;
	 int     (*routine)();
	 DataPtr lpart;
	 DataPtr rpart;
	 struct tq_cell_struct *next;    /* Only used for free list maintenance. */
	}
	tq_cell;


/* NOTE: Code generated by the compiler restricts number of processes
 *       to be less than or equal to 32. ProcessID's are expected to
 *       be represented by a bit in a 32-bit word. Increasing this limit
 *       will require changes to the generated code along with runtime
 *       code in the rhs modules. Task_queues are also limited to a
 *       maximum of 32 and are similarly fixed in the compiler.
 */
#define MAX_PROCESSES    32
#define MAX_QUEUES       32



#define RIGHT_LEAVE_BETA_TASK  1
#define LEFT_LEAVE_BETA_TASK   2
#define LEAVE_ROOT_TASK        3
#define LEAVE_PNODE_TASK       4

#define EXIT_NODE              1
#define CONTINUE_NODE          0



/* This is the declaration I wanted to use but the C compiler does
 * not support initialization of union types.
typedef union
        {
         int      ival;         eg., value for tab() 
         OpsVal   *optr;        eg., &OpsSymbols[6] 
	 int      (*prtn)();    eg., &bmake 
	} ThreadedCodeElement;
 */

typedef int *ThreadedCodeElement;




/*************************************************************************

                     CONVERSION TO/FROM OpsValS

*************************************************************************/

/*
 *        val2int() converts an OpsVal into an integer
 *        val2sym() converts an OpsVal into a symbol
 *        int2val() converts an integer into an OpsVal
 *        sym2val() converts a symbol into an OpsVal
 */

#define val2int(v) ((int) (v) >> 1)

#define val2sym(v) ((Symbol) (v) >> 1)

#define int2val(i) ((OpsVal) (i) << 1)

#define sym2val(i) ((OpsVal) ((i) << 1) + 1)

#define symbolp(i) ((i) & 01)

#define numberp(i) (((i) & 01) == 0)

#define difftypes(i,j) (((i) ^ (j)) & 01)

#define sametypes(i,j) ((((i) ^ (j)) & 01) == 0)








/*************************************************************************

                     GLOBAL VARIABLES

*************************************************************************/
extern wmeptrvec         *flg_instance;     /* Ptr to the wmes of the chosen instance  */
extern int                flg_len_instance; /* How many wmes in the chosen instance    */
extern int                flgpfire;         /* The chosen rule's rhs address (just an index now for CParaOPS5)  */
extern OpsVal		  flg_ruleid;       /* Name/id of the rule about to fire       */
extern int		 *watch;	    /* Corresponds to watch-level in lisp OPS5 */


extern OpsVal  syminf,
               symcrlf,
               symrjust,
               symtabto,
               symnil,
               symeof,
               symin,
               symout,
               symaccept,
               symwrite,
               symtrace;



/* NOTE: These variables (curwme through R9)
 *       are global to the Rete match code.
 */
extern wmeptr             curwme;              /* Points to current wme to add/delete. */
extern int                curdir;              /* Add/delete curwme. */
extern int                succdir;             /* Direction for successor nodes  */
extern wmeptr             ops_target;          /* Name known by Rete for curwme. */

extern int              (*R0)();               /* Used by Push/PopTaskQueue for routine addr. */
extern int                HKey;                /* Hash table key (was R11 on Vax and R3 on Encore. */

extern DataPtr            R6;
extern DataPtr            R7;
extern DataPtr            R8;
extern DataPtr            R9;


extern tq_cell		  **task_queue[MAX_QUEUES];        /* global task queue for scheduling tasks */
extern int                 *tq_index[MAX_QUEUES];
extern int                  QueueSize;

#ifndef UNIPROC_VERSION
extern LockPtr		    tq_lock[MAX_QUEUES];
#endif

extern int                  NumQueues;
extern int                  NumQueues_Minus1;
extern int                  QueueSelect;

extern int		  *BitVector;          /* Each bit set identifies an active process. */

#ifndef UNIPROC_VERSION
extern LockPtr	  	   tb_lock;	       /* Lock for modifying the BitVector.      */
#endif

extern int		  *end_of_run_flag;

extern beta_cell   **ltokHT;	                 /* Hash table for left tokens. */
extern beta_cell   **ltokHTconj;                 /* Hash table for left conjugate tokens. */
extern alpha_cell  **rtokHT;                     /* Hash table for right tokens. */
extern alpha_cell  **rtokHTconj;                 /* Hash table for right conjugate tokens. */

extern int	   NumProc;		     /* Number of match processes */
extern int	   ProcessID;		     /* ID of match process */
extern int         ProcessIDBit;             /* Bit to represent the ProcessID (2**ProcessID) */
extern int         MyPrimaryQueue;           /* Process' main queue for push/popping tasks. */

extern int      MakeInputLineNum;               /* Line being parsed in make input file. */
extern FILE    *yyin;                           /* File descriptor for make input file. */
extern boolean  WantCmdInterpreter;             /* Tells if user wants interactive mode. */



extern int     *CR_Strategy;                    /* Conflict resolution strategy to use. */


extern struct rusage  *g_time_match_beg, *g_time_match_end;
extern struct rusage  *g_time_rhs_beg, *g_time_rhs_end;
extern struct rusage  *g_time_init;
extern struct rusage  *g_time_load_beg, *g_time_load_end;

extern double g_match_utime, g_match_stime, g_rhs_utime, g_rhs_stime;
extern double g_init_utime, g_init_stime;
extern double g_load_utime, g_load_stime;

extern boolean g_match_started;



extern FILE *fp_watch;       /* Where watch info is printed. */
extern FILE *fp_dbug;        /* Where debug info is printed. */
extern FILE *fp_err;         /* Where error info is printed. */
extern FILE *fp_out;         /* Where normal info is printed. */


extern boolean  show_debug;        /* Allows debugging info to be printed to fp_dbug. */



/* Added to allow tokens from hash tables to be
 * restored to free list for system reinitialization.
 */
extern beta_cell   **Global_Free_4_Bcell;   /* Header for global free list of beta cells. */
extern beta_cell   **Global_Free_32_Bcell;  /* Header for global free list of beta cells. */
extern beta_cell   **Global_Free_128_Bcell; /* Header for global free list of beta cells. */
extern beta_cell   **Global_Free_256_Bcell; /* Header for global free list of beta cells. */

#ifndef UNIPROC_VERSION
extern LockPtr       Free_4_Bcell_Lock;     /* Lock for the above free list. */
extern LockPtr       Free_32_Bcell_Lock;    /* Lock for the above free list. */
extern LockPtr       Free_128_Bcell_Lock;   /* Lock for the above free list. */
extern LockPtr       Free_256_Bcell_Lock;   /* Lock for the above free list. */
#endif

extern alpha_cell  **Global_Free_Acell;     /* Header for global free list of alpha cells. */

#ifndef UNIPROC_VERSION
extern LockPtr       Free_Acell_Lock;       /* Lock for the above free list. */
#endif

extern tq_cell     **Global_Free_TQcell;    /* Header for global free list of tq_cells. */

#ifndef UNIPROC_VERSION
extern LockPtr       Free_TQcell_Lock;      /* Lock for the above free list. */
#endif
