
/****************************************************************************
 *
 * MODULE:  extern.c
 *
 ****************************************************************************
 *
 * Abstract:
 *    Global variables.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    16 Aug 89 V5.0  Anurag Acharya
 *                    Integrated the uniprocessor version
 *    15 Aug 89       Anurag Acharya
 *                    Enclosed all the lock declarations in conditional
 *                    compilation statements(#ifndef UNIPROC_VERSION)
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Update for CParaOPS5 Version 4.0 P4.3.
 *    15 May 89 V3.0  Dirk Kalp
 *                    Move lock definitions for the hash based token memory
 *                    to psm_locks.c. Use new lock type from psm_locks.h.
 *    12 May 89 V2.0  Dirk Kalp
 *                    Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    Increase max number of CEs permitted in LHS from 64
 *                    to 256 (corresponding compiler change made in ../lhs).
 *                    Redefine alpha_cell and beta_cell to have token part
 *                    at end of structure to allow for variable size token
 *                    part (to save space instead of always allocating size
 *                    256) and, in turn, permit Rete assembly code to access
 *                    the fields in the structure with uniform offsets.
 *                    Added global free lists for the alpha and beta cells
 *                    to allow system reinitialization to reclaim memory
 *                    used for the cells in the hash tables (Note: Each
 *                    match process continues to maintain its own local
 *                    free lists across system initializations.).
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *    28 Aug 86       Dirk Kalp
 *    22 Aug 86 V1.0  Anoop Gupta
 *
 * Copyright (c) 1986, 1987, 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/

#include  "global.h"


int 		*watch;			/* corresponds to watch-level in lisp OPS5 */


wmeptrvec          *flg_instance;       /* Ptr to the wmes of the chosen instance */
int                 flg_len_instance;   /* How many wmes in the chosen instance */
int                 flgpfire;           /* The chosen rule's rhs address (just an index now for CParaOPS5)  */
OpsVal 		    flg_ruleid;         /* Name/id of rule about to fire */




OpsVal  syminf,
	symcrlf,
        symrjust,
        symtabto,
        symnil,
        symeof,
	symin,
	symout,
	symaccept,
	symwrite,
	symtrace;




/* NOTE: The variables 'ops_target', 'curdir', 'succdir', tq_.....
 *       are global to the Rete match assembly code.
 */
wmeptr             curwme;              /* Points to current wme to add/delete. */
int                curdir;              /* Add/delete curwme. */
int		   succdir;		/* Direction for successor nodes  */
wmeptr             ops_target;          /* Name known by Rete for curwme. */

int              (*R0)();               /* Used by Push/PopTaskQueue for routine addr. */
int                HKey;                /* Hash table key (was R11 on Vax and R3 on Encore. */

DataPtr            R6;
DataPtr            R7;
DataPtr            R8;
DataPtr            R9;

tq_cell		  **task_queue[MAX_QUEUES];              /* global task queue for scheduling tasks */
int                *tq_index[MAX_QUEUES];
int                 QueueSize;

#ifndef UNIPROC_VERSION
LockPtr		    tq_lock[MAX_QUEUES];
#endif

int                 NumQueues;
int                 NumQueues_Minus1;
int                 QueueSelect;

int		  *BitVector;                    /* Each bit set identifies an active process. */

#ifndef UNIPROC_VERSION
LockPtr		  tb_lock;	        	 /* Lock for modifying the BitVector.      */
#endif

int		  *end_of_run_flag;


beta_cell   **ltokHT;	                  /* Hash table for left tokens. */
beta_cell   **ltokHTconj;                 /* Hash table for left conjugate tokens. */
alpha_cell  **rtokHT;                     /* Hash table for right tokens. */
alpha_cell  **rtokHTconj;                 /* Hash table for right conjugate tokens. */

int	   NumProc;		     /* Number of match processes */
int	   ProcessID;		     /* ID of match process */
int        ProcessIDBit;             /* Bit to represent the ProcessID (2**ProcessID) */
int        MyPrimaryQueue;           /* Process' main queue for push/popping tasks. */


int      MakeInputLineNum;               /* Line being parsed in make input file. */
FILE    *yyin;                           /* File descriptor for make input file. */
boolean  WantCmdInterpreter;             /* Tells if user wants interactive mode. */



int     *CR_Strategy;                    /* Conflict resolution strategy to use. */



struct rusage  *g_time_match_beg, *g_time_match_end;
struct rusage  *g_time_rhs_beg, *g_time_rhs_end;
struct rusage  *g_time_init;
struct rusage  *g_time_load_beg, *g_time_load_end;

double g_match_utime, g_match_stime, g_rhs_utime, g_rhs_stime;
double g_init_utime, g_init_stime;
double g_load_utime, g_load_stime;

boolean g_match_started;


FILE *fp_watch;       /* Where watch info is printed. */
FILE *fp_dbug;        /* Where debug info is printed. */
FILE *fp_err;         /* Where error info is printed. */
FILE *fp_out;         /* Where normal info is printed. */

boolean  show_debug = FALSE;   /* Allows debugging info to be printed to fp_dbug. */


/* Added to allow tokens from hash tables to be
 * restored to free list for system reinitialization.
 */
beta_cell   **Global_Free_4_Bcell;   /* Header for global free list of beta cells. */
beta_cell   **Global_Free_32_Bcell;  /* Header for global free list of beta cells. */
beta_cell   **Global_Free_128_Bcell; /* Header for global free list of beta cells. */
beta_cell   **Global_Free_256_Bcell; /* Header for global free list of beta cells. */

#ifndef UNIPROC_VERSION
LockPtr       Free_4_Bcell_Lock;     /* Lock for the above free list. */
LockPtr       Free_32_Bcell_Lock;    /* Lock for the above free list. */
LockPtr       Free_128_Bcell_Lock;   /* Lock for the above free list. */
LockPtr       Free_256_Bcell_Lock;   /* Lock for the above free list. */
#endif

alpha_cell  **Global_Free_Acell;     /* Header for global free list of alpha cells. */

#ifndef UNIPROC_VERSION
LockPtr       Free_Acell_Lock;       /* Lock for the above free list. */
#endif

tq_cell     **Global_Free_TQcell;    /* Header for global free list of tq_cells. */

#ifndef UNIPROC_VERSION
LockPtr       Free_TQcell_Lock;      /* Lock for the above free list. */
#endif
