
/****************************************************************************
 *
 * MODULE:  VAX_locks.s
 *
 ****************************************************************************
 *
 * Abstract:
 *    VAX assembly coded routines for lock operations defined in psm_locks.h.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    10 Aug 89 V4.0  Dirk Kalp
 *                    Update for CParaOPS5 Version 4.0 P4.3.
 *    15 May 89 V5.0  Dirk Kalp
 *                    Create for CParaOPS5 Version 3.0 P4.2.
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/




/*--------------------------------------------------------------------------
 *
 *	VAX_Test_Then_Lock(lockptr)
 *         LockPtr lockptr;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Test_Then_Lock
_VAX_Test_Then_Lock:
	.word	0x0
1:	tstb	*4(ap)
	jneq	1b
	bbssi	$0, *4(ap), 1b
	ret


/*--------------------------------------------------------------------------
 *
 *	VAX_Release(lockptr)
 *         LockPtr lockptr;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Release
_VAX_Release:
	.word	0x0
1:	bbcci	$0,*4(ap), 1b
	ret


/*--------------------------------------------------------------------------
 *
 *	VAX_Lock(lockptr)
 *         LockPtr lockptr;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Lock
_VAX_Lock:
	.word	0x0
1:	bbssi	$0, *4(ap), 1b
	ret





/*--------------------------------------------------------------------------
 *
 *	VAX_LA_LR_RW_HT(bucket)
 *         int bucket;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_LA_LR_RW_HT
_VAX_LA_LR_RW_HT:
	.word	0x0
	movl	4(ap), r0			/* r0 = bucket index */
	movab	*_tokHTlock[r0], r1		/* r1 = addr of lock */
	moval	*_LeftRightCounter[r0], r0	/* r0 = addr of counters */

	/* Test counters to see if in correct state.  We test and spin here */
	/* rather than lock first in order to avoid going out of the cache. */
1:	tstw	(r0)				/* RightCount == 0 ? (need write access) */
	jneq	1b				/* loop if not */
	tstw	2(r0)				/* LeftCount >= 0 ? (need read access) */
	jlss	1b				/* loop if not */

	/* Counters look OK, but have to check them under lock. */
2:	tstb	(r1)				/* Test_Then_Lock(tokHTlock[bucket]) */
	jneq	2b
	bbssi	$0, (r1), 2b

	tstw	(r0)				/* RightCount == 0 ? (need write access) */
	jneq	4f				/* abort if not */
	tstw	2(r0)				/* LeftCount >= 0 ? (need read access) */
	jlss	4f				/* abort if not */

	/* State OK, so set Right for write access and Left for read access. */
	decw	(r0)				/* RightCount = -1 */
	incw	2(r0)				/* LeftCount++ */

3:	bbcci	$0, (r1), 3b			/* Release(tokHTlock[bucket]) */
	ret

4:	bbcci	$0, (r1), 4b			/* Release(tokHTlock[bucket]) */
	jbr	1b				/* go try again */


/*--------------------------------------------------------------------------
 *
 *	VAX_Rel_LR_HT(bucket)
 *         int bucket;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Rel_LR_HT
_VAX_Rel_LR_HT:
	.word	0x0
	movl	4(ap), r0			/* r0 = bucket index */
	movab	*_tokHTlock[r0], r1		/* r1 = addr of lock */
	moval	*_LeftRightCounter[r0], r0	/* r0 = addr of counters */

1:	tstb	(r1)				/* Test_Then_Lock(tokHTlock[bucket]) */
	jneq	1b
	bbssi	$0, (r1), 1b

	decw	2(r0)				/* LeftCount-- */

2:	bbcci	$0, (r1), 2b
	ret


/*--------------------------------------------------------------------------
 *
 *	VAX_Rel_RW_HT(bucket)
 *         int bucket;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Rel_RW_HT
_VAX_Rel_RW_HT:
	.word	0x0
	movl	4(ap), r0			/* r0 = bucket index */
	moval	*_LeftRightCounter[r0], r0	/* r0 = addr of counters */
        incw	(r0)
/*	movw	$0, *_LeftRightCounter[r0] */	/* RightCount = 0 */
	ret





/*--------------------------------------------------------------------------
 *
 *	VAX_LA_LW_RR_HT(bucket)
 *         int bucket;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_LA_LW_RR_HT
_VAX_LA_LW_RR_HT:
	.word	0x0
	movl	4(ap), r0			/* r0 = bucket index */
	movab	*_tokHTlock[r0], r1		/* r1 = addr of lock */
	moval	*_LeftRightCounter[r0], r0	/* r0 = addr of counters */

	/* Test counters to see if in correct state.  We test and spin here */
	/* rather than lock first in order to avoid going out of the cache. */
1:	tstw	2(r0)				/* LeftCount == 0 ? (need write access) */
	jneq	1b				/* loop if not */
	tstw	(r0)				/* RightCount >= 0 ? (need read access) */
	jlss	1b				/* loop if not */

	/* Counters look OK, but have to check them under lock. */
2:	tstb	(r1)				/* Test_Then_Lock(tokHTlock[bucket]) */
	jneq	2b
	bbssi	$0, (r1), 2b

	tstw	2(r0)				/* LeftCount == 0 ? (need write access) */
	jneq	4f				/* abort if not */
	tstw	(r0)				/* RightCount >= 0 ? (need read access) */
	jlss	4f				/* abort if not */

	/* State OK, so set Right for write access and Left for read access. */
	decw	2(r0)				/* LeftCount = -1 */
	incw	(r0)				/* RightCount++ */

3:	bbcci	$0, (r1), 3b			/* Release(tokHTlock[bucket]) */
	ret

4:	bbcci	$0, (r1), 4b			/* Release(tokHTlock[bucket]) */
	jbr	1b				/* go try again */


/*--------------------------------------------------------------------------
 *
 *	VAX_Rel_RR_HT(bucket)
 *         int bucket;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Rel_RR_HT
_VAX_Rel_RR_HT:
	.word	0x0
	movl	4(ap), r0			/* r0 = bucket index */
	movab	*_tokHTlock[r0], r1		/* r1 = addr of lock */
	moval	*_LeftRightCounter[r0], r0	/* r0 = addr of counters */

1:	tstb	(r1)				/* Test_Then_Lock(tokHTlock[bucket]) */
	jneq	1b
	bbssi	$0, (r1), 1b

	decw	(r0)				/* RightCount-- */

2:	bbcci	$0, (r1), 2b
	ret


/*--------------------------------------------------------------------------
 *
 *	VAX_Rel_LW_HT(bucket)
 *         int bucket;
 *      {
 *         VAX assembly code
 *      }
 *--------------------------------------------------------------------------*/
	.globl	_VAX_Rel_LW_HT
_VAX_Rel_LW_HT:
	.word	0x0
	movl	4(ap), r0			/* r0 = bucket index */
	moval	*_LeftRightCounter[r0], r0
	incw	2(r0)
/*	movw	$0, *_LeftRightCounter+2[r0] */	/* LeftCount = 0 */
	ret






