
/****************************************************************************
 *
 * MODULE:   printops.c  
 *
 ****************************************************************************
 *
 * Abstract:
 *    The routines here are used to print out debugging information.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    12 May 89 V2.0 Dirk Kalp
 *                   Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    No changes.
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *    16 May 86
 *    14 May 86
 *     1 May 86
 *    29 Apr 86
 *    27 Feb 86
 *    26 Feb 86 V1.0  Dirk Kalp
 *                    Put together from previous version created by
 *                    Quei-Len Lee.
 *
 * Copyright (c) 1986, 1987, 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/

/***** NOTE: These routines need to be modified to show new fields added
/*****       to data structures in "defs.h". Also some formatting of
/*****       debugging information should be done. Also add documentation
/*****       to routine headers.
 *****/ 
   

#include "defs.h"



/* Imported Routines:
 *    From system:
 *       fopen
 *       fclose
 */



/* External Routines:
 *    These routines from other modules return values other than the
 *    standard integer and so their return types are declared here
 *    for routines in this module that call them.
 */
/* There are none. */



/* Forward Declarations:
 *    These routines return values other than the standard integer and
 *    their return types are given here for other routines in this module
 *    that call them before they are defined.
 */
/* There are none. */





static boolean  opened_sym = FALSE;


write_symtab()
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    Print out symbol table.
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *    "cmp_production" in "cmplhs.c".
 *
 *-------------------------------------------------------------------------*/
{
   FILE   *fopen();
   FILE   *fp;
   int    key;
   symptr sym;

   if (opened_sym)
      fp = fopen("symbol.tab", "a");
   else
     {
      fp = fopen("symbol.tab", "w");
      opened_sym = TRUE;
     }
   
   key = 0;
   while (key <= (HASHTABSIZE - 1))
     {
      sym = hashtable[key];
      while (sym)
        {
         printsym(sym, key, fp);
         sym = sym->next;
        }
      ++key;
     }
     
   printcname(fp);
   
   printbucket(fp);
   
   fclose(fp);
}



printsym(sym, key, fp)
   symptr sym;
   int    key;
   FILE   *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "x" in "x.c".
 *
 *-------------------------------------------------------------------------*/
{
   attptr att;
   conf_ptr clist;
   
   fprintf(fp, "\n");
   fprintf(fp, "HashNumber = %d\t Symbol: %s\n", key, sym->symname);
   fprintf(fp, "\t\tIs_vec_att:\t%d\n", sym->is_vec);
   fprintf(fp, "\t\tIs_pname:\t%d\n", sym->is_pname);
   fprintf(fp, "\t\tIs_cname:\t%d\n", sym->is_cname);
   fprintf(fp, "\t\tIs_att:\t%d\n", sym->is_att);
   fprintf(fp, "\t\tIs_fname:\t%d\n", sym->is_fname);
   fprintf(fp, "\t\tValid_bind:\t%d\n", sym->valid_bind);
   fprintf(fp, "\t\tOpsbind:\t%d\n", sym->opsbind);  
   fprintf(fp, "\t\tAttribute list:\n");

   att = sym->attlist;  fprintf(fp,"\t\t\t");
   while (att)
     {
      fprintf(fp, "%s  ", att->attname);
      att = att->next;
     }
   fprintf(fp,"\n");

   fprintf(fp, "\t\tConflict List:\n");
   clist = sym->conflist;
   while (clist)
     {
      fprintf(fp, "%s  ", clist->conf->symname);
      clist = clist->next;
     }
   fprintf(fp, "\n");
}



printsym1(sym)
   symptr sym;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "x" in "x.c".
 *
 *-------------------------------------------------------------------------*/
{
   attptr att;
   conf_ptr clist;
   
   printf("SYMBOL:\t %s\n", sym->symname);
   printf("\t\tIs_vec_att:\t%d\n", sym->is_vec);
   printf("\t\tIs_pname:\t%d\n", sym->is_pname);
   printf("\t\tIs_cname:\t%d\n", sym->is_cname);
   printf("\t\tIs_att:\t%d\n", sym->is_att);
   printf("\t\tIs_fname:\t%d\n", sym->is_fname);
   printf("\t\tValid_bind:\t%d\n", sym->valid_bind);
   printf("\t\tOpsbind:\t%d\n", sym->opsbind);	  
   printf("\t\tAttribute list:\n");

   att = sym->attlist;  printf("\t\t\t");
   while (att)
     {
      printf("%s  ", att->attname);
      att = att->next;
     }
   printf("\n");

   printf("\t\tConflict List:\n");  printf("\t\t\t");
   clist = sym->conflist;
   while (clist)
     {
      printf("%s  ", clist->conf->symname);
      clist = clist->next;
     }
   printf("\n");
}



printkey(key)
   int key;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "x" in "x.c".
 *
 *-------------------------------------------------------------------------*/
{
   attptr att;
   conf_ptr clist;
   
   if(hashtable[key])
     {
      printf("SYMBOL:\t %s\n", hashtable[key]->symname);
      printf("\t\tIs_vec_att:\t%d\n", hashtable[key]->is_vec);
      printf("\t\tIs_pname:\t%d\n", hashtable[key]->is_pname);
      printf("\t\tIs_cname:\t%d\n", hashtable[key]->is_cname);
      printf("\t\tIs_att:\t%d\n", hashtable[key]->is_att);
      printf("\t\tIs_fname:\t%d\n", hashtable[key]->is_fname);
      printf("\t\tValid_bind:\t%d\n", hashtable[key]->valid_bind);
      printf("\t\tOpsbind:\t%d\n", hashtable[key]->opsbind);  
      printf("\t\tAttribute list:\n");
      
      att = hashtable[key]->attlist;  printf("\t\t\t");
      while (att)
        {
         printf("%s  ", att->attname);
         att = att->next;
        }
      printf("\n");

      printf("\t\tConflict List:\n");
      clist = hashtable[key]->conflist;  printf("\t\t\t");
      while (clist)
        {
         printf("%s  ", clist->conf->symname);
         clist = clist->next;
        }
      printf("\n");
     }
}



printcptr(cptr)
   cname_ptr cptr;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "x" in "x.c".
 *
 *-------------------------------------------------------------------------*/
{
   sym_attptr ptr;
  
   if (cptr)
     {
      printf("cname %s\n", cptr->cname->symname);
      while (cptr)
        {
         ptr = cptr->attlist;
         printf("attribute list: ");
         while (ptr)  printf("%s  ", ptr->attsym->symname);
         printf("\n");
         cptr = cptr->next;
        }
     }
}



printcname(fp)
   FILE *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "x" in "x.c".
 *
 *-------------------------------------------------------------------------*/
{
   cname_ptr  cptr;
   sym_attptr aptr;

   cptr = b_cname_ptr;
   while (cptr)
     {
      fprintf(fp, "Class name: %s :\n", cptr->cname->symname);
      aptr = cptr->attlist;
      fprintf(fp, "\tAttribute list: ");
      while (aptr)
        { 
         fprintf(fp, " %s ", aptr->attsym->symname);
         aptr = aptr->next;
        }
      fprintf(fp,"\n");
      cptr = cptr->next;
     }
}



printbucket(fp)
   FILE *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "x" in "x.c".
 *
 *-------------------------------------------------------------------------*/
{
   sym_attptr aptr;
   int        i;

   i = FIRST_OPSBIND;
   while ((i <= g_last_buc) && (bucket[i]))
     {
      aptr = bucket[i];
      fprintf(fp, "bucket[%d] : ", i);
      while (aptr)
        {
         fprintf(fp, " %s", aptr->attsym->symname);
         aptr= aptr->next;
        }
      fprintf(fp,"\n");
      ++i;
     }
}





static boolean  opened_net;


write_net()
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   FILE *fopen(), *fp;
   symptr sym;
   nodeptr node, bnode;

   if (opened_net)
      fp = fopen("network", "a");
   else
     {
      fp = fopen("network", "w");
      opened_net = TRUE;
     }
   
   node  = g_root;
   bnode = g_root->son->brothl;
  
   while (node)
     {
      fprintf(fp,"\n");
      fprintf(fp,"node name: "); pnodename(node->nodename, fp);
      fprintf(fp,"node addr: %x\n", node);
      switch (node->nodename)
        {
         case ROOT_NODE:   break;
         case TEQA: 
         case TNEA: 
         case TXXA: 
         case TEQN:
         case TNEN:
         case TGTN:
         case TGEN:
         case TLTN:
         case TLEN:
         case TXXN:
         case TEQS:
         case TNES:
         case TGTS:
         case TGES:
         case TLTS:
         case TLES:
         case TXXS:     ptnode(node->nodeinfo.tnode, fp);       break;
         case AND_NODE:
         case NOT_NODE: pbetanode(node->nodeinfo.betanode, fp); break;
         case P_NODE:   ppnode(node->nodeinfo.pnode, fp);       break;
         case ANY_NODE: panynode(node->nodeinfo.anynode, fp);   break;
         case RI_NODE:  break;
         default:       fprintf(fp, "no such nodename : %d", node->nodename);
        }
      fprintf(fp, " lbrother:  %x ", node->brothl);
      fprintf(fp, "  rbrother:  %x ", node->brothr);
      fprintf(fp, "  son :  %x\n", node->son);
      if (node->son)
         node = node->son;
      else
        {
         node = bnode;
         bnode = node->brothl;
        }
     } /* end while */
}



printnet(node)
   nodeptr node;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   symptr sym;

   if (node)
     {
      printf("\n");
      printf("node name: ");
      pnodename(node->nodename, stdout);
      printf("node addr: %x\n", node);
      switch (node->nodename)
        {
         case ROOT_NODE:  break;
         case TEQA: 
         case TNEA: 
         case TXXA: 
         case TEQN:
         case TNEN:
         case TGTN:
         case TGEN:
         case TLTN:
         case TLEN:
         case TXXN:
         case TEQS:
         case TNES:
         case TGTS:
         case TGES:
         case TLTS:
         case TLES:
         case TXXS:     ptnode(node->nodeinfo.tnode, stdout);       break;
         case AND_NODE:
         case NOT_NODE: pbetanode(node->nodeinfo.betanode, stdout); break;
         case P_NODE:   ppnode(node->nodeinfo.pnode, stdout);       break;
         case ANY_NODE: panynode(node->nodeinfo.anynode, stdout);   break;
         case RI_NODE:  break;
         default:       printf("no such nodename : %d", node->nodename);
        }
      printf(" lbrother: %x ", node->brothl);
      printf(" rbrother: %x ", node->brothr);
      printf(" son : %x\n", node->son);
      if (node->nodename == RI_NODE)  printnet(node->son);
     }
}



static
pnodename(name, fp)
   scalar name;
   FILE   *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   switch (name)
     {
      case 1:    fprintf(fp, "ROOT_NODE"); break;
      case 2:    fprintf(fp, "T_NODE");    break;
      case 3:    fprintf(fp, "AND_NODE");  break;
      case 4:    fprintf(fp, "NOT_NODE");  break;
      case 5:    fprintf(fp, "P_NODE");    break;
      case 6:    fprintf(fp, "RI_NODE");   break;
      case 7:    fprintf(fp, "ANY_NODE");  break;
      case 100:  fprintf(fp, "TEQA");      break;  
      case 101:  fprintf(fp, "TNEA");      break;  
      case 106:  fprintf(fp, "TXXA");      break;  
      case 200:  fprintf(fp, "TEQN");      break;  
      case 201:  fprintf(fp, "TNEN");      break;  
      case 202:  fprintf(fp, "TGTN");      break;  
      case 203:  fprintf(fp, "TGEN");      break;  
      case 204:  fprintf(fp, "TLTN");      break;  
      case 205:  fprintf(fp, "TLEN");      break;  
      case 206:  fprintf(fp, "TXXN");      break; 
      case 300:  fprintf(fp, "TEQS");      break;  
      case 301:  fprintf(fp, "TNES");      break;  
      case 302:  fprintf(fp, "TGTS");      break;  
      case 303:  fprintf(fp, "TGES");      break;  
      case 304:  fprintf(fp, "TLTS");      break;  
      case 305:  fprintf(fp, "TLES");      break;  
      case 306:  fprintf(fp, "TXXS");      break;  
      case 400:  fprintf(fp, "TEQB");      break;
      case 401:  fprintf(fp, "TNEB");      break;
      case 402:  fprintf(fp, "TGTB");      break;  
      case 403:  fprintf(fp, "TGEB");      break;  
      case 404:  fprintf(fp, "TLTB");      break;  
      case 405:  fprintf(fp, "TLEB");      break;  
      case 406:  fprintf(fp, "TXXB");      break;
     }
}



static
ptnode(tn, fp)
   t_nodeptr tn;
   FILE      *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   fprintf(fp, "  pos: %d ", tn->pos); 
   fprintf(fp, "  value: ");
   if (tn->utype == INTNUM)  fprintf(fp,"%d ", tn->value.num);
   if (tn->utype == SUBNUM)  fprintf(fp,"%d ", tn->value.snum);
   if (tn->utype == STRING)  fprintf(fp,"%s ", tn->value.str);
}



static
pbetanode(an, fp)
   beta_nodeptr an;
   FILE         *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   tests_ptr tlist;

   fprintf(fp, "test list: \n");
   tlist = an->testlist;
   while (tlist)
     {
      fprintf(fp, " test:         %d ", tlist->test);
      fprintf(fp, " left wme:     %d ", tlist->l_wme);
      fprintf(fp, " left subnum:  %d ", tlist->l_snum);
      fprintf(fp, " right subnum: %d \n", tlist->r_snum);
      tlist = tlist->next;
     }
}



static
ppnode(pn, fp)
   p_nodeptr pn;
   FILE      *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   fprintf(fp, "  p node name : %s \n", pn->pname);
   fprintf(fp, "   test count: %d\n", pn->testcnt);
}



static
panynode(pn, fp)
   any_nodeptr pn;
   FILE        *fp;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   anyatm_ptr ptr;

   ptr = pn->anyatm_list;
   fprintf(fp, "   pos: %d  anyatom: ", pn->snum);
   while (ptr)
     {
      if (ptr->is_int)
         fprintf(fp, " %d, ", ptr->aval.any_int); 
      else
         fprintf(fp, " %s, ", ptr->aval.any_ptr->symname); 
      ptr = ptr->next;
     }
}



printvar(var)
   varptr var;
/*---------------------------------------------------------------------------
 *
 * Abstract:
 *    X
 *
 * Parameters:
 *    None
 *
 * Environment:
 *    Nothing special.
 *
 * Calls:
 *    No one.
 *
 * Called by:
 *    "main" in "ops5.c".
 *
 *-------------------------------------------------------------------------*/
{
   while (var)
     {
      printf("%s %d %d %d %x\n",
             var->varname, var->test, var->cenum, var->snum, var->next);
      var = var->next;
     }
}

