%{

/****************************************************************************
 *
 * MODULE:  ops5.yacc
 *
 ****************************************************************************
 *
 * Abstract:
 *    Provides specifications to YACC for the parser.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    25 Jun 89 V4.0 Dirk Kalp
 *                   Update with ParaOPS5 4.3.
 *    12 May 89 V2.0 Dirk Kalp
 *                   Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    25 Jun 89 V4.3  Dirk Kalp
 *                    Change all compiler generated routine names to have
 *                    "ops_" prefix. This is to ensure no conflicts with
 *                    system or user routine names when user programs are
 *                    linked.
 *    19 Apr 89 V4.2  Dirk Kalp
 *                    Change "default" to "ops_default", "default" is a 
 *                    keyword in C.
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *     1 Oct 88 V3.2  Dirk Kalp
 *                    Add call to routine "extfunc" when external function is
 *                    recognized in RHS call action or user defined function.
 *                    Needed to check that name was declared External.
 *    23 Sep 88 V3.1  Anurag Acharya
 *		
 *			Modified the grammar specs to jell together with the
 *			lex changes. just doing that cut the yacc tables
 *			sizes by more than half!
 *			Details:
 *			  * merged the CSATOM and ANYATOM tokens into a single
 *			    ATOM token - differentiation based on context
 * 			  * merged the ANYNUMBER and the FIXNUM tokens into
 *			    a single FIXNUM token - using context again
 *			  * removed the non-terminal var_or_constant : this was
 *			    obviated once the different atom tokens were merged
 *			  * simplified the spec for "atom_list"
 *
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    No changes.
 *     9 Aug 88 V2.1  Dirk Kalp
 *                    Modified  specification for user_defined_function
 *                    to use "ucall" instead of "fcall".
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *                    Added this module header.     
 *
 * Copyright (c) 1986, 1987, 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 *
 ****************************************************************************/

#include "defs.h"

#define LITERALIZE_VAL 		0
#define LITERAL_VAL		1
#define EXTERNAL_VAL		2
#define VECTOR_ATTRIBUTE_VAL	3
#define PRODUCTION_VAL		4

int argcnt;
char *prodname;
int topleveltype;

extern int flagtoplevel;
extern int flagfunction;
extern int flagcommand;
extern int flagcompute;

%}
%union {
    int ival;
    char cval;
    double fval;
    str_arr sval;
}
%token <ival> PROD
%token <ival> MAKE
%token <ival> REMOVE
%token <ival> MODIFY
%token <ival> HALT
%token <ival> BIND
%token <ival> CBIND
%token <ival> CALL
%token <ival> WRITE
%token <ival> OPENFILE
%token <ival> CLOSEFILE
%token <ival> DEFAULT
%token <ival> LITVAL
%token <ival> LITERAL
%token <ival> LITERALIZE
%token <ival> VECTOR
%token <ival> EXTERNAL
%token <ival> SUBSTR
%token <ival> GENATOM
%token <ival> CRLF
%token <ival> RJUST
%token <ival> TABTO
%token <ival> ACCEPT
%token <ival> ACCEPTLINE
%token <ival> COMPUTE
%token <ival> ACTION
%token <ival> RANGLEB
%token <ival> LANGLEB
%token <ival> MOD
%token <ival> DIV
%token <ival> NEQ
%token <ival> LT
%token <ival> EQUAL
%token <ival> LE
%token <ival> GE
%token <ival> GT
%token <ival> FIXNUM
%token <sval> ATOM
%token <sval> VAR
%type <cval> '=', '+', '-', '*', '(', ')', '{', '}','^'
%start program
%%
program                 :    seq_of_dec_prod
                        ;

seq_of_dec_prod         :    /* empty */
                        |    seq_of_dec_prod  dec_or_prod 
				{ 
				  flagtoplevel = 1; 
				}
                        ;

dec_or_prod             :    '('  literalize_decl  ')'
                        |    '('  literal_decl  ')'
                        |    '('  vec_attr_decl  ')'
                        |    '('  external_decl  ')'
                        |    '('  production  ')'
                        ;

literalize_decl         :    LITERALIZE 
				{
				  topleveltype = LITERALIZE_VAL;
				}
			    ATOM  attr_list  {literalize($3);}
                        ;


attr_list               :    /* empty */
                        |    ATOM  attr_list  {add_attr_list($1);}
                        ;

vec_attr_decl           :    VECTOR 
				{
				  topleveltype = VECTOR_ATTRIBUTE_VAL;
			         }
			     attr_list  {vec_att();}
                        ;

literal_decl            :    LITERAL
				{
				  topleveltype = LITERAL_VAL;
				}
			     literal_list  {literal();}
                        ;

literal_list            :    /* empty */ 
                        |    ATOM  '='  FIXNUM  literal_list {add_literal($1, $3);}
                        ;

external_decl           :    EXTERNAL 
				{
				  topleveltype = EXTERNAL_VAL;
				}
			     attr_list  {extern_dec();}
                        ;

production              :    PROD  ATOM  
				{ 
				  topleveltype = PRODUCTION_VAL;
				  prodname = $2;
				  cmp_production($2);
				}  
			      lhs  ACTION
                                {note_rhs();}  
			      rhs  
				{cmp_p();}
                        ;

lhs                     :    positive_ce  rest_lhs
                        ;

rest_lhs                :    /* empty */
                        |    rest_lhs  any_ce
                        ;

any_ce                  :    positive_ce 
                        |    negative_ce 
                        ;

positive_ce             :    form
                        |    '{'  VAR   form  '}' {cmp_cevar($2);}
                        |    '{'  form  VAR   '}' {cmp_cevar($3);}
                        ;

negative_ce             :    '-'  {set_flag_negce();}  form  
                        ;

form                    :    '('  {init_ce();}  lhs_term_list  ')'  {cmp_ce();} 
                        ;

lhs_term_list :              /* empty */
                        |    lhs_term_list  {init_lhsterm();}  lhs_term 
                        ;

lhs_term                :    '^'  ATOM  {cmp_tab($2);}  lhs_value 
                        |    '^'  FIXNUM  {cmp_tabno($2);}  lhs_value
                        |    lhs_value
                        ;

lhs_value               :    '{'  restriction_list  '}'
                        |    restriction 
                        ;

restriction_list        :    /* empty */ 
                        |    restriction_list  {init_test();} restriction 
                        ;

restriction             :    LANGLEB  atom_list  RANGLEB  {cmp_any();}
                        |    predicate  atomic_value
                        |    atomic_value
                        ;

atom_list            :    /* empty */
                        |    atom_list  ATOM    {add_anystr($2);}
                        |    atom_list  FIXNUM  {add_anynum($2);}
                        ;

atomic_value            :    ATOM  {cmp_constant($1);}
                        |    FIXNUM  {cmp_fixnum($1);}
                        |    VAR     {cmp_var($1);}
                        ;


predicate               :    '='    {note_test(TEST_EQ);}
                        |    NEQ    {note_test(TEST_NE);}
                        |    LT     {note_test(TEST_LT);}
                        |    LE     {note_test(TEST_LE);}
                        |    GE     {note_test(TEST_GE);}
                        |    GT     {note_test(TEST_GT);}
                        |    EQUAL  {note_test(TEST_XX);}
                        ;

rhs                     :    action_list  {newinst(); codeouts("_opsret");}
                        ;

action_list             :    /* empty */ 
                        |    action_list  '('  
					     {
						flagcommand = 1;
					      }
			     action  ')' 
                        ;

action                  :    MAKE  {newinst(); codeouts("_ops_bmake");}
                             rhs_term_list  {newinst(); codeouts("_ops_emake");}
                        |    REMOVE  element_designator_list 
                        |    MODIFY  {newinst(); codeouts("_ops_bmodify");}
                             element_designator  rhs_term_list
                             {newinst(); codeouts("_ops_emodify");} 
                        |    HALT  {newinst(); codeouts("_ops_halt");}
                        |    BIND  VAR  {newinst(); codeouts("_ops_reset");
                                         newinst(); codeouts("_ops_fcall");
                                         newinst(); codeoutl(0);
                                         newinst(); codeouts("_ops_genatom");
                                         newinst(); codeouts("_ops_bind");  
                                         bvarnum($2);} 
                        |    BIND  VAR  {newinst(); codeouts("_ops_reset");}
                             rhs_term_list  {newinst(); codeouts("_ops_bind"); bvarnum($2);}
                        |    CBIND  VAR  {newinst(); codeouts("_ops_cbind"); cbvarnum($2);}
                        |    CALL  {newinst(); codeouts("_ops_reset");} ATOM
                             rhs_term_list  {newinst(); codeouts("_ops_call");
                                             newinst(); /*codeoutc('_');*/ extfunc($3);}
                        |    WRITE  
				{
				 newinst(); codeouts("_ops_reset");
				}
                             rhs_term_list  
				{
				 newinst(); codeouts("_ops_write");
				}
                        |    OPENFILE  {newinst(); codeouts("_ops_reset");}
                             rhs_term_list  {newinst(); codeouts("_ops_openfile");}
                        |    CLOSEFILE  {newinst(); codeouts("_ops_reset");}
                             rhs_term_list  {newinst(); codeouts("_ops_closefile");}
                        |    DEFAULT  {newinst(); codeouts("_ops_reset");} 
                             rhs_term_list  {newinst(); codeouts("_ops_default");}
                        ;

element_designator_list :    /* empty */
                        |    {newinst(); codeouts("_ops_remove");}
                             element_designator  element_designator_list 
                        ;

element_designator      :    FIXNUM  {newinst(); codeouti(ele_num($1));}
                        |    VAR  {newinst(); codeouti(ele_var($1));}
                        ;

rhs_term_list           :    /* empty */
                        |    rhs_term_list  rhs_term
                        ;

rhs_term                :    '^'  ATOM  {cmp_tab($2);}
                             rhs_value 
                        |    '^'  FIXNUM  {cmp_tabno($2);}
                             rhs_value 
                        |    '^'  VAR  {cmp_var($2); newinst(); codeouts("_ops_variabletab");}
                             rhs_value 
                        |    rhs_value 
                        ;

rhs_value               :    atomic_value { newinst(); codeouts("_ops_rval"); }
                        |    '('  
				{ 
				  flagfunction = 1;
				}				
				function  ')'
                        ;

elem_designator_substr  :    FIXNUM  {newinst(); codeouts("_ops_fixcon");
			              newinst(); codeoutl(ele_num($1));}
                        |    VAR  {newinst(); codeouts("_ops_fixcon");
      				   newinst(); codeouti(ele_var($1));}
                        ;

function                :    LITVAL  atomic_value
                             {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(1);
                              newinst(); codeouts("_ops_litval");}
                        |    SUBSTR  elem_designator_substr  atomic_value
                             atomic_value  {newinst(); codeouts("_ops_fcall"); 
			                       newinst(); codeoutl(3);
                                               newinst(); codeouts("_ops_substr");}
                        |    GENATOM 
                             {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(0);
                              newinst(); codeouts("_ops_genatom");}
                        |    CRLF 
                             {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(0);
                              newinst(); codeouts("_ops_crlf");}
                        |    RJUST  atomic_value
                             {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(1);
                              newinst(); codeouts("_ops_rjust");}
                        |    TABTO  atomic_value 
                             {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(1);
                              newinst(); codeouts("_ops_tabto");}
                        |    ACCEPT  {argcnt=0;} file_descriptor
			     {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(argcnt);
			      newinst(); codeouts("_ops_accept");}
                        |    ACCEPTLINE  {argcnt=0;} arg_list
			     {newinst(); codeouts("_ops_fcall");
			      newinst(); codeoutl(argcnt);
			      newinst(); codeouts("_ops_acceptline");}
                        |    COMPUTE  expression
			     {newinst(); codeouts("_ops_rval"); flagcompute = 0; }
                        |    user_defined_function
                        ;

file_descriptor         :    /* empty */
                        |    ATOM         {cmp_constant($1); argcnt++;}
			|    VAR            {cmp_var($1); argcnt++;}
			;
			
arg_list                :    /* empty */
                        |    arg_list  {argcnt++;}  atomic_value
			;

user_defined_function   :    ATOM  {argcnt=0;}  atomic_value_list
                             {newinst(); codeouts("_ops_ucall");
                              newinst(); codeoutl(argcnt);
			      newinst(); /*codeoutc('_');*/ extfunc($1);}
                        ;

atomic_value_list    	:    /* empty */
                        |    atomic_value_list  {argcnt++;}  atomic_value
                        ;

expression              :    element
                        |    element  '+'  expression  {newinst(); codeouts("_ops_add");}
                        |    element  '-'  expression  {newinst(); codeouts("_ops_sub");}
                        |    element  '*'  expression  {newinst(); codeouts("_ops_mult");}
                        |    element  DIV  expression  {newinst(); codeouts("_ops_div");}
                        |    element  MOD  expression  {newinst(); codeouts("_ops_mod");}
                        ;

element                 :    '('  expression  ')'
                        |    FIXNUM  {cmp_fixnum($1);}
                        |    VAR  {cmp_var($1);}
                        ;


