%{

/****************************************************************************
 *
 * MODULE:  ops5.lex
 *
 ****************************************************************************
 *
 * Abstract:
 *    Provides specifications to Lex for the lexical analyzer.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    12 May 89 V2.0 Dirk Kalp
 *                   Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    24 Oct 88 V4.0  Dirk Kalp
 *                    Release of ParaOPS5 Version 4.0.
 *    13 Aug 88 V3.2  Dirk Kalp
 *                    Fixed bug in specs for substr, genatom, and litval.
 *    23 Sep 88 V3.1  Anurag Acharya 
 *
 *		         Recoded the specifiction of several tokens -
 *			 mostly moving stuff from the Lex recognizer into my
 *			 own C code - the rationale being that the pattern
 *			 being recognized was very simple and trying to use 
 *			 full power of Lex would both slow it down and take
 *			 up a lot more table space. Most of the tokens treated
 *			 this way were the ones that "scanned" their input
 *			 till a particular character appeared in the input
 *			 stream.
 * 			details:
 *				* pushed the distinction between different types
 *				  of atoms into the Yacc specs ( as it should be)
 *				* double quoted atoms, bar quoted atoms, comments
 *				  are recognized by my C code
 *				* added a routine to scan characters from the 
 *				  input stream till some special char appears and
 *				  copy 'em to the Yacc buffer (yylval.sval)
 *				* merged the recognition of the "//" quoted
 *				  atoms with the recognition of "//"
 *				* simplified the recognition of the disjunctive
 *				  constants - now they are recognized as normal
 *				  quoted atoms - rather than special beasties
 *				* generalized the spec. for floating pt. numbers
 *				  now it accepts " . " as a number but issues a
 *				  "unsupported number" warning - this is pure
 *				  cosmetic.
 *    13 Aug 88 V3.0  Dirk Kalp
 *                    No changes.
 *    25 May 88 V2.0  Dirk Kalp
 *                    Updated to consolidate Vax and Encore versions.
 *                    Added this module header.     
 *
 * Copyright (c) 1986, 1987, 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 *
 ****************************************************************************/

#include "defs.h"
#include "y.tab.h"
int flagtoplevel = 1;
int flagcompute = 0;
int flagcommand = 0;
int flagdisjunct = 0;
int flagfunction = 0;
int OpsBufChar;
%}
%e	425
%a	8750
%p 	1500
%o	20000
%n	200
%k	100
number    [-+]?[0-9]+\.?
notnumber [-a-zA-Z0-9\_\!\@\#\$\%\&\*\<\>\:\+\/]
exp       [Ee][-+]?[0-9]+
%%
[ \t]+ 	;
[\n]	{ SourceLineNum++; }
";"     {
  	  for (OpsBufChar = input(); 
	       ((char) OpsBufChar != '\n') && (OpsBufChar != EOF);
	       OpsBufChar = input());
 	  SourceLineNum++;
	}

">>"    { 
	  if (flagdisjunct) { flagdisjunct = 0; return(RANGLEB); }
	  else { strcpy(yylval.sval,yytext); return(ATOM); }
	}

"="	{  return ('=');}
"+"	{  return ('+');}
"-"	{  return ('-');}
"*"	{  return ('*');}
"^"	{  return ('^');}
"("	{
	 return ('(');
	}
")"	{
	 return (')');
	}
"{"	{  return ('{');}
"}"	{  return ('}');}
"-->" 	{  return(ACTION);} 
"<<"    {  flagdisjunct = 1; return(LANGLEB);}
"//"	{
	  if (flagcompute) return(DIV);
	 else {  
		int i;
		char c;

		for (OpsBufChar = input(), i = 0;
		     OpsBufChar != EOF;
		     OpsBufChar = input(), i++)
		{
		
		  c = (char) OpsBufChar;
		
		  if (c == '\n' ) SourceLineNum++;

		  if ((c == ' ') || (c == '\t') || ( c == '\n'))
		   return(ATOM);

		  yylval.sval[i] = c;

		 }

		yylval.sval[i] = '\0';		  

		return(ATOM);		
	       }
	}
"\\"    {  return(MOD);}
"<>"	{  return(NEQ);}
"<"	{  return(LT);}
"<=>"	{  return(EQUAL);}
"<="	{  return(LE);}
">="	{  return(GE);}
">"	{  return(GT);}

p  	{
	 if (flagtoplevel) { flagtoplevel = 0; return(PROD); }
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
make 	{
	 if (flagcommand) {flagcommand = 0; return(MAKE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
remove  {
	 if (flagcommand) {flagcommand = 0; return(REMOVE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
modify  {
	 if (flagcommand) {flagcommand = 0; return(MODIFY);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
halt 	{
	 if (flagcommand) {flagcommand = 0; return(HALT);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
bind 	{
	 if (flagcommand) {flagcommand = 0; return(BIND);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
cbind 	{
	 if (flagcommand) {flagcommand = 0; return(CBIND);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
call 	{
	 if (flagcommand) {flagcommand = 0; return(CALL);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
write 	{
	 if (flagcommand) {flagcommand = 0; return(WRITE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
openfile {
	 if (flagcommand) {flagcommand = 0; return(OPENFILE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
closefile {
         if (flagcommand) {flagcommand = 0; return(CLOSEFILE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
default {
	 if (flagcommand) {flagcommand = 0; return(DEFAULT);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
litval {
	 if (flagfunction) {flagfunction = 0; return(LITVAL);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
literal {
	 if (flagtoplevel) {flagtoplevel = 0; return(LITERAL);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
literalize {
 	 if (flagtoplevel) {flagtoplevel = 0; return(LITERALIZE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
vector"-"attribute {
 	 if (flagtoplevel) {flagtoplevel = 0; return(VECTOR);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
external {
 	 if (flagtoplevel) {flagtoplevel = 0; return(EXTERNAL);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
substr  {
 	 if (flagfunction) {flagfunction = 0; return(SUBSTR);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
genatom {
 	 if (flagfunction) {flagfunction = 0; return(GENATOM);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
crlf 	{
 	 if (flagfunction) { flagfunction = 0; return(CRLF); }
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
rjust 	{
 	 if (flagfunction) { flagfunction = 0; return(RJUST); }
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
tabto   {
 	 if (flagfunction) { flagfunction = 0; return(TABTO); }
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
accept {
 	 if (flagfunction) {flagfunction = 0; return(ACCEPT);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
acceptline {
 	 if (flagfunction) {flagfunction = 0; return(ACCEPTLINE);}
	 else { strcpy(yylval.sval,yytext); return(ATOM);}
	}
compute {
 	 if (flagfunction)
           {
	    flagcompute = 1; 
            flagfunction = 0;
	    return(COMPUTE);
	   }
	 else
	   {
	    strcpy(yylval.sval,yytext);
	    return(ATOM);
	   }
	}

"<"({notnumber})+">" {
		      strcpy(yylval.sval,yytext);
		      return(VAR);
	             }
{number}   {
	       yylval.ival = atoi(yytext); 
	       return(FIXNUM);
	}

[-+]?[0-9]*\.[0-9]*({exp})?  {
	 yylval.ival = 0;
	 opserror("Floating numbers not supported...\n");
	 return(FIXNUM);
	}

\"	{
	  ScanTillAndRetain('\"');
	  return(ATOM);
        }

\| 	{
	  ScanTillAndRetain('|');
	  return(ATOM);
	  }


({notnumber})+ {
	   strcpy(yylval.sval,yytext);return(ATOM);
 	 }
%%

ScanTillAndRetain(c)
char c;
{
  int i;
	  
	  for ( OpsBufChar = input(), i = 0;
		(((char) OpsBufChar) != c) && (OpsBufChar != EOF);
		OpsBufChar = input(), i++)
	   {
		yylval.sval[i] = (char) OpsBufChar;
		
		if ( ((char) OpsBufChar) == '\n') 
		  SourceLineNum++;

	    }

	   yylval.sval[i] = '\0';
}
