
/****************************************************************************
 *
 * MODULE:  defs.h
 *
 ****************************************************************************
 *
 * Abstract:
 *    Declarations for global types and variables.
 *
 ****************************************************************************
 *
 * CParaOPS5
 * Change Log:
 *    12 May 89 V2.0 Dirk Kalp
 *                   Create CParaOPS5 from ParaOPS5 4.2.
 *
 ****************************************************************************
 *
 * ParaOPS5
 * Change Log:
 *    14 Feb 89 V4.1 Dirk Kalp
 *                   Added "g_vecatt_list" to collect up all the vector
 *                   attributes so they can be represented at the end of
 *                   the assembly file. This is to support standard OPS5
 *                   print format for wmes.
 *    24 Oct 88 V4.0 Dirk Kalp
 *                   Release of ParaOPS5 Version 4.0.
 *     1 Oct 88 V3.1 Dirk Kalp
 *                   Added definitions to support OPS5 user interface cmds
 *                   "matches" and "call" given at the top level.
 *    13 Aug 88 V3.0 Dirk Kalp
 *                   Increase max CEs permitted in LHS from 64 to 256.
 *    25 May 88 V2.0 Dirk Kalp
 *                   Updated to consolidate Vax and Encore versions.
 *    17 Sep 86      Dirk Kalp
 *    15 Sep 86      Dirk Kalp
 *    12 Sep 86      Dirk Kalp
 *    22 Aug 86      Dirk Kalp
 *    19 Aug 86
 *     9 Jul 86
 *    14 May 86
 *    12 MAy 86
 *     1 May 86
 *    29 Apr 86
 *    16 Apr 86
 *     4 Apr 86
 *    14 Mar 86 V1.0  Dirk Kalp
 *                    Put together from previous version created by
 *                    Quei-Len Lee.
 *
 * Copyright (c) 1986, 1987, 1988, 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement
 * specifies the terms and conditions for use and redistribution.
 *
 ****************************************************************************/


#include <stdio.h>

   

#define TRUE           1
#define FALSE          0



typedef char            *string;

typedef char            str_arr[128];

typedef unsigned short  scalar;

typedef unsigned short  boolean;

typedef short int       opsnum;

typedef union
        {
         string str;
         int    num;
         opsnum snum;
        }
        opsval;

typedef struct
        {
         boolean flag_error;
         boolean flag_warn;
         int     errcnt;
         int     warncnt;
        }
        csw_struct;



extern FILE       *yyin;          /* File ptr to source file of productions. */
extern FILE       *codeout;       /* File ptr to output file of compiled code. */
extern FILE       *fp_root;       /* File ptr to output file of compiled code. */
extern FILE       *fp_sub ;       /* File ptr to output file of compiled code. */
extern FILE       *fp_incl;       /* File ptr to output file of compiled code. */
extern int        SourceLineNum;  /* Which line in source file we're parsing. */
extern int        debug;
extern int        debugnet;
extern csw_struct csw;            /* Tracks compilation errors. */


#define HASHTABSIZE    1009
#define BUCKETSIZE     128

#define CLASS_OPSBIND  1       /* Field index for a class name. */
#define FIRST_OPSBIND  1       /* First field index. */
#define MAX_OPSBIND    127     /* Maximum field index of an attribute. */

#define FIRST_CE_INDEX 1
#define LAST_CE_INDEX  256
#define POSITIVE_CE    1
#define NEGATIVE_CE   -1


typedef struct att_struct
        {
         string            attname;  /* String name of an attribute. */
         opsnum            num;      /* Binding assigned by Literal. */
         struct att_struct *next;
        }
        att_list, *attptr;


typedef struct conf_struct
        {
         struct symtab_struct *conf; /* Points to attribute in conflict set. */
         struct conf_struct   *next;
        }
        conf_list, *conf_ptr;


typedef struct symtab_struct
        {
         string   symname;         /* String name of the symbol. */
         boolean  is_fname;        /* Flag if an external function name. */
         boolean  is_pname;        /* Flag if a production name. */
         boolean  is_cname;        /* Flag if a class name. */
         boolean  is_att;          /* Flag if an attribute name. */
         boolean  is_vec;          /* Flag if a vector attribute name. */
         boolean  valid_bind;      /* Flag if next field validated. */
         opsnum   opsbind;         /* Binding if is_att. */
         attptr   attlist;         /* Attribute list if is_cname. */
         conf_ptr conflist;        /* Conflict list if is_att. */
         int      offset;          /* Offset in ops_symbols table. */
         struct symtab_struct *next;
        }
        symtab, *symptr;


typedef struct attsym_struct
        {
         symptr               attsym; /* Ptr to attribute in symbol table. */
         struct attsym_struct *next;
        }
        sym_att, *sym_attptr;


typedef struct cname_struct
        {
         symptr              cname;   /* A class name entry in symbol table. */
         sym_attptr          attlist; /* List of attributes for the class. */ 
         struct cname_struct *next;
        }
        cname_list, *cname_ptr;



extern symptr     hashtable[HASHTABSIZE];  /* The symbol table. */

extern attptr     b_attptr;           /* Beginning of a list of att names. */
extern attptr     e_attptr;           /* End of a list of att names. */
extern attptr     free_attptr;        /* Free list of att_struct's. */

extern cname_ptr  b_cname_ptr;        /* Beginning of list of class names. */
extern cname_ptr  e_cname_ptr;        /* End of list od class names. */

extern sym_attptr bucket[BUCKETSIZE]; /* Groups att names by field index. */
extern opsnum     g_last_buc;         /* Highest index of any att name. */

extern int        ce_type[LAST_CE_INDEX+1];  /* Used to mark ce's as pos/neg. */

extern sym_attptr g_vecatt_list;      /* Global head of list of all vector attributes. */



#define ROOT_NODE 1
#define T_NODE    2
#define AND_NODE  3
#define NOT_NODE  4
#define P_NODE    5
#define RI_NODE   6
#define ANY_NODE  7

#define TEST_EQ   0
#define TEST_NE   1
#define TEST_GT   2
#define TEST_GE   3
#define TEST_LT   4
#define TEST_LE   5
#define TEST_XX   6

#define ATM     100
#define NUM     200
#define S       300
#define BETA    400

#define STRING    1
#define INTNUM    2
#define SUBNUM    3

#define TEQA    100   /* TEST_EQ + ATM */
#define TNEA    101   /* TEST_NE + ATM */
#define TXXA    106   /* TEST_XX + ATM */

#define TEQN    200   /* TEST_EQ + NUM */
#define TNEN    201   /* TEST_NE + NUM */
#define TGTN    202   /* TEST_GT + NUM */
#define TGEN    203   /* TEST_GE + NUM */
#define TLTN    204   /* TEST_LT + NUM */
#define TLEN    205   /* TEST_LE + NUM */
#define TXXN    206   /* TEST_XX + NUM */

#define TEQS    300   /* TEST_EQ + S */
#define TNES    301   /* TEST_NE + S */
#define TGTS    302   /* TEST_GT + S */
#define TGES    303   /* TEST_GE + S */
#define TLTS    304   /* TEST_LT + S */
#define TLES    305   /* TEST_LE + S */
#define TXXS    306   /* TEST_XX + S */

#define TEQB    400   /* TEST_EQ + BETA */
#define TNEB    401   /* TEST_NE + BETA */
#define TGTB    402   /* TEST_GT + BETA */
#define TGEB    403   /* TEST_GE + BETA */
#define TLTB    404   /* TEST_LT + BETA */
#define TLEB    405   /* TEST_LE + BETA */
#define TXXB    406   /* TEST_XX + BETA */

#define CEVAR     1   /* A condition element var. */
#define GVAR      2   /* An externally bound attribute var. */
#define CURVAR    3   /* An internally bound attribute var in current ce. */
#define BVAR      4   /* A var created with BIND. */
#define CBVAR     5   /* A var created with CBIND. */



typedef struct var_struct
        {
         string            varname; /* String name of variable. */
         scalar            test;    /* Predicate associated with var. */
         opsnum            cenum;   /* Associated condition element number. */
         opsnum            snum;    /* Associated sub-element number. */
         struct var_struct *prev;
         struct var_struct *next;
        }
        varrec, *varptr;


typedef struct          /* T_NODE */
        {
         opsnum pos;    /* Subelement number of an attribute. */
         scalar utype;  /* Tells type of next field, 'value'. */
         opsval value;  /* The value of the attribute. */
        }
        t_noderec, *t_nodeptr;



typedef struct anyatm_struct
        {
         boolean is_int;           /* Identifies type of next field. */
         union   {
                  int    any_int;  /* For integer constant atoms. */
                  symptr any_ptr;  /* For string constant atoms. */
                 }
                 aval;
        struct anyatm_struct *next;
        }
        anyatm_rec, *anyatm_ptr;

typedef struct                     /* ANY_NODE */
        {
         anyatm_ptr anyatm_list;   /* List of constants in the disjunction.*/
         opsnum     snum;          /* Subelement number of the attribute. */
        }
        any_noderec, *any_nodeptr;



typedef struct           /* P_NODE */
        {
         string pname;   /* String name of production. */
	 int    pindex;  /* Index of production in source file. */
         int    testcnt; /* Specificity as measured by count of features. */
         int    cecount; /* Number of condition elements. */
         string rtn;     /* String name of C routine name generated by compiler. */
        }
        p_noderec, *p_nodeptr;



typedef struct test_struct
        {
         scalar test;    /* Test to perform between 2 attributes. */
         opsnum l_wme;   /* Which wme in the left memory token to select. */
         opsnum l_snum;  /* Subelement number of attribute in l_wme. */
         opsnum r_snum;  /* Subelement number of attribute in right memory. */
         struct test_struct *next;
        }
        tests_rec, *tests_ptr;

typedef struct               /* Beta nodes: AND_NODE, NOT_NODE */
        {
         tests_ptr testlist; /* List of variable test specs for beta node. */
         int       nodeid;   /* Node ID for beta node */
         int       betalev;  /* Depth in network of this beta node. */
	 string    right_rtn;     /* Compiler generated name of right join routine. */
	 string    left_rtn;      /* Compiler generated name of left join routine. */
	 string    testpass_rtn;  /* Compiler generated name of test and pass token routine (AND only). */
	 string    test_rtn;      /* Compiler generated name of test bindings routine (NOT only). */
	 string    pass_rtn;      /* Compiler generated name of pass token routine (NOT only). */
        }
        beta_noderec, *beta_nodeptr;



typedef union                /* Node-specific info records. */
        {
         t_nodeptr    tnode;
         any_nodeptr  anynode;
         p_nodeptr    pnode;
         beta_nodeptr betanode;
        }
        nodetype;

typedef struct nodelist      /* Record structure for Rete network nodes. */
        {
         scalar          nodename;
         nodetype        nodeinfo;
         struct nodelist *brothl;
         struct nodelist *brothr;
         struct nodelist *son;
        }
        noderec, *nodeptr;





extern varptr     g_bvar;          /* Heads list of vars created with BIND. */
extern varptr     g_cbvar;         /* Heads list of vars created with CBIND. */
extern opsnum     g_bvarnum;       /* Provides index for next BIND var. */
extern opsnum     g_cbvarnum;      /* Provides index for next CBIND var. */


extern boolean    have_compiled_p; /* Flags when first production is seen. */
extern boolean    flag_rhs;        /* Set when compiling RHS of a production. */
extern boolean    have_cmprhs;     /* Set when RHS of first production seen. */
extern boolean    first_inst;      /* Signals beginning of RHS codegen for a production. */

extern int 	  g_num_rete_roots;/* Number of rete network roots       */
extern int	  g_max_rules_in_rete; /* Max number of rules in a network before it is split */

extern string     g_pname;         /* Name of production being compiled. */
extern int        g_pcount;        /* Counts number of productions. */
extern int        g_featurecount;  /* Counts specificity in a production. */

extern nodeptr    g_root;          /* Points to the root node in network. */
extern nodeptr    g_last;          /* Points to last node added to network. */
extern nodeptr    g_lastbranch;    /* Points to last network branch built. */

extern boolean    g_flag_negce;    /* Set when we have negated cond element. */
extern int        g_cecount;       /* Counts cond elements in a production. */
extern opsnum     g_subnum;        /* Field index of current att in a ce. */
extern scalar     g_curtest;       /* Predicate associated with current att. */
extern anyatm_ptr g_anyatm;        /* Points to head of current disjunction. */
extern varptr     g_curvar;        /* Heads list of vars in current ce. */
extern varptr     g_var;           /* Heads list of att vars externally bound. */
extern varptr     g_cevar;         /* Heads list of ce vars in a production. */
extern int        g_betalev;       /* Tells # of wme's in a left-mem token. */

extern varptr     freevar;         /* Free list for variable records. */
extern nodeptr    freenode;        /* Free list for ROOT and RI_NODEs. */
extern nodeptr    freetnode;       /* Free list for T_NODEs. */
extern nodeptr    freepnode;       /* Free list for P_NODEs. */
extern nodeptr    freebetanode;    /* Free list for AND and NOT_NODEs. */ 
extern nodeptr    freeanynode;     /* Free list for ANY_NODEs. */
extern anyatm_ptr free_anyatm;     /* Free list for disjunction elements. */
extern tests_ptr  free_test;       /* Free list for beta test elements. */

extern sym_attptr g_opssym;        /* Beginning of list of string constants. */
extern sym_attptr g_lastsym;       /* End of list of string constants. */
extern int        g_offset;        /* Offset into 'ops_symbols' for strings. */



/* Declarations to support top level OPS5 user interface cmds "matches" and "call".
 * These provide the hooks needed to extract information to pass on to the OPS5
 * run-time system.
 */


typedef struct blist_struct
        {
         nodeptr             bnode;    /* Point to a beta node. */
         struct blist_struct *next;
        }
        blist_rec, *blist_ptr;


typedef struct plist_struct
        {
         symptr              prodsym;      /* Symbol table entry for a production. */
         blist_ptr           blist_head;   /* Used to access all beta nodes of a given production. */
         blist_ptr           blist_tail;   /* Gets us to tail of above list. */
         struct plist_struct *next;
        }
        plist_rec, *plist_ptr;



typedef struct elist_struct
        {
         symptr              ext_fname;    /* Symbol table entry for external function name. */
         struct elist_struct *next;
        }
        elist_rec, *elist_ptr;




extern plist_ptr    ProductionList;   /* Provides access to each production and its beta nodes. */
extern plist_ptr    g_prod;           /* Collects up the beta nodes for the production being compiled. */

extern elist_ptr    ExternalList;     /* A list to access all the names declared as external functions. */



#define OPS_LEAVE 999999

#define JSB       0
#define JBR       1
#define JEQL      2
#define JNEQ      3
#define JGEQ      4
#define JGTR      5
#define JLEQ      6
#define JLSS      7


#define MEM_HASHTABLE_SIZE  4096

typedef struct stack             /* An element in the depth-first stack. */
        {
        nodeptr node;
        int     lab;
        struct stack *next;
        }
        stkrec, *stkptr;



typedef struct link              /* An element on the forward label list. */
        {
        nodeptr node;
        int     lab;
        struct link *next;
        }
        link_rec, *linkptr;



extern stkptr      stacktree;    /* The depth-first backtracking stack. */
extern stkptr      freestack;    /* Free list of stack records. */

extern linkptr     beta_testlink;/* List to remember beta node code labels. */
extern linkptr     beta_passlink;/* List to remember beta node code labels. */
extern linkptr     freelink;     /* Free list for link records. */

extern int         g_label;      /* Provides next 'L' label in Rete code. */

extern int         flag_ri;      /* Set when an RI_NODE is encountered. */
extern int         flag_skip_son;/* Set when short circuiting depth-first. */

extern int         nodeid_cnt;   /* node_id counter */

extern int         cur_nodeid;   /* node_id of current beta node. */
extern int         cur_betalev;  /* Wme's in left mem token of cur beta node. */

extern int         g_topcnt;     /* Provides next 'TOP' label in Rete code. */
extern int         g_exitcnt;    /* Provides next 'EXIT' label in Rete code. */

