@make(article)
@device(postscript)
@style(size 10)

@begin(transparent, indent 0)
@tabclear()
@b[Gregg Yost@>9 January 1991]
@end(transparent)

@blankspace(0.5 inches)
@center{@b[TAQL Tutorial Problem Set 2]}

Implement an operator, @i[insert-after], that inserts a new element
after a specified element of a list.  If the specified element is not
in the list, insert the new element at the beginning of the list.

For example, @w{@t[insert-after(^new q ^after a ^list (b a c))]} would
return the list @w{@t[(b a q c)]}, and
 @w{@t[insert-after(^new q ^after w ^list (b a c))]} would return the
 list @w{@t[(q b a c)]}.

Your implementation should invoke the member operator (discussed in
class, and define in member.taql) to find the item in the list if it
is there.  You should test your solution using a driver problem space
similar to the one we used to test the member operator (defined in
member-driver.taql).

Inserting a new element into a list is not entirely straightforward in
TAQL.  The problem is that you have to create a new list node and
splice it into the existing list, which involves editing two different
objects: the newly created node, and the prior node in the list (the
one that must be changed to point to the new node).  But, the
identifer of the newly-created node does not exist outside of the edit
clause that creates it, so that the edit clause that changes the prior
node cannot access the new node.  This may not be clear to you now,
but it will be when you try to do this.  You can solve this problem by
using the @i[:bind] keyword in apply-operator.  See the TAQL manual
for details.

The code for the member operator and its driver space are in
member.taql and member-driver.taql in the tutorial directory.@foot{The
tutorial directory is the taql-tutorial subdirectory of the directory
TAQL is installed in at your site.  It is also available in
/afs/cs.cmu.edu/project/soar/member/gry/taql-tutorial.}  A trace of
the member operator running its test cases is in member.trace.  Our
solution to this exercise and a trace of it running are in the files
insert-after.taql, insert-driver.taql, and insert-after.trace.
