;;; TAQL Load File
;;;
;;; Gregg Yost, Erik Altmann
;;; School of Computer Science
;;; Carnegie Mellon University
;;;
;;; Working file: /afs/cs.cmu.edu/user/altmann/taql/load.lisp
;;;
;;; Loading this file loads the TAQL system.
;;;
;;; Known bugs/funnies:
;;;
;;;   - When the function package is in good enough shape, we should be
;;;     able to load it directly out of its distribution directory, and
;;;     we shouldn't have to have our own copy of convert-expr.lisp.
;;; 
;;; =======================================================================
;;; Modification history:
;;; =======================================================================
;;;
;;; 7-15-91 - gry - We don't compile tc-doc-strings.lisp because if we do,
;;;   Lisp dies mysteriously when loading TAQL under Allegro CL 3.1.12.  It
;;;   just contains a bunch of constant definitions, anyways.
;;;
;;;   Also, changed so that TAQL will not be reloaded if it the :taql feature
;;;   is already present in the running lisp (which means that TAQL has
;;;   already been loaded).
;;;
;;; 7-14-91 - ema - loads tc-doc-strings.lisp
;;;
;;; 4-5-91 - gry - loads space-model.lisp and init-taql.lisp.
;;;
;;; 3-19-91 - gry - loads types.lisp (Type declarations, must be loaded first).
;;;
;;; 3-15-91 - gry - loads segments.lisp (Segment-related routines).
;;;
;;; 3-6-91 - gry - loads data-model.lisp (Data Model module).
;;;
;;; 2-20-91 - gry - loads pseudo-sp.lisp (Pseudo-SP expansion).
;;;
;;; 9-28-90 - gry - loads taql-version.lisp (TAQL version info).
;;;
;;; 9-13-90 - gry - loads operator-control.lisp (operator-control TC support)
;;;
;;; 9-5-90 - gry - loads data-types.lisp (TAQL data type support).
;;;    Introduced new load path variables.
;;;
;;; 2-6-90 - ema - loads all the stuff for the taql compiler.  change
;;;    the pathname taql-path if you copy the compiler to some other
;;;    directory. 

#+taql
(format t "~%TAQL is already loaded, not reloading.~%")

#-taql
(progn

 ;; Edit this variable to define the directory containing the TAQL libraries:

 (setq *taql-library-directory-pathname*
       (pathname
	"/afs/cs.cmu.edu/project/soar/member/gry/taql/3/1/4/lib/"))

 ;; Edit this variable to define the directory containing the function package:

 (setq *function-package-directory-pathname*
       (pathname
	"/usr/misc/.Soar5/lib/function/"))

 ;; Edit taql-path to define the directory containing TAQL:

 (let ((taql-path
	(pathname
	 "/afs/cs.cmu.edu/project/soar/member/gry/taql/3/1/4/"))
       (*load-verbose* nil))

   (load (merge-pathnames "types" taql-path))
   (load (merge-pathnames "taql-version" taql-path))
   (load (merge-pathnames "taql-compiler" taql-path))
   (load (merge-pathnames "data-types" taql-path))
   (load (merge-pathnames "operator-control" taql-path))
   (load (merge-pathnames "segments" taql-path))
   (load (merge-pathnames "data-model" taql-path))
   (load (merge-pathnames "space-model" taql-path))
   (load (merge-pathnames "pseudo-sp" taql-path))
   (load (merge-pathnames "tc-doc-strings.lisp" taql-path))
   (load (merge-pathnames "init-taql" taql-path))
   
   ;; When this is split out as a separate file from the function package,
   ;; we will load it from the directory the function package is installed
   ;; in.  This is only needed to support the expression data type.
   (load (merge-pathnames "convert-expr.lisp" taql-path))

   (load (merge-pathnames "taql-support.soar" taql-path))
   )

 (taql-greeting)
 )
