;;; TAQL Compile File
;;;
;;; Gregg Yost, Erik Altmann
;;; School of Computer Science
;;; Carnegie Mellon University
;;;
;;; Loading this file compiles the TAQL system.
;;;
;;; Known bugs/funnies:
;;;
;;;   - see /afs/cs/user/altmann/taql/compiled/README for one way to
;;;   compile for multiple platforms.
;;;
;;; =======================================================================
;;; Modification history:
;;; =======================================================================
;;;
;;; 7-15-91 - gry - We don't compile tc-doc-strings.lisp because if we do,
;;;   Lisp dies mysteriously when loading TAQL under Allegro CL 3.1.12.  It
;;;   just contains a bunch of constant definitions, anyways.
;;;
;;; 4-5-91 - gry - compiles space-model.lisp and init-taql.lisp.
;;;
;;; 3-19-91 - gry - compiles types.lisp (Type declarations, must be compiled
;;;                 first).
;;;
;;; 3-15-91 - gry - compiles segments.lisp (Segment-related routines).
;;;
;;; 3-6-91 - gry - compiles data-model.lisp
;;;
;;; 2-20-91 - gry - compiles pseudo-sp.lisp
;;;
;;; 10-7-90 - ema - added pointer to multiple platform stuff.
;;; 
;;; 9-28-90 - gry - modified to compile operator-control.lisp and
;;;                 taql-version.lisp
;;; 9-6-90 - gry - modified to compile data-types.lisp as well as
;;;                taql-compiler.lisp

(let ((taql-path
       (pathname
	"/afs/cs.cmu.edu/project/soar/member/gry/taql/3/1/4/")))

  (compile-file (merge-pathnames "types" taql-path))
  ;; We have to load the compiled file here, because some compilers are
  ;; too "smart" to let the special variable proclamations in it persist
  ;; across files (apparently).
  (load (merge-pathnames "types" taql-path))
  (compile-file (merge-pathnames "taql-version" taql-path))
  (compile-file (merge-pathnames "taql-compiler" taql-path))
  (compile-file (merge-pathnames "data-types" taql-path))
  (compile-file (merge-pathnames "operator-control" taql-path))
  (compile-file (merge-pathnames "segments" taql-path))
  (compile-file (merge-pathnames "data-model" taql-path))
  (compile-file (merge-pathnames "space-model" taql-path))
  (compile-file (merge-pathnames "pseudo-sp" taql-path))
  (compile-file (merge-pathnames "init-taql" taql-path))
 )
