@make(text)
@device(postscript)
@style(size 10)


@begin(transparent, indent 0)
@tabclear()
@b[Erik Altmann>9 January 1991]
@end(transparent)

@blankspace(0.5 inches)
@center{@b[TAQL Tutorial Problem Set 3:  The Selection Space]}

@b[Problem 1 - The Blocks World]

A very young Soar is to be taught how to create a
lexicographically-ordered tower of blocks on the floor.  In its
infancy, Soar is unable to lift more than one block at a time.  It can
put a block down either on another block or on the floor.  In the
figure below, the initial configuration of the blocks is on the left,
and the tower that Soar is to build is on the right.  In both
configurations, the bottom blocks rest implicitly on the floor.

@begin(center)
@graphic(postscript="blocks.idr",boundingbox="1.15in,9.2in,4.25in,10.2in")
@end(center)

Given just the operators for moving blocks, two of them will tie for
the very first move (it's possible to lift either @i(A) or @i(C)).
Without some search control knowledge, Soar will continue to encounter
an operator-tie impasse every time an operator has to be chosen.
Because the operators for this task are invertible, Soar could take an
unbounded length of time to find the result state (depending on the
order in which evaluate-object operators are chosen).

An elegant form of search control knowledge for this task is
@i(cycle-detection).  If Soar is able to recognize that it has reached
a state identical to one higher up on the context state, then it can
be told to backtrack from the second occurrence of the state.  (One
can think of this as Soar remembering that it was just in a particular
state; the context stack can be though of as a history of recent
operator applications.)

For example, if Soar first lifts @i(C), then it will generate a cycle
very soon.  If it puts @i(C) down on @i(A), then it can only pick
@i(C) up again, which is a duplicate state.  If it puts @i(C) down
immediately, then that it also a cycle.  This will eventually cause
Soar to backtrack and decide to evaluate the operator that lifts
@i(A).  This will take it off on a more extensive search.  Soar will
run into a number of similar dead ends, but will eventually find
the solution.

The attached TAQL program stub was generated from sample a Blocks
World solution, by deleting the bodies of many of the TCs.  Among
those remaining, some create a simple representation of the initial
and desired configurations in the top context.  There is a
@i(propose-initial-state) TC for the space that applies the task
operator, which uses the representation from the top context to build
one that is more convenient to manipulate when actually moving blocks.
There is a sample @i(augment) TC that shows how to add entailments to
the state so that the @i(:cycle-when) keyword can be used to detect
when a cycle has been reached.  All the comments from the sample
solution have been left in, to guide construction of a solution.

The @i[blocks] subdirectory of the tutorial directory
contains the attached stub program (stub.taql), the sample solution
from which it was generated (blocks.taql), and a trace of the sample
solution running (blocks.trace).@foot{The
tutorial directory is the taql-tutorial subdirectory of the directory
TAQL is installed in at your site.  It is also available in
/afs/cs.cmu.edu/project/soar/member/gry/taql-tutorial.}

@blankspace(1 line)

@b[Problem 2 - The Traveling Realtor]

A realtor of dubious credibility has to visit each of a number of
cities.  For various reasons, he decides to avoid visiting any city
twice (including the city he starts at).  He would also like to make
some effort to keep down the total distance that he travels on his
tour.  His simple, greedy algorithm is to pick the next city so as to
minimize the combined distance to the city @i(after) that one.  Write
a Soar program that implements this heuristic.

The figure below gives the cities and their separations, and the
realtor's starting position:

@begin(center)
@graphic(postscript="tour.idr",boundingbox=".75in,9.1in,2.6in,10.5in")
@end(center)

This exercise is optional, and no hints are given.  A sample solution
resides in the file trav.taql in the @i[trav] subdirectory of the
tutorial directory.
