;;; -*- Mode: Text -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;; File            : taql314.tpl
;;; Author : Frank Ritter 
;;; Created On: Wed Feb 20 17:36:39 1991
;;; Last Modified By: Frank Ritter
;;; Last Modified On: Wed Sep 25 12:41:57 1991
;;; Update Count : 98
;;; 
;;; PURPOSE 
;;; 	The templates to create taql constructs.  
;;; This is designed to work with TAQL 3.1.4, 
;;; not all Taql 3.0.* constructs are supported.  
;;; 
;;; TABLE OF CONTENTS 
;;; 	I.	The main menu
;;; 	II.  	The main constructs 
;;; 	III.  	Text templates 
;;;	IV.  	Construct name templates 
;;; 	V.	Old-fashioned taql templates
;;; 
;;; (C) Copyright 1991, Frank Ritter, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; 13 nov 90 changed addition-clauses to new-addition-clauses. fer
;;;           made problem-space part of name auto-expand
;;; * need to clear whitespace (if any) from front of menu selection 
;;; * shouldn't jump to selection, make user choose to.
;;;

#| Naming conventions

  Current                                            manual
{fu}   is required, once only                     {fu}
{?fu}  is optional                                [fu]
{fus}  is a bunch (and at least one) fu           [fu]+
{?fus} is 0,1 or more fu's                        [fu]*

Another approach would be:  this would be less formal, and perhaps
more accessable.

[!fu]  (or {} if I can't get [] to work)
[?fu]
[+fu]
[*fu]

clauses that expand to menus don't get ! (auto-expansion)
clauses that are textenter, and are embeded (not first element),
  should always get !
clauses that are first, but that are very frequent, also get !
So far, err on making user type y (ie, less auto-expansion)

Clauses are complicated with sub-templates
conditions bottom out with text

Lists with more than 1 line of items get parens matched in column.

Relative sizes of various template sets on 8/8/90:

  1382  awk.tpl
  2715  c.tpl
  2548  latex.tpl
  2808  elisp.tpl
  3401  pascal.tpl
  5484  bib.tpl
  6151  scribe.tpl
  8459  texinfo.tpl
 30180  taql.tpl

|#




;;; ****************************************************************
;;;        I.   the main menu
;;; ****************************************************************

Template taql-construct Selection
:begin
    PROBLEM-SPACE-PROPOSAL-AND-INITIALIZATION:
propose-space:	  	
propose-initial-state:  
propose-task-state:     
    OPERATOR-PROPOSAL:
propose-task-operator:	
propose-operator:	
    OPERATOR-SELECTION-and-EVALUATION:
prefer:
compare:
evaluate-object:
evaluation-properties:
operator-control:
    OPERATOR-APPLICATION:
apply-operator:		
    GOAL-TESTING-and-RESULT-RETURNING:
goal-test-group:
result-superstate:
propose-superobjects:	
    ELABORATION:
augment:		    
    OTHER-TEMPLATES:    
the-OSU-production-templates:
sp:			; the simple sp
taql-program-template:	; Yost's outline
:end
         5 /14 finished noon 2 aug
         6 /14 finished 1416 2 aug
         7 /14 finished 1951 2 aug
         8 /14 finished 1354 3 aug
         9 /14 finished 2323 3 aug
         10/14 finished 1737 5 aug
         11/14 finished 1007 6 aug
         12/14 finished 2042 8 aug
         13/14 finished 2053 8 aug

;;; ****************************************************************
;;; 	II.   The main constructs
;;;
;;; The large constructs here, then the small ones down below.  Both
;;; should be alphabetic.  Constructs only used within one TC are 
;;; included up here.
;;; ****************************************************************

;;;
;;;    PROBLEM SPACE PROPOSAL AND INITIALIZATION
;;;

Template PROBLEM-SPACE-PROPOSAL-AND-INITIALIZATION Selection
:begin
propose-space:
propose-initial-state:
propose-task-state:
:end


Template propose-space Sequence
:begin
(propose-space {!propose-space-name}
  {space-to-propose}
  {subspace-function-clause}
  {?when-conditions}
  {?copy-clauses}
  {?rename-clauses}
  {?new-addition-clauses}
  {?use-superspace-or-top-space-or-id-clause}
)
:end

Template space-to-propose Sequence
:begin
:space {!textenter:problem-space-name}
:end


;;;
;;; Subspace-function
;;;

Template subspace-function-clause Sequence
:begin
:function ({subspace-function})
:end

Template subspace-function Selection
:begin
apply-operator-operator-condition:
propose-or-select-initial-state-or-operator-for-space:
propose-or-select-space-that-will-perform-function:
:end

Template apply-operator-operator-condition Sequence
:begin
apply operator {operator-condition}
:end

Template propose-or-select Selection
:begin
propose
select
:end

Template propose-or-select-initial-state-or-operator-for-space Sequence
:begin
{propose-or-select} {initial-state-or-oper} for {!textenter:problem-space-name}
:end

Template initial-state-or-oper Selection
:begin
initial-state
operator
:end

Template propose-or-select-space-that-will-perform-function Sequence
:begin
{propose-or-select} space that will {!subspace-function}
:end



;;;
;;;   propose-initial-state 
;;;

Template propose-initial-state Sequence
:begin
(propose-initial-state {!propose-initial-state-name}
  {?space-condition}
  {?when-conditions}
  {?copy-clauses}
  {?rename-clauses}
  {?new-addition-clauses}
  {?use-superstate-or-top-state-or-id-clause}
)
:end


Template use-superstate-or-top-state-or-id-clause Sequence
:begin
:use {!superstate-or-top-state-or-id}
:end

Template superstate-or-top-state-or-id Selection
:begin
superstate
top-state
id:
:end

Template propose-task-state Sequence
:begin
(propose-task-state {!propose-task-state-name}
  {?space-condition}
  {?when-conditions}
  {?new-addition-clauses}
)
:end



;;;
;;;    OPERATOR PROPOSAL
;;;

Template OPERATOR-PROPOSAL Selection
:begin
propose-task-operator:
propose-operator:
:end

Template propose-task-operator Sequence
:begin
(propose-task-operator {!propose-task-operator-name}
  {space-condition}
  {operator-creation-by-spec-clause}
  {?when-conditions}
)
:end



;;; 
;;;  Propose-operator
;;; 

Template propose-operator Sequence
:begin
(propose-operator {!propose-operator-name}
  {operator-proposal-clause}
  {?space-condition}
  {?when-conditions}
  {?select-once-only}
)
:end

Template operator-proposal-clause Selection
:begin
operator-creation-by-spec-clauses:
operator-reference-by-id-clause:
:end

Template operator-creation-by-spec-clauses Repetition
:begin

{operator-creation-by-spec-clause}
:end

Template operator-creation-by-spec-clause Sequence
:begin
:op {simple-name-or-operator-creation-spec}
:end

Template operator-reference-by-id-clause Sequence
:begin
:op-id <{!textenter:operator-id}>
:end

Template simple-name-or-operator-creation-spec Selection
:begin
simple-operator-name:
operator-creation-spec:
:end

Template operator-creation-spec Sequence
:begin
({operator-name-or-no-name}{rhs-attribute-value-pairs}
 {?when-conditions}
 {?operator-substructure-clause})
:end

Template operator-substructure-clause Sequence
:begin
:substructure {other-soar-value-specs}
:end

Template operator-name-or-no-name Selection
:begin
simple-operator-name:
:no-name
:end


;;;
;;;    OPERATOR SELECTION and EVALUATION
;;;

Template OPERATOR-SELECTION-and-EVALUATION Selection
:begin
prefer:
compare:
evaluate-object:
evaluation-properties:
operator-control:
:end

Template prefer Sequence
:begin
(prefer {!prefer-name}
  {?space-condition}
  {?when-conditions}
  {?operator-condition-clause}
  {preferences-clauses}
  {?obscure-prefer-clauses}
)
:end

Template obscure-prefer-clauses Sequence
:begin
{?for-goal-condition}
{?object-type-spec}
{?object-condition}
:end

;;;
;;; Preferences
;;;

Template preferences-clauses Repetition
:begin

{preference-clause}
:end

Template preference-clause Sequence
:begin
:value {preference}
:end

Template preference Selection
:begin
best
worst
indifferent
reject
require
prohibit
reconsider
:end



;;;
;;;  COMPARE
;;;

Template compare Sequence
:begin
(compare {!compare-name}
  {?space-condition}
  {?when-conditions}
  {?op1-and-op2}
  {relation}
  {?obscure-compare-clauses}
)
:end

Template obscure-compare-clauses Sequence
:begin
{?for-goal-condition}
{?object-type-spec}
{?object1-and-object2}
:end

Template object1-and-object2 Sequence
:begin
:object1 <{!textenter:id-name}>
:object2 <{!textenter:id-name}>
:end

Template op1-and-op2 Sequence
:begin
:op1 {operator-condition}
:op2 {operator-condition}
:end

Template relation Sequence
:begin
:relation {better-or-worse-or-indifferent}
:end

Template better-or-worse-or-indifferent Selection
:begin
better
worse
indifferent
:end


;;;
;;;	operator-control
;;;

Template operator-control Sequence
:begin
(operator-control {!operator-control-name}
  {?space-condition}
  {?when-conditions}
  {control-spec-clause}
)
:end

Template control-spec-clause Sequence
:begin
:control-spec {control-spec}
:end

Template control-specs Repetition
:begin

{control-spec}
:end

Template control-spec Selection
:begin
op-condition:
modifier-condition:
:end

Template modifier-condition Sequence
:begin
({modifiers} {control-specs})
:end

Template modifiers Repetition
:begin

{modifier}
:end

Template modifier Selection
:begin
control-spec-type:
control-spec-modifier:
operator-modifier:
:end

Template control-spec-type Selection
:begin
:seq
:or
:loop
:end

Template control-spec-modifier Selection
:begin
:swp
:optional
when-condition:
exit-when-condition:
loop-spec:
:end

Template loop-spec Sequence
:begin
:loop-name {!textenter:symbol}
:end

Template operator-modifier Selection
:begin
:ind
:ra
:oot
:end




;;;
;;;    OPERATOR APPLICATION
;;;

Template OPERATOR-APPLICATION Selection
:begin
apply-operator:
result-superstate:
propose-superobjects:
:end

Template apply-operator Sequence
:begin
(apply-operator {!apply-operator-name}
  {operator-condition-clause}
  {?space-condition}
  {?when-conditions}
  {?terminate-when-conditions}
  {?bind-object-ids}
  {?use-state-clause}
  {?edits}
  {?actions}
  {?sliding-actions}
)
:end

Template terminate-when-conditions Repetition
:begin

{terminate-when-condition}
:end

Template terminate-when-condition Sequence
:begin
:terminate-when ({?conditions})
:end

Template use-state-clause Sequence
:begin
:use {!textenter:state-id}
:end


;;;
;;;	Edits  now used in result superstate & apply-op
;;;

Template edits Repetition
:begin

{edit}
:end

Template edit Sequence
:begin
(edit :what {object-spec}
  {?edit-type}
  {?when-conditions}
  {?replace-clauses}
  {?copy-clauses}
  {?rename-clauses}
  {?remove-clauses}
  {?new-addition-clauses}
  {?directive-clauses}
)
:end

Template edit-type Sequence
:begin
:type {sliding-or-one-shot}
:end

Template sliding-or-one-shot Selection
:begin
sliding
one-shot
:end

;;;
;;; replace-edit clauses
;;;

Template replace-clauses Repetition
:begin

{replace-clause}
:end

;; var-or-const should be lvalue in 314
Template replace-clause Sequence
:begin
:replace ({attribute-name}{?var-or-const}
          :by {value-spec}
          {?when-conditions}
         )
:end


Template copy-clauses Repetition
:begin

{!copy-clause}
:end

Template copy-clause Sequence
:begin
:copy ({attribute-names} {?from-object-spec}
       {?when-conditions}
       {?remove-from-target-or-sources})
:end

Template from-object-spec Sequence
:begin
:from {object-spec}
:end

Template remove-from-target-or-sources Repetition
:begin

{!remove-from-target-or-source}
:end

Template remove-from-target-or-source Sequence
:begin
:remove {source-or-target}
:end

Template source-or-target Selection
:begin
source
target
:end

;;;
;;; Rename-edit clauses
;;;

Template rename-clauses Repetition
:begin

{rename-clause}
:end

Template rename-clause Sequence
:begin
:rename ({attribute-name-pairs} {?from-object-spec}
         {?remove-from-target-or-sources}
         {?when-conditions})
:end

;;;
;;; remove-edit clauses
;;;

Template remove-clauses Repetition
:begin

{remove-clause}
:end

;; lvalue goes into 314
Template remove-clause Sequence
:begin
:remove ({attribute-name-or-all}{?var-or-const}
         {?when-conditions}
         )
:end

Template object-spec Selection
:begin
context-object:
bound-object:
state-subobject:
:end

Template bound-object Sequence
:begin
(:none {class} {id})
:end

Template state-subobject Sequence
:begin
({state-subobject-name} {class} {?id})
:end

;;;
;;;	Directive clauses
;;;

Template directive-clauses Repetition
:begin

{directive-clause}
:end

Template directive-clause Sequence
:begin
:directive ({directive}
            {?when-conditions})
:end

Template directive Selection
:begin
insert-clause:
delete-clause:
member-clause:
concatenate-clause:
rplaca-clause:
rplacd-clause:
:end

Template insert-clause Sequence
:begin
(insert* arg)
:end

Template delete-clause Sequence
:begin
(delete* arg)
:end

Template member-clause Sequence
:begin
(member* arg)
:end

Template concatenate-clause Sequence
:begin
(concatenate* arg)
:end

Template rplacd-clause Sequence
:begin
(rplacd* list new-cdr)
:end

Template rplaca-clause Sequence
:begin
(rplaca* list new-car)
:end



;;;
;;;  More operator application
;;;

Template result-superstate Sequence
:begin
(result-superstate {!result-superstate-name}
  {?space-condition}
  {?group-type-condition-or-id}
  {?group-name-condition-or-id}
  {?when-conditions}
  {?terminate-when-conditions}
  {?bind-object-ids}
  {?RS-use-state-condition}
  {?edits}
  {?actions}
  {?sliding-actions}
)
:end

Template RS-use-state-condition Sequence
:begin
:use {superstate-or-final-state-or-state}
:end

Template superstate-or-final-state-or-state Selection
:begin
superstate
final-state
state-id:
:end



;;;
;;;   More operator application
;;; 

Template propose-superobjects Sequence
:begin
(propose-superobjects {!propose-superobjects-name}
  {?space-condition}
  {?group-type-condition-or-id}
  {?group-name-condition-or-id}
  {?when-conditions}
  {object-type-spec}
  {superobjects-to-propose}
)
:end

Template superobjects-to-propose Repetition
:begin

{superobject}
:end

Template superobject Sequence
:begin
:object <{!textenter:id-name}>
:end


;;;
;;;      GOAL TESTING and RESULT RETURNING
;;;

Template GOAL-TESTING-and-RESULT-RETURNING Selection
:begin
goal-test-group:
result-superstate:
propose-superobjects:
:end

Template goal-test-group Sequence
:begin
(goal-test-group {!goal-test-group-name}
  {?space-condition}
  {?when-conditions}
  {?group-type-condition}
  {?group-name-condition}
  {?test-conditions}
)
:end

Template test-condition Sequence
:begin
:test ({!textenter:test-name} {when-conditions})
:end

Template test-conditions Repetition
:begin

{test-condition}
:end


;;;
;;;   Evaluate-object
;;;

Template evaluate-object Sequence
:begin
(evaluate-object {!evaluate-object-name}
  {?space-condition}
  {?when-conditions}
  {?bind-object-id}
  {objects-to-evaluate}
  {?numeric-value-clauses}
  {?symbolic-value-clauses}
)
:end

Template object-to-evaluate Sequence
:begin
:what {object-type-or-condition-to-evaluate}
:end

Template objects-to-evaluate Repetition
:begin

{object-to-evaluate}
:end

Template object-type-or-condition-to-evaluate Selection
:begin
evaluate-object-type:
evaluate-object-condition:
:end

Template evaluate-object-condition Sequence
:begin
({evaluate-object-type} {?when-conditions}
  {?bind-object-id}
  {?cycle-when-condition}
  {?return-when-conditions}
)
:end

Template evaluate-object-type Selection
:begin
problem-space
state
operator
lookahead-state
:end


Template numeric-value-clause Sequence
:begin
:numeric-value {simple-numeric-value-or-condition}
:end

Template numeric-value-clauses Repetition
:begin

{!numeric-value-clause}
:end

Template simple-numeric-value-or-condition Selection
:begin
novalue-or-integer:
novalue-or-integer-condition:
:end

Template novalue-or-integer-condition Sequence
:begin
({novalue-or-integer}
 {?when-conditions}
 {?bind-object-id}
)
:end

;;;
;;;  Symbolic values
;;; 

Template symbolic-value-clause Sequence
:begin
:symbolic-value {symbolic-value-or-condition}
:end

Template symbolic-value-clauses Repetition
:begin

{!symbolic-value-clause}
:end

Template symbolic-value-or-condition Selection
:begin
symbolic-value-type:
symbolic-value-type-condition:
:end

Template symbolic-value-type-condition Sequence
:begin
({symbolic-value-type}
 {?when-conditions}
 {?bind-object-id}
)
:end


Template cycle-when-condition Sequence
:begin
:cycle-when {conditions}
:end

Template return-when-condition Sequence
:begin
:return-when {conditions}
:end

Template return-when-conditions Repetition
:begin

{return-when-condition}
:end

Template bind-object-ids Repetition
:begin

{!bind-object-id}
:end

Template bind-object-id Sequence 
:begin
:bind-object {!id}
:end

Template object-type-evaluate Sequence
:begin
:object-type {ps-or-state-or-oper-or-lookahead-state}
:end

Template novalue-or-integer Selection
:begin
novalue
integer:
:end

;; we could put a lexical test in here later
Template integer Sequence
:begin
{!text:integer-or-compute-call}
:end

Template symbolic-value-type  Selection
:begin
novalue
success
failure
indifferent
less-common-symbolic-value-type:
:end

Template less-common-symbolic-value-type Selection
:begin
partial-success
partial-failure
required-success
prohibit-failure
lose
win
draw
unknown
:end



;;;
;;;  Evaluation-properties 
;;;

Template evaluation-properties Sequence
:begin
(evaluation-properties {!evaluation-properties-name}
  {space-condition}
  {?when-conditions}
  {?better-spec}
  {?if-multiple-spec}
  {?attributes-to-copy-in-lookahead}
)
:end

Template better-spec Sequence
:begin
:better {higher-or-lower}
:end

Template higher-or-lower Selection
:begin
higher
lower
:end

Template if-multiple-spec Sequence
:begin
:if-multiple {pessimistic-or-optimistic-or-all}
:end

Template pessimistic-or-optimistic-or-all Selection
:begin
pessimistic
optimistic
all
:end

Template attributes-to-copy-in-lookahead Sequence
:begin
:lookahead ( {?monotonic-increasing-or-decreasing}
             {?EP-copy-attributes}
             {?EP-dont-copy-attributes}
             {?EP-copy-new-attributes}
           )
:end

Template monotonic-increasing-or-decreasing Sequence
:begin
:monotonic {increasing-or-decreasing}
:end

Template EP-copy-attributes Sequence
:begin
:copy ({?attribute-names-or-all})
:end

Template EP-dont-copy-attributes Sequence
:begin
:dont-copy ({?attribute-names-or-any})
:end

Template EP-copy-new-attributes Sequence
:begin
:copy-new ({?attribute-names-or-all})
:end

Template increasing-or-decreasing Selection
:begin
increasing
decreasing
:end



;;;
;;;    ELABORATION
;;;

Template ELABORATION Selection
:begin
augment:
:end

Template augment Sequence
:begin
(augment {!augment-name}
  {?space-condition}
  {?when-conditions}
  ;; not required for actions usage
  {augment-object-spec}
  {?new-addition-clauses}
  {?A-copy-clauses}
  {?A-rename-clauses}
  {?actions}
)
:end

Template augment-object-spec Sequence
:begin
:what {object-spec}
:end

Template A-copy-clauses Repetition
:begin

{!A-copy-clause}
:end

Template A-copy-clause Sequence
:begin
:copy ({?attribute-names}
         {?from-object-spec}
         {?when-conditions}
      )
:end

Template A-rename-clauses Repetition
:begin

{A-rename-clause}
:end

Template A-rename-clause Sequence
:begin
:rename ({?attribute-name-pairs}
           {?from-object-spec}
           {?when-conditions}
        )
:end



;;;****************************************************************
;;;            II.   The helper parts
;;;****************************************************************
;;;
;;;  These are templates shared by more than one construct
;;;


;;;
;;;	actions and sliding-actions
;;;

;      {:actions (SOAR-ACTION+ [:when (COND+)]*)}*
Template actions Repetition
:begin

{action}
:end

Template action Sequence
:begin
:actions ({soar-action}
          {?other-soar-actions}
      {?when-conditions})
:end

;       [:sliding-actions (SOAR-ACTION+ [:when (COND+)]*)]*
Template sliding-actions Repetition
:begin

{sliding-action}
:end

Template sliding-action Sequence
:begin
:sliding-actions ({soar-action}
                  {?other-soar-actions}
          {?when-conditions})
:end



Template new-addition-clause Sequence
;;for apply-operator and others
:begin
:new ({action-spec}
      {?when-conditions}
     )
:end

Template new-addition-clauses Repetition
:begin

{new-addition-clause}
:end

Template action-spec Selection
:begin
attribute-and-simple-result:        ;{attribute-name}{results}
attribute-and-substructured-result: ;{attribute-name}{soar-value-specs}
attribute-with-interlocked-results: ;{rhs-attribute-value-pairs}{?soar-value-specs}
:end

Template attribute-and-simple-result Sequence
:begin
{!textenter:attribute-name}{results}
:end

Template attribute-and-substructured-result Sequence
:begin
{!textenter:attribute-name} {soar-value-specs}
:end

Template attribute-with-interlocked-results Sequence
:begin
({rhs-attribute-value-pairs})
{?other-soar-value-specs}
:end


;;; Attributes

Template attribute-names Repetition
:begin
 {!textenter:attribute-name}
:end

Template attribute-name Sequence
:begin
{!textenter:attribute-name}
:end

Template attribute-name-pairs Repetition
:begin

{attribute-name-pair}
:end

Template attribute-name-pair Sequence
:begin
{!textenter:attribute-name} {!textenter:attribute-name}
:end

;; added an ! here so gen can work faster... 8mar91
Template lhs-attribute-value-pair Sequence
:begin
 {?negation}^{!textenter:attribute-name}{var-const-funct-svalue-or-disjuncts}
:end

Template rhs-attribute-value-pair Sequence
:begin
 ^{!textenter:attribute-name}{results}
:end

; should be "- ", i.e. space after -
Template negation String
:begin
- 
:end

Template rhs-attribute-value-pairs Repetition
:begin
{rhs-attribute-value-pair}
:end

Template lhs-attribute-value-pairs Repetition
:begin
{lhs-attribute-value-pair}
:end

Template value-spec Selection
:begin
var-const-funct-or-svalue:
soar-value-specs:
:end

Template attribute-name-or-all Selection
:begin
attribute-name:
:all
:end

Template attribute-names-or-all Selection
:begin
attribute-names:
 :all
:end

Template attribute-names-or-any Selection
:begin
attribute-names:
 :any
:end


;;;
;;; Conditions
;;;

Template condition Sequence
:begin
({context-object-or-class-and-id}{lhs-attribute-value-pairs})
:end

Template conditions Repetition
:begin

{condition}
:end

Template constant Sequence
:begin
 {!textenter:constant}
:end

Template constants Repetition
:begin
{!constant}
:end

Template context-object Selection
:begin
goal
problem-space
state
operator
supergoal
superspace
superstate
superoperator
top-goal
top-space
top-state
top-operator
:end


;;;
;;; Copy clauses
;;;

Template copy-clauses Repetition
:begin

{!copy-clause}
:end

Template copy-clause Sequence
:begin
:copy ({?attribute-names} {?from-object-spec}
            {?copy-new-clauses}
            {?when-conditions}
      )
:end

Template copy-new-clauses Repetition
:begin

:copy-new ({attribute-names})
:end

;;;
;;;  Soar-action
;;;

Template context-object-or-class-and-id Selection
:begin
context-object:
class-and-id:
:end

Template class-and-id Sequence
:begin
{!textenter:class} <{!textenter:id-name}>
:end

Template class Sequence
:begin
{!textenter:class}
:end

Template for-goal-condition Sequence
:begin
:for-goal {!supergoal-or-id}
:end

Template function-call Sequence
:begin
 ({!textenter:function-n-args})
:end

;;;
;;;  Group test items
;;; 

Template group-name-condition-or-id Sequence
:begin
:group-name {constant-or-variable-group-name}
:end

Template group-name-condition Sequence
:begin
:group-name {!textenter:group-name}
:end

Template constant-or-variable-group-name Selection
:begin
constant-group-name:
variable-group-name:
:end

Template constant-group-name Sequence
:begin
{!textenter:group-name}
:end

Template variable-group-name Sequence
:begin
<{!textenter:group-name}>
:end

Template group-type-condition Sequence
:begin
:group-type {success-or-failure}
:end

Template group-type-condition-or-id Sequence
:begin
:group-type {success-or-failure-or-id}
:end

Template success-or-failure-or-id Selection
:begin
success
failure
id:
:end

Template success-or-failure Selection
:begin
success
failure
:end


Template object-type-spec Sequence
:begin
:object-type {!ps-or-state-or-oper}
:end

Template object-condition Sequence
:begin
:object <{!textenter:id-name}>
:end

Template operator-condition-clause Sequence
:begin
:op {operator-condition}
:end

Template operator-condition Selection
:begin
simple-operator-name:
operator-cond:
:end

Template operator-name-or-any-name Selection
:begin
simple-operator-name:
:any-name
:end

;; attribute-value-pairs here is == to cond-tail
Template operator-cond Sequence
:begin
({operator-name-or-any-name}{?lhs-attribute-value-pairs}
 {?when-conditions})
:end

Template simple-operator-name Sequence
:begin
{!textenter:operator-name}
:end





Template ps-or-state-or-oper Selection
:begin
problem-space
state
operator
:end

Template ps-or-state-or-oper-or-lookahead-state Selection
:begin
problem-space
state
operator
lookahead-state
:end




;;;
;;; Rename clauses
;;;

Template rename-clauses Repetition
:begin

{rename-clause}
:end

Template rename-clause Sequence
:begin
:rename ({?attribute-name-pairs} {?from-object-spec}
            {?rename-copy-new-condition}
            {?when-conditions}
        )
:end

Template rename-copy-new-condition Sequence
:begin
:copy-new ({attribute-name-pairs})
:end

;;;
;;; 
;;;

Template results Repetition
:begin

{var-const-funct-or-svalue}
:end

Template select-once-only String
:begin
:select-once-only
:end


;;;
;;; Soar-actions
;;;

Template soar-actions Sequence
:begin
({soar-action}
 {?other-soar-actions}
)
:end

Template other-soar-actions Repetition
:begin

{!soar-action}
:end

Template soar-action Sequence
:begin
({context-object-or-class-and-id} {rhs-attribute-value-pairs})
:end


;;;
;;; very similar to soar-actions
;;;

Template soar-value-specs Sequence
:begin
({first-soar-value-spec}
 {?other-soar-value-specs}
)
:end

Template first-soar-value-spec Sequence
:begin
({class} {rhs-attribute-value-pairs})
:end

Template other-soar-value-specs Repetition
:begin

{!soar-value-spec}
:end

Template soar-value-spec Sequence
:begin
({class-and-id}{rhs-attribute-value-pairs})
:end



;;;
;;;  Superspace and state names
;;;

Template space-condition Sequence
:begin
:space {!textenter:problem-space-name}
:end

Template use-superspace-or-top-space-or-id-clause Sequence
:begin
:use {!superspace-or-top-space-or-id}
:end

Template superspace-or-top-space-or-id Selection
:begin
superspace
top-space
id:
:end

Template supergoal-or-id Selection
:begin
id:
supergoal
:end

Template id Sequence
:begin
<{!textenter:id-name}>
:end

Template state-id Sequence
:begin
<{!textenter:state-id-name}>
:end


;;;
;;;  Var, constant, and when conditions
;;;

Template var-or-const Selection
:begin
variable:
constant:
:end

;;; new for 314
;;;

Template var-const-funct-svalue-or-disjuncts Repetition
:begin
{var-const-funct-svalue-or-disjunct}
:end

;; only used on lhs
Template var-const-funct-svalue-or-disjunct Selection
:begin
variable:
constant:
function-call:
lhs-structured-value:
disjunct:
data-macro:
null-item:
:end

;; for results
;; only used on rhs
Template var-const-funct-or-svalue Selection
:begin
variable:
constant:
function-call:
rhs-structured-value:
data-macro:
null-item:
:end

Template rhs-structured-value Sequence
:begin
 ({?class-name} {?id}{rhs-attribute-value-pairs})
:end

Template lhs-structured-value Sequence
:begin
 ({?class-name} {?id}{lhs-attribute-value-pairs})
:end


;;;
;;;		Data macro templates
;;;

Template data-macro Selection
:begin
data-macro-lists:
data-macro-sets
data-macro-expressions
data-macro-texts
:end

Template data-macro-lists Selection
:begin
data-macro-car:
data-macro-cdr:
data-macro-cons:
data-macro-list:
data-macro-null:
:end

Template data-macro-car Sequence
:begin
 (car {var-constant-or-dm})
:end

Template data-macro-cdr Sequence
:begin
 (cdr {var-constant-or-dm})
:end

Template data-macro-cons Sequence
:begin
 (cons {var-constant-or-dm} {!var-constant-or-dm})
:end

Template data-macro-list Sequence
:begin
 (list {var-constant-or-dms})
:end

Template data-macro-null Sequence
:begin
 (null)
:end

Template var-constant-or-dms Repetition
:begin
{var-constant-or-dm} 
:end

Template var-constant-or-dm Selection
:begin
variable:
constant:
data-macro:
:end



Template class-name Sequence
:begin
{!textenter:class-name} 
:end

Template disjunct Sequence
:begin
 <<{!textenter:constant}{constants}>>
:end

;;; end new for 314
;;;

Template null-item String
:begin
:end

Template variable Sequence
:begin
 <{!textenter:variable-name}>
:end

Template when-condition Sequence
:begin
:when ({conditions}
      )
:end

Template when-conditions Repetition
:begin

{when-condition}
:end



;;; ****************************************************************
;;;        III.   Text and other templates
;;; ****************************************************************

Template OTHER-TEMPLATES Selection
:begin
sp:			; the simple sp
taql-program-template:	; Yost's outline
template:    		; for making more templates
:end


Template sp Sequence
:begin
(sp {!textenter:sp-name}
    {conditions}
  -->
    {actions})

Template action Sequence
:begin
({textlong:action})
:end

Template actions Repetition
;; this is only used in sp
:begin

{action}
:end

Template template Sequence
:begin
Template {text:template-name} {template-type}
:begin
{textlong}
{template-end}

:end

Template template-end Function
:begin
":end"
:end

Template template-type Selection
:begin
Sequence
Selection
Repetition
String
Lexical
Function
:end


Template taql-program-template String
:begin
;==============
; Soar switches
;==============

(user-select ...)
(trace-attributes ...)
(multi-attributes ...)

;===========
; Task setup
;===========

; ---- propose task state and operator:

;===========
; Task space
;===========

; ---- propose space:

; ---- propose initial state:

; ---- goal test:

; ---- return results:

; ---- state elaborations:

; ---- propose operators:

; ---- apply operators:

; ---- search control (select operator):

:end


;;;****************************************************************
;;;	IV.	Construct name templates
;;;****************************************************************

Template problem-space-name Sequence
:begin
{!textenter:problem-space-name}*
:end

Template message Sequence
:begin
*{!textenter:message}
:end

Template operator-name Sequence
:begin
*{!textenter:operator-name}
:end

Template operator-or-object-name Sequence
:begin
*{!textenter:operator-or-object-name}
:end

Template task-name Sequence
:begin
*{!textenter:task-name}
:end

;; used in names only
Template group-type-or-name Sequence
:begin
*{!group-type-or-name-choice}
:end

Template group-type-or-name-choice Selection
:begin
constant-group-name:
success-or-failure:
:end



Template propose-space-name Sequence
:begin
{!problem-space-name}PS{?message}
:end

;; took off {!problem-space-name} b/c GRY doesn't think its used much 6/91
Template propose-task-state-name Sequence
:begin
PTS{?task-name}{?message}
:end

Template propose-initial-state-name Sequence
:begin
{!problem-space-name}PIS{?message}
:end

;; took off {!problem-space-name} b/c GRY doesn't think its used much 6/91
Template propose-task-operator-name  Sequence
:begin
PTO{!task-name}{?message}
:end

Template propose-operator-name Sequence
:begin
{!problem-space-name}PO{!operator-name}{?message}
:end

Template prefer-name Sequence
:begin
{!problem-space-name}P{!operator-or-object-name}{?message}
:end

Template compare-name Sequence
:begin
{!problem-space-name}C{!operator-name}{?operator-name}{?message}
:end

Template operator-control-name Sequence
:begin
{!problem-space-name}OC{?message}
:end

Template apply-operator-name Sequence
:begin
{!problem-space-name}AO{!operator-name}{?message}
:end

Template result-superstate-name Sequence
:begin
{!problem-space-name}RS{group-type-or-name}{?message}
:end

Template propose-superobjects-name Sequence
:begin
{!problem-space-name}PSO{group-type-or-name}{?message}
:end

Template goal-test-group-name Sequence
:begin
{!problem-space-name}GTG{group-type-or-name}{?message}
:end

Template evaluation-properties-name Sequence
:begin
{!problem-space-name}EP{?message}
:end

Template evaluate-object-name Sequence
:begin
{!problem-space-name}EO{?message}
:end

Template augment-name Sequence
:begin
{!problem-space-name}A{?message}
:end

Template sp-name Sequence
:begin
{!problem-space-name}SP{?message}
:end


;;;****************************************************************
;;;	V.	Subselection templates
;;;****************************************************************
;;;
;;;  These are automatically generated by the Make-sub-selection-template
;;; function in taql-template.el, and then inserted by hand here.
;;;

Template propose-space-clauses Selection
:begin
propose-space-name:
space-to-propose:
subspace-function-clause:
when-conditions:
copy-clauses:
rename-clauses:
new-addition-clauses:
use-superspace-top-space-or-id-clause:
:end

Template propose-initial-state-clauses Selection
:begin
propose-initial-state-name:
space-condition:
when-conditions:
copy-clauses:
rename-clauses:
new-addition-clauses:
use-superstate-or-top-state-or-id-clause:
:end

Template propose-task-state-clauses Selection
:begin
propose-task-state-name:
space-condition:
when-conditions:
new-addition-clauses:
:end

Template propose-task-operator-clauses Selection
:begin
propose-task-operator-name:
space-condition:
operator-creation-by-spec-clause:
when-conditions:
:end


Template propose-operator-clauses Selection
:begin
propose-operator-name:
operator-proposal-clause:
space-condition:
when-conditions:
select-once-only:
:end


Template prefer-clauses Selection
:begin
prefer-name:
space-condition:
when-conditions:
operator-condition-clause:
preferences-clause:
obscure-prefer-clauses:
:end


Template compare-clauses Selection
:begin
compare-name:
space-condition:
when-conditions:
op1-and-op2:
relation:
obscure-compare-clauses:
:end

Template propose-superobjects-clauses Selection
:begin
propose-superobjects-name:
space-condition:
group-name-condition-or-id:
group-type-condition-or-id:
when-conditions:
object-type-spec:
superobjects-to-propose:
:end



Template evaluate-object-clauses Selection
:begin
evaluate-object-name:
space-condition:
when-conditions:
bind-object-id:
objects-to-evaluate:
numeric-value-clause:
symbolic-value-clause:
:end

Template evaluation-properties-clauses Selection
:begin
evaluation-properties-name:
space-condition:
when-conditions:
better-spec:
if-multiple-spec:
attributes-to-copy-in-lookahead:
:end

Template operator-control-clauses Selection
:begin
operator-control-name:
space-condition:
when-conditions:
control-spec-clause:
:end

Template apply-operator-clauses Selection
:begin
apply-operator-name:
operator-condition-clause:
space-condition:
when-conditions:
terminate-when-conditions:
bind-object-ids:
use-state-clause:
edits:
actions:
sliding-actions:
:end

Template goal-test-group-clauses Selection
:begin
goal-test-group-name:
space-condition:
when-conditions:
group-type-condition:
group-name-condition:
test-conditions:
:end

Template result-superstate-clauses Selection
:begin
result-superstate-name:
space-condition:
group-name-condition-or-id:
group-type-condition-or-id:
when-conditions:
terminate-when-conditions:
bind-object-ids:
RS-use-state-condition:
edits:
actions:
sliding-actions:
:end

Template augment-clauses Selection
:begin
augment-name:
space-condition:
when-conditions:
augment-object-spec:
new-addition-clauses:
A-copy-clauses:
A-rename-clauses:
action:
:end



;;;; -*- Mode: Soar -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : ps.tpl
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jun 21 11:56:16 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Jun 21 13:20:40 1991
;;;; Update Count    : 3
;;;; Soar Version    : 5.2
;;;; TAQL Version    : 3.1.3
;;;; 
;;;; PURPOSE
;;;; 	Templates for Old fashion TAQL stuff.  changes go here, the
;;;; section gets inserted into the template files before release.
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; (C) Copyright 1991, Frank Ritter University, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;
;;; 	V.	Old-fashioned taql templates
;;;

Template the-OSU-production-templates Selection
:begin
Top-Goal:
Goal-for-subgoals
Propose-top-problem-space
Propose-problem-spaces-for-subgoals
Compare-problem-spaces-binary-preferences
Select-problem-space-unary-preferences
Propose-initial-state-in-the-top-problem-space
Propose-initial-state-in-a-subgoal-no-copy
Propose-initial-state-in-a-subgoal-copy
Elaborate-state
Numeric-evaluation-of-state-in-subgoal-of-evaluate-object
Symbolic-evaluation-of-state
Propose-operator
Compare-operators-binary-preferences
binary-preferences
Select-operator-unary-preferences
Operator-application
Operator-termination
Goal-test-Detect-desired-feature
Detect-desired-state
Detect-failed-state
Result-superoperator
:end

Template Top-Goal Sequence
:begin
(sp top-goal*elaborate*goal*{textenter:goal-name}
  (goal <g> ^object nil)
-->
  (goal <g> ^desired <d> ^name {textenter:goal-name})
  {?preferences-for-desired-state-substructure})
:end

Template preferences-for-desired-state-substructure Sequence
:begin
(goal <g> {attribute-value-pairs})
:end

Template Goal-for-subgoals Sequence
:begin
(sp {textenter:superproblem-space}*elaborate*goal*{textenter:goal-name}
  (goal <g> ^object <sg> ^impasse {impasse-type} 
            ^attribute {evaluate-object-type}
            {?attribute-value-pairs})
  (goal <sg> {?attribute-value-pairs});necessary supercontext
-->
  (goal <g> ^desired <d> ^name {textenter:goal-name})
  )   ;[possibly preferences for desired state substructure]
:end

Template impasse-type Selection
:begin
tie
conflict
no-change
constraint-failure
:end

Template Propose-top-problem-space Sequence
:begin
(sp {textenter:goal-name}*propose*space*{textenter:problem-space}
  (goal <g> ^object nil ^name {textenter:goal-name})
-->
  (goal <g> ^problem-space <p>)
  ; [possibly preferences for desired state substructure]
  ; or use TAQL!
  (problem-space <p> ^name {textenter:problem-space}
                     ^default-state-copy yes  ; for state copying
                     ^one-level-attributes {?attribute-names}
                     ^two-level-attributes {?attribute-names}))
:end

Template Propose-problem-spaces-for-subgoals Sequence
:begin
(sp {textenter:goal-name}*propose*space*{textenter:problem-space}
  (goal <g> ^object <sg> ^name {textenter:goal-name})
 -->
  (goal <g> ^problem-space <p>)
  (problem-space <p> ^name {textenter:problem-space}
                     ^default-state-copy yes  ; for state copying
                     ^one-level-attributes {?attribute-names}
                     ^two-level-attributes {?attribute-names}))
:end

Template Compare-problem-spaces-binary-preferences Sequence
:begin
(sp {textenter:goal-name}*compare*spaces*{textenter:better-space]*{textenter:space-name}
  (goal <g> ^problem-space <p1> + { <> <p1> <p2> } +
            ^object <sg> ^impasse {impasse-type} ^attribute {ps-or-state-or-oper}
                       {?attribute-value-pairs}) ;necessary context about impasse
  (problem-space <p1> ^name {textenter:problem-space})
  (problem-space <p2> ^name {textenter:problem-space})
  (goal <sg> {?attribute-value-pairs}) ;necessary supercontext
  ;more supercontext structure if necessary
-->
  (goal <g> ^problem-space <p1> [ >, =, or < ] <p2>))
:end

Template Select-problem-space-unary-preferences Sequence
:begin
(sp {textenter:goal-name}*select*space*{textenter:problem-space}
  (goal <g> ^problem-space <p1> +
            ^object <sg> ^impasse {impasse-type} ^attribute [impasse role]
            {?attribute-value-pairs}) ;necessary context about impasse
  (problem-space <p1> ^name {textenter:problem-space})
  (goal <sg> {?attribute-value-pairs}) ;necessary supercontext
  ;[more supercontext structure if necessary]
-->
  (goal <g> ^problem-space <p1> {preference-value}))
:end

Template preference-value Selection
:begin
 !
 >
 =
 <
 -
 ~
:end

Template Propose-initial-state-in-the-top-problem-space Sequence
:begin
(sp {textenter:problem-space}*propose*state*top-initial-state
  (goal <g> ^problem-space <p> ^object nil)
  (problem-space <p> ^name {textenter:problem-space})
-->
  (goal <g> ^state <s>)
  (state <s> {?attribute-value-pairs}) ;structure of state
  ;[more preferences for state structure if necessary]
  )
:end

Template Propose-initial-state-in-a-subgoal-no-copy Sequence
:begin
(sp {textenter:problem-space}*propose*state*initial-state
  (goal <sg> ^state <ss> {?attribute-value-pairs}) ;[necessary supercontext]
  ; more supercontext, especially about the superstate
  (goal <g> ^problem-space <p> ^object <sg> {?attribute-value-pairs}) 
  ; context about impasse
  (problem-space <p> ^name {textenter:problem-space})
-->
  (goal <g> ^state <s>)
  (state <s> ^superstate <ss> {?attribute-value-pairs})
  ; structure of state (usually copied from superstate)
  ; more preferences state structure if necessary
)
:end

Template Propose-initial-state-in-a-subgoal-copy Sequence
:begin
(sp {textenter:superproblem-space]*propose*state*{textenter:problem-space}*initial-state
  (goal <sg> ^state <ss>)
  ;[necessary supercontext]
  (goal <g> ^problem-space <p> ^object <sg>
            {?attribute-value-pairs}) ; context about impasse
  (problem-space <p> ^name {textenter:problem-space})
-->
  (goal <g> ^state <ss>))
:end

Template Elaborate-state Sequence
:begin
(sp {textenter:problem-space}*elaborate*state
  (goal <g> ^problem-space <p> ^state <s>)
  (problem-space <p> ^name {textenter:problem-space})
  (state <s> {?attribute-value-pairs}) ;necessary context for elaboration
  {?conditions}
-->
  ; preferences for any arguments or substructure
  (state <s> {?attribute-value-pairs})) 
:end

Template Numeric-evaluation-of-state-in-subgoal-of-evaluate-object Sequence
:begin
(sp {textenter:problem-space}*evaluate*state*numeric
  (goal <g> ^problem-space <p> ^state <s> ^object <sg> ^applied <o>)
  (problem-space <p> ^name {textenter:problem-space})
  (goal <sg> ^state <ss> ^operator <so>)
  (state <ss> ^evaluation <e>)
  (operator <so> ^type evaluation ^evaluation <e> ^object <o>
                 ^desired <d>)
  : augmentations used to determine distance to desired state
  (state <s> {?attribute-value-pairs})
  ; augmentations used to determine distance of state
  (desired <d> {?attribute-value-pairs})
  -->
  (evaluation <e> ^numeric-value {textenter:number}))
:end

Template Symbolic-evaluation-of-state Sequence
:begin
(sp {textenter:problem-space}*evaluate*state*symbolic
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; augmentations used to determine distance to desired state
  (state <s> {?attribute-value-pairs})
  ; augmentations used to determine distance of state
  (desired <d> {?attribute-value-pairs})
  -->
  (state <s> ^{symbolic-evaluation-type} <d>))
:end

Template symbolic-evaluation-type Selection
:begin
required-success
success
partial-success
indifferent
failure
partial-failure
prohibit-failure
:end

Template Propose-operator Sequence
:begin
(sp {textenter:problem-space}*propose*operator*{textenter:operator-name}
  (goal <g> ^problem-space <p> ^state <s>)
  (problem-space <p> ^name {textenter:problem-space})
  ; necessary context for proposal, arguments or substructure for operator
  (state <s> {?attribute-value-pairs})
  {?conditions}
-->
  (goal <g> ^operator <o>)
  (operator <o> ^name {textenter:operator-name}
                [preferences for any arguments or substructure])
:end

Template Compare-operators-binary-preferences Sequence
:begin
(sp {textenter:problem-space}*compare*operator*{textenter:better-operator}*{textenter:worse-operator}
  (goal <g> ^problem-space <p> ^state <s> ^operator <o1> + { <> <o1> <o2> } +)
  (problem-space <p> ^name {textenter:problem-space})
  ;structure tested to compare worth of operators
  (state <s> {?attribute-value-pairs})
  (operator <o1> ^name {textenter:better-operator})
  (operator <o2> ^name {textenter:worse-operator})))
-->
  (goal <g> ^operator <o1> {binary-preferences} <o2>))
:end

Template binary-preferences Selection
:begin
 >
 =
 <
:end

Template Select-operator-unary-preferences Sequence
:begin
(sp {textenter:problem-space}*select*operator*{textenter:operator-name}
  (goal <g> ^problem-space <p> ^state <s> ^operator <o1> +)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure tested to determine worth of operator
  (state <s> {?attribute-value-pairs})
  (operator <o> ^name {textenter:operator-name})
-->
  (goal <g> ^operator <o1> {preferences}))
:end

Template Operator-application Sequence
:begin
(sp implement*{textenter:operator-name}
  (goal <g> ^state <s> ^operator <o>)
  ; structure to be augmented, changed, or removed by operator
  (state <s> {?attribute-value-pairs})
  (operator <o> ^name {textenter:operator-name} {?attribute-value-pairs}) 
  ; additional arguments
-->
  ; preferences to augment, change, or remove structure
  (state <s> {?attribute-value-pairs})
  ; preferences for state substructure
  )
:end


Template Operator-termination Sequence
:begin
(sp terminate*{textenter:operator-name}
  (goal <g> ^state <s> ^operator <o>)
  ; structure that indicates operator applied
  (state <s> {?attribute-value-pairs})
  ; arguments or structure
  (operator <o> ^name {textenter:operator-name} {?attribute-value-pairs})
-->
  (goal <g> ^operator <o> @))
:end

Template Goal-test-Detect-desired-feature Sequence
:begin
(sp {textenter:problem-space}*detect*state*{textenter:feature}
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure indicates goal partially achieved
  (state <s> {?attribute-value-pairs})
  ; structure of desired compared to state
  (desired <d> {?attribute-value-pairs})
  -->
  ; structure that records goal partially achieved
  (state <s> {?attribute-value-pairs}))
:end

Template Detect-desired-state Sequence
:begin
(sp {textenter:problem-space}*detect*state*success
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure that indicates goal is achieved
  (state <s> {?attribute-value-pairs})
  ; structure that indicates goal is achieved
  (desired <d> {?attribute-value-pairs})
-->
  (state <s> ^{success-value} <d>))
:end

Template success-value Selection
:begin
required-success
success
partial-success
:end

Template Detect-failed-state Sequence
:begin
(sp {textenter:problem-space}*detect*state*failure
  (goal <g> ^problem-space <p> ^state <s> ^desired <d>)
  (problem-space <p> ^name {textenter:problem-space})
  ; structure that indicates that state failed
  (state <s> {?attribute-value-pairs})
  ; structure that indicates that state failed
  (desired <d> {?attribute-value-pairs})
-->
  (state <s> ^{goal-failure-type} <d>))
:end

Template goal-failure-type Selection
:begin
required-failure
failure
partial-failure
:end

Template Result-superoperator Sequence
:begin
(sp {textenter:superproblem-space}*result*operator*{textenter:problem-space}
  (goal <g> ^problem-space <p> ^state <s> ^desired <d> ^object <sg>)
  (problem-space <p> ^name {textenter:problem-space})
  (state <s> ^success <d>
             ; structure indicating appropriate superoperator
             {?attribute-value-pairs}
             ; arguments or substructure to pass to superoperator
             {?attribute-value-pairs})
  (goal <sg> ^problem-space <sp> ^state <ss>)
-->
  (goal <sg> ^operator <o>)
  (operator <o> ^name {textenter:operator} ; appropriate operator name
                      ; arguments or substructure
                      {?attribute-value-pairs}))
:end




Local Variables:
tpl-begin-template-definition:"^Template"
tpl-begin-template-body:"^:begin"
tpl-end-template-body:"^:end"
end:
