;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-site.el
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul 6, 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Wed Apr  8 14:01:29 1992
;;;; Update Count    : 46
;;;; 
;;;; PURPOSE
;;;; 	Site initialization file for the CMU Soar group
;;;; 
;;;; HISTORY
;;;;   started at mich, copied and redited for v3.
;;;; TABLE OF CONTENTS
;;;;
;;;;    I.  	General global site variables
;;;;    II.     Set up for comment-region.el
;;;;   III.     Set up where manuals are 
;;;;
;;;; Copyright 1990, Frank Ritter.
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;; 	I.	CRITICAL, site dependent, GLOBAL path VARIABLES 
;;;                 -- DON'T FORGET TO SET THESE!
;;;-----------------------------------------------------------------------------
;;; NB: Direcories do not get ending "/"
;;;

(defvar soar-mode-home-directory
  (expand-file-name "/afs/cs/project/soar/5.2/emacs/soar/4.2")
  "Explicit pathname to the directory containing this and other files of the
Soar Emacs mode.")

;; Note: no leading /
(defvar soar-ilisp-subdirectory "ilisp/4.11"
  "Subdirectory to soar-mode-home-directory that ilisp lives in.")

(defvar soar-image-name
  "Soar5"
  "*Default Soar image to invoke from `run-soar'.  If the value is a string
then it names the image file or image path that `run-soar' invokes.
Otherwise, if the value of this variable is a list rather than a string, the
value is given to funcall, the result of which should yield a string which is
the image name or path.")



;;;
;;;    II.  	General global site variables
;;;

(setq soar-*site* 'cmu)

(setq-default
      header-copyright-notice
      "Copyright 1991, Carnegie Mellon University.")



;;; 
;;; III.      Set up for comment-region.el
;;;
; ilisp does this for us now...
;
;(setq comment-region-alist
;      (cons (cons 'soar-mode 'lisp-mode-comment-region) 
;            comment-region-alist))
;
;(setq uncomment-region-alist
;      (cons (cons 'soar-mode 'lisp-mode-uncomment-region) 
;            uncomment-region-alist))



;;;--------------------------------------------------------------------------
;;;  IV.      Set up manuals and soar-mode-site-hook
;;;--------------------------------------------------------------------------

;;; The first shall be last...   Each file is copied into version/manuals so 
;;; they get tar'ed up.  Later we could use links or direct references to
;;; save space.

;; we allow that some sites may keep their own manuals in different places due 
;; to disk space problems
(setq man-manual-home (concat soar-mode-home-directory "/manuals/"))

;; change paths to your local paths,
;; they are too large to ship
;; put them on hook so they can be defered until after the menu has been created.

(setq soar-mode-site-hook
     (append '((lambda ()
  (add-to-menu  'soar-document-menu  '(
    ("5-deflt      default productions.   "
      (goto-manual "/afs/cs.cmu.edu/project/soar/5.2/2/lib/default.soar"
                   'soar-mode))
    ("6-src        Soar5 source.   "
      (goto-manual "/usr/misc/.Soar5/lib/Soar5.lisp"
                   'lisp-mode))
    ("7-bib        Soar bibliography.     "
      (goto-manual "/afs/cs/project/soar/member/biblio/soar.bib"
                   'scribe-mode))
    ("8-Intro      Intro to CMU site      "
      (goto-manual 
             "/afs/cs/project/soar/5.2/emacs/soar/new/manuals/cmu-intro.txt"
             'text-mode))
    ("9-Dbase      Database of Soar community members."
      (goto-manual 
             "/afs/cs/project/soar/5.2/emacs/soar/new/manuals/database.txt"
             'text-mode))
  ))))
  soar-mode-site-hook))
