;;;; -*- Mode: Emacs-Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-simple-menus.el
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul 12 14:38:57 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Apr  8 12:21:29 1992
;;;; Update Count    : 19
;;;; 
;;;; PURPOSE
;;;; 	Sets up the simple menus for soar-mode.
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun run-soar-menu () 
  "provide a menu of commands for Soar and Taql."
  (interactive)
  (run-menu 'soar-menu "soar"))

(def-menu
  'soar-menu
  "" ;main prompt
  "The menu key allows you to select various command options" ;help prompt
   ;123456789012345
 '(
   ("Soar            Do primarily Soar commands." soar-command-menu)
   ("Lisp            Do primarily Lisp commands." ilisp-command-menu)
   ("Emacs           Do plain Emacs commands."   emacs-menu)
))


(def-menu 'soar-command-menu
  "Soar Options"
  "" ;help prompt
 '(("About        About soar-mode." describe-mode)
   ("Documents    Examine various manuals."   soar-document-menu)
   ("Commands     Other commands in soar-mode."   other-soar-command-menu)
   ("Prod         Do stuff to productions." production-command-menu)
   ("Switch       Switch to the running Soar buffer." switch-to-lisp)
   ("TimeStamps   Insert the date and/or time." soar-timestamp-menu)
;  ("Varset      menu to set variables."   soar-variables-menu)
))

(def-menu
  'soar-document-menu 
  "" ;main prompt
  "The menu key allows you to select various documents to browse:" ;help prompt
  ;; all manuals should live in the manuals sub-directory
 '(("1-Man5.2     Main Soar manual."   (goto-manual "Soar5-manual.doc" 'soar-mode))
   ("2-5.2.1-RN   5.2.1 Release notes." 
        (goto-manual "5.2.1-release-notes" 'soar-mode))
   ("3-soar-mode  soar-mode manual."   (goto-manual "soar-mode.doc" 'soar-mode))
   ("4-SX         SX manual.      " (goto-manual "sx-manual.doc" 'soar-mode))
))

(def-menu 'other-soar-command-menu
  "Soar commands"
  "" ;help prompt
 '(("Load         Load a file into Soar." soar-load-file)
   ("Headr        Make a file header." make-header)
   ("Rev          Make a revision line in header." make-revision)
   ("FindTT       Find (use) a tags-table.  W/ prompt and file name completion."
                  find-tags-table)
   ("Tag          Make a tags table for a list of files." make-tags-table)
   ("Rtag         Remake a tags table for a list of files.
                   (This is faster than Tag.)"           remake-tags-table)
   ("Count        Count the number of productions in current buffer."
                  soar-count-productions)
   ("List         Soar-list-production-names" soar-list-production-names)
   ("Bug          Generate a bug report"  soar-bug)
))

(def-menu 'production-command-menu
  "Production"
  "" ;help prompt

 '(("Break        Pbreak production." soar-pbreak-production)
   ("FullM        Full-matches on production." soar-full-matches-production)
   ("Load         Load the production into Soar." lisp-eval-defun)
   ("2Load        Load the production into Soar and go there." 
                      eval-defun-and-go-lisp)
   ("Prin         SPR production."  soar-spr-production)
   ("Smatch       SMatch production."  soar-smatches-production)
   ("Trace        Traces the previous production." soar-ptrace-production)
   ("Xcise        Excise production."     soar-excise-production)
   )
)

(def-menu 'soar-timestamp-menu
 "Time Stamps"
 ""
 '(("DateStamp       Insert a date only timestamp."  insert-date-string)
   ("TimeStamp       Insert a time only timestamp."  insert-time-string)
   ("FullTimeStamp   Insert a full day/date/hour timestamp."
    insert-current-time-string)
   )
)

;; example of leaving old menu format.
;(defun replace-menu ()
;  "Options for finding & replacing strings in current buffer:
; Interactive  Check each occurance before replace. [default]
; All          Replace all occurances without asking.
; -------
; Regexp   Search & replace using a regular expression.
; String   Search & replace any string of characters.
; Tags     Search & replace through all files listed in tag table.
;"
;  (interactive)
;  (let ((prompt "Replace: All Help Regexp String Tag ")
;        (opt nil)
;        (forward t)
;        (interactive t))
;    (while (not opt)
;      (message prompt)
;      (setq opt (downcase (read-char)))
;      (if (= opt ?h) (setq opt
;                           (pop-up-help 'replace-menu "Replace option: ")))
;      (cond ((= opt ?i)                 ; Set for interactive search
;             (setq interactive t)
;             (setq prompt "Replace: All Help Regexp String Tag ")
;             (setq opt nil))
;            ((= opt ?a)                 ; Set for noninteractive search
;             (setq interactive nil)
;             (setq prompt "Replace: Interactive Help Regexp String Tag ")
;             (setq opt nil))
;            ((= opt ?s)                 ; String replace
;             (if interactive (call-interactively 'query-replace)
;               (call-interactively 'replace-string)))
;            ((= opt ?r)                 ; Regexp search
;             (if interactive (call-interactively 'query-replace-regexp)
;               (call-interactively 'replace-regexp)))
;            ((= opt ?t)                 ; Tags search
;             (call-interactively 'tags-query-replace))
;            (t (ding)))))
;  )
