;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/package.lisp".
;;;; -*- Mode: lisp; package: user -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : all-sx.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jun 29 16:43:19 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Mon Apr  6 00:58:08 1992
;;;; Update Count    : 152
;;;; Soar Version    : 5.2
;;;; 
;;;; PURPOSE
;;;; 	Sets up the sx package for the DSI.
;;;;    I.  	Setup and use the SX package
;;;;    II.  	Setup and use the clx package
;;;;	III.	Setup new type information
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (eval compile load)
  (in-package "USER")
  (soarresetsyntax))


;;; 
;;;        I.  Setup and use the SX package
;;;

;; This will have to change with 5.2 to use the soar package
(eval-when (eval compile load)
 (cond ( (find-package "SX")
         (let ( (sxp (find-package "SX")) )
         (rename-package sxp "SX" '("SIX"))
         (use-package (list
                             (if (find-package "COMMON-LISP")
                                      "COMMON-LISP"
                                      "LISP")
                             "SOAR"            ;; grab soar things
                             "KR"  
                             #-release-sx
                             "KR-DEBUG"  ;; grab abunch of sx things
                             "GARNET-GADGETS")
                     sxp)
         (format t "~%; Found sx package in sx/package.lisp.... ~%") ))
       ( t  (make-package "SX"
			  :nicknames '("SIX")
                          :use (list (if (find-package "COMMON-LISP")
                                      "COMMON-LISP"
                                      "LISP")
                                ;"YLOOP" ;; I believe I rooted this out...
                                "SOAR"            ;; grab soar things
                                "KR"  
                                #-release-sx
                                "KR-DEBUG"  ;; grab abunch of sx things
                                "GARNET-GADGETS")))))

;; necc. to export soar things till 5.2 is up and can do it itself
; delete 1sept or later

(eval-when (eval compile load)
 (in-package "SX"))

(eval-when (eval compile load)
   (export '( ;; functions
              continuous-ms
              cms
              dsi-movie
              dump-sx
              create-graphic-display
              excise-graphic-chunk
              find-operator-problem-space ; always
              set-auto-scroll
              sx
              sx-banner
              add-context-item
              get-date        
              interactive-create-problem-space

              pscm-stats
              reset-pscm-stats

              init-sx
	      quit-sx
	      sx-quit
              sx-snapshot
              restart-sx
	      reinit-sx
              initialize-chunks
              update-examiner-windows

              ;; variables
              chunk-beep-on-fire
              auto-scroll
              check-sx-x-server
              *default-ps-anchored*
              double-buffer-windows-p
              n1-dump-directory
              CONTINUOUS-MS!
              menus-disappear-after-selection
              static-menu-expert
              *sx-directory*
              *sxl-directory*      
              *sx*
              *sx-repl-conditions*
              *sx-version*
              snap-print-command
              snap-dump-directory
              snap-basic-command
              snap-file
		     )
           (find-package "SX")))

; user also can use sx things...
; somebody puts an sx in user...damn -fer 8/90
(eval-when (eval compile load)
 (use-package '("SX" ;; grab abunch of other related packages for user
               )
               "USER"))


;;;
;;;        II.  Setup and use the clx package
;;;	
;;;

;; We now let build-sx load it.
;; (require 'clx)

#+:XLIB 
(eval-when (compile load eval)
  (shadowing-import  
      '(define-keysym
        define-condition
        alist)
    (find-package "XLIB"))
  (use-package 'xlib))

(eval-when (compile load eval)
#-soar5   (proclaim '(function SX-SOARSYNTAX-HOOK nil nil))
#-soar5   (proclaim '(function SX-SOARRESETSYNTAX-HOOK () nil))
#-soar5   (proclaim '(function SX-EXCISE-CHUNKS () nil))
#-soar5   (proclaim '(function FIND-OPERATOR-PROBLEM-SPACE (symbol) symbol))
;; this just changed its args 19-Jan-92 -FER
;;          (proclaim '(function GET-SX-ITEM (symbol symbol) symbol))
#-soar5   (proclaim '(function SX-SIGNAL-PREFERENCE-PHASE-START () nil))
#-soar5   (proclaim '(function SX-SIGNAL-QUIESCENCE-PHASE-START-HOOK () nil))
#-soar5   (proclaim '(function ADD-CONTEXT-ITEM (tme-object gme-attribute
                                                 gme-value) nil))
#-soar5   (proclaim '(function ADD-CHUNK (symbol) nil))
#-soar5   (proclaim '(function CHECK-SX-X-SERVER () nil))
#-soar5   (proclaim '(function SX-AFTER-ELABORATION-HOOK () nil))
#-soar5   (proclaim '(function SX-DSM-WATCH-HOOK () nil))
#-soar5   (proclaim '(function FIRE-GRAPHIC-RULE (symbol) nil))
#-soar5   (proclaim '(function CLEAR-GRAPHIC-DISPLAY () nil))
#-soar5   (proclaim '(function UPDATE-examiner-WINDOWS () nil))
#-soar5   (proclaim '(function SX-SET-MACROCYCLE-HOOK () nil))
  (proclaim '(special CONTINUOUS-MS!))
)

;;;
;;;	III.	Setup new type information
;;;

;; we may also be able to inherit this from Soar, but it doesn't seem to work:
#-kr-deftypes
(deftype logical () '(or t nil))

#-kr-deftypes
(deftype a-schema-type () '(member a-schema))

#-kr-deftypes
(deftype a-schema-or-nil () '(or a-schema nil))

(deftype display-or-nil () '(or xlib:display nil))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/soar-additions.lisp".
;;;; -*- Mode: lisp; Package: soar -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-additions.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jun 25 17:20:12 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:44:04 1992
;;;; Update Count    : 192
;;;; 
;;;; PURPOSE
;;;; 	New code in the soar package for soar to keep, motivated by
;;;; the DSI.  Should be clean of SX code?
;;;;
;;;; TABLE OF CONTENTS
;;;; 	I. 	Context object attribute value accessors
;;;;	II.	toggle-soarsyntax
;;;;	III.	find-production-ps
;;;;	IV.	Soar-read-n
;;;;	V.	Load-taql
;;;;    VI.	get-wmparts
;;;;	VIb.	wm-structure?
;;;;	VII.	decision- and elaboration-cycle-count
;;;;	VIII.	BFP 
;;;;	IX.	sp?
;;;;	X.	sp-or-tc?
;;;;	XI.	r for run, p for macrocycle
;;;;	XII.	Common macrocycle shortcuts, next-*
;;;;
;;;; Copyright 1990, FER.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings; proclaim vars funs; declares


;; this should change with 5.2....
(eval-when (load eval compile)
  (in-package "SOAR"))

(eval-when (load eval compile)
  (proclaim '(string taql-home-directory))
  (proclaim '(special taql-home-directory))
  (proclaim '(function context-object-attribute-value-pairs (symbol) list))
  (proclaim '(function toggle-soarsyntax () kr:logical))
  (proclaim '(function find-production-ps (symbol) symbol))
  (proclaim '(function load-taql () nil))
  (proclaim '(function sp-or-tc? (symbol) kr:logical))
  (proclaim '(function get-wmparts (kr:a-schema-type) list))
  ;(proclaim '(function next-g (integer) nil))
  ;(proclaim '(function next-p (integer) nil))
  ;(proclaim '(function next-s (integer) nil))
  ;(proclaim '(function next-o (integer) nil))
  )

;;;	i.	New variables

;; will move to main soar code in 5.3
#-Soar5
(defvar graphic-display? nil
 "*Running the graphic display if t.")

(defvar taql-home-directory "/usr/misc/.Soar5/lib/taql/3.1.4"
  "*Where TAQL lives on your system.")

;;;	ii. 	Export statement

(export '(;; VARIABLES
          #-soar5 bfp-spacep
          taql-home-directory          
          graphic-display?  ;; not exported in soar 5.2.2, don't know why
          ;; FUNCTIONS & MACROS
          #-soar5 attribute-value
          #-soar5 bfp
          #-soar5 context-object-name
          #-soar5 context-object-name-p
          #-soar5 decision-cycle-count
          #-Soar5 elaboration-cycle-count	  
          #-soar5 find-production-ps
          #-soar5 get-wmparts	  
          load-taql          ;always
          next-g 
          next-p
          next-s
          next-o
          #-soar5 r
	  #-soar5 soar-read-n
	  #-Soar5 sp?
          sp-or-tc?       ; always
          #-soar5 toggle-soarsyntax
          #-Soar5 wm-structure?
         )
   (find-package "SOAR"))


;;;
;;;; 	I. 	Context object attribute value accessors
;;;

(defun context-object-attribute-value-pairs (symbol)
 "Returns the attribute value pairs for symbol."
  (declare (symbol symbol))
 ;; can't cache them on the symbol's plist, may change with time
 (do* ( (do-wmes (get symbol 'wmpart*) (cdr do-wmes))
        (nwme (caar do-wmes) (caar do-wmes))
        (result nil))
       ((null do-wmes) result)
   (setf result
	 (nconc result 
                (list (list (wme-attribute nwme) (wme-value nwme))))) )
)

;; very speciifc dependencies on how to get wm items
#-soar5
(defun attribute-value (symbol attribute)
 "return the value of ATTRIBUTE for SYMBOL"
 (let ((result (find attribute (get symbol 'wmpart*)
                     :test  #'(lambda (x y) (equal x (third (car y) ))))))
 (if result
     (fourth (car result)))))

#-soar5
(defun context-object-name (symbol)
 "get name of SYMBOL"
  (format nil "~a" (or (attribute-value symbol 'name)
                        symbol)))

#-soar5
(defun context-object-name-p (symbol)
 "does SYMBOL still have a soar name?"
 (and (attribute-value symbol 'name)))


;;;
;;;	II.	toggle-soarsyntax
;;;

#-Soar5
(proclaim '(inline toggle-soarsyntax))

#-soar5
(defun toggle-soarsyntax ()
 (if (soarsyntaxp) 
     (soarresetsyntax)
     (soarsyntax))
 (soarsyntaxp))


;;;
;;;	III.	find-production-ps
;;;

;; the top-ps function is exported, but appears not to be bound in the
;; soar 5.2 source in /usr/misc/.Soar5/lib/.  It will need to be bound
;; for this function.
;; It may go something like this:

#-soar5
(defdsmmacro top-ps ()
                       () symbol
 (declare)
 `(if *top-gnode* (problem-space *TOP-GNODE*))
)


(defun find-production-ps (achunk)
 "Finds the ps that ACHUNK belongs to.
If not accesable by name, tries to find ps based on operator,
else returns the top-level problem space.  If passed nil, it returns nil."
 (declare (symbol achunk))
 (if (get-p achunk)
 (let ( (left-side (get-sp-lhs (p-production (get-p achunk)))))
  (do ( (clause (pop left-side) (pop left-side))
        (ps-name nil) 
        (operator-name nil) )
   ;; end test & result
   ( (and (not left-side) (not clause))
     (cond ( ps-name)
           ( operator-name
	     #+sx(if soar::graphic-display?
                     (sx:find-operator-problem-space operator-name)
                     (top-ps))
	     ;; lose early
	     #-sx(top-ps))
           (t (format t "~% GOT a chunk without a PS or O !: ~a~%" achunk)
              (top-ps))) )
   ;; body
   ;(format t "~% clause is ~s" clause)
   (if (listp clause)  ; you could eat a negation bad here...
	               ; actually should check for -^problem-space
       (let ( (name (second (member 'name clause)))
              (type (car clause))  )
         (if name  
             (cond ((eq 'operator type)
                    (setq operator-name name) )
                   ((eq 'problem-space type)
                    (setq ps-name
			  ;#+sx(sx::get-sx-item name nil)
                          #+sx name
			  #-sx name)))))) ))))


;;;
;;;	IV.	Soar-read-n
;;;

#-soar5
(defun soar-read-n (header &optional (min 0) (max 100))
  (declare (integer min max))
  (prog (choice)
      (if (< max min)
          (progn
            (setf choice min)
            (setf min max)
            (setf max choice)))
       L1
       (soar-format *trace-file* "~%~A~%Please enter a number (~s-~s)~%"
                    header min max)
       (soar-format *trace-file* "? ")
       (setq choice (read))
       (cond ((and (numberp choice)
	           (>= choice min)
		   (<= choice max))
              (return choice)))
       (soar-format *trace-file*
		    "~%Your answer was not a number between ~s and ~s." min max)
       (go l1)))


;;;
;;;    VI.	get-wmparts
;;;

;; Number: 274
;; Report Date: 11-Feb-91
;; Reported by: Frank Ritter <fr07+@ANDREW.CMU.EDU>
;; Status: User-Library
;; Cross Reference: 30Jan91-15.08.10
;; Priority: 5
;; Synopsis:
;; Code for getting the names and atribute value pairs of context objects.
;; 
;; Comments:
;; Frank, this is not really appropriate for Soar IO. I understand why you
;; needed it but in general the trend is to try to limit the information
;; available to Soar-IO. I'll file this away so that we won't lose it
;; if someone wants it.

;; deleted (&optional object (soar::top-goal)) 31-Jan-92 -FER

(defun get-wmparts (object)
  "Returns a list of strings corresponding to the wme's of OBJECT."
  (do* ( (Xs (get object 'soar::wmpart*) (cdr Xs))
	 (x (car Xs) (car Xs))
	 (result nil))
       ((null Xs) result)
    (setf result
	  (nconc result
                 (list
                 (let ((start (car x)))
                   (format nil "^~s ~s ~a"
                          (third start) (fourth start)
		           (if (fifth start)
			       (princ-to-string (fifth start)) ""))))))
    ))


;;;
;;;	VIb.	wm-structure?
;;;
;;; just a quick and dirty test to see if something can be expanded.
;;;

#-Soar5
(defun wm-structure? (item)
  (if (and (symbolp item)
           (or (get-wmparts item)
               (context-member item)))
      t))

#-Soar5
(defun context-member (item)
  (if (recursive-context-member item (contexts))
      t))

#-Soar5
(defun recursive-context-member (item contexts)
  (cond ((null contexts) nil)
        ((member item (car contexts)))
        (t (recursive-context-member item (cdr contexts)))))


;(defun get-wmparts2 (&optional (object (soar::top-goal)))
;  "Returns a list of strings corresponding to the wme's of OBJECT."
;  (do* ( (Xs (get object 'soar::wmpart*) (cdr Xs))
;	 (x (car Xs) (car Xs))
;	 (result nil))
;       ((null Xs) result)
;    (setf result
;	  (nconc result
;		 (list
;                 (let ((start (car x)))
;                 (list
;                   (format nil "^~s"
;                          (third start))
;                   (format nil "~s"
;                          (fourth start))
;                   (format nil "~a"
;		           (if (fifth start)
;			       (princ-to-string (fifth start)) "")) )))))
;    ))

;;;
;;;	V.	load-taql
;;;
;;; Probably site  and taql-home-directory dependent

#+Soar5
(defun load-taql ()
  "Do what you have to to load TAQL based on the value
of soar:taql-home-directory."
  ;; this is a bur, latest patches should be a file called such.
  (format t "~%; Loading taql load.lisp out of ~a,~%;  with value ~s."
            "soar:taql-home-directory"
             taql-home-directory)
  (let ((old-package (package-name *package*)))
    (in-package :user)
    (unwind-protect
        (load (format nil "~a/load.lisp" taql-home-directory))
        (in-package old-package)))
  nil)

;;;
;;;	
;;;

#-Soar5
(proclaim '(inline decision-cycle-count))
#-Soar5
(defun decision-cycle-count ()
   (- (cycle-count 'quiescence-phase) 1))

#-Soar5
(proclaim '(inline elaboration-cycle-count))
#-Soar5
(defun elaboration-cycle-count ()
   (- (cycle-count 'preference-phase) 1))

;;;
;;;	VIII.	BFP
;;;
;;; Cons a lot, could be cleaned up to use raw function calls that wm, spo, etc
;;; are built on.

;
;   Why do we need a new function?  Why can't we just upgrade spr to do
;   these things.  It already does many of them.
;
;When I looked at spr, I thought the code was not extendable in a
;reasonable way.  I thought having it do what bfp does would require
;keywords or positional arguments, both of which are burdensome.  While
;I agree with the philosophy (nea, theory) of keep it simple (Kiss), in
;this case, I believed keeping it simple meant providing two entry
;points.
;
;While I believe it should become part of Soar, an alternative view and
;point I was trying to make was that these sort of extensions that are
;big wins for users (Bob reports great satisfaction with it), can be
;quickly and relatively painlessly built by them or for them.
;
;However, as I write this up, I find that you are right.  Our
;suggestion for bfp should really be to replace spr with bfp.  The
;features of spr we don't like (e.g., not being able to mix types, no
;help, the lack of an ability to print with attribute descriptions) are
;really bugs, not something inharent in the intended functionality of spr.
;If Bob wishes to print WMEs with wm instead of swm, then bfp/spr
;should provide that as a single  keyword or as a global value
;(probably both).
;To: Frank Ritter <fr07+@andrew.cmu.edu>
;Cc: soar-archive@NATASHA.MACH.CS.CMU.EDU
;Subject: Bug Status 330
;Date: Wed, 26 Jun 91 21:55:55 EDT
;From: Soar.Hacker@TRICERATOPS.SOAR.CS.CMU.EDU
;
;# Soar 5.2 bug synopsis file. Each record contains the following fields:
;#
;# Report Date:
;# Reported by:
;# Status: (including, but not limited to: reported, fixed, non-bug, priority).
;# Cross Reference: (an id garnered from time stamp)
;# Priority: (1 is low, 9 is high)
;# Synopsis: (a brief description of the bug)
;# Comments: (anything not covered above)
;#
;Number: 330
;Report Date: 26-Jun-91
;Reported by: Frank Ritter <fr07+@andrew.cmu.edu>
;Status: TAQL
;Cross Reference: 12Jun91-10.24.26
;Priority: 3
;Synopsis:
;spr will not handle wm timetags
;
;Comments:
;None.
;------------------------------------------------------------------------------
;
;Number: 332
;Report Date: 26-Jun-91
;Reported by: Frank Ritter <fr07+@andrew.cmu.edu>
;Status: tested
;Cross Reference: 06Jun91-17.11.42
;Priority: 5
;Synopsis:
;Newer version of spr
;
;Comments:
;None.
;------------------------------------------------------------------------------
;

#-Soar5
(defvar spr-line-p t "*Try to put a line between each spr-printed item if T (default).")

;; (soar::spr 11 g1 DEFAULT*TOP-PS*PROPOSE*OPERATOR*WAIT (goal)) 
#-Soar5
(defmacro spr (&rest args)
  (let ( (a (car args))
         (b (cdr args)) )
    ;(format t "Doing ~s of ~s w/ b= ~s" a args b)
    ;(format t "This printing based on an idea by Bob. ~%")
    (cond
      ((null args) nil) ; done
      ((eq a :help)
       (format t "~a~%" (documentation 'soar::spr 'soar::function)))
      ((numberp a)      ; wme
       (eval `(wm ,a)))  ;puts its own space in
      ((wm-structure? a)        ; object
       (eval `(spo ,a))
       (if spr-line-p (format t "~%")))
      ((symbolp a) (eval `(spm ,a))       ; production
       (if spr-spacep (format t "~%")))
      ((listp a)          ; wm descriptions
       (eval `(sppwm ,@a)))
      (t (error "Fell off of bdp cond.")) )
    (if b (eval `(spr ,@b)))))

;; bug in allegro makes us doc macros after we define them
#-Soar5
(setf (documentation 'spr 'function)
  "Given a list of Soar objects, print them.
    For wmes: print just them
    For productions: print them
    For object ids: print them to the default level
    For wm descriptions (which now must be in lists): print them.")


;;;
;;;	IX.	sp?
;;;
;;; Returns T if it's arg is an sp.
;;; reported Date: Wed, 12 Jun 91 11:03:12 -0400 (EDT)
;
;To: Frank Ritter <fr07+@andrew.cmu.edu>
;Cc: soar-archive@NATASHA.MACH.CS.CMU.EDU
;Subject: Bug Status 329
;Date: Wed, 26 Jun 91 21:52:16 EDT
;From: Soar.Hacker@TRICERATOPS.SOAR.CS.CMU.EDU
;
;# Soar 5.2 bug synopsis file. Each record contains the following fields:
;#
;# Report Date:
;# Reported by:
;# Status: (including, but not limited to: reported, fixed, non-bug, priority).
;# Cross Reference: (an id garnered from time stamp)
;# Priority: (1 is low, 9 is high)
;# Synopsis: (a brief description of the bug)
;# Comments: (anything not covered above)
;#
;Number: 329
;Report Date: 26-Jun-91
;Reported by: Frank Ritter <fr07+@andrew.cmu.edu>
;Status: tested
;Cross Reference: 12Jun91-11.03.12
;Priority: 5
;Synopsis:
;sp object test
;
;Comments:
;None.
;------------------------------------------------------------------------------
;

#-Soar5
(defun sp? (prod) 
     (if (soar::soarmemq prod soar::*pnames*)
         t))

;;;
;;;	X.	sp-or-tc?
;;;
;;; will not be in 5.3

(defun sp-or-tc? (arg)
  "Returns t if arg is a name of a soar production or a tc."
  (declare (symbol arg))
  (or (sp? arg)
      #+taql(user::tc-name-p arg)))

;;;
;;;	XI.	r for run
;;;

#-Soar5
(defmacro r (&optional n)
  `(if ,n
      (run ,n)
      (run)))


;;;
;;;	XII.	Common macrocycle shortcuts, next-*
;;;

(defun next-g (&optional arg)
  "Run to the ARGth next goal (default is 1st)."
  (declare (integer arg))
  (macrocycle-ps "Goal" (or arg 1))
  nil)

(defun next-p (&optional arg)
  "Run to the ARGth next problem-space (default is 1st)."
  (declare (integer arg))
  (macrocycle-ps "Problem-space" (or arg 1))
  nil)

(defun next-s (&optional arg)
  "Run to the ARGth next state (default is 1st)."
  (declare (integer arg))
  (macrocycle-ps "State" (or arg 1))
  nil)

(defun next-o (&optional arg)
  "Run to the ARGth next operator (default is 1st)."
  (declare (integer arg))
  (macrocycle-ps "Operator" (or arg 1))
  nil)

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/soar-bugs.lisp".
;;;; -*- Mode: Soar -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-bugs.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Aug 10 15:22:41 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Thu Jan 23 11:53:57 1992
;;;; Update Count    : 40
;;;; Soar Version    : 5.2
;;;; Taql Version    : 3.1
;;;; 
;;;; PURPOSE
;;;; 	Soar bugs that should be fixed for all users.
;;;; Soar-repairs.lisp is for items that only the DSI is interested
;;;; in.  Soar-additions.lisp is for completely new soar things.
;;;;
;;;; TABLE OF CONTENTS
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings;  proclaim vars funs;  declares

(eval-when (load eval compile)
  (in-package "SOAR"))

;; 23-Jan-92 -FER I don't know why this is here....
;(defun retask-dsm ()
; (retask-diplomat)
; (retask-utilities)
; (retask-trafficker)        
;              
; (retask-user)
; (retask-supervisor)
; (retask-firer)
; (retask-conflux)
; (retask-subflux)
; (retask-decider)
;
; (retask-slots)
; (retask-preferences)
; (retask-context)
; (retask-subtext)
; (retask-symbols)
;
; (retask-actions)
; (retask-conditions)
; (retask-chunk5)
; (retask-tracer)
;)


;(defun make-context (goal supernode)    
; (declare (type tme-object goal)
;          (type gnode-or-NIL supernode))
; ;;; make bottom gnode for goal stack.
; ;; changed to agnode to avoid keywood error -fer
; ;;  if this works, then allegro compiles differently in file vs. function
; (let ((agnode (make-gnode goal
;                          (if supernode
;                              (1+ (gnode-depth supernode))
;                              0)
;                          supernode)))
;  (declare (type gnode agnode))
;  (setf (anode-onode (gnode-space-anode agnode)) agnode)
;  (setf (anode-onode (gnode-state-anode agnode)) agnode)
;  (setf (anode-onode (gnode-operator-anode agnode)) agnode)
;  agnode
;))

;; reported 1/91
;; Report Date: 11-Feb-91
;; Reported by: Frank Ritter <fr07+@ANDREW.CMU.EDU>
;; Status: Tested
;; Cross Reference: 30Jan91-14.59.15
;; Priority: 5
;; Synopsis:
;; Removal of some code no longer needed bu SGI
;; 
;; Comments:
;; In Next patch file

#-Soar5
(defun run-aux (break-criterion) 
 ;; was nlam-run.
 ;; Modified to use PPWM style wme expansion for run breaking. -BGM 1/15/89
 ;; Modified to send context trace information, under the si, to the run trace. -BGM.
 ;; Updated old style IO to soar-format. -BGM 8/18/88
 (let ((status NIL))
  (cond ((= *pcount* 0)
         (setf status "Please load in some productions first."))
        (T
         ;; set break and go.
         (cond ((set-run-break break-criterion)
                ;; valid break criterion. go. 

                ;; initialize top context.
                (cond ((initialize-top-context-p)
                       #+:soar-times (start-soar-time decide)
                       ;; these lines copied from old init-wm-context.
                       (and *learning* (learn-aux nil))
                       (initialize-top-context)
                       (setq *initial-actions* *action-count*)
                       (setq *elapsed-time* 0)
              	        (setq *elapsed-build-time* 0)
                       #+:soar-times (stop-soar-time decide) ))
                ;; go.
                #+:soar-times (start-soar-time real)
                #+:soar-times (start-soar-time run)
                (start-elapsed-time)
                (setf status (cycle))
                (if (eq status 'break)
                    (setf status '***BREAK***)
                    (setf status "End -- Explicit Halt"))

              	 (stop-elapsed-time)
              	 #+:soar-times (stop-soar-time real)
              	 #+:soar-times (stop-soar-time run) )
               (T
                ;; invalid break criterion.
                (setf status "What?") )) ))
 (soar-format *trace-file* "~%~A" status)
 NIL))

;; reported 1/91
;;Number: 271
;;Report Date: 11-Feb-91
;;Reported by: Frank Ritter <fr07+@ANDREW.CMU.EDU>
;;Status: Tested
;;Cross Reference: 30Jan91-14.27.22
;;WIll be in next patch file.
;; now interns into the user package rather than wherever the user is running

#-Soar5
(defun soar-genid (symbol-or-character)
 (let* ((first-character (first-character-of symbol-or-character))
	(symbol (or (pop (svref (soar-gensyms-free-ids *soar-gensyms*)
				(char-code first-character)))
		    (intern (concatenate 'string 
			     (make-string 1 :initial-element first-character)
			     (write-to-string 
			       (incf (soar-gensyms-count *soar-gensyms*))))
                            (find-package "USER") ))) )
   ;; Store the symbol so that it can have its properties cleared.
   (push symbol (soar-gensyms-ids *soar-gensyms*))
   (setf (get symbol 'gensymed) (hash-id symbol))
   ;; Give the RETE a hash index.
   (setf (get symbol 'wmpart*) nil)
   ;; Give the RETE a wmpart* property off of which to hang WMES of this ID.
   symbol))

;; reported 1/91
#-Soar5
(defun soar-genpname (symbol-or-character)
  (cond
    ((soar-gensyms-free-pnames *soar-gensyms*)
     (let ((symbol (pop (soar-gensyms-free-pnames *soar-gensyms*))))
       (push symbol (soar-gensyms-pnames *soar-gensyms*))
       (setf (get symbol 'gensymed) t)
       symbol))
    (t
      (let* ((prefix (make-string 1 :initial-element 
                                    (first-character-of symbol-or-character)))
             (symbol (loop 
                       (multiple-value-bind (symbol previously-existing)
                          (intern (concatenate 'string
                                     prefix
				    (write-to-string (incf (soar-gensyms-count *soar-gensyms*))))
                                  (find-package "USER"))
                          (unless (and previously-existing 
                                      (get-p symbol))
			              (return symbol))))))
	    (push symbol (soar-gensyms-pnames *soar-gensyms*))
	    (setf (get symbol 'gensymed) t)
	    ;; Note that this is a gensym. I'm not sure who uses this.
	    symbol))))

;; reported 1/91
;; Number: 272
;; Report Date: 11-Feb-91
;; Reported by: Frank Ritter <fr07+@ANDREW.CMU.EDU>
;; Status: Tested
;; Cross Reference: 30Jan91-14.57.05
;; Priority: 5
;; Will be in next patch file.

#-Soar5
(defun load-soar-init-file (&optional other-file-name)
 ;; Load the soar init file from the user's home directory, if it exists.
 ;; TFMcG 28-Jun-90
 ;; added other-file-name for use with sx too  -fer 9/90
  (let ((init-file (or other-file-name  *soar-init-file-name*)) )
  (and init-file
       (open (merge-pathnames (pathname init-file)
			      (user-homedir-pathname))
	     :direction :probe)
       (lispload (merge-pathnames (pathname init-file)
				  (user-homedir-pathname))))
  nil))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/soar-repairs.lisp".
;;;; -*- Mode: lisp; Package: SX -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : soar-repairs.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jun 25 17:20:12 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Mon Mar 30 21:22:56 1992
;;;; Update Count    : 239
;;;; 
;;;; PURPOSE
;;;; 	modifications to existing soar code for the sx that haven't caught
;;;;  up with soar yet.
;;;; TABLE OF CONTENTS
;;;;	i.	Hooks code
;;;;
;;;; 	I.  	init-soar-hook added to init-soar
;;;; 	II.	cycling, the main loop in soar
;;;;	III.	last-chunk
;;;;	IV.     soar-macrocycle fixed up again
;;;;	V. 	Soarsyntax
;;;;	VI.	Soarresetsyntax
;;;;	VII.	dsm-watch
;;;;	VIII.	retask-dsmsoar and others
;;;; 	IX.	Changes for CHUNK COMPILATION.
;;;;	XI.	Firing-Rule-report
;;;;	XII.	signal-quiescence-phase-start
;;;;	XIII.	signal-preference-phase-start
;;;;	XIV.	ms - do ~% correctly
;;;;	XV.	preferences fixed up
;;;;	XVI.	sem patch(es)
;;;;	XVII.	nlam-excise [now redundant]
;;;;	XVIII.	signal-preference-phase-end
;;;;	XIX.	print-pgs-context
;;;; 
;;;;  Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings;  proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SOAR"))

(eval-when (load eval compile)
  (export '(after-dc-hook
	    init-soar-hook
            proposed-operators
            pgs-tab-size
            pgs-goal-leader
            pgs-pscm-id
            pgs-real-tab
            pgs-show-depth
            run-hooks)
	(find-package "SOAR")))

(eval-when (load eval compile)
  (proclaim '(function cycling () nil))
  (proclaim '(list preferences-result
                   proposed-operators-result))
  (proclaim '(function push-typed-preferences (symbol tme-type list) nil))
  (proclaim '(function format-preference2 (tme-type tme-value tme-value)
                       string))
  ;(proclaim '(function nlam-excise (list) list))
  )

#-Soar5
(if (not (find-package "KR"))
    (make-package "KR"))
#-Soar5
(if (not (find-package "OPAL"))
    (make-package "OPAL"))

;;;
;;;	i.	Hooks code
;;;
;;; This hooks code generously allows
;;; function names, lambda-forms, lists to eval, and nil to be on the list
;;;

;; Number: 276
;; Report Date: 11-Feb-91
;; Reported by: Frank Ritter <fr07+@ANDREW.CMU.EDU>
;; Status: Tested
;; Cross Reference: 30Jan91-15.26.12
;; Priority: 2
;; Synopsis:
;; Init-soar-hook code
;; 
;; Comments:
;; Will be included in the next patch file.

#-Soar5
(defun run-hooks (hook-or-list-of-hooks)
 "run the commands on the hook-or-list-of-hooks"
 (cond ((not hook-or-list-of-hooks))
       ((and (symbolp hook-or-list-of-hooks)
             (boundp hook-or-list-of-hooks))
        (run-hook (eval hook-or-list-of-hooks)))
       ((symbolp hook-or-list-of-hooks)
        (run-hook hook-or-list-of-hooks))
       ((and hook-or-list-of-hooks
             (listp hook-or-list-of-hooks))
        (mapc #'run-hook hook-or-list-of-hooks)))
 nil)

#-Soar5
(defun run-hook (hook-fn)
  "eval the lists of hook"
  (cond ((not hook-fn))
        ((and (symbolp hook-fn)
	      (fboundp hook-fn))
	 (funcall hook-fn))
        ((eq (first hook-fn) 'lambda)
         (funcall hook-fn))
        ((listp (first hook-fn))
         (mapc #'run-hook hook-fn))
        ((and (listp hook-fn)
	      (fboundp (first hook-fn)))
	 (eval hook-fn))
	(t (format *error-output*
		   "Couldn't figure out what to do with ~s in run-hooks."
		   hook-fn)) ))


;;;
;;; 	I.  init-soar-hook added to init-soar
;;;


#-Soar5
(defvar init-soar-hook nil 
  "*Hook to run after init-soar. Items can be
function names, lists to eval, lambda forms, or nil.")

#-Soar5
(defun init-soar ()  
 (retask-dsmsoar)
 (run-hooks 'init-soar-hook))


;;;
;;; 	II.	cycling, the main loop in soar
;;; This is sub-optimal (or over-optimized!), there is no fun call that
;;; is equivalent to a dc, or an elaboration cycle, so we have to patch things
;;; in. -fer 2/91
;;;
;;;  modified to check the sx server, call a hook after a dc.

#-Soar5
(defvar after-dc-hook nil    ;(setq user::after-dc-hook '((format t "~% after a dc")))
  "hook to run after each decision cycle. Items can be
function names, lists to eval, lambda forms, or nil.")


;;#-Soar5
;; used to be set in soar5 for us, but I missed an update...
;; 25-Aug-91 -FER
;;

(defun cycling ()
;;;****************************************************************************
;;; Function: cycling
;;; Description: Modified Soar5 function providing hook into EDT code.
;;;****************************************************************************
  (setf *cycler-status* 'cycling)
  (do ((current-cycle *current-cycle*))  ;avoid global accesses       
      (())
    ;; check the sx server every (elaboration?) cycle -fer
    #+sx(sx:check-sx-x-server)
    (cond ((halt-p)
	   (setf *cycler-status* 'halt)
	   (setf *current-cycle* current-cycle)
	   (clear-halt)
	   (return T))
	  ((break-p) 
	   (setf *cycler-status* 'break)
	   (setf *current-cycle* current-cycle)
	   (clear-break)
	   (return T))
	  ((keyboard-break-p) 
	   (setf *cycler-status* 'break)
	   (setf *current-cycle* current-cycle)
	   (clear-keyboard-break)
	   (return T))
	  (T  ;progress, as it were, to next phase.
	   (cond ((eq current-cycle 'preference-phase)
		  (setf current-cycle 'working-memory-phase)
		  (working-memory-phase)
		  #+sx(if soar::graphic-display?
                          (sx::sx-after-elaboration-hook)))
		 ((eq current-cycle 'working-memory-phase)
		  (setf current-cycle 'quiescence-phase)
		  (and (quiescence-phase)
                       ;; added hook to run after decision cycle -fer 2/91
                       (run-hooks 'after-dc-hook))
                  ;; missed this first time 'round
                   #+sx(if soar::graphic-display?
                           (sx::sx-after-dc-hook))
                  )
		 ((eq current-cycle 'quiescence-phase)
		  (when *edt*
		    (event-timing)) ;Hook into Soar5 for EDT code.
		  (setf current-cycle 'preference-phase)
		  (preference-phase))
		 (T   ;startup
		  (setf current-cycle 'preference-phase)
		  (preference-phase) )) )) )
  nil)


(eval-when (load eval compile)
  (in-package "SX"))
;; move to sx package

(eval-when (load eval compile)
  (proclaim '(function sx-after-elaboration-hook () nil))
  (proclaim '(function sx-soarsyntax-hook () nil))
  (proclaim '(function sx-soarresetsyntax-hook () nil))
  (proclaim '(function sx-dsm-watch-hook () nil))
  (proclaim '(function sx-signal-quiescence-phase-start-hook () nil))
  (proclaim '(function sx-signal-preference-phase-start () nil))
  )

(defun sx-after-elaboration-hook ()
  (if (and (boundp 'sx::*sx*) sx::*sx*)
      (progn (if (g-value sx::*sx* :update-live-windows-always)
                 (sx::update-examiner-windows))
             (if sx::continuous-ms! (sx::emacs-ms)))
      ))

(defun sx-after-dc-hook ()
  (if (and (boundp 'sx::*sx*) sx::*sx*)
      (progn (sx::update-examiner-windows)
             (if sx::continuous-ms! (sx::emacs-ms)))
      ))

;; (setf (symbol-function 'sx-after-dc-hook)
;;      (symbol-function 'sx-after-elaboration-hook))


;;;
;;;	III.	last-chunk
;;;
;;; Now returns last chunk instead of nil, and can not print out if you wish.
;;;

(eval-when (load eval compile)
   (in-package "SOAR"))

#-Soar5
(defun last-chunk (&key (print-p t))
 ;; added DSM version of last-chunk. -KAM 7/8/89.
 (dolist (chunk *chunks*)            
  (declare (symbol chunk))
  (cond ((not (internal-chunk-p chunk))
	 (if print-p
             (eval (cons 'spm (list chunk))))
         (return chunk) )) ))

;; chunk instead of chunk-creation was used in soar5.2 release.
(defun macrocycle-get-latest (type)
  (let ( (context (car (last (soar::contexts)))) )
    (cond ((string= type "Goal") (second context))
          ((string= type "Problem-space") (third context))
          ((string= type "State") (fourth context))
          ((string= type "Operator") (fifth context))
	  ((string= type "Chunk-creation") (last-chunk :print-p nil))
          (t "error in macrocycle-get-latest"))))

;;;
;;;		IV.	macrocycle fixed up again
;;;

(eval-when (load eval compile)
   (in-package "SOAR"))

(defun macrocycle (&optional (n macrocycle-n) (type  macrocycle-type) )
  "Run Soar for the macrocycle number and type, and then redisplays any 
graphic displays."
  (declare (integer n) (string macrocycle-type))
  (if (not (numberp n))
      (progn (format t "~%macrocycle requires n to be a number (it was ~s).~%"
		     n)
	     (return-from macrocycle)))
  (if (not (stringp type))
      (progn (format t "~%macrocycle requires type to be a string (it was ~s).~%"
		     type)
	     (return-from macrocycle)))
  (cond ((string= type "Decision")    (run-aux (list N 'd)))
        ((string= type "Elaboration") (run-aux (list n)))
	((member type macrocycle-ps-types :test 'string=)
	 (macrocycle-ps type n))
	(t (format t "macrocycle passed bad values: ~s ~s" type n)))
  #+sx(if soar::graphic-display? (sx:update-examiner-windows))
  (run-hooks after-macrocycle-hook)
  ;; change here 11-Nov-91 -FER
  ;; dropped ~% because *** break *** is there
  (format t "   ***macro-cycle break***") 
  )

(eval-when (load eval compile)
  (in-package "SX"))

(defun sx-set-macrocycle-hook ()
  (if (and (boundp 'sx::*sx*) 
           sx::*sx*)
      (progn
        (kr::s-value sx::*sx* :macrocycle-number soar:macrocycle-n)
        (kr::s-value sx::*sx* :macrocycle-type soar:macrocycle-type)
        (kr::s-value sx::*sx* :macrocycle-max-dc soar:macrocycle-max-dc))))


;;;
;;;	V. 	Soarsyntax
;;;
;;;  From sptop/lexer.lisp [and patch file], changed to let dsi know.

(eval-when (load eval compile)
   (in-package "SOAR"))

#-Soar5
(defun soarsyntax ()
  ;; The *soar-readtable* is the *read-table* for now, because otherwise the TI
  ;; breaks because it exects to call load using the very first readtable ever built.
    (setq *soar-readtable* *readtable*)
    ;; Install all of the soar reader functions.
    (dolist (character.function *soars-macro-characters*)
      (set-macro-character (car character.function)
			   (cdr character.function) 
			   nil
			   *readtable*))
  #+sx(if soar::graphic-display?
          (sx::sx-soarsyntax-hook))
    t)

(eval-when (load eval compile)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(special status-xb-syntax)))

(defun sx-soarsyntax-hook ()
  (if (and (boundp '*sx*)
           *sx*)
      (progn
       (s-value *sx* :soar-syntax t)
       ;; due to load order, this might not be around at first call.
       (if (boundp 'status-XB-syntax)
           (s-value status-XB-syntax
                    :value '("Soar syntax")))
       (if (boundp 'soar-status-window)
           (opal:update soar-status-window)))))


;;;
;;;		VI.	Soarresetsyntax
;;;

(eval-when (load eval compile)
   (in-package "SOAR"))

; #-Soar5
(defun soarresetsyntax ()
  ;; As the TI won't let us use spanking new read tables, 
  ;; I've changed this to get a clean readtable and copy
  ;; back into our old readtable the favorite syntaxes for our characters.
  (dolist (character.function *soars-macro-characters*)
   (let ((character (car character.function)))
    (set-syntax-from-char character character *readtable*
			  *clean-readtable*)))
  #+sx(if soar::graphic-display?
          (sx::sx-soarresetsyntax-hook))
  t)


(eval-when (load eval compile)
  (in-package "SX"))

;; move to sx package
(defun sx-soarresetsyntax-hook ()
  (if (and (boundp '*sx*)
            *sx*)
      (progn (s-value *sx* :soar-syntax nil)
             (if (boundp 'status-XB-syntax)
                 (s-value status-XB-syntax :value nil))
             (if (boundp 'soar-status-window)
                 (opal:update soar-status-window)))))


;;;
;;;	VII.	dsm-watch
;;;
;;; from tracer module, tracer.lisp

(eval-when (load eval compile)
   (in-package "SOAR"))

#-Soar5
(defun dsm-watch (level &optional task-rules-only)                    
 (declare (number level)
          (symbol task-rules-only))           

 ;; task-rules-only is T if only the task (user) rules are to be traced.
 (setf *firing-trace-task-rules-only* task-rules-only)
 (unwatch)
 (setf *watch-level* level)  
 (case level
  (-1)                  
  (0 (trace-goal-creation)
     (trace-context-installation-short))
  (.5    (trace-cycles)
         (trace-goal-creation)
         (trace-context-installation-long)
         (trace-context-installation-short)
         (trace-firing-all-rules))
  (1   (trace-cycles)
       (trace-goal-creation)
       (trace-context-installation-long)
       (trace-context-installation-short)
       (trace-firing-all-rules)    
       (trace-lhs)) 
  (1.5   (trace-cycles)
       (trace-goal-creation)
       (trace-context-installation-long)
       (trace-context-installation-short)
       (trace-firing-all-rules)
       (trace-augmentation-addition)
       (trace-augmentation-removal)
       (trace-preference-wme-addition)
       (trace-preference-wme-removal))
  (2   (trace-cycles)
       (trace-goal-creation)
       (trace-context-installation-long)
       (trace-context-installation-short)
       (trace-firing-all-rules)
       (trace-lhs) 
       (trace-augmentation-addition)
       (trace-augmentation-removal)
       (trace-preference-wme-addition)
       (trace-preference-wme-removal))
  (3   (trace-cycles)
       (trace-goal-creation)
       (trace-context-installation-long)
       (trace-context-installation-short)
       (trace-internal-firing)
       (trace-firing-all-rules)
       (trace-lhs) 
       (trace-rhs)
       (trace-augmentation-addition)
       (trace-augmentation-removal)
       (trace-preference-wme-addition)
       (trace-preference-wme-removal))
  (otherwise   (setf *watch-level* -1) ))
  ;; lets the sx know what's going on
 (if soar::graphic-display?
     (sx::sx-dsm-watch-hook))
 T) 


(eval-when (load eval compile)
  (in-package "SX"))

;; move to sx package
(defun sx-dsm-watch-hook ()
  (if (and (boundp 'sx::*sx*) 
           sx::*sx*)
      (progn (kr::s-value sx::*sx* :watch soar::*watch-level*)
             (and (kr::schema-p sx::soar-status-window)
                  (opal::update sx::soar-status-window))))
  nil)


;;;
;;;	VIII.	retask-dsmsoar & others
;;; just added code to run dsi.
;;;

(eval-when (load eval compile)
   (in-package "SOAR"))

#-Soar5
(proclaim '(function retask-tracer () true))

;; slight change to reset-pscm-stats 28-Jan-92 -FER
(defun retask-tracer ()
 ;; task restart.
 #+sx(sx::clear-graphic-display)
 T)

(defun restart-soar ()  
  ;; Have allegro do a full gc after a restart soar. -BGM 1-Mar-90
  #+(and :allegro :gsgc)
   (setf (sys:gsgc-switch :next-gc-is-global) t)
 (restart-dsmsoar)  
 #+sx(sx::reset-pscm-stats)
)

#-Soar5
(proclaim '(function signal-context-installation
                    (tme-object gme-attribute gme-value) true))
#-Soar5
(defun signal-context-installation (goal attribute value)
 (declare (type tme-object goal)
          (type gme-attribute attribute)
          (type gme-value value))
 (let ((event (events-context-installation *events*)))
  (declare (type event event)) 

  (incf (event-count event))        
  (cond ((= (event-count event) (event-break-count event))
         (signal-break))
        ((or (member value (event-break-criteria event) :test #'eq)
             (member (object-name value) (event-break-criteria event) :test #'eq))
         (signal-break) ))

  (cond ((and (eq attribute 'state)
              (eq goal (top-goal)))
         ;; tell soar/io there is a top state.
         (signal-io-top-state-installation value) )) 

  (cond ((watching-p)
         (cond ((context-installation-long-trace-p)
                (context-installation-long-report (event-count event)
                                                  goal
                                                  attribute
                                                  value) )) 
         (cond ((context-installation-short-trace-p)
                (context-installation-short-report (event-count event)
                                                   goal
                                                   attribute
                                                   value) )) ))
 #+sx(if graphic-display?
           (sx:add-context-item goal attribute value))
 T))


#-Soar5
(proclaim '(function signal-goal-creation
                     (tme-object gme-attribute symbol list tme-object fixnum)
                     true))
#-Soar5
(defun signal-goal-creation (goal   attribute  impasse
                             items  supergoal  depth)
 (declare (type tme-object goal supergoal)
          (type gme-attribute attribute)
          (symbol impasse)   (list items)                   
          (fixnum depth)) 
 (let ((event (events-goal-creation *events*)))
  (declare (type event event)) 

  (incf (event-count event))        
  (cond ((= (event-count event) (event-break-count event))
         (signal-break) ))  
                                
  (cond ((and (goal-creation-trace-p) (watching-p))
         (goal-creation-report (event-count event)
                               goal       attribute
                               impasse    items
                               supergoal  depth)))
 #+sx(if graphic-display?
           (sx::add-context-item goal 'goal goal))
 T))



;;;
;;; 	IX.	Changes for CHUNK COMPILATION.
;;;
;;; added that compile-chunks calls for the building of a chunk.

#-Soar5
(defun compile-chunks ()

 ;; called by supervisor module at end of elaboration module.
 ;; modified from Soar4 function create-production.
                                                             
 #+:soar-times (start-soar-time chunk)
 (prog (chunk-name chunk-ok-p)

	 (unless *new-chunks*
	  #+:soar-times (stop-soar-time chunk)
	  (return))

  (start-build-time)
  (setf *new-chunks* (nreverse *new-chunks*))
                                     
  ;; traverse list of new chunks.   
  ;; should loop through chunks within the tests rather than
  ;; testing within loop.
  (dolist (new-chunk *new-chunks*)
     (setf chunk-name (cadar new-chunk))

     ;; compile chunk.
     (setf chunk-ok-p (compile-chunk chunk-name new-chunk))
     
     (if chunk-ok-p
         ;; print trace info.
         (cond ((internal-chunk-p chunk-name)
                (cond ((internal-firing-trace-p)
                       ;; tracing internal chunks and instantiations.
                    			(cond ((eqp *print-learn* 1)
    		  	                     (soar-format *trace-file* "~%")
           			                (eval (list 'spm chunk-name)))
           			               (*print-learn* 
     		  		(soar-format *trace-file* "~%Internal Build:")
                         			  (ms-soar-princ t chunk-name 'pname) )) )) ) 
               (T
                ;; chunk is external.
             			(cond ((eqp *print-learn* 1)
    		  	              (soar-format *trace-file* "~%")
           			         (eval (list 'spm chunk-name)))
    			               (*print-learn* 
              		  		(soar-format *trace-file* "~%Build:")
                  			  (ms-soar-princ t chunk-name 'pname) )) 
               #+sx
               (if graphic-display?
                   (sx::add-chunk chunk-name))
                (cond (*tracep*
                       ;; put a firing trace on new chunk.
                       (trace-firing-rule chunk-name) )) )) ) )
  
  (setf *new-chunks* NIL)

  (stop-build-time)
  #+:soar-times (stop-soar-time chunk)
))

#-Soar5
(defun excise-chunks nil  
  ;; also removes them from trace -fer 9/2/90
  ;; Installed # - :DSM from mcmahon. -BGM 2/3/89
  ;; Updated to use unptrace. -BGM 1/14/89
  ; [ARG -- 1/2/88] Do nothing if *chunks* is nil.
  (if (not (null *chunks*))
      (prog (chunks)
            ;; replaced append to NIL with copy-list. -KAM 6/14/89
            (setf chunks (copy-list *chunks*))
	    (eval (cons 'excise chunks))
            #+sx(sx::sx-excise-chunks))))


;;;
;;;	XI.	Firing-Rule-report
;;; just changed to let dsi know.

#-Soar5
(defun firing-rule-report (title count rule-name lhs rhs)
 (declare (string title)            (fixnum count)
          (symbol rule-name)        (list lhs rhs))
 (declare (ignore count))

 (soar-format *trace-file*
              "~%~A ~D:~D ~A"
              title
              (cycle-count 'quiet)
              (1- (cycle-count 'production))
              rule-name)
 ;; give it a shot at being a chunk firing for the graphical display -fer
 #+sx(sx::fire-graphic-rule rule-name)
 (cond (*lhs-trace*
        (soar-format *trace-file*
                     " ~A"
                     (format-lhs lhs)) ))
 (cond (*rhs-trace*
        (soar-format *trace-file*
                     "~%~A"
                     (format-rhs rhs)) ))
 T)


;;;
;;;	XII.	signal-quiescence-phase-start
;;;	where cycle gets set
;;; -fer added that it sets cycle count for display in graphic-display-window

#-Soar5
(defun signal-quiescence-phase-start ()
 (let ((event (events-quiescence-phase-start *events*)))
  (declare (type event event)) 

  (clear-forced-quiescence)
  (setf *elaborations-since-quiescence* 0)

  (signal-production-start) 
  (signal-run-cycle-start)

  (incf (event-count event))        
  #+sx(if soar::graphic-display?
          (sx::sx-signal-quiescence-phase-start-hook))
  (cond ((= (event-count event) (event-break-count event))
         (signal-break) ))

  (cond ((and (cycle-trace-p) (watching-p))
         (cycle-report (event-count event) 'quiescence-phase)))
 T ))


(eval-when (load eval compile)
  (in-package "SX"))

;; move to sx package
(defun sx-signal-quiescence-phase-start-hook ()
  (if (and (boundp 'sx::*sx*) 
           sx::*sx*)
      (progn
         (setf sx::cleanup-chunks t)
         (kr::s-value sx::*sx* :decision-cycle ;the count is off by 1
             (- (soar::cycle-count 'quiet) 1)))
       )
  nil)


;;;
;;;	XIII.	signal-preference-phase-start
;;;

(eval-when (load eval compile)
   (in-package "SOAR"))

#-Soar5
(defun signal-preference-phase-start ()
;; define a timetag for all instantiations that occur within this preference
;; phase. Bug #23Jul90-14.14.00 24-Jul-90 GAP
 (setq *preference-phase-timetag* (make-timetag))
 (let ((event (events-preference-phase-start *events*)))
  (declare (type event event)) 
  (signal-production-start)
  (signal-run-cycle-start)
  #+sx(if soar::graphic-display?
          (sx::sx-signal-preference-phase-start))
  (incf (event-count event))
  (cond ((= (event-count event) (event-break-count event))
         (signal-break) ))
  (cond ((and (top-state) (not (keyboard-break-p)))
         ;; soar-io.
         (io-input-cycle) ))
  (cond ((and (cycle-trace-p) (watching-p))
         (cycle-report (event-count event) 'preference-phase)))
 T ))

(eval-when (load eval compile)
  (in-package "SX"))

(defun sx-signal-preference-phase-start ()
  (let ((dirty nil))
  (if sx::cleanup-chunks
      (progn
     (if (get-values *sx* :latest-selected-chunks)
         (progn (sx::unselect-chunks)
                (setf dirty t)))
     (if (get-values *sx* :latest-fired-chunks)
         (progn (sx::unfire-chunks)
                (setf dirty t)))
     (if dirty (opal:update sx::graphic-display-window))))
  (setf sx::cleanup-chunks nil)
  nil))


;;;
;;;	XIV.	ms - do ~% correctly
;;;

(eval-when (load eval compile)
   (in-package "SOAR"))

#-Soar5
(defun ms ()
 ;; Change to (ms) as per bug #11May90-10.08.36 GAP 5/11/90
 (let ((retracts (retracted-rule-names))
       (fires (unfired-rule-names)))
  (declare (list retracts fires))
  (cond (retracts
         (soar-format *trace-file*
                      "~%Retractions:")
         (rule-queue-report retracts) ))
  (cond (fires
	 (if retracts
	     (soar-format *trace-file* "~%"))
         (soar-format *trace-file*
                      "~%Instantiations:")
         (rule-queue-report fires) ))
 ;; return T or NIL.
 (logicize (or retracts fires))))


;;;
;;;	XV.	preferences fixed up
;;;
;;; now takes 1 or 2 args
;;; and has doc string

(eval-when (load eval compile)
  (soarresetsyntax))

;; #-Soar5
(defparameter preferences-result nil
#-release-sx  "Where preference results are stored.")

;; reported 12/91
;; #-Soar5
(defmacro preferences (&optional (object nil) (attribute nil)
                                 &rest r
                                 &key (return-p nil) (print-p t) )
#-allegro"Finds within OBJECT (defaults to highest meta-level goal if not passed)
preferences for ATTRIBUTE (no default)."
;  (format t "called with ~s ~s <" object attribute)
 (cond (attribute `(slot-preferences ',object ',attribute ',return-p
                                     ',print-p))
        ;; you got passed no object, use the top level goal
	(object  `(slot-preferences ',(bottom-goal) ',object ',return-p
                                    ',print-p))
	;; you got passed nothing, use defaults
        (t  `(slot-preferences ',(bottom-goal) 'operator ',return-p
                               ',print-p))))

;; allegro won't let you set doc string directly for macros...
#+(and allegro
       (not Soar5))
(setf (documentation 'preferences 'function)
      "Finds within OBJECT (defaults to highest meta-level goal if not passed)
preferences for ATTRIBUTE (no default).")

#-Soar5
(proclaim '(function slot-preferences (tme-object tme-attribute
                                                  boolean boolean) true))
#-Soar5
(defun slot-preferences (object attribute return-p print-p)
 (declare (type tme-object object)
          (type tme-attribute attribute)
          (type boolean return-p)
          (type boolean print-p))
 (setq preferences-result nil)
 (cond ((context-slot-p object attribute)
        (context-preferences-report object attribute print-p))
       (T
        (subtext-preferences-report object attribute print-p) ))
 (if return-p 
     preferences-result
     t))

;; #-Soar5
#+allegro
(setf (documentation 'preferences 'function)
      "Finds within OBJECT (default highest meta-level goal) 
preferences for ATTRIBUTE (no default).")

#-Soar5
(proclaim '(function print-typed-preferences
                     (tme-class tme-object tme-attribute tme-type list)
                     true))
#-Soar5
(defun print-typed-preferences (class object attribute type typed-preferences)
 (declare (type tme-class class)
          (type tme-object object)
          (type tme-attribute attribute)
          (type tme-type type)
          (list typed-preferences))
 (let ((parser (cond ((eq type 'oa-reject)
                      #'parse-oa-reject)
                     ((member type '(better indifferent-to parallel-to) :test #'eq)
                      #'parse-binary-preference)
                     (T #'parse-unary-preference)) ))
  (soar-format *trace-file*
               "~%~As:"
               (string-capitalize type))
  (dolist (preference typed-preferences T)
    (multiple-value-bind (process reference i-support o-support) 
                         (funcall parser preference) 
      (declare (type tme-value process reference)
               (atom i-support o-support)) 

     (push (format nil
                  "~A   I-Support: ~A   O-Support: ~A"
                  (format-preference class 
                                     object
                                     attribute
                                     type  
                                     process 
                                     reference)
                  i-support
                  o-support)
           preferences-result)
     (soar-format *trace-file*
                  "~%~A   I-Support: ~A   O-Support: ~A"
                  (format-preference class 
                                     object
                                     attribute
                                     type  
                                     process 
                                     reference)
                  i-support
                  o-support) ))  ))


;;;
;;;	XV.	proposed-operators
;;;

;; will not be in 5.3
(defparameter proposed-operators-result nil)

(defun proposed-operators (&optional (goal (bottom-goal)))
  "Returns a list of operators proposed for GOAL."
 (declare (type tme-object goal))
 (setq proposed-operators-result nil)
 (if (not goal) (return-from proposed-operators nil))
 (let* ( (anode (gnode-operator-anode (goal-gnode goal))) )
  (declare ;(type gnode-or-NIL gnode)
	   (type anode-or-NIL anode))
 (if anode
 (multiple-value-bind (requires prohibits accepts reconsiders rejects
                       betters bests worsts indifferents indifferent-tos
                       parallels parallel-tos)
                      (preferences-parse-preferences anode)
  (declare (list requires prohibits accepts reconsiders rejects
                 betters bests worsts indifferents indifferent-tos
                 parallels parallel-tos))
  (if reconsiders (push-typed-preferences goal 'reconsider reconsiders))
  (if requires (push-typed-preferences goal 'require requires))
  (if prohibits (push-typed-preferences goal 'prohibit prohibits))
  (if accepts (push-typed-preferences goal 'accept accepts))
  (if rejects (push-typed-preferences goal 'reject rejects))
  (if betters (push-typed-preferences goal 'better betters))
  (if bests (push-typed-preferences goal 'best bests))
  (if worsts (push-typed-preferences goal 'worst worsts))
  (if indifferents (push-typed-preferences goal 'indifferent indifferents))
  (if indifferent-tos (push-typed-preferences goal 'indifferent-to indifferent-tos))
  (if parallels (push-typed-preferences goal 'parallel parallels))
  (if parallel-tos (push-typed-preferences goal 'parallel-to parallel-tos))
  (sort proposed-operators-result #'string-lessp)))))

(defun push-typed-preferences (object type typed-preferences)
 (declare (ignore object)
          (type tme-type type)
          (list typed-preferences))
 (let ((parser (cond ((member type '(better indifferent-to parallel-to)
			      :test #'eq)
                      #'parse-binary-preference)
                     (T #'parse-unary-preference)) ))
  (dolist (preference typed-preferences T)
    (multiple-value-bind (process reference i-support o-support) 
                         (funcall parser preference) 
      (declare (type tme-value process reference)
               (atom i-support o-support)) 
     (push (soar-format nil
                  "~A"  ;ISupp:~A OSupp:~A
                  (format-preference2
                                     type  
                                     process 
                                     reference)
                  i-support
                  o-support)
	   proposed-operators-result)))
  nil))

(defun format-preference2 ( type process reference)
 (declare (symbol type)
          (atom process reference))
 (cond (reference
        (soar-format NIL                                       
                     "~A (~a) ~A ~A"
                     process
		     (context-object-name process)
                     (preference-external-type type)
                     reference))
       (T
        (soar-format NIL                                       
                     "~A (~a) ~A"
                     process
		     (context-object-name process)		     
                     (preference-external-type type)) ))
)


;;;
;;;	XVI.	sem patch(es)
;;;

#+sem(if (not (boundp 'sem::*sem-version*))
         (progn
           (setf sem::*sem-version* nil)
           (proclaim '(special sem::*sem-version*))))


;;;
;;;	XVII.	nlam-excise
;;;

;(defun nlam-excise (pname-list)
;  ;; 2-Oct-91 -FER  removed sx chunks too
;  ;; Modernized, BGM 11/7/88.
;  ; Randy.Gobbel  9-May-86 14:37 
;  (if (null pname-list)
;    (setq pname-list *last-pname*)
;    (setq *last-arg* (setq *last-pname* (list (car pname-list)))))
;  (dolist (pname pname-list)
;    (excise-p pname)
;    #+sx(sx:excise-graphic-chunk
;         (sx::get-sx-item pname nil)))
;  pname-list)


;;;
;;;	XVIII.	signal-preference-phase-end
;;;

;(eval-when (compile eval load) (proclaim '(ftype (function () true) signal-preference-phase-end)))
;
;(defun signal-preference-phase-end ()
; (let ((event (events-preference-phase-end *events*)))
;  (declare (type event event)) 
;  (signal-production-end) 
;
;  (incf (event-count event))        
;  (cond ((= (event-count event) (event-break-count event))
;         (signal-break) ))
;  ;; cms does not go  here, doesn't get any productions
; T))


;;;
;;;	XIX.	print-pgs-context
;;;
;;; We require a slightly more compact trace.

(defvar pgs-tab-size 3)
(defvar pgs-goal-leader "==>")
(defvar pgs-real-tab nil
  "*If not nil (the default), insert a real tab after dc.")
(defvar pgs-pscm-id t
  "*If t (the default) print PSCM objects in trace or pgs with id.")
(defvar pgs-show-depth nil
  "*If t (default nil) print periods in the trace for each level down.")

;; This gets called by soar-format, so don't need to use it.
(defun format-tab-or-depth (tab goal-depth)
 (declare (fixnum tab goal-depth))
 ;; Added test for zero to avoid Allegro bug. -BGM 9/21/89
 ;; note that absolute tabbing refers to local buffer.
 (if *subgoal-tabs*
     (if (zerop tab)
         ""
         (if pgs-show-depth
             (let ((result ""))
               ;(format t "[~s ~s]" tab goal-depth)
               (setq tab (1- tab))
               (dotimes (i goal-depth)
                 (setq result (concatenate 'string result "."))
                 (dotimes (i tab)
                 (setq result (concatenate 'string result " "))))
               result)
             (format NIL "~vT" tab)))
     (format NIL "(~D)~6T" goal-depth)))


(eval-when (compile eval load)
  (proclaim '(ftype (function (fixnum tme-object gme-value gme-value gme-value)
                                true) print-pgs-context)))


(defun print-pgs-context (depth goal space state operator)                 
 (declare (fixnum depth)
          (type tme-object goal)
          (type gme-value space state operator))

 (let ((tab (* pgs-tab-size depth)))
 ;; goal.
 (cond ((= depth 0)
        (soar-format *trace-file*
                     "~%~4T~AG: "
                     (format-tab-or-depth tab depth)))
       (T
        (soar-format *trace-file*
                     "~%~4T~A~AG: "
                     (format-tab-or-depth (- tab pgs-tab-size) depth)
                     pgs-goal-leader ) ))
 (soar-format *trace-file* "~A~A~A"
              (if pgs-pscm-id goal "")
              (if pgs-pscm-id " " "")
              (format-trace-attributes goal))
 ;; problem space.
 (if space
     (soar-format *trace-file*
                     "~%~4T~AP: ~A~A~A"
                     (format-tab-or-depth tab depth)
                     (if pgs-pscm-id space "")
                     (if pgs-pscm-id " " "")
                     (format-trace-attributes space)))
 ;; state.
 (if state
        (soar-format *trace-file*
                     "~%~4T~AS: ~A~a~A"
                     (format-tab-or-depth tab depth)
                     (if pgs-pscm-id state "")
                     (if pgs-pscm-id " " "")
                     (format-trace-attributes state)) )
 ;; operators.                                      
 (if operator
        (soar-format *trace-file*
                     "~%~4T~AO: ~A~a~A"
                     (format-tab-or-depth tab depth)
                     (if pgs-pscm-id operator "")
                     (if pgs-pscm-id " " "")
                     (format-trace-attributes operator)) )
 T))

(defun goal-creation-report (count goal attribute impasse items supergoal depth)
 (declare (fixnum depth)  (type tme-object goal)
          (ignore count attribute impasse items supergoal))
  (cond ((= depth 0)
         ;; first goal.
         (soar-format *trace-file*
                     (if pgs-real-tab
                         "~%~D	 ~AG: ~A~A~A"  ;; real tab & spc in this line
                         "~%~D~4T~AG: ~A~A~A")
                      (1- (cycle-count 'quiet))
                      (format-tab-or-depth 0 depth)
                      (if pgs-pscm-id goal "")
                      (if pgs-pscm-id " " "")
                      (format-trace-attributes goal)))
        (T    
         (soar-format *trace-file*
                     (if pgs-real-tab
                         "~%~D	 ~A~aG: ~A~a~A"  ;; real tab & spc in this line
                         "~%~D~4T~A~aG: ~A~a~A")
                      (1- (cycle-count 'quiet))
                      (format-tab-or-depth (* pgs-tab-size (1- depth)) depth)
                      pgs-goal-leader
                      (if pgs-pscm-id goal "")
                      (if pgs-pscm-id " " "")
                      (format-trace-attributes goal)) ))
 T)

(eval-when (compile eval load) (proclaim '(ftype (function 
                     (fixnum tme-object gme-attribute gme-value)
                     true) context-installation-short-report))) 
(defun context-installation-short-report (count goal attribute value)
 (declare (type tme-object goal)
          (type gme-attribute attribute)
          (type gme-value value)
          (ignore count))
 (let ((depth (goal-depth goal)))
  (declare (fixnum depth))
  (soar-format *trace-file*
               (if pgs-real-tab
                   "~%~D	 ~A~A~A~A~A" ;; real tab & spc in this line
                   "~%~D~4T~A~A~A~A~A")
               (1- (cycle-count 'quiet))
               (format-tab-or-depth (* pgs-tab-size depth) depth)
               (case attribute
                  (problem-space "P: ")
                  (state "S: ")
                  (operator "O: "))
               (if pgs-pscm-id value "")
               (if pgs-pscm-id " " "")
               (format-trace-attributes value))
 T))


;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/utils.lisp".
;;; -*- Mode: soar; Package: sx; Syntax: common-lisp; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : utils.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jun 29 17:39:15 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Mar  4 16:50:24 1992
;;;; Update Count    : 42
;;;; Soar Version    : 5.1
;;;; 
;;;; PURPOSE
;;;; 	lisp utilities for the sx, taken from Ritter's larger utils file
;;;;   /afs/psy/usr/fr07/tools/lisp/utils.lisp
;;;; TABLE OF CONTENTS
;;;;	I.	get-sx-item
;;;;  (get-date (&optional (stream nil)))
;;;;  (no-op &optional &rest args) does nothing
;;;;  (no-op-t &optional &rest args) does nothing and returns t
;;;;  (whitespace-char-p achar) returns t iff achar is whitespace
;;;;  (round.to NUM GRAIN)
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (load eval compile)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(function get-sx-item (symbol symbol) kr:a-schema-or-nil))
  (proclaim '(function find-sx-object-by-name (string symbol) kr:a-schema-or-nil))
  (proclaim '(function strip-package (string) string))
 )

(defconstant *sx-utils-version* "1.0") 

(eval-when (load eval)
  (format t "; SX utils version ~a" *sx-utils-version*))


;;;
;;;	I.	get-sx-item
;;;

(defun get-sx-item (name type)  #-release-sx  
 "NAME is a symbol in another package, return the corresponding SX object."
  (declare (symbol name type))
  (let* ((old-pack *package*)
         result iresult)
    (in-package "SX")
    (setq result (symbol-name name))
    (setq iresult  (intern result))
    ;(format t "result ~s iresult ~s" result iresult)
    (setq result (cond ((boundp iresult) (eval iresult))
                       (t (find-sx-object-by-name result type))))
    (setq *package* old-pack)
    result))

(defun find-sx-object-by-name (astring type)
  (declare (string astring) (symbol type))
#-release-sx  "Look for sx item named ASTRING of type TYPE."
  ;; a desperate attempt by any measure
  ;; check each ps,  first itself, then its operators, then its states
  ;; type can be :problem-space, :operator, or :state
  ;; returns the first one it finds
  (let ((results nil)
        (pss (get-values *sx* :problem-spaces)) )
    (if pss
    (do ( (ps (pop pss) (pop pss)) )
        ((or results
             (and (null ps) (null pss)))
         results)
      (if (or (not type) (eq type :problem-space))
          (if (string-equal astring (g-value ps :name-string))
              (setq results ps)))
      (if (or (not type) (eq type :operator))
          (do* ( (ops (get-values ps :operators))
                 (op (pop ops) (pop ops)) )
               ((or results
                    (and (null ops) (null op))) )
            (if (and (not results)
                     (string-equal astring (g-value op :name-string)))
                (setq results op))))
      (if (or (not type) (eq type :state))
          (do* ( (states (get-values ps :states))
                 (state (pop states) (pop states)) )
               ((or results
                    (and (null states) (null state))) )
            (if (and (not results)
                     (string-equal astring (g-value state :name-string)))
                (setq results state))))
      ;; chunks should be covered directly by name calls above
      ;; goals don't have names
      )) ))

;(defun find-sx-object-by-name (astring)
;  (declare (string astring))
; "look for sx item by name" ; a desperate attempt by any measure
; (let ((results nil))
;   (yloop:yloop
;     (until results)
;     (lfor ps in (get-values *sx* :problem-spaces))
;     (ldo (if (string-equal astring (g-value ps :name-string))
;              (setq results ps))
;          (yloop:yloop
;             (until results)
;             (lfor op in (get-values ps :operators))
;             (ldo (if (and (not results)
;                           (string-equal astring (g-value op :name-string)))
;                      (setq results op))))
;          (yloop:yloop
;             (until results)
;             (lfor state in (get-values ps :states))
;             (ldo (if (and (not results)
;                           (string-equal astring (g-value state :name-string)))
;                      (setq results state))))
;          ;; chunks should be covered directly by name calls above
;          ;; goals don't have names
;    ))            
;   results))


;(defun doc-string (item &optional type)
; "returns the documentation for item, if available as a function, or
;as a variable"
; (if type  
;     (documentation item type))
;     (or (documentation item 'function)
;         (documentation item 'variable)
;         (documentation item 'structure)
;         (documentation item 'type)
;         (documentation item 'setf)))


(defmacro iHALF (N) #-release-sx "Divides N by 2.0" `(floor (/ ,N 2)))

;; returns time to do body in ms
(defmacro stop-watch (&rest body)
  `(let ((start (get-internal-real-time)))
        ,@ body
        (- (get-internal-real-time) start)))

(proclaim '(inline get-date))

(defun get-date (&optional (stream nil))
#-release-sx"Return a string worth printing as a date"
 (declare (stream stream))
 (multiple-value-bind (sec min hour date month year)
        (decode-universal-time (get-universal-time))
  (format stream "~a/~a/~a ~a:~a.~a" month date year hour min sec)))

(proclaim '(inline no-op))

(defun no-op (&optional &rest args) 
#-release-sx"Does nothing."
  (declare (ignore args))
  nil)

(proclaim '(inline no-op-t))

(defun no-op-t (&optional &rest args) 
#-release-sx  "Does nothing, returns t."
  (declare (ignore args))
  t)


;;;
;;;	iii.	sintern - symbol & string intern
;;;

(defun strip-package (string)
#-release-sx  "Strip the leading package off of string for symbol if necc."
  (declare (string string))
  (let ( (colon-pos (search ":" string)) )
    (if colon-pos
	(strip-package (subseq string (+ 1 colon-pos)))
	string)))

(eval-when (load eval compile)
  (proclaim '(inline strip-package)) )

(defmacro sintern (string-or-symbol &optional (package nil))
  (if package
   `(intern (strip-package
	     (string-upcase (if (stringp ,string-or-symbol) 
                                ,string-or-symbol
                                (format nil "~s" ,string-or-symbol))))
	    , package)
   `(intern (strip-package
	     (string-upcase (if (stringp ,string-or-symbol) 
                               ,string-or-symbol
                               (format nil "~s" ,string-or-symbol)))    ))))

;;(proclaim '(inline whitespace-char-p))

;; moved to garnet-loop 23-Jan-92 -FER
;(defun whitespace-char-p (achar)
;#-release-sx  "returns t if achar is whitespace"
;  (and (member achar *whitespace-chars* :test #'char=)
;       t))

(defmacro idivide (x y)
 `(floor (/ ,x ,y)))

;(defun round.to (NUM GRAIN)       ;(round.to 0.4 .01)
;    "Rounds num to the nearest grain size"
;    (* (round num grain) grain))   ;(round .4 .01)  


(defmacro round.to (NUM GRAIN)
#-release-sx  "Rounds num to the nearest grain size"
  `(* (round ,num ,grain) ,grain))

(defun query-string (prompt default)  #-release-sx
  "Read in a string with prompting w/ PROMPT and DEFAULT as the default value."
  (format t "~0&~a: [~a] " prompt default)
  (if (> (+ (length prompt) (length default)) 60)
      (format t "~%"))
  (let ((result (read-line)))
   (if (> (length result) 0) result default)))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/parameters.lisp".
;;;-*-mode: lisp; package: sx -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : parameters.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul  5 23:35:27 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Tue Feb  4 22:48:44 1992
;;;; Update Count    : 41
;;;; Soar Version    : 5.2
;;;; TAQL Version    : 3.1.3
;;;; 
;;;; PURPOSE
;;;;
;;;;     This file contains defparamters for the SX that affect such modules
;;;; as the command buttons, menus,
;;;; and the text windows. These paramters are placed here in a single file
;;;; so that they are more easily
;;;; accessible to users of sx. The parameters that these rely upon,
;;;; but which should not be changed by users are in sx.lisp.
;;;;
;;;; TABLE OF CONTENTS
;;;;     i.	Declarations & proclaims
;;;;	ii.	Variables that are site dependent
;;;;     I.	:SX feature
;;;;     II.	Parameters for all Windows
;;;;	III.	Not user parameters
;;;;
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares



;;;
;;;		i.	Declarations & proclaims
;;;

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(string *machine-display-name*
                     *sxl-directory*
                     *sx-directory*))
  (proclaim '(cons default-point))
  ;; (proclaim '(list soar-Hour-Glass-Windows))
  (proclaim '(type kr:logical
                      continuous-ms!
                      *default-ps-anchored*
                      menus-disappear-after-selection))
  (proclaim '(type display-or-nil *machine-display*))
  )


;;;
;;;	ii.	Variables that are site dependent
;;;

;; will change between sites
(defvar *sx-directory* "/afs/cs/project/soar/5.2/src/sx/new/"
  "*The directory where sx lives.")

(defparameter *sxl-directory* "/afs/cs/project/soar/5.2/src/sx/new"
  "*The sx local directory where users can load files with :sxl command
(no trialing /).")


;;;
;;;		I.	:SX features
;;;
;;; This feature is used to turn off and on the addition of the SX module.
;;; I'm not sure how standard the :XLIB feature currently is, I had to request
;;; it from our CMU lisp group, but they did say that they asked the CLX
;;; folks who added it into the specification for them.
;;; Remove this pushnew to turn off the SX.

(and (not (member :sx *features*))
     (pushnew :SX *features*))

(defvar *default-ps-anchored* t
  "When t (default), problem spaces come up anchored by default.")

(defparameter menus-disappear-after-selection nil
  "*If this is nil at startup (the default), the popup menu will stay up until
put away.")


;;;
;;;		II.	Parameters for all Windows
;;;

;;; should use x default thingy here

; Still needs work, assumes allegro is in unix env, kludey way to remove :0
; needs to cut :0 off
;                 (if colon-posn (setq display (subseq display 0 colon-posn)))
	;	  (or display (machine-instance))))

(defvar chunk-beep-on-fire nil
  "*When T (default nil), chunks beep when they fire.")

(defparameter continuous-ms! nil
  "*When T (default nil), continuous-ms is on.")

;; we actually use the value of this variable in tests for speed, but we don't
;; let users know that they can set it this way or encourage it if they ask;
;; setf'ing  it does not update the dialog box it's displayed in.

;(defparameter auto-scroll t
;  "*When T (default t), graphic display window will auto-scroll while running.
;The display is faster when it is nil.")


;;;
;;;	III.	Not user parameters
;;;

;; (defparameter soar-Hour-Glass-Windows nil
;;  "Windows that get an hourglass on when long computations are started.")

(defparameter default-point (cons 50 50)
#-release-sx"Used when you need a default point.")

(defvar *machine-display-name* ""
#-release-sx"The name of CLX display to open when sx is called.")
;; initialized in lisp-differences

(defvar *machine-display* nil ; -fer changed from open-display call
#-release-sx"The CLX display open at the moment on this machine.")
; set with (open-display *machine-display-name*) by create-sx -fer

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/variables.lisp".
;;;; -*- Mode: lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : variables.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Aug 13 13:18:21 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Tue Feb  4 16:51:38 1992
;;;; Update Count    : 19
;;;; Soar Version    : 5.2
;;;; Taql Version    : 3.1
;;;; 
;;;; PURPOSE
;;;; 	Most, if not all, variables in the Soar Graphical interface.
;;;; TABLE OF CONTENTS
;;;; 	I.  	Variables set for Garnet
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings;  proclaim vars funs; declares


(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(list *show-never-op-names*
                   *show-once-op-names*n))
  )


;;;
;;; 	I.  	Variables set for Garnet
;;;

; (setq kr::*warning-on-null-link* t)    ; this is awfully noisey
; (setq kr::*warning-on-circularity* t)    ; this is awfully noisey too

;; do type checking on window parts until demo?! speed needed
#-release-sx
(opal::type-check t)

;#+release-sx
;(opal::type-check nil)


;;;
;;;	II.	User variables
;;;

(defvar *show-never-op-names* nil
  "*A list of operator names as strings, that should never appear on the trace.")

(defvar *show-once-op-names* nil
  "*A list of operator names as strings, that should only appear once in a row,
e.g., perhaps wait.")


;;;
;;;	III.	variables set so there are no warnings
;;;

(defparameter GDW-POPUP-MENU-WINDOW nil)
;(defparameter LEARNING-WINDOW nil)

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/constants.lisp".
;;;; -*- Mode: lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : constants.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Aug 14 13:22:11 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Mar 11 16:15:18 1992
;;;; Update Count    : 81
;;;; Soar Version    : 5.2.1
;;;; Taql Version    : 3.1.4
;;;; 
;;;; PURPOSE
;;;; 	Constants that are used as messages to users, other constants.
;;;; TABLE OF CONTENTS
;;;;	I.	Plain constants
;;;; 	II.	Messages to users
;;;;    III.	Export all the symbols
;;;;	IV.	Other versions
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings; proclaims; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))


;;;
;;;	I.	Plain constants
;;;

(defconstant *sx-init-file-name* ".sx-init.lisp"
  "The name of the file searched for in the user's home directory at startup.
   NIL to discourage behavior.")

;;; graphic window constants

(defconstant left-soar-status-margin 5
  #-release-sx"left margin for soar-status-window")
(defconstant left-soar-status-margin2 15
  #-release-sx"left margin for soar-status-window")
(defconstant middle-soar-status-margin 125
  #-release-sx"middle margin for soar-status-window")
(defconstant status-x-buttons-top-margin 5
  #-release-sx"top of the taql-verbose button set.")

;; (defconstant tab "	")
;; (defconstant CR "
;; ")


;;;
;;;
;;;

(eval-when (eval compile load)
 (cond ( (find-package "MSG")
         (format t "~%; Found SX MSG package in sx/package.lisp ~%") )
       ( t  (make-package "MSG" ) )))

(eval-when (eval compile load)
 (in-package "MSG"))

; user also can use sx things...
(eval-when (eval compile load)
 (use-package "MSG" "USER")
 (use-package "MSG" "SX"))



;;;
;;; 	II.	Messages to users
;;;

;; SX REPL items and intro

(defconstant welcome-to-sx
    "; Starting sx...type :? for help, :quit or (quit-sx) to stop.")

(defconstant rewelcome-to-sx
    "; Restarting sx...type :? for help, :quit or (quit-sx) to stop.")

(defconstant *sx-prompt* "sx"
  #-release-sx
  "Prompt w/o brackets to display when running the sx repl.")

(defconstant goodbye-to-sx
  "Type (destroy-sx) to clean up the windows.
Type (sx) or <esc> sx to continue running."
  #-release-sx"Message that Sx prints when exiting.")

(defconstant dsi-help-comment
  "* For help on the SoarX display, see the manual available as 
hardcopy, or on-line (see below).

* For help on soar-mode,
type \"C-h m\" in soar-mode buffers in Emacs.

* For help on taql-mode,
type \"C-h f taql-mode\" in taql-mode buffers in Emacs.

* In general, on-line manuals are available in Emacs in
soar-mode buffers under the menu \"C-c C-m\",
in the \"Soar  Documentation\", or \"TAQL  Documentation\" sub-menus.
")


;;;
;;;  III.   Export all the symbols
;;;

(eval-when (eval compile load)
  (export '(welcome-to-sx
    rewelcome-to-sx
    *sx-prompt*
    goodbye-to-sx
    dsi-help-comment)))


;;;
;;;	IV.	Other versions
;;;

(eval-when (load eval compile)
  (in-package "SX"))

(defconstant *sx-version* "5.3.1")

(push :SX5.3 user::*features*)
(push :SX5.3.1 user::*features*)

;;; .1 started up based on brian milne's
;;; .2 moved to 5.2 directory, started stuffing garnet in
;;; 5.1.1 second attempt at OSU
;;  5.2 for steve Cross visit
;;; 5.3 release to SoarX

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/soar-loop.lisp".
;;; -*- Mode: lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; File            : soar-loop.lisp
;;; Author          : Frank Ritter
;;; Created On      : Fri Jul  5 15:03:54 1991
;;; Last Modified By: Frank Ritter
;;; Last Modified On: Thu Feb 27 17:12:52 1992
;;; Update Count    : 74
;;; 
;;; PURPOSE
;;;      Interface to the garnet read-eval-print loop used to make the
;;; SX command interpreter.
;;; TABLE OF CONTENTS
;;;	i.	Small variables & labels
;;;	I.	Command list
;;;     II.     Functions used in soar-loop
;;; 
;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares


(eval-when (load eval compile)
    (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(function quit-sx () nil))
  )


;;;
;;;	i.	Small variables & labels
;;;

(setf opal:grepl-supersystem-name "sci")

(setf opal:grepl-prompt-function 'sx::print-sx-prompt)

(setf opal:goodbye-to-grepl msg:goodbye-to-sx)

(setf opal:welcome-to-grepl msg:welcome-to-sx)

(setf opal:rewelcome-to-grepl msg:rewelcome-to-sx)

(setf opal:grepl-loading-directory user::*sxl-directory*)

(setf opal:grepl-loop-sleep-time .2)


;;;
;;;	I.	Command list
;;;
;;; This is best done within the opal package to get "item" bound correctly

(eval-when (load eval compile)
  (in-package "OPAL"))

;; this should be quasy sorted in order of likelihook, but doubful that this is
;; a big win.

(setq *grepl-conditions*   '(
  ((or (grepl-test :? ?)
       (grepl-test :help help))
   ":? (or ?) will give you a copy of this message as help."
   (print-grepl-help-message))
  ((or (grepl-test :quit quit)
       (grepl-test :stop stop)
       (grepl-test :q q))
  ":quit (or :q or :stop) will quit the loop.  Otherwise all errors are caught
   and return to garnet-loop at the top level rather than to the standard
   lisp read-eval-print loop."
   (sx:quit-sx))
  ;; in fact, all of the allegro keywords can be put here...
  ((grepl-test :pack pack)
 ":pack will set the package to the package corresponding to the string, atom, 
   or evaluated literal expression that it is passed as a second argument."
   (let* ((p1 (or (pop input)
                  (progn (if (not (listen *standard-input*))
                             (format t "Package to use: "))
                         (read *standard-input*))))
          (p2 (cond ((stringp p1) p1) 
                    ((listp p1) (eval p1)) ;quoted list or form
                    ((boundp p1) (eval p1))
                    (t p1))) )
     (push p2 grepl-history)
     (in-package p2)))
  ((numberp grepl-item) 
   "Any number runs that many macrocycles."
   (eval `(soar:macrocycle ,grepl-item)))
  ((grepl-test :init init)
   ":init will run init-soar."
   (soar:init-soar))
  ((or (grepl-test :update update)
       (grepl-test :up up))
   ":up or :update will update the windows."
   (sx::update-examiner-windows)
   (opal:update sx::graphic-display-window))
  ((grepl-test :m m)
   ":M (or m or (m)) will run 1 macro cycle."
   (soar:macrocycle))
  ((grepl-test :g g)
   "For *=G,P,S,O,  * (or :* or (next-* &optional N)) will run to the 
    next Goal, Problem-space, State, or Operator."
   (soar:next-g))
  ((grepl-test :p p)
   nil
   (soar:next-p))
  ((grepl-test :s s)
   nil
   (soar:next-s))
  ((grepl-test :o o)
    nil
   (soar:next-o))
  ((grepl-test :d d)
   ":d & d and :r & r will run 1 decision or elaboration cycle."
   (soar:d 1))
  ((grepl-test  :r r)
   nil ;no help string, covered above
   (soar:run 1))  
  ((grepl-test :cgd cgd)
   ":cgd will create (or recreate) the graphic display window."
   (sx:create-graphic-display))
  ((or (grepl-test :c cgd)
       (grepl-test :comma cgd))
   ":c toggles the reader syntax (shown in the prompt)
    between lisp syntax (:) and soar syntax (,)."
   (soar:toggle-soarsyntax))
  ((grepl-test :cms cms)
   ":cms toggles continuous match set being shown in an Emacs buffer."
   (sx:continuous-ms))
  ((grepl-test :e e)
    ":e (or e) will examine the selected object in the graphic display."
   (sx::popup-pscm-examiner
      (kr::g-value sx::*sx* :selected-items)))
  ((grepl-test :redo redo)
   ":redo will redo the last command."
    (setq grepl-item (pop opal:grepl-history))
    (do* ((tests *grepl-conditions*)
          (test (pop tests) (pop tests))  )
         ( (or (not test) (eval (car test)))
           (eval `(progn ,@(cddr test)))   ))
   )
  ((grepl-test :snap snap)
    ":snap will take a picture that can be printed."
   (sx:sx-snapshot nil))
  ;; this needs to be last
  ((grepl-test :sxl sxl)
   ":sxl will reload a file from the user::*sxl-directory*."
   ;; if its not a string, downcase it.
   (let ((file (cond (input (pop input))
                     (t (and (not (listen *standard-input*))
                             (format t "File to load (w/o extension & \"s): "))
                        (read)))))
     (if (stringp file) nil (setq file (string-downcase file)))
     (push file opal:grepl-history)
     (load (format nil "~a/~a" user::*sxl-directory*  file))
     (terpri)))
  ((keywordp grepl-item)
   ;; unmatched keywords get a petite help message, but this is not noted in
   ;; help that gets printed out.
   nil
   (format t "Type `:?' or `:help' for the list of commands."))
                             
;  (t "Anything else is evaluated and the result printed out."
;     (format t "~a" (cond ((listp grepl-item) (eval grepl-item))
;                          ((atom grepl-item)
;                           (if (boundp grepl-item)
;                               (eval grepl-item)
;                               (format nil "~s not bound" grepl-item))))))
))


;;;
;;;	II.	Functions used in soar-loop
;;;

(eval-when (load eval compile)
  (in-package "SX"))

(defvar sx-old-syntaxp (not (soarsyntaxp)))

(defun print-sx-prompt (&key (stream t) (newline nil))
 #-release-sx "Print out the sx-prompt."
 ;; key is required here I believe 19-Jan-92 -FER
 (declare (stream stream) (type kr:logical newline))
 (and newline (format stream "~%"))
 (if (and (eq sx-old-syntaxp (soarsyntaxp))
          (eq opal:old-grepl-package *package*)
          (string= opal:old-grepl-supersystem-name
                   opal:grepl-supersystem-name))
     nil
     (progn
       (setq opal:old-grepl-supersystem-name opal:grepl-supersystem-name)
       (setq opal:old-grepl-package *package*)
       (setq sx-old-syntaxp (soarsyntaxp))
       (setq opal:old-grepl-prompt
             (format nil "~%<~a~a~a> "
                     opal:grepl-supersystem-name
                     (if (soarsyntaxp) "," ":")
                     (string-downcase (package-name *package*)))  )))
 (format stream "~a" opal:old-grepl-prompt))

(defun quit-sx ()
  "Make the graphic display stop."
   (setq opal::*quit-grepl* t)
   (throw 'opal::exit-grepl t))

(setf (symbol-function 'sx-quit)
      (symbol-function 'quit-sx))


;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/lisp-differences.lisp".
;;;; -*- Mode: lisp; Package: SX -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : lisp-differences.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Feb  5 00:29:49 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Mar 11 18:05:19 1992
;;;; Update Count    : 32
;;;; Soar Version    : 5.2
;;;; TAQL Version    : 3.1.3
;;;; 
;;;; PURPOSE
;;;; 	Lisp functions that are well known to differ, e.g. save an image,
;;;; should be put here, and a separate dsi function called.
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	Declares and proclaims
;;;;	I.	*machine-display-name*
;;;;	II. 	soar-print-lisp-banner
;;;;	III.	soar-run-shell-command
;;;;	IV.	exit-lisp
;;;;	V.	load-lisp-init-file
;;;;	VI.	sx-gc
;;;;	VII.	load-lisp-init-file
;;;;	VIII.	sx-dump-image
;;;;	IX.	sx-chdir
;;;; 
;;;; (C) Copyright 1990, Frank Ritter, all rights reserved.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings; proclaim vars funs; declares


;;;
;;;	i.	Declares and proclaims
;;;

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(function soar-run-shell-command (string) nil))
  (proclaim '(function exit-lisp () nil))
  (proclaim '(function sx-gc () nil))
  (proclaim '(function host-name () string))
  (proclaim '(function attempt-to-load-lisp-init-file () string))
  (proclaim '(function sx-dump-image (string) nil))
  )
  


;; build-sx still has a lot of differences
;; garnet-changes has some too

;;;
;;;	I.	*machine-display-name*
;;;
(setq *machine-display-name*
          #-:allegro (machine-instance) ; should
          #+:allegro (string-trim ":0123456789"           ;used to be "unix"
                       (system:getenv "DISPLAY")))
; "The name of CLX display to open when sx is called."

;;;
;;;	II. 	soar-print-lisp-banner
;;;

(defun soar-print-lisp-banner (&optional (stream t))
   (declare (stream stream))
   #+allegro(format stream "~%;    Allegro ~a." excl::*common-lisp-version*)
   )

;;;
;;;	III.	soar-run-shell-command
;;;

(defun soar-run-shell-command (command)
  #-release-sx"Run a command in a shell for soar."
  #+allegro(excl:run-shell-command command)
  #-allegro(format t "Do not know how to run-shell-command for this lisp.")
  nil)

;;;
;;;	IV.	exit-lisp
;;;

(defun exit-lisp ()
  "Quit lisp, doesn't return."
  #+allegro(exit)
  #+lucid(quit)
  #+cmu(user::quit)
  (format t "Don't know how to exit this lisp.")
  )

;;;
;;;	V.	sx-gc
;;;

(defun sx-gc ()
  #-release-sx"Do a gc."
  #+allegro(excl:gc)
  #-allegro
  (format t "Don't know how to GC in this lisp.")
  )

;;;
;;;		Host-name
;;;

(defun host-name ()
  #+allegro
   (let* ((host-name (short-site-name))
          (dot-posn (position #\. host-name)))
      (when dot-posn
	(setq host-name (subseq host-name 0 dot-posn)))
      host-name)
)


;;;
;;;	VII.	load-lisp-init-file
;;;

(defun attempt-to-load-lisp-init-file () 
  #+allegro(load-soar-init-file ".clinit.cl")
  #+lucid(load-soar-init-file "lisp-init.lisp")
  nil)

;;;
;;;	VIII.	sx-dump-image
;;;

(defun sx-dump-image (image-name)
  #+allegro(excl:dumplisp :name image-name)
  #+lcl4.0(disksave image-name :full-gc t :verbose t)
  #-(or allegro lcl4.0)
    (format t "~%; Don't know how to dump an image in this lisp!")
    nil)

;;;
;;;	IX.	sx-chdir
;;;

;; (defun sx-chdir (directory)
;;   #+lucid(cd x)
;;   #+allegro(chdir x))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/bridge.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : bridge.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Mar  1 16:52:50 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Wed Nov 13 15:55:25 1991
;;;; Update Count    : 16
;;;; 
;;;; PURPOSE
;;;; 	This sets up communication protocols with gnu, when bridge.el 
;;;; is loaded.
;;;; TABLE OF CONTENTS
;;;; 	i.	Variables
;;;;
;;;;	I.	send-to-emacs
;;;;
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimized:  doc-strings; proclaims; declares

(eval-when (load eval compile)
  (in-package "SX")
  (soarresetsyntax))


;;;
;;; 	i.	Variables
;;;

(defconstant bridge-start-regexp ""
#-release-sx
  "Regular expression to match the start of a process bridge in
process output.  It should be followed by a buffer name, the data to
be sent and a bridge-end-regexp.")

(defconstant bridge-end-regexp ""
#-release-sx
  "Regular expression to match the end of a process bridge in process
output.")

;;;   
;;;	I.	send-to-emacs
;;;
;;; Assumes that soar is running in a gnu-emacs buffer.

(defmacro send-to-emacs (label &body body)
#-release-sx"Send a string to emacs."
 `(progn
    (princ bridge-start-regexp t)
    (format t "~a" ,label)
    ,@body
    (princ bridge-end-regexp t)))


;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/events.lisp".
;;;-*-mode: lisp; package: sx -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : events.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Jul  3 18:10:25 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:15:03 1992
;;;; Update Count    : 113
;;;; 
;;;; 
;;;; PURPOSE
;;;;	This file, events.lisp, implements an event handler for the SX
;;;;  in CLX that should run with little consing even on a standard (non lisp
;;;;  machine) architectures.
;;;; 	
;;;; HISTORY
;;;; 
;;;; TABLE OF CONTENTS
;;;;
;;;;	iii.	In-package
;;;;	iv.	Proclamations
;;;;	I.	unused
;;;;	II.	unused
;;;;	III.	unused
;;;;	IV.	unused
;;;;	V.	Sx-clear-events
;;;;    VI.     Sx-event-loop
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings; proclaims; declares


(eval-when (load eval compile)
  (in-package "SX")
  (soarresetsyntax))

;;;
;;;		iv.	Proclamations
;;;

(eval-when (load eval compile)
  (proclaim '(declaration values))
  (proclaim '(optimize (speed 3) (safety 0))))


;;;
;;;		I.	unused
;;;

;;;
;;;		II.	unused
;;;

;;;
;;;		III.	unused

;;;
;;;		IV.	unused
;;;


;;;
;;;		V.	Sx-clear-events
;;;
;;; Clear all the events off the queue, start with a clean slate.
;;; -fer 6/90  there has to be a better way....

;; Only version 3 is currently used.
;;
;
;(defun sx-clear-events ()
; "clear the event queue"
;  (if (xlib:event-listen *machine-display*)
;      (event-case (*machine-display* :discard-p t :force-output-p t
;				     :peek-p nil)
;        (exposure (window count)
;          (format t "clearing an expose event. ~%")
;          (process-event *machine-display* :handler 'no-op-t
;	                 :timeout 1 :discard-p t)
;          t)
;        (button-press (window code x y) 
;          (format t "clearing a bnp event. ~%")
;          (process-event *machine-display* :handler 'no-op-t
;                         :timeout 1 :discard-p t)
;          t)
;        (key-press (window code state)
;          (format t "clearing a kp event. ~%")
;          (process-event *machine-display* :handler 'no-op-t
;                         :timeout 1 :discard-p t)
;          t)	))
;  ;; you may have to recurse
;  (if (event-listen *machine-display*)
;      (sx-clear-events))
;)
;
;(defun sx-clear-events2 ()
; "clear the event queue, more advanced version"
; (cond ( (event-listen *machine-display*)
;         (format t "clearing an event. ~%")
;         (process-event *machine-display* :handler 'no-op-t
;	                 :timeout 1 :discard-p t)))
;  ;; you may have to recurse
;  (if (event-listen *machine-display*)
;      (sx-clear-events2))
;)

(eval-when (compile eval load)
  (proclaim '(ftype (function (&optional kr:a-schema-type) t) sx-clear-events3)))

(defun sx-clear-events3 (&optional window)
 #-release-sx"Clear the event queue, really more advanced version."
    (declare (type kr:a-schema-type window))
 (let ((display (if window
                    (opal::display-info-display (g-value window :display-info))
	            (let ((win1 (caar (opal::get-table-contents))))
		       (if win1
			   (xlib:window-display win1)
                           opal::*default-x-display*)))))
 (xlib:process-event
     display :timeout 0
     :handler #'(lambda (&key event-window a-window &allow-other-keys)
                  (declare (ignore event-window a-window))
		  t))
 (and (xlib:discard-current-event display)
      (sx-clear-events3)))
 t)


;;; 
;;;		VI.	Sx-event-and-lisp-loop 
;;;
;;;
;;;    This is an event loop that read lisp if it appears, and runs an
;;; event handler when x events appear.
;;;

;(defun sx-event-and-lisp-loop (&optional window)
;  "A loop that reads input and calls code to handle xevents
;when they happen."
;  (print-sx-prompt)
;  (let ((display (if window
;                     (opal::display-info-display (g-value window :display-info))
;                     (let ((win1 (caar (opal::get-table-contents))))
;                       (if win1
;                           (xlib:window-display win1)
;                           opal::*default-x-display*)))))
;  ;; gnu will buffer input for us, so that's cool, and event-listen
;  ;; tells us when there's an x-event.  If gnu is not there, a user
;  ;; is committed to typing something if he starts to.
;  (prog () start
;        (cond ( (listen *standard-input*) 
;                (garnet-lisp-repl) )
;              ( (event-listen display) 
;                (opal::default-event-handler display :timeout 0) )
;              ( t (sleep sx-event-and-lisp-loop-sleep-time) )      )
;        (go start))
;   ;; dump the event that made you quit?
;   (xlib:event-case (display :discard-p t :timeout 5) ; discard current event
;     (otherwise () t))))

(eval-when (compile eval load)
  (proclaim '(ftype (function (&optional kr:a-schema-type) t) check-sx-x-server)))

(defun check-sx-x-server (&optional window)
  #-release-sx
  "Check the x server, and do something iff it needs it."
    (declare (type kr:a-schema-type window))
  (let ((display (if window
                     (opal::display-info-display (g-value window :display-info))
		     (let ((win1 (caar (opal::get-table-contents))))
		       (if win1
			   (xlib:window-display win1)
                           opal::*default-x-display*)))))
  (if (event-listen display)
      (opal::default-event-handler display :timeout 0))
  )
  t)

;(defparameter sx-repl-history nil
; "currently the last thing the sx did")

;(defvar item nil "where the command keyword is stored?")

;(defun sx-repl (&optional input)
;  "read-eval-print-loop for sx that runs once per call"
;  (declare (special input)) ; necc for the evals below
;  ;; could do wspace reads all at once 
;  ;; when you get here you have input, but if just a whitespace, pitch
;  ;; it
;  ;; could use a smarter about errors, and not getting thrown past
;  ;; very shaky history item
;  (setq sx-repl-history (reverse sx-repl-history)) ;reverse up here for safty
;  (if (and (not input) (whitespace-char-p (peek-char nil *standard-input*)))
;      (read-char *standard-input*)  ;read some deadspace, else doit
;    (progv '(item) 
;            (list (or (pop input)
;                      (read *standard-input*)))
;      (if (not (eq item :redo))
;          (setq sx-repl-history (list item)))
;      (do* ((tests *sx-repl-conditions*)
;           (test (pop tests) (pop tests))  )
;          ( (or (not test) (eval (car test)))
;            (eval `(progn ,@(cdr test)))   ))
;     (if (not (eq item :redo))
;         (print-sx-prompt :stream t)))))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/simple-schemas.lisp".
;;;; -*- Mode: lisp; Package: SX -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : simple-schemas.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Feb 17 14:38:54 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:43:45 1992
;;;; Update Count    : 141
;;;; 
;;;; PURPOSE
;;;; 	Simple garnet schemas for use by multiple files.
;;;; TABLE OF CONTENTS
;;;;
;;;;	i.	fonts
;;;;	ii.	lines
;;;;	iii.	Soar priority level
;;;;
;;;;	I.	put-me-away-button
;;;;	II.	hot-text
;;;;	III.	SGd-error and calling code
;;;;	IV.	labeled box resource
;;;;	V.	sgd-choice-gadget
;;;;	VI.	graphic-display bits
;;;;	VII.	sx-triangle
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares


(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(type kr:a-schema-or-nil
                   font-fixed-bold-large
                   name-tag-font
                   big-title-font
                   line-6
                   put-me-away-button
                   sgd-Labeled-Box
                   sgd-Labeled-Box-window

                   static-LINE
                   sgd-error
                   sgd-Labeled-Box
                   sgd-Labeled-Box-window
                   sgd-choice-gadget
                   sgd-choice-gadget-window
                   name-tag
                   anchored-indicator
                   sx-impasse
                   impasse-line
                   pscm-examiner-scrolling-menu
                   sx-triangle ))
  (proclaim '(function dsi-query-using-labeled-box (string string) kr:logical))
  (proclaim '(type kr:a-schema-or-nil soar-priority-level))
  (proclaim '(special
                      font-fixed-bold-large
                      name-tag-font
                      big-title-font
                      line-6
                      put-me-away-button
                      sgd-Labeled-Box
                      sgd-Labeled-Box-window
                      static-LINE
                      sgd-error
                      sgd-choice-gadget
                      sgd-choice-gadget-window
                      name-tag
                      anchored-indicator
                      sx-impasse
                      impasse-line
                      pscm-examiner-scrolling-menu
                      sx-triangle ))
  )


;;;
;;;	i.	fonts
;;;

(create-instance 'font-fixed-bold-large opal:font
   (:family :fixed)
   (:face :bold)
   (:size :large))

;(create-instance 'font-fixed-bold-very-large opal:font
;   (:family :fixed)
;   (:face :bold)
;   (:size :very-large))

(defvar name-tag-font font-fixed-bold-large)
(defvar big-title-font font-fixed-bold-large)


;;;
;;;	ii.	lines
;;;

(create-instance 'static-LINE opal:line-style
  (:line-style :solid) ; :dash
  (:line-thickness 3) 
  (:dash-pattern '(4 1)))

(create-instance 'line-6 opal:line-style
  (:line-style :solid)
  (:line-thickness 6))

(defconstant cline-style opal:line-2 #-:release-sx"Style of connecting lines.")


;;;
;;;	iii.	Soar priority level
;;;

;; used to be called in graphic trace, but shouldn't now that
;; they apply to all windows...

;; (defun ADD-SOAR-PRIORITY-LEVEL ()
;;   (unless (member SOAR-PRIORITY-LEVEL inter:priority-level-list)
;;     (push (create-instance 'SOAR-PRIORITY-LEVEL inter:priority-level)
;; 	  inter:priority-level-list)))
;; (add-soar-priority-level)

;; this should save us a function 18-Jan-92 -FER
(eval-when (load eval)
 (push (create-instance 'SOAR-PRIORITY-LEVEL inter:priority-level)
       inter:priority-level-list))


;;;
;;;	I.	put-me-away-button
;;;

(create-instance 'put-me-away-button gg:text-button
    (:text-on-left-p nil)
    (:shadow-offset 0)
    (:window (o-formula (gvl :parent :window)))
    (:Final-feedback-p nil)
    (:font opal:font-fixed-bold-medium)    
    (:text-offset 4)
    (:gray-width 4)
    (:top (o-formula (- (gvl :window :height)
                 	(gvl :height))))
    (:left (o-formula (- (gvl :window :width)
                         (gvl :width))))
    (:continuous nil)
    (:string " OK ")
    (:interactors `(
       (:TEXT-BUTTON-PRESS :modify
          (:start-event (list :leftdown)))
       (:fast-ok-inter ,inter:button-interactor
          (:start-where t)
          (:active T)
          (:waiting-priority ,soar-PRIORITY-LEVEL)
          (:running-priority ,soar-PRIORITY-LEVEL)
          (:window ,(o-formula (gv-local :self :operates-on :window)))
          (:final-function
		,#'(lambda (gadget value)
                     (funcall (g-value gadget :operates-on :selection-function)
                              (g-value gadget :operates-on) value)))
          (:start-event #\RETURN)
          (:continuous nil)) ))
    (:parts '((:shadow :omit)
	      (:feedback-obj :omit)
	      :gray-outline 
	      :white-field :text))
    (:selection-function 
         #'(lambda (button points)
	     (let ((window (g-value button :window)))
	   (s-value window :visible nil)
	   (opal:update window)
	   (let ( (extra (g-value button :additional-action)) )
	     (if extra
		 (funcall extra button points))))  )))

;;;
;;;	II.	hot-text
;;;
(proclaim '(special sx-goal))

(create-instance 'hot-text opal:aggregadget
  (:title "Object")
  (:object)  ;this should be a sx-context-item
  (:font opal:default-font) ;name-tag-font
  (:top 5)
  (:left 5)
  (:parts `(
    (:cold-label ,opal:text
      (:string ,(o-formula (gvl :parent :title)))
      (:top ,(o-formula (gvl :parent :top) ))
      (:left ,(o-formula (gvl :parent :left))) )
    (:hot-object ,opal:text
      (:string ,(o-formula
		 (cond ( (not (gvl :parent :object)) "")
		       ( (is-a-p (gvl :parent :object) sx-goal)
                         (format nil "~a" (gvl :parent :object :id)) )
                       ( t
			 (format nil "~a (~a)"
                                 (gvl :parent :object :id)
                                 (gvl :parent :object :name-string))))))
       (:font ,opal:font-fixed-bold-medium)
       (:top ,(o-formula (gvl :parent :top) ))
       (:left ,(o-formula (+ (gvl :parent :cold-label :left) 6
			     (gvl :parent :cold-label :width))) ))    ))
   (:interactors `(
     (:jumper ,inter:button-interactor
       (:start-where ,(o-formula (list :in (gvl :operates-on :hot-object))))
       (:continuous nil)
       (:window ,(o-formula (gvl :operates-on :window)))
       (:final-function
	 ,#'(lambda (interactor points)
             (declare (ignore points))
              (popup-pscm-examiner-with-hour-glass
                 (g-value interactor :operates-on :object))))
))))


;;;
;;;	III.	SGd-error and calling code
;;;

(defconstant sgd-error-window-title "The DSI is talking to YOU!")

(create-instance 'sgd-error gg:error-gadget
    (:window-title sgd-error-window-title)
    (:really-modal-p t)
    (:font big-title-font)
)

(defconstant error-string-postfix "(press button or type CR to continue)")

(defun sgd-error (string window-title beep-p)
#-:release-sx  "Popup an error window for the graphic display."
  (declare (string string) (type (or string nil) window-title)
           (type kr:logical beep-p))
  (s-value sgd-error :window-title (or window-title
                                       sgd-error-window-title))
  (gg:display-error sgd-error
		    (format nil "~a~%~a" string error-string-postfix)
                    beep-p))


;;;
;;;	IV.	labeled box resource
;;;

;; (defparameter sgd-Labeled-Box NIL)
;; (defparameter sgd-Labeled-Box-window NIL)

(create-instance 'sgd-labeled-box-window inter:interactor-window
   (:width (o-formula (gvl :aggregate :components :window-width)))
   (:height (o-formula (gvl :aggregate :components :window-height)))
   (:top 35) (:left 200)
   (:title "Edit string and hit return when finished.")
   (:visible nil)
   (:aggregate  (create-instance 'sgd-labeled-box-top-agg opal:aggregate
	            (:overlapping NIL))) )

(create-instance 'sgd-labeled-box gg:Labeled-Box
   (:really-modal-p t)
   (:left 5) (:top 5))

(opal:add-components sgd-Labeled-Box-top-agg sgd-labeled-box)

(opal:update sgd-Labeled-Box-window)

(defun dsi-query-using-labeled-box (prompt default)
  (declare (string prompt default))
  (gg:query-with-labeled-box sgd-Labeled-Box prompt default))


;;;
;;;	V.	sgd-choice-gadget
;;;

;; (defparameter sgd-choice-gadget NIL)
;; (defparameter sgd-choice-gadget-window NIL)

(create-instance 'sgd-choice-gadget gg:choice-gadget
     (:window-title "Query from the DSI:")
     (:really-modal-p t)
     (:top 5) (:left 650))


;;;
;;;	VI.	graphic-display bits
;;;
;;;	relatively simple schemas
;;;

(create-instance 'name-tag opal:text
  (:string (o-formula (gvl :parent :traced-name-string)))
  (:visible (o-formula (gvl :parent :text-visible)))
  (:top (o-formula (gvl :parent :text-top) ))
  (:left (o-formula (gvl :parent :text-left)))
  (:fill-background-p t)
  (:font (o-formula (or (gvl :set-font) name-tag-font)))
)

(create-instance 'anchored-indicator opal:aggregadget
  (:string "*")
  (:visible (o-formula (gvl :parent :anchored)))
  (:left (o-formula (- (opal:gv-right (gvl :parent :graphic)) 12)))
  (:top (o-formula (- (opal:gv-bottom (gvl :parent :graphic)) 17)))
  (:parts `(
     (:tag ,opal:text
       (:string ,(o-formula (gvl :parent :string)))
       (:visible ,(o-formula (gvl :parent :visible)))
       (:font ,name-tag-font)
       (:top ,(o-formula (gvl :parent :top) ))
       (:left ,(o-formula (gvl :parent :left))) ))))
		 
;(proclaim '(special chunk-wall))
;(create-instance 'chunk-wall opal:line
;  ;; used but initially nil slots
;  ;; (:chunks)
;  (:row 1) ;for chunk rowing
;  (:line-style cline-style)
;  (:visible (o-formula
;               (and (gvl :parent :visible)
;                    (or (gv :self :parent :chunks) t) ;kludge to get line up
;                    (< 0 (length (get-values (gv :self :parent) :chunks))))))
;  (:point (o-formula (cons (gvl :x1) (gvl :y1))))
;  (:x1 (o-formula (+ (gvl :parent :graphic :left)
;                     (gvl :parent :graphic :size) ;a wee bit
;                     (idivide (gvl :parent :graphic :half-side) 2)  ;offset
;                     )))
;  (:y1 (o-formula (opal:gv-bottom (gvl :parent :graphic))))
;  (:x2 (o-formula (+ (gvl :x1) (gvl :parent :graphic :size))))
;  (:y2 (o-formula (gvl :y1)))    )


(create-instance 'impasse-line opal:line-style (:line-thickness 4))

(create-instance 'sx-impasse opal:line
 (:line-style impasse-line)
 (:visible (o-formula (and (gvl :parent :visible)
                           (gvl :parent :impasse-item))))
 (:point (o-formula (cons (gvl :x2) (gvl :y2)))) ;the bottom
     ;(:x1 (o-formula (+ 5 (gvl :parent :graphic :left)
     ;                     (gvl :parent :graphic :width))))
 (:x1 (o-formula (+ 5 (gvl :parent :impasse-item :graphic :left)
                      (gvl :parent :impasse-item :graphic :width))))
 (:y1 (o-formula (+ -5 (gvl :parent :impasse-item :graphic :top))))
 (:x2 (o-formula (gvl :x1)))
 (:y2 (o-formula (+ 5
                    (opal:gv-bottom (gvl :parent :impasse-item :graphic)))) ))



;;;
;;;	I.	Subschemas for ps-examiner
;;;

(create-instance 'pscm-examiner-scrolling-menu gg:scrolling-menu
  (:left 7)
  (:num-visible 6)
  (:page-trill-p nil)
  (:Multiple-p nil)
  (:Final-feedback-p nil)
  (:title-font opal:default-font)
  (:v-spacing 0)
  (:scroll-bar-on-left-p nil))


;;;
;;;	VII.	sx-triangle
;;;

;; triangles should be defined as pt of head,
;; and length of side, at least for now

(defparameter default-point (cons 49 50)
  #-release-sx
  "Used when you need a default point.")

(defconstant triangle-ratio 2.65)

(create-instance 'sx-triangle opal:polyline
    (:point default-point)
    (:size 50)     ;length of enclosing square
    (:half-side (o-formula (idivide (gvl :size) triangle-ratio)))
    (:line-style cline-style)
    (:point-list
        (o-formula
           (let* ( (start (gvl :point))   (size (gvl :size))
                   (x (car start))        (y (cdr start))
                   (half-size (gvl :half-side))    )
             (list x y                         ; start
                   (+ x size) (+ y half-size)  ; lower right
                   (+ x size) (- y half-size)  ; upper right
                   x y                         ; start again
             )))))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/graphic-display.lisp".
;;;; -*- Mode: Lisp; package: SX -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;
;;;; File            : graphic-display.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul 13 14:41:03 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:19:22 1992
;;;; Update Count    : 990
;;;; Soar Version    : 5.2.2
;;;; Taql Version    : 3.1.4
;;;;
;;;; PURPOSE
;;;; 	Provides a graphic display of the problem spaces as they run.
;;;; TABLE OF CONTENTs
;;;;
;;;;	i.  	Variables for graphic displaying
;;;;	ii.	Proclaims
;;;;
;;;;	I.	Create-graphic-display
;;;;	II.	graphic schemas
;;;;	III.	find-operator-problem-space
;;;;	IV.	Creating functions
;;;; 	V.	Cleanup functions
;;;;	VI.	blank
;;;;	N.	Final code
;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Optimizations:  doc-strings; declares; proclaims-vars, proclaims-fns

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))


;;;
;;;	i.  Variables for graphic tracing
;;;

(defconstant x-start-ps-location 80)
(defconstant x-delta-ps-location 180)
(defconstant x-max-ps-location 1200)
(defconstant y-start-ps-location 80)
(defconstant y-delta-ps-location 95)  ;; this should be principled....
(defconstant y-max-ps-location 1500)

(defparameter old-top-goal nil
  #-release-sx
   "Used to store the old top goal.")

#-nil
(defun compute-initial-problem-space-locations ()
  ;; make a list of where problem spaces will go.
  (do ( (col x-start-ps-location (+ col x-delta-ps-location))
	(locations nil) )
      ( (> col x-max-ps-location)      ;; end test & result
        (reverse locations))
    (do ( (row y-start-ps-location (+ row y-delta-ps-location)) )
      ( (> row y-max-ps-location) )	;; end test & result
      ;; (format t "~% doing ~s ~s" col row)
      (push (cons col row) locations))))

(eval-when (load eval compile) (proclaim '(list *ps-locations*)))
;; orginally made with compute-initial-problem-space-locations
(defvar *ps-locations*
  ;; (compute-initial-problem-space-locations)
  '((80 . 80)(80 . 175)(80 . 270)(80 . 365)(80 . 460)
    (80 . 555)(80 . 650)(80 . 745)(80 . 840)(80 . 935)
    (80 . 1030)(80 . 1125)(80 . 1220)(80 . 1315)(80 . 1410)
    (260 . 80)(260 . 175)(260 . 270)(260 . 365)(260 . 460)
    (260 . 555)(260 . 650)(260 . 745)(260 . 840)(260 . 935)
    (260 . 1030)(260 . 1125)(260 . 1220)(260 . 1315)(260 . 1410)
    (440 . 80)(440 . 175)(440 . 270)(440 . 365)(440 . 460)
    (440 . 555)(440 . 650)(440 . 745)(440 . 840)(440 . 935)
    (440 . 1030)(440 . 1125)(440 . 1220)(440 . 1315)(440 . 1410)
    (620 . 80)(620 . 175)(620 . 270)(620 . 365)(620 . 460)
    (620 . 555)(620 . 650)(620 . 745)(620 . 840)(620 . 935)
    (620 . 1030)(620 . 1125)(620 . 1220)(620 . 1315)(620 . 1410)
    (800 . 80)(800 . 175)(800 . 270)(800 . 365)(800 . 460)
    (800 . 555)(800 . 650)(800 . 745)(800 . 840)(800 . 935)
    (800 . 1030)(800 . 1125)(800 . 1220)(800 . 1315)(800 . 1410)
    (980 . 80)(980 . 175)(980 . 270)(980 . 365)(980 . 460)
    (980 . 555)(980 . 650)(980 . 745)(980 . 840)(980 . 935)
    (980 . 1030)  (980 . 1125)  (980 . 1220)  (980 . 1315)  (980 . 1410)
   (1160 . 80)   (1160 . 175)  (1160 . 270)  (1160 . 365)  (1160 . 460)
   (1160 . 555)  (1160 . 650)  (1160 . 745)  (1160 . 840)  (1160 . 935)
   (1160 . 1030) (1160 . 1125) (1160 . 1220) (1160 . 1315) (1160 . 1410))
  "Where the problem-spaces location template lives.")

(defparameter *top-goal* nil
  #-release-sx
  "The top most (initial) goal.")

(eval-when (load eval compile)
           (proclaim '(list copied-ps-locations)))

(defparameter copied-ps-locations *ps-locations*
  #-release-sx
  "Where the problem-spaces locations really live.")

(defvar initial-goal-location (first *ps-locations*)
  #-release-sx  
  "The intial goal gets put here, but immediately gets moved to where
   the first ps hangs out.")

(defconstant problem-space-size 90
  #-release-sx
  "Size of PS, length & width of square.")

(defconstant half-problem-space-size (idivide problem-space-size 2))
(defconstant quarter-problem-space-size (idivide problem-space-size 4))

(defconstant operator-diameter (idivide problem-space-size 7)
  #-release-sx
  "Operator size.")

(defconstant operator-radius (idivide operator-diameter 2)
  #-release-sx
  "1/2 operator size.")

;; if you want more or less line width, here's where you could set it.
;; cline stands for connecting-line

(defvar graphic-display-window nil
  #-release-sx
  "The graphic display big window.")

;; (defvar graphic-display-window-agg nil
;;  #-release-sx
;;  "Where the graphic display big window keeps its stuff")

(defparameter *sx-chunks* nil
  #-release-sx
  "Where the sx thinks chunks live.")


;;;
;;;	ii.	Proclaims
;;;

(eval-when (load eval compile)
  (proclaim '(special *top-goal*
                    graphic-display-window
                    graphic-display-inner-window
	            graphic-display-window-agg
                    gd-top-status-line
                    macrocycle-window  ; also proclaimed and defined later
	            gd-bottom-status-line))
  (proclaim '(type kr:a-schema-or-nil *top-goal* graphic-display-window
                    graphic-display-inner-window
	            graphic-display-window-agg
                    gd-top-status-line
                    macrocycle-window
	            gd-bottom-status-line))
  (proclaim '(cons initial-goal-location))
  (proclaim '(list *sx-chunks* copied-ps-locations))
  (proclaim '(function create-graphic-display () nil))
  (proclaim '(function create-graphic-display-top-status-line () nil))
  (proclaim '(function create-graphic-display-bottom-status-line () nil))
  (proclaim '(function clear-graphic-display () nil))
  (proclaim '(special Sx-Context-Item))
  (proclaim '(special sx-problem-space))
  (proclaim '(special sx-goal))
  (proclaim '(integer state-size))
  (proclaim '(special sx-state))
  (proclaim '(special sx-operator))
  (proclaim '(function find-operator-problem-space (symbol) kr:a-schema-type))
  (proclaim '(function op-name-in-ps-p (symbol kr:a-schema-type) kr:logical))
  (proclaim '(ftype (function (symbol symbol symbol) nil) add-context-item))
  (proclaim '(ftype (function (kr:a-schema-type) nil) do-auto-scroll))
  (proclaim '(function create-graphic-context-item
                       (integer kr:a-schema-type symbol symbol) kr:a-schema-type))
  (proclaim '(function find-or-create-goal (integer kr:a-schema-type symbol) kr:a-schema-type))
  (proclaim '(function get-goal-impasse-item (kr:a-schema-type symbol symbol) kr:a-schema-type))
  (proclaim '(function find-goal (kr:a-schema-type symbol) (or nil kr:a-schema-type)))
  (proclaim '(function create-initial-goal (integer symbol) kr:a-schema-type))
  (proclaim '(inline short-attribute-mapping))
  (proclaim '(inline short-impasse-mapping))
  (proclaim '(inline short-goal-type))
  (proclaim '(function find-or-create-problem-space
                       (integer kr:a-schema-type symbol) kr:a-schema-type))
  (proclaim '(inline wake-up-chunks))
  (proclaim '(function find-problem-space (symbol) (or nil kr:a-schema-type)))
  (proclaim '(function restart-examiner (kr:a-schema-type) nil))
  (proclaim '(function create-problem-space
                       (integer kr:a-schema-type symbol kr:logical) kr:a-schema-type))
  (proclaim '(function find-state (symbol) kr:a-schema-type))
  (proclaim '(function find-or-create-state (integer kr:a-schema-type symbol) kr:a-schema-type))
  (proclaim '(function find-or-make-operator (symbol integer) kr:a-schema-type))
  (proclaim '(function find-old-op (kr:a-schema-type kr:a-schema-type integer symbol) kr:a-schema-type))
  (proclaim '(function find-operator-in-ops (symbol list kr:logical) kr:a-schema-type))
  (proclaim '(function find-or-create-operator
                       (integer kr:a-schema-type symbol) kr:a-schema-type))
  (proclaim '(inline more-precise-count))
  (proclaim '(function make-context-object-name (integer symbol) string))
  (proclaim '(function creatable-operator (symbol) kr:logical))
  (proclaim '(function cleanup-display (kr:a-schema-type symbol) nil))
  (proclaim '(function cleanup-context-item (kr:a-schema-type) nil))
  (proclaim '(function cleanup-goal (kr:a-schema-type) nil))
  (proclaim '(function cleanup-problem-space (kr:a-schema-type) nil))
  (proclaim '(function cleanup-state (kr:a-schema-type) nil))
  (proclaim '(function hard-cleanup-state (kr:a-schema-type) nil))
  (proclaim '(function cleanup-examiner (kr:a-schema-type) nil))
  (proclaim '(function cleanup-operator (kr:a-schema-type) nil))
  (proclaim '(function hard-cleanup-operator (kr:a-schema-type) nil))
  (proclaim '(function compute-next-problem-space-location () cons))
  (proclaim '(function compute-next-goal-location (kr:a-schema-type) cons))
  (proclaim '(function context-object-trace-name
                     (kr:a-schema-type kr:logical) string))
  (proclaim '(special g1))
 )


;;;
;;;	I.  Create-graphic-display
;;;
;;; Please remember that the graphic-display-window is not a window, but
;;; an aggregadget.  Use graphic-display-inner-window as the window.
;;;

(defvar graphic-display-inner-window nil
  #-release-sx
  "The real pane of the graphic-display-window.")

(defun create-graphic-display ()
  "*Create a graphic display window for showing the problem space display."
 (format t "~%; Starting to create a graphic display window...")
 (if (and (boundp 'graphic-display-window) (schema-p graphic-display-window))
     (progn (s-value gdw-popup-menu-window :visible NIL)
            (opal:update gdw-popup-menu-window)
            (opal:destroy graphic-display-window)
            (setf opal:garnet-Hour-Glass-Windows
                  (delete graphic-display-inner-window
                          opal:garnet-Hour-Glass-Windows))))
 (create-instance 'graphic-display-window gg:scrolling-window-with-bars
                                        ;inter:interactor-window
    (:title (format nil "Soar Graphic Display ~a @ ~a"  *sx-version*
                    (host-name)))
    (:position-by-hand nil)
    (:height 350)
    (:width 452)
    (:total-width x-max-ps-location) ; call this 7 ps wide
    (:total-height y-max-ps-location) ;call this 13 deep, 91 total
    (:v-page-incr y-delta-ps-location) ; should be one ps size
    (:double-buffered-p opal:default-double-buffer-p)    )
 ;; necessary to get parts build right for later part building
 (opal:update graphic-display-window)
 (setq graphic-display-inner-window
       (g-value graphic-display-window :inner-window))
 (setq graphic-display-window-agg
       (g-value graphic-display-window :inner-aggregate))
 (s-value *sx* :graphic-display-inner-window graphic-display-inner-window)
 (s-value *SX* :SELECTED-ITEMS nil)
 (setq copied-ps-locations *ps-locations*)
 (create-graphic-display-top-status-line)
 (create-graphic-display-bottom-status-line)
 (setq *sx-chunks* nil)
 (opal:update graphic-display-window)
 (create-gdw-mover graphic-display-inner-window)
 (create-gdw-popup-menu)
 ;; now done on the load
 ;; (create-graphic-display-inters)
 (push graphic-display-inner-window opal:garnet-Hour-Glass-Windows)
 (init-soar)
 (setf old-top-goal nil)
 (format t "~%; Finished creating a graphic display.~%")
 nil)



(defun create-graphic-display-top-status-line ()
  #-release-sx
  "Create a status line which hangs out at the top."
 ;; it gets put on the front of the aggregadget, and it stays in front
 ;; as other things get loaded.
 ;; should also stay visible as scrolled
 (create-instance 'gd-top-status-line opal:aggregadget
   (:top (o-formula (- 2 (gv graphic-display-window :y-offset))))
   (:left (o-formula (- 10 (gv graphic-display-window :x-offset))))
   (:parts `(
     (:outline-box ,opal:rectangle
        (:top ,(o-formula (- (gvl :parent :top) 1 )))
        (:left ,(o-formula (- (gvl :parent :left)  3)))
        (:filling-style ,opal:white-fill)
        (:line-style ,cline-style)
        (:width ,(o-formula (+ 7 (gvl :parent :DC-count :width))))
        (:height ,(o-formula (+ 2 (gvl :parent :DC-count :height))))    )
     (:DC-count ,opal:text
        (:string ,(o-formula (format nil "DC:~d" (gv *sx* :decision-cycle))))
        (:top ,(o-formula (gvl :parent :top)))
        (:font ,name-tag-font)
        (:left ,(o-formula (gvl :parent :left))) ))))
 (opal:add-component graphic-display-window-agg gd-top-status-line
		     :where :front)
 nil)

(defun create-graphic-display-bottom-status-line ()
  #-release-sx
  "Create a status line which hangs out at the bottom."
 ;; it gets put on the front of the aggregadget, and it stays in front
 ;; as other things get loaded.
 ;; should also stay visible as scrolled
 (create-instance 'gd-bottom-status-line opal:aggregadget
   (:top (o-formula (- (gv graphic-display-window :outer-window :height)
                       (gvl :outline-box :height) 20 ;scroll height
		       (gv graphic-display-window :y-offset))))
   (:left (o-formula (- 10 (gv graphic-display-window :x-offset))))
   (:parts `(
     (:outline-box ,opal:rectangle
        (:top ,(o-formula (- (gvl :parent :top) 1 )))
        (:left ,(o-formula (- (gvl :parent :left)  3)))
        (:filling-style ,opal:white-fill)
        (:line-style ,cline-style)
        (:width ,(o-formula (+ 7 (gvl :parent :cycle-type :width))))
        (:height ,(o-formula (+ 2 (gvl :parent :cycle-type :height))))    )
     (:cycle-type ,opal:text
        (:string ,(o-formula (format nil "MC: ~d ~a (~d dcmax) ~a"
				     (gv *sx* :macrocycle-number)
				     (gv *sx* :macrocycle-type)
				     (gv *sx* :macrocycle-max-dc)
				     (if (gv *sx* :protocol-on)
					 "ProtcOn" ""))))
        (:top ,(o-formula (gvl :parent :top)))
        (:left ,(o-formula (gvl :parent :left))) )))
   (:interactors `(
     (:changer ,inter:button-interactor
       (:start-where ,(o-formula (list :in (gvl :operates-on :cycle-type))))
       (:continuous nil)
       (:window ,graphic-display-inner-window)
       (:final-function
	 ,#'(lambda (&rest rest)
                (declare (ignore rest))
	      (gg:popup-window macrocycle-window :pop-to-last-mouse nil))))))
   )
 (opal:add-component graphic-display-window-agg gd-bottom-status-line
		     :where :front)
 nil)

(defun clear-graphic-display ()
  #-release-sx"Clear the graphic-display window."
 ;; clearly not the right thing to do
 (if *sx* (clear-sx))
 (cond ( (and *top-goal* (not (destroy-p *top-goal*)))
         (cleanup-goal *top-goal*)
         (setq *top-goal* nil)))
 (update-examiner-windows)
 (if (and graphic-display-window-agg
	  (not (destroy-p graphic-display-window-agg)))
     (opal:update graphic-display-window))
 nil)

;;;
;;;	II.	graphic schemas
;;;

(create-instance 'sx-context-item opal:aggregadget
 ;; point is center left side, used to position items
 ;; initially nil items that are accessed
 ;; (:id nil) ; the soar id, e.g. S3
 ;; (:selected nil)    ;just created or to be acted on
 ;; (:anchored nil)     ; on clean up, don't hide if t
 ;; (:impass-goal nil) ; the goal that is the result of an impasse on you
 ;; (:subgoals ) ;goals that have been spawned off of this item
 ;; (:name-attribute nil)  ;; only used by states so far.  Holds the value of
                           ;; the name attribute, often nil
 (:pscm-counter 0)
 (:width   (o-formula (+ (gvl :graphic :width)
                         (gvl :name :width))))
 (:height   (o-formula (+ (gvl :graphic :height)
                          (gvl :name :height))))
 (:point default-point)
 (:text-visible t)
 (:size problem-space-size)
 (:half-size (o-formula (idivide (gvl :size) 2)))
 (:text-left (o-formula (car (gvl :point)) ))
 (:text-top (o-formula (- (gvl :graphic :top) 2))) ; smaller dither up
 (:name-string (o-formula (or (and (gvl :id)
				   (soar::context-object-name (gvl :id)))
                              "context-item")))
 ;; the name with traced attributes filled in
 (:traced-name-string (o-formula (or (and (gvl :id)
                                     (context-object-trace-name (gvl :id) nil))
                                     "traced-context-item")))
 (:parts `(
   (:name ,name-tag) )))

(create-instance 'sx-problem-space sx-context-item
  ;; these all get initially nil anyhow
  ;; (:goal)  ;the goal it belongs to
  ;; (:impasse-goal)  ;the goal it leads to
  ;; (:operators)
  ;; (:states)
  ;; (:chunks)
  ;; (:latest-operator nil)
  ;; (:latest-state nil)
  ;; (:latest-state-or-operator nil)
  ;; (:latest-chunk nil)
  ;;if tracing and if normally ephemoral, if it has a current goal
  (:width ;(+ 1 (* 2 (g-value sx-triangle :line-style :line-thickness))
          ;   problem-space-size)
          (o-formula (+ (gvl :graphic :width) 8
                        (gvl :name :width))))
  (:height (+ problem-space-size (g-value name-tag :height)))
  (:row 1) ;for chunk rowing
  (:visible (o-formula (and (gv *sx*  :graphic-display-problem-space)
                            (not (gvl :invisible))
                            (if (not (gvl :anchored))
                                (gvl :goal)
                                t))))
  (:text-visible (o-formula (if (gvl :visible)
				(gv *sx* :problem-space-id-visible))))
  (:text-left (o-formula (+ (opal:gv-right (gvl :graphic)) 8)))
  ;; the font has a lot of blank top & bottom, so move it around accordingly
  (:text-top (o-formula (- (gvl :graphic :top)
                           (idivide (gvl :name :height) 2))))

  (:parts `(
    ;(:chunk-wall ,chunk-wall)
    (:name ,name-tag
      (:string ,(o-formula (gvl :parent :traced-name-string)))
                 ;(progn (gvl :parent :goal) ;this forces a new name
                 ;       (cond ((context-object-name-p (gvl :parent :id))
                 ;              (problem-space-name
	        	;	   (gvl :parent :id)))
                 ;             (t (string-upcase ))))
      )
    (:graphic ,sx-triangle
       (:point ,(o-formula (gvl :parent :point)))
       ;could this be moved up to sx-context-item? -ecp
       (:filling-style ,(o-formula (if (gvl :parent :selected)
                                       opal:light-gray-fill
                                       opal:white-fill)))
       (:visible ,(o-formula (gvl :parent :visible)))
       (:size ,(o-formula (gvl :parent :size)))     )
   (:anchored-indicator ,anchored-indicator)  )))

(defconstant problem-space-height
  (* 2 (g-value sx-problem-space :graphic :half-side)))

(create-instance 'sx-goal sx-context-item
  ;; point is in the center of the circle
  ;; based on ps size
  ;; (:resolution-objects nil) PS or goals that have been selected to solve
                 ;; a goal
  ;; (:latest-problem-space nil)
  ;; (:latest-state nil)
  ;; (:latest-operator nil)
  ;; (:latest-context-item nil)
  ;; (:attribute nil) ; the item you impassed on
  ;; (:impasse nil) ; the type of impasse
  ;; (:cline nil)  ;line up to impasse context-item
  ;; (:goal nil)  ;; the goal above you
  ;; (:subgoal nil)    ;; the goal below you
  ;; (:short-type-string nil)
  ;; (:type-string nil) ;no longer used, uses :traced-name-string
  (:visible (o-formula (and *sx* (gv *sx*  :graphic-display-goal))))
  ;; width and height are so dependent on subfeatures, let garnet do it....
  (:width   (o-formula (+ (gvl :graphic :width)
                          (gvl :type-tag :width))))
  ;; this should be enough, but it's not, and garnet does not do it,
  ;; so try adding even more....
  (:height (+ 50 (* 2 operator-diameter) (g-value name-tag :height)))
  (:text-visible (o-formula (and *sx* (gv *sx* :goal-id-visible))))
  (:text-top (o-formula (+ 2 (gvl :graphic :top) )))
  (:text-left (o-formula (if (gvl :latest-problem-space)
                            (- (gvl :graphic :left) 4 (gvl :name :width))
                            (+ (gvl :graphic :left) 4 (gvl :graphic :width)))))
  (:type-text-top (o-formula
		   (if (gvl :latest-problem-space)
		       (+ (gvl :graphic :top) (gvl :name :height) 2)
		       (+ (gvl :graphic :top) (gvl :name :height) 2))))
  (:type-text-left (o-formula
         (if (gvl :latest-problem-space)
             (- (gvl :graphic :left) 4 (gvl :type-tag :width))
	     (- (gvl :graphic :left) 4 (idivide (gvl :type-tag :width) 3) ))))
  ;; this is a goal-diameter!
  (:size (* 2 operator-diameter))
  (:parts `(
   (:graphic-impasse ,sx-impasse)
   (:name ,name-tag (:string ,(o-formula (gvl :parent :name-string))) )
   (:graphic ,opal:circle
     (:visible ,(o-formula (gvl :parent :visible)))
     (:point ,(o-formula (gvl :parent :point)))
     (:line-style ,cline-style)
     (:filling-style ,(o-formula (if (gvl :parent :selected)
                                     opal:light-gray-fill
				     opal:white-fill)))
     (:top ,(o-formula (- (cdr (gvl :point))
                          (gvl :parent :half-size))))
     (:left ,(o-formula (- (car (gvl :point))
                           (gvl :parent :half-size))))
     (:width ,(* 2 operator-diameter))
     (:height ,(* 2 operator-diameter))
     ;(:width ,(o-formula (gvl :parent :size)))
     ;(:height ,(o-formula (gvl :parent :size)))
     )
   (:type-tag ,name-tag
      (:string ,(o-formula (if (gvl :parent :latest-problem-space)
                               (gvl :parent :short-type-string)
                               (gvl :parent :traced-name-string))))
      ;; type-tags are always visible
      (:visible t) ;,(o-formula (and t ;(or t; (gv *sx* :goal-id-visible)
		   ;                   (gvl :parent :selected))
                   ;                 (gvl :parent :visible)) )
      (:font ,(o-formula (if (or (gvl :parent :latest-problem-space)
                                 (gvl :parent :impasse-goal))
			     opal:default-font
			     name-tag-font)))
      (:top ,(o-formula (gvl :parent :type-text-top)))
      (:left ,(o-formula (+ 7 (gvl :parent :type-text-left))))
))))


(defparameter state-size (idivide (g-value sx-problem-space :size) 7))
(if (not (oddp state-size))
    (setf state-size (+ 1 state-size)))

(create-instance 'sx-state sx-context-item
  ;; point is center left
  ;; (:problem-space nil)
  (:visible (o-formula (and *sx* (gv *sx*  :graphic-display-state))))
  (:previous-state-or-operator nil)
  (:text-visible (o-formula (if (and *sx* (gv *sx* :state-id-visible))
                                (eq (gvl :problem-space :latest-state)
                                    (gv :self)))))
  (:previous-item (o-formula (or (gvl :previous-state-or-operator)
                                 (gvl :problem-space))))
  (:point ;; this should be made part of the state definition
          ;; "Where to put the next state."
 (o-formula
   (let* ((ops (gvl :problem-space :latest-operator))
          (states (gvl :previous-state-or-operator))
          (latest-state (eq (gvl :problem-space :latest-state)
                            (gv :self))))
    (cond ((and (not ops) (not states) latest-state) ;alone on front
           (cons (+ (car (gvl :problem-space :point))  operator-radius 3
                    operator-diameter)
                 (cdr (gvl :problem-space :point))))
          ;; you're the latest state w/ operator
          (latest-state
           (cons (- (car (gvl :problem-space :latest-state-or-operator :point))
                    operator-diameter)
                 (+ operator-radius -2 operator-diameter
                    (cdr (gvl :problem-space :point)))))
          (t ; you are a dead state
           (cons (- (car (gvl :previous-item :point))
                    operator-diameter)
                 (+ operator-radius -2 operator-diameter
                    (cdr (gvl :problem-space :point)))))
   ))))
  ;; slide the name over if it won't fit
  (:text-left (o-formula (gvl :graphic :left)))
  (:text-top (o-formula (+ (gvl :graphic :top)
			   (gvl :size))))
  (:size state-size)
  (:height (+ state-size (g-value name-tag :height)))
  (:parts `(
    (:graphic ,opal:rectangle
       (:top ,(o-formula (- (cdr (gvl :parent :point))
                            (gvl :parent :half-size))))
       (:left ,(o-formula (car (gvl :parent :point))))
       (:line-style ,cline-style)
       (:visible ,(o-formula (gvl :parent :visible)))
       (:filling-style ,(o-formula (if (gvl :parent :selected)
                                       opal:light-gray-fill
                                       opal:white-fill)))
       (:width ,state-size)
       (:height ,state-size)    )
   ;; taken out after a soar-video talk, don't really need this line
   ;; put back in to tie up to operator
   (:cline ,opal:line
       (:line-style ,cline-style)
       (:visible ,(o-formula (not (eq (gvl :parent :problem-space
                                           :latest-state-or-operator)
                                      (gvl :parent)))))
       (:x2 ,(o-formula (+ (car (gvl :parent :point))
                           (idivide state-size 2))))  ; self
       (:y2 ,(o-formula (gvl :parent :graphic :top)))
       (:y1 ,(o-formula                               ; operator
               (let ((p-item (gvl :parent :problem-space
                                  :latest-state-or-operator)))
                  (+ (gv p-item :graphic :top)
                     operator-diameter))))
;       (:y1 ,(o-formula                               ; operator
;               (let ((p-item (or (gvl :parent :problem-space
;                                  :latest-state-or-operator)
;                                 (gvl :parent :previous-item)
;                                 (gvl :parent :previous-state-or-operator))))
;                  (+ (gv p-item :graphic :top)
;                     operator-diameter))))
       (:x1 ,(o-formula (+ operator-diameter (gvl :x2))))
       ;; old code
       ;(:x2 ,(o-formula (+ (car (gvl :parent :point)) 1)))  ; self
       ;(:y2 ,(o-formula (cdr (gvl :parent :point))))
       ;(:x1 ,(o-formula                               ; previous
       ;        (let ((p-item (gvl :parent :previous-item)))
       ;          (+ (car (gv p-item :point))
       ;             (if (or (is-a-p p-item sx-operator)
       ;                     (is-a-p p-item sx-state))
       ;                 (gv p-item :size)
       ;                0)))))
       ;(:y1 ,(o-formula (cdr (gvl :parent :previous-item :point))))
 ))))

(create-instance 'sx-operator sx-context-item
  ;; point is center left
  (:visible (o-formula (and *sx* (gv *sx*  :graphic-display-operator))))
  ;; name is visible as long as its the latest operator in that ps
  (:text-visible
   (o-formula
      (if (and *sx* (gv *sx* :operator-id-visible))
          (or (gvl :selected)
              (and (not (member (gv *sx* :selected-items)
                                (gvs (gvl :problem-space) :operators)))
                   (eq (gvl :problem-space :latest-operator)
                       (gv :self)))   ))))
  ;; (:problem-space nil)
  ;; (:previous-state-or-operator nil)
  ;; cycle when operator was created
  (:cycle-number 0)
  (:previous-item sx-problem-space)
  ;; slide the name over if it won't fit
  (:point (o-formula
   (let* ( (object (gvl :previous-item))
           (starting-point (gv object :point)))
   (cond ( (eq sx-problem-space (gv object :is-a))
           ;; this starts out not quite another operator in
           ;(format t "got ~s ~s" object starting-point)
           (cons (+ (car starting-point) operator-radius 
                    operator-diameter 1 operator-diameter)
                 (cdr starting-point)))
         (t ;(format t "got2 ~s ~s" object starting-point)
           (cons (+ (car starting-point)  operator-radius -2
                     operator-diameter)
                  (cdr starting-point)))         ))))
  (:text-left (o-formula (gvl :graphic :left)))
  (:text-top (o-formula (- (gvl :graphic :top)
			   (gvl :name :height) 3)))
  ;; size is a diameter
  (:size operator-diameter)
  (:height (+ operator-diameter (g-value name-tag :height)))
  (:parts `(
   (:graphic ,opal:circle
       (:point ,(o-formula (gvl :parent :point)))
       (:filling-style ,(o-formula (if (gvl :parent :selected)
                                       opal:light-gray-fill
                                       opal:white-fill)))
       (:line-style ,cline-style)
       (:visible ,(o-formula (gvl :parent :visible)))
       (:size ,(o-formula (gvl :parent :size)))
       (:top ,(o-formula (- (cdr (gvl :point)) (gvl :parent :half-size))))
       (:left ,(o-formula (car (gvl :point))))
       ;(:width ,(o-formula (gvl :parent :size)))
       ;(:height ,(o-formula (gvl :parent :size)))
       (:width ,operator-diameter)
       (:height ,operator-diameter)
      )
   (:cline ,opal:line
       (:line-style ,cline-style)
       (:visible ,(o-formula (not (eq (gvl :parent :problem-space)
                                      (gvl :parent :previous-item)))))
       (:x2 ,(o-formula (+ 1 (car (gvl :parent :point)))))  ; self
       (:y2 ,(o-formula (cdr (gvl :parent :point))))
       (:x1 ,(o-formula                               ; previous
               (let ((p-item (gvl :parent :previous-item)))
                 (+ (car (gv p-item :point))
                    (if (or (is-a-p p-item sx-operator)
                            (is-a-p p-item sx-state))
                        (gv p-item :size)
                        0)))))
       (:y1 ,(o-formula (cdr (gvl :parent :previous-item :point)))) )
)))


;;;
;;;	III.	find-operator-problem-space
;;;


;; not possible in plain soar, should stay in DSI
(defun find-operator-problem-space (op-name)
  #-release-sx
  "Find the best (top-most?) problem-space for op-id."
  (declare (symbol op-name))
 ;; quick kludge, take the latest
 (do* ( (pss (kr::get-values sx::*sx* :problem-spaces))
        (ps (pop pss) (pop pss))
        (results nil) )
    ( (or results (not ps))
     (let ((latest-ps (kr::g-value sx::*sx* :latest-problem-space)) )
      (or results (if latest-ps (kr::g-value latest-ps :id))) ))
   (if (and ps (op-name-in-ps-p op-name ps))
       (setq results (g-value ps :id))) ))

;; this is just DSI
(defun op-name-in-ps-p (op-name ps)
  ;; #-release-sx "Is OP-NAME one of PS's operators?"
 (declare (symbol op-name) (type KR:A-SCHEMA-TYPE ps))
 (let ( (ops (kr::get-values ps :operators))
        (results nil)
        (name (format nil "~a" op-name)) )
 (do* ( (op (pop ops) (pop ops))  )
   ((or results
	(and (not ops) (not op)))
    results)
   (if (string-equal name (kr::g-value op :name-string))
       (setq results t)) )))


;;;
;;;	IV.	Creating functions
;;;

(defun add-context-item (goal-name attribute value)
  ;; #-release-sx
  ;; "Add a context item to the *sx*, and do what needs done."
  (declare (symbol goal-name attribute value))
 (let ( (count (g-value *sx* :decision-cycle))
       new-context visiblep)
 ;; assuming we have an *sx*
 (if (not (g-value *sx* :latest-context-item))
     (setq new-context (create-initial-goal count value))
     (let* ( (goal (cond ((eq attribute 'goal)
                          (eval (sintern (soar:attribute-value value 'object)
                                         (find-package "SX"))))
                         (t (eval (sintern goal-name (find-package "SX"))))))
             (old-selected (g-value *sx* :selected-items)))
       (setf new-context (create-graphic-context-item count
                                   goal attribute value))
       (setf visiblep (g-value new-context :visible))
       ;(format t "~% ~s ~s ~s" visiblep old-selected new-context)
       (cond (visiblep
              (if old-selected (s-value old-selected :selected nil))
              (s-value *sx* :latest-context-item new-context)
	      (s-value *sx* :selected-items new-context)
              (s-value new-context :selected t) ))
       (set (sintern value (find-package "SX")) new-context)
       (if (not (member new-context
                        (get-values graphic-display-window-agg :components)))
           (opal:add-component graphic-display-window-agg new-context 
                               :behind gd-top-status-line)
           (opal:move-component graphic-display-window-agg new-context
                               :behind gd-top-status-line))))
 (s-value new-context :pscm-counter (1+ (g-value new-context :pscm-counter)))
 (if (g-value *sx* :auto-scroll) (do-auto-scroll new-context))
 (opal:update graphic-display-window)
 nil))

(defun set-auto-scroll (&optional (value 'no-value))
  (declare (type kr:logical value))
  (cond ((eq value 'no-value))
        ((or (eq t value) (eq nil value))
         (s-value  *sx* :auto-scroll value)
         (opal:update soar-status-window))
        (t (format t "SX error.  Usage:  (set-auto-scroll [t | nil])")))
  (g-value *sx* :auto-scroll))

(defun set-always-update (&optional (value 'no-value))
  (declare (type kr:logical value))
  (cond ((eq value 'no-value))
        ((or (eq t value) (eq nil value))
         (s-value  *sx* :update-live-windows-always value)
         (opal:update soar-status-window))
        (t (format t "SX error.  Usage:  (set-always-update [t | nil])")))
  (g-value *sx* :update-live-windows-always))

;; this can be cleaned up some, inner-top, 
;; by referencing to the objects graphic object, we don't scroll on names

(defun do-auto-scroll (object)
  (declare (type kr:a-schema-type object))
 (let* ((inner-top (- (g-value graphic-display-window :y-offset)))
        (display-height (g-value graphic-display-window :inner-height))
        (display-width (g-value graphic-display-window :inner-width))        
        (inner-bottom (+ inner-top display-height))
        (inner-left (- (g-value graphic-display-window :x-offset)))
        (inner-right (+ inner-left display-width))
        (object-top (g-value object :graphic :top))
        (object-bottom (+ object-top (g-value object :graphic :height)))
        (object-left (g-value object :graphic :left))
        (object-right (+ object-left (g-value object :graphic :width)))
        y-offset x-offset )
;; (format t "~% inner-top: ~s inner-bott: ~s object-top: ~s object-bott: ~s"
;;         inner-top      inner-bottom     object-top object-bottom )
 (cond ((< inner-bottom object-bottom) ;you are too low(toward screen bottom)
        ;; scroll so new object is at bottom of display
        (setf y-offset (- (round.to (+ 100 (- object-top display-height))
                                    y-delta-ps-location))) )
       ((< object-top inner-top) ;you are too high
        (setf y-offset (min 0
                            (- (round.to (+ 100 (- object-top display-height))
                                    y-delta-ps-location))))))
 (cond ( (< object-left inner-left) ;you are too left
         (setf x-offset (- (round.to ;(- object-left 50)
                                     (+ 100 (- object-left display-width))
                                     x-delta-ps-location))))
       ( (< inner-right object-right) ;you are too right
         (setf x-offset (- (round.to ;(- object-left 50)
                                     (+ 100 (- object-left display-width))
                                     x-delta-ps-location)))) )
 (if (or y-offset x-offset)
     (scroll-win-to graphic-display-window
       (max (- display-width)
            (min 0 (or x-offset (g-value graphic-display-window :x-offset))))
       (max (- display-height)
            (min 0 (or y-offset (g-value graphic-display-window :y-offset))))))
 nil))


(defun create-graphic-context-item (count goal attribute value)
  #-release-sx "Create a context item schema."
  (declare (integer count) (type kr:a-schema-type goal) (symbol attribute value))
 (cond ((eq attribute 'operator)
        (if (creatable-operator value)
            (find-or-create-operator count goal value)))
       ((eq attribute 'state)
        (find-or-create-state count goal value))
       ((eq attribute 'goal)
        (find-or-create-goal count goal value))
       ((eq attribute 'problem-space)
        (find-or-create-problem-space count goal value))))


(defun find-or-create-goal (count goal value)
 (declare (integer count) (type kr:a-schema-type goal) (symbol value))
 ;; this should probably come later, after you know what to clean up
 (cleanup-display goal 'goal)
 (let* ((attribute (soar:attribute-value value 'user::attribute))
        (impasse-type (soar:attribute-value value 'user::impasse))
        (impasse-item (get-goal-impasse-item attribute impasse-type))
        (old-goal (find-goal impasse-item impasse-type))
        result line prev-ps)
 ;; create the goal
 (setq result
      (if old-goal
          old-goal
	  (let ((result
                (create-instance (make-context-object-name count value) sx-goal
                                  )) )
	    (setq line
               (create-instance nil opal:line
                  (:line-style cline-style)
		  (:x2 (o-formula (car (gv result :point))))
                  (:y2 (o-formula (cdr (gv result :point))))
		  (:x1 (o-formula (opal:gv-right
                                   (gv result :impasse-item :graphic))))
                                  ;(+ (car (gv result :previous-item :point))
                                  ;   (gv result :previous-item
                                  ;       :graphic :width))
                  (:y1 (o-formula (cdr (gv result :impasse-item :point))))))
             (s-value result :cline line)
	     (append-value *sx* :goals result)
             result)))
  (s-value result :name-string (soar:context-object-name value))
  (s-value result :traced-name-string (context-object-trace-name value nil))
  (s-value result :goal goal)
  (s-value result :id value)
  (s-value result :attribute attribute)
  (s-value result :impasse (soar:attribute-value value 'user::impasse))
  ;; set up a back pointer (there will always be an impasse item)
  (setf prev-ps (g-value impasse-item :problem-space))
  (if prev-ps (s-value prev-ps :impasse-goal result))
  (s-value result :short-type-string (short-goal-type attribute impasse-type))
  (s-value result :point (compute-next-goal-location goal))
  ;; tie it back up with a line to what it came from
  (setf line (g-value result :cline))

  (opal:add-component graphic-display-window-agg line
	:behind gd-top-status-line)
  ;; set up pointers back for pscm-tracing
  (s-value goal :subgoal result)
  (s-value result :impasse-item impasse-item)
  (if (and (eq 'goal attribute)
           (not (member result (get-values goal :resolution-objects))))
      (append-value impasse-item :resolution-objects result))
  (if (and (not (eq 'goal attribute))
           (not (member result (get-values impasse-item :subgoals))))
      (append-value impasse-item :subgoals result))
  (s-value impasse-item  :impasse-goal result)
  (s-value *sx* :latest-goal result)
  result))
 ;previous value of prev-item (or (g-value *sx*  :latest-context-item) result)


(defun get-goal-impasse-item (;;agoal
                              attribute impasse-type)
 #-release-sx"The item that that goal should tie to."
 (declare ;(type kr:a-schema-type agoal)
          (symbol attribute impasse-type))
  ;; don't know why this was here 27-Nov-91 -FER
  ;(if (and (eq impasse-type 'no-change)
  ;         (eq attribute 'goal))
  ;    (cleanup-problem-space (g-value agoal :goal :latest-problem-space)))
  (if (eq impasse-type 'no-change)
      (case attribute
     ;; (operator (g-value agoal :goal :latest-problem-space :latest-operator))
     ;; (problem-space (g-value agoal :goal :latest-problem-space))
     ;; (state (g-value agoal :goal :latest-problem-space :latest-state))
     ;; (goal (g-value agoal :goal))
        ;; now called earlier in the creation
        (operator (g-value *sx* :latest-operator))
        (problem-space (g-value *sx* :latest-problem-space))
        (state (g-value *sx* :latest-state))
        (goal (g-value *sx*  :latest-goal))
        (otherwise 'dontknowin-g-g-p-i))
      ;; else a tie
      (case attribute
     ;;   (operator (g-value agoal :goal :latest-problem-space :latest-state))
     ;;   (problem-space (g-value agoal :goal))
     ;;   (state (g-value agoal :goal :latest-problem-space))
     ;;   (goal (g-value agoal :goal))
        (operator (g-value *sx* :latest-state))
        (state (g-value *sx* :latest-problem-space))
        (problem-space (g-value *sx* :latest-goal))
        (goal (g-value *sx* :latest-goal))
        (otherwise 'dontknowin-g-g-p-i2))))

(defun find-goal (impasse-item impasse-type)
  #-release-sx "Find an old goal that you can use based on impasse item."
  (declare (symbol value))
  (let ((old-goals (get-values impasse-item :subgoals)))
    (do ( (results nil)
	  (goal (pop old-goals) (pop old-goals)) )
	((or results
	     (and (null old-goals) (null goal)))
	 results)
      (cond ( (and goal		;may be nil
		   (equal impasse-type (g-value goal :impasse))
		   (not (g-value goal :goal)))
	     (setq results goal)
             (restart-examiner goal))))))

(defun create-initial-goal (count value)
  (declare (ignore count) (symbol value))
  ;; Create the goal assuming it will be identified "G1".
  (let ( (result (or old-top-goal

 (let ((topgoal (create-instance
                        (make-context-object-name 0 'user::g1)
                         sx-goal
                         (:id 'user::g1)
                         (:point initial-goal-location)
                         (:traced-name-string "*top-goal*")
                         (:short-type-string "*top-goal*") )))
     (setq old-top-goal topgoal)
     (setq g1 topgoal)
     (append-value *sx* :goals topgoal)
     (s-value topgoal :name-string "G1")
     topgoal)))

         (old-selected (g-value *sx* :selected-items)))
  (s-value result :traced-name-string
           (context-object-trace-name value nil))
  (s-value result :selected t)
  (if old-selected (s-value old-selected :selected nil))
  ;; not possible to tie it back up to what it came from
  ;; set up pointers back, to itself in this case
  (setq *top-goal* result)
  (s-value *sx* :latest-goal result)
  (s-value *sx* :latest-context-item result)
  (s-value *sx* :selected-items result)
  ;; this is not done by a higher level like all other items
  (opal:add-component graphic-display-window-agg result 
                      :behind gd-top-status-line)
  result))

; dead-code 11-Nov-91 -FER
;(defun goal-type (value)
;  #-release-sx
;  "Return a string describing the type of VALUE"
;  (let ((attribute (g-value item :attribute))
;        (impasse (g-value item :impasse) ) )
;  (cond ((or attribute impasse)
;         (format nil "~a ~a" attribute impasse) )
;        (t "*top-goal*"))))

(defun short-attribute-mapping (attribute)
   (declare (symbol attribute))
  (case attribute
    (operator 'op)
    (problem-space 'ps)
    (state 'S)
    (goal 'g)
    (otherwise 'dontknow)))

(defun short-impasse-mapping (attribute)
     (declare (symbol attribute))
  (case attribute
    (no-change 'NC)
    (tie 'TIE)
    (constraint-failure 'CF)
    (conflict 'Conf)
    (otherwise 'dontknow)))

(defun short-goal-type (attribute impasse-type)
  #-release-sx
  "Return a short string describing the type of VALUE."
  (declare (symbol attribute type))
  (cond ((or attribute impasse-type)
         (format nil "~a ~a" (short-attribute-mapping attribute)
                 (short-impasse-mapping impasse-type)) )
        (t "*topG*")))

(defun find-or-create-problem-space (count goal value)
  #-release-sx  "Find a ps or create it."
  (declare (integer count) (type kr:a-schema-type goal) (symbol value))
 (if goal (cleanup-display goal 'problem-space))
 (let* ((old-space (find-problem-space value))
        chunks
        (result nil) )
   (setq result
        (if old-space
            old-space
            (create-problem-space count goal value
				  *default-ps-anchored*)))
   (if (not (g-local-value result :point))
       ;; give it a new location
       (s-value result :point 
                (compute-next-problem-space-location)))  ;goal value
   (s-value result :traced-name-string
           (context-object-trace-name value t))
   (s-value *sx* :latest-problem-space result)
   (s-value goal :latest-problem-space result)
   (if (not (member result (get-values goal :resolution-objects)))
       (append-value goal :resolution-objects result))
   (s-value result :goal goal)
   (s-value result :id value)
   (if (g-value result :visible) (s-value goal :point (g-value result :point)))
   (setq chunks (get-values result :chunks))
   (if chunks (wake-up-chunks chunks))
   result))

(defun wake-up-chunks (chunks)
  (declare (list chunks))
  (mapc #'(lambda(x) (mark-as-changed x :visible) )
    chunks))

;; (context-object-trace-name value)
;; gets called twice on starting up a new ps
(defun find-problem-space (value)
  #-release-sx  "Find an old problem-space that you can use."
 (declare (symbol value))
 ;; passing name in would save a call sometimes
 (let ( (name (soar::context-object-name value))
        (old-spaces (get-values *sx* :problem-spaces))  )
   (do ( (space (pop old-spaces) (pop old-spaces))
         (results nil) )
       ((or results
	    (and (null old-spaces) (null space)))
	 results)
    (cond ( (and space		;may be nil
	         (string-equal name (g-value space :name-string))
		 (not (g-value space :goal)))
	    (setq results space)
            (restart-examiner space)  )))    ))

(defun restart-examiner (pscm-object)
  (declare (type kr:a-schema-type pscm-object))
  (let ( (examiner (g-value pscm-object :examiner)) )
    (if examiner
        (progn
          (recompute-formula (g-value EXAMINER :dead-head) :visible)
          ;; the old scheme was to put them on and off the list, but
          ;; this is too hard to do, and doesn't save time (I, fer, think)
          ;(append-value *sx* :examiners examiner)
          ;(append-value *sx* :examiner-windows
          ;              (g-value examiner :window))
          )))
  nil)


(defun create-problem-space (count goal name anchored)
    (declare (integer count) (symbol name anchored)
             (type kr:a-schema-type goal))
  (let* (result
         (name-string (soar::context-object-name name) )        )
  (setq result
    (create-instance (make-context-object-name count name) sx-problem-space
      (:goal goal)
      (:anchored anchored)
      (:name-string name-string)))
  (append-value *sx* :problem-spaces result)
  (if goal (s-value goal :latest-context-item result))
  result))


;; this may be upsurping trace-attributes
;; dead code as of 9/91, replaced by traced-name-string
;(defun problem-space-name (value)
;  #-release-sx
;  "Find the sx name for VALUE problem-space"
; (let* ( (type (soar:attribute-value value 'type))
;         (type-string (if type (format nil ":~a" type) "")))
;    (format nil "~a~a" (string-upcase (soar::context-object-name value))
;                       (string-downcase type-string))))
;

;(defun find-state (value)
; "find an old state that you can use."
; (let ( (name (soar::context-object-name value))
;        (old-states (get-values (g-value *sx* :latest-problem-space)
;                                   :states))  )
; (yloop:yloop
;    (lfor state in old-states)
;    (initial (results nil))
;    (until results)
;    (ldo (cond ( (and state ;may be nil
;                      (string-equal name (g-value state :name-string))
;                      (not (g-value state :goal)))
;                 (setq results state)
;                 (let ( (examiner-window (g-value state :examiner-window)) )
;                   (if examiner-window
;                       (append-value *sx* :examiner-windows examiner-window)))  )))
;    (result results))))


(defun find-state (value name)
  #-release-sx "Find an old state that you can use."
  (declare (ignore value) (symbol name))
  ;; matched by name-attribute now, since many are nil.
  (let ( (old-states (get-values (g-value *sx* :latest-problem-space)
				 :states))  )
    (do ( (results nil)
	  (state (pop old-states) (pop old-states)) )
	((or results
	     (and (null old-states) (null state)))
	 results)
      (cond ( (and (eq name (g-value state :name-attribute))
		   (not (g-value state :goal)))
	     (setq results state)
             (restart-examiner state)  )))))

(defun find-or-create-state (count goal value)
  (declare (integer count) (type kr:a-schema-type goal) (symbol value))
  (cleanup-display goal 'state)
  (let* (result
         (plain-name (attribute-value value 'name))
         (state-name (soar::context-object-name value))
         (my-ps (g-value *sx* :latest-problem-space))
         (old-state (find-state value plain-name)))
    (setq result
          (if old-state
              old-state
              (create-instance (make-context-object-name count value) sx-state
                               (:problem-space my-ps) )))
    (s-value result :name-attribute plain-name)
    (s-value result :name-string state-name)
    (s-value result :traced-name-string
             (context-object-trace-name value nil))
    (s-value result :goal (g-value *sx* :latest-goal))
    (s-value result :previous-state-or-operator
	     (g-value my-ps :latest-state-or-operator))
    (s-value result :id value)
    (s-value *sx* :latest-state result)
    (s-value *sx* :latest-context-item result)
    (s-value my-ps :latest-state result)
    (s-value my-ps :latest-state-or-operator result)
    (s-value goal :latest-context-item result)
    (if (not (member result (get-values my-ps :states)))
	(append-value my-ps :states result))
    result ))


;(trace find-old-op find-operator-in-ops find-or-create-operator)

(defun find-or-make-operator (value count)
  #-release-sx
  "Find an old operator that you can use."
 ; 1. no op by that name yet, create
 ; 2. parent op by that name, not in use, use it.
 ; 3. parent op by that name, in use, no children, make one.
 ; 4. parent op by that name, in use, a children not in use, use it
 ; 5. parent op by that name, in use, no free children, create another.
 ;; passing name in would save a call sometimes
 ;; only considers ops appearing in the bottom ps
    (declare (integer count) (symbol value))
 (let* ( (name (soar::context-object-name value) )
	 (my-ps (g-value *sx* :latest-problem-space))
	 (ops nil) (old-op nil)  )
   ;; these two had been in the let, but they got optimized out! -fer 5/91
   ;; in some cases, e.g. nl-soar in dc 12?
 (setf ops (get-values my-ps :operators))
  ;(format t "~% ops are ~s" ops)
 (setf old-op (find-operator-in-ops name ops nil))
 (cond ( (not old-op) ;1 no op, create
		 ;(format t "   case 1   ")
	 (create-instance (make-context-object-name count value) sx-operator
             (:problem-space my-ps)
	     (:name-string name)) )
       ( (and old-op (not (g-value old-op :goal))) ;2 op not in use
	 ;(format t "~% case 2  ~s  ~s" old-op (g-value old-op :goal))
	 old-op)
       ( (and old-op (g-value old-op :goal)) ;3-5
	 	; (format t "   case 3-5   ")
	 (find-old-op old-op my-ps count value)) )))

(defun find-old-op (old-op ps count value)
 ;; we know here old-op would match, but it has a goal
  (declare (integer count) (type kr:a-schema-type old-op ps) (symbol value))    
 (let ( (children (get-values old-op :is-a-inv))
        (ps-operators (get-values ps :operators))
        (replacement nil) )
 (cond ( (not children) 
        ;(format t "    case 3: op in use, no children, make child")
        (setf replacement
              (create-instance (make-context-object-name count value) old-op)))
	( (setf replacement (find-operator-in-ops old-op children t))
             ;(format t "   case 4  op in use, can use free child ")
	  ;; so if you have an old child
          )
	( t ;(format t "   case 5: op and children in use, create  ")
	   (setf replacement
                 (create-instance (make-context-object-name count value)
                                  old-op))))
  ;; now have to switch the child and the parent
  (s-value replacement :selected nil)
  ;(s-value replacement :point (first (get-values old-op :point)))
  (s-value replacement :id (g-value old-op :id))
  (s-value replacement :cycle-number (g-value old-op :cycle-number))
  (s-value replacement :goal (g-value old-op :goal))
  (s-value replacement :previous-state-or-operator
	   (g-value old-op :previous-state-or-operator))
  (s-value replacement :previous-item (g-value old-op :previous-item))
  ;; could also hand off examiner window right here! -fer
  ;(format t "~% at if in  foo ~s ~s " old-op (g-value *sx* :latest-operator))
  (if (eq old-op (g-value *sx* :latest-operator))
      ;; this is the latest operator
      (progn (s-value *sx* :latest-operator replacement)
             (s-value *sx* :latest-context-item replacement)
             (s-value ps :latest-operator replacement)
             (s-value ps :latest-state-or-operator replacement)
             (s-value (g-value *sx* :latest-goal)
		      :latest-context-item replacement))
      ;; cleanup pointers to it
      (progn
	(mapc #'(lambda (x1)
                  ; (format t "~% doing mapcar ~s  ~s   ~s"
		  ;   old-op x1 (g-value x1 :previous-state-or-operator))
	       (if (eq old-op (g-value x1 :previous-state-or-operator))
		   (s-value x1 :previous-state-or-operator replacement))
	       (if (eq old-op (g-value x1 :previous-item))
		   (s-value x1 :previous-item replacement))  )
	      ps-operators)))
   ;; won't get added on its own since it may have been created here,
   ;;     and daddy is already on...
   (opal:add-component graphic-display-window-agg replacement
                       :behind gd-top-status-line)
   (if (not (member replacement ps-operators))
       (append-value ps :operators replacement))
   old-op))

;(defun find-operator-in-ops (name ops goal-test)
; (yloop:yloop
;   (lfor op1 in ops)
;   (initial (result nil))
;   (until result)
;   (ldo ;(format t "~% FO-in-Os-ing ~s" op1)
;        (cond ( (and op1 ;may be nil
;                     (if goal-test
;                         (not (g-value op1 :goal))
;                         (and (eq sx-operator (g-value op1 :is-a))
;                              (string-equal name (g-value op1 :name-string)))))
;                (setq result op1)) ))
;   (result result)))


(defun find-operator-in-ops (name ops goal-test)
  (declare (list ops) (type kr:logical goal-test))
  (do ( (op1 (pop ops) (pop ops))
	(results nil) )
      ((or results
	   (and (null op1) (null ops)))
       results)
    (cond ( (and op1			;may be nil
		 (if goal-test
		     (not (g-value op1 :goal))
		     (and (eq sx-operator (g-value op1 :is-a))
			  (string-equal name (g-value op1 :name-string)))))
	   (setq results op1)) )))


(defun find-or-create-operator (count goal value)
  ;; GOAL is a real sx-goal, VALUE is the user::name
  #-release-sx
  "Create an operator. Sets value (eg: o23) to be the latest instantiation of
operator.  Actual value is kept in o23-cycle#."
  (declare (integer count) (type kr:a-schema-type goal) (symbol value))
 (cleanup-display goal 'operator)
 (let* ( (my-ps (g-value *sx* :latest-problem-space))
         (result (find-or-make-operator value count)) )
  (s-value result :traced-name-string (context-object-trace-name value nil))
  (restart-examiner result)
  (s-value result :id value)
  (s-value result :cycle-number count)
  (s-value result :goal (g-value *sx* :latest-goal))
  (s-value result :previous-state-or-operator
 	  (g-value my-ps :latest-state-or-operator))
  (s-value result :previous-item (or (g-value my-ps :latest-operator)
                                     my-ps))
  (s-value *sx* :latest-operator result)
  (s-value *sx* :latest-context-item result)
  (s-value my-ps :latest-operator result)
  (s-value my-ps :latest-state-or-operator result)
  (s-value goal :latest-context-item result)
  (if (not (member result (get-values my-ps :operators)))
      (append-value my-ps :operators result))
  result ))

(defun more-precise-count (result1)
  (declare (symbol result1))
  (let* ( (current-counter (or (get result1 'sx-counter)
                               0)))
    (setf (get result1 'sx-counter)
          (+ current-counter .01))
    (+ current-counter .01)))


(defun make-context-object-name (count value)
 #-release-sx "Make symbol name for an object with name VALUE at COUNT cycle."
   (declare (integer count) (symbol value))
 (let ((result1
        (cond (count (intern (string-upcase (format nil "~a-~s" value count))
                             (find-package "SX")))
              (t (intern (string-upcase (format nil "~a" value))
                         (find-package "SX"))))))
   (if (not (boundp result1))
       result1
       (make-context-object-name (more-precise-count result1) value))))


(defun creatable-operator (value)
  (declare (symbol value))
 (let* ( (op-name (soar::context-object-name value) )
         (last-op (g-value *sx* :latest-operator))       )
 (cond ( (member op-name *show-never-op-names* :test 'string=)
         nil)
       ( (member op-name *show-once-op-names* :test 'string=)
         (not (string= op-name
                       (if last-op
                           (g-value last-op :name-string)))) )
       (t )    )))


;;;
;;; 	V.	Cleanup functions
;;;

(defun cleanup-display (current-goal attribute)
 #-release-sx  "Clean up the display as item is added."
 (declare (type kr:a-schema-type current-goal) (symbol value))
 (let ( (latest-goal (g-value *sx* :latest-goal)) )
   (if (and current-goal (not (eq latest-goal current-goal)))
       (progn
         ;(format t "in cleanup-display with ~s ~s" current-goal latest-goal)
         (let* ( (ps (g-value current-goal :latest-problem-space))
                 (astate (and ps (g-value ps :latest-state)))
                 (op (and ps (g-value ps :latest-operator)))
                 (impasse-goal (g-value current-goal :subgoal))
                 (latest (g-value current-goal :latest-context-item)) )
           (if latest (cleanup-context-item latest))
           (if impasse-goal (cleanup-goal impasse-goal))          
           ;kludge? here for ps
           (and (equal 'problem-space attribute)
                ps
                (cleanup-context-item ps))
           (s-value *sx* :latest-state astate)
           (s-value *sx* :latest-operator op)
           (s-value *sx* :latest-problem-space ps)
           (s-value *sx* :latest-goal current-goal) ))  ))
 nil)


(defun cleanup-context-item (item)
  (declare (type kr:a-schema-type item))
 (let ( (type (g-value item :is-a)) )
 (cond ((eq type sx-goal) (cleanup-goal item))
       ((eq type sx-problem-space) (cleanup-problem-space item))
       ((eq type sx-state) (cleanup-state item))
       ((eq type sx-operator) (cleanup-operator item))
       (t (error " In SX code cleanup-context-item ~a has a bad type." item)))
 nil))

(defun cleanup-goal (goal)
  #-release-sx "Recursively clean up the display starting at goal."
    (declare (type kr:a-schema-type goal))
 (let* ((c-line (g-value goal :cline))
        (supergoal (g-value goal :goal))
        (ps (g-value goal :latest-problem-space))
	(impasse-goal (g-value goal :impasse-goal))
        (previous-item (g-value goal :previous-item))
        (previous-ps (if previous-item
                         (g-value previous-item :problem-space)))   )
  (cond ((and c-line  (not (destroy-p c-line)))
         (opal:remove-component graphic-display-window-agg c-line)) )
  (if ps (cleanup-problem-space ps))
  (if impasse-goal (cleanup-goal impasse-goal))
  (if supergoal (s-value supergoal :subgoal nil))
  (if previous-item (s-value previous-item :impasse-goal nil))
  (if previous-ps (s-value previous-ps :impasse-goal nil))
  (s-value goal :goal nil)
  (s-value goal :latest-problem-space nil)
  (s-value goal :latest-context-item nil)  
  (opal:remove-component graphic-display-window-agg goal)
  (cleanup-examiner goal)
  nil))


;; this should be cleaned up so every one cleans up only themselves.
(defun cleanup-problem-space (ps)
  #-release-sx
  "Recursively clean up the display starting at PS."
    (declare (type kr:a-schema-type ps))
 (let ( (goal (g-value ps :impasse-goal)) )
   (cond ( (and goal (not (destroy-p goal)))
           (cleanup-goal goal)
           (if (eq ps (g-value goal :latest-context-item))
               (s-value goal :latest-context-item nil))
           (s-value ps :impasse-goal nil)))
 (mapc #'(lambda (x) (if x (hard-cleanup-operator x) ))
       (get-values ps :operators))
 (mapc #'(lambda (x) (if x (hard-cleanup-state x) ))
       (get-values ps :states))
 (s-value ps :goal nil)
 (s-value ps :latest-operator nil)
 (s-value ps :latest-state-or-operator nil)
 (s-value ps :latest-state nil)
 (s-value ps :parent nil)
 (s-value ps :selected nil)
 ;; need to put every ps onto list, b/c user might make it nonanchored
 (cond   ;should cleanup window here too
   ( (not (g-value ps :anchored))
     (push (g-value ps :point) copied-ps-locations)
     (s-value ps :point nil)
     (opal:remove-component graphic-display-window-agg ps)) )
 (cleanup-examiner ps)
 nil))

(defun cleanup-state (state)
  #-release-sx
  "Recursively clean up the display starting at state."
    (declare (type kr:a-schema-type state))
 (if (not (destroy-p state))
     (let ( (goal (g-value state :impasse-goal)) )
       (cond ( (and goal (not (destroy-p goal)))
              (cleanup-goal goal)) )
       (s-value state :impasse-goal nil))))

(defun hard-cleanup-state (state)
  #-release-sx
  "Recursively clean up the display starting at state."
    (declare (type kr:a-schema-type state))
 (if (not (destroy-p state))
 (let ( (goal (g-value state :impasse-goal)) )
   (cond ( (and goal (not (destroy-p goal)))
           (cleanup-goal goal)) )
   (opal:remove-component graphic-display-window-agg state)
   (cleanup-examiner state)
   (s-value state :goal nil)
   (s-value state :impasse-goal nil)))
 nil)


(defun cleanup-examiner (pscm-object)
    (declare (type kr:a-schema-type pscm-object))
  (let ( (examiner (g-value pscm-object :examiner)) )
    (if examiner
        (progn
          (recompute-formula (g-value EXAMINER :dead-head) :visible)
            ;(format t "<<<<~s  ~s>>>>" (g-value EXAMINER :dead-head :visible)
            ;        (wm-structure? (g-value pscm-object :id)) )
          ;(set-values *sx* :examiner-windows
          ;        (remove (g-value examiner :window)
          ;                (get-values *sx* :examiner-windows)))
          ;(set-values *sx* :examiners
          ;         (remove examiner (get-values *sx* :examiners)))
          ))
    nil))


(defun cleanup-operator (op)
  #-release-sx  "Recursively clean up the display starting at op."
      (declare (type kr:a-schema-type op))
 (if (not (destroy-p op))
 (let ( (goal (g-value op :impasse-goal)) )
   (cond ( (and goal (not (destroy-p goal)))
           (cleanup-goal goal) ))
   (s-value op :impasse-goal nil))))



(defun hard-cleanup-operator (op)
  #-release-sx
  "Recursively clean up the display starting at op."
    (declare (type kr:a-schema-type op))
 (if (not (destroy-p op))
 (let ( (goal (g-value op :impasse-goal)) )
   (cond ( (and goal (not (destroy-p goal)))
           (cleanup-goal goal) ))
   (opal:remove-component graphic-display-window-agg op)
   (s-value op :goal nil)
   (cleanup-examiner op)
   (s-value op :impasse-goal nil)))
 nil)


;;;
;;;		Compute object point locations
;;;


(defun compute-next-problem-space-location () ;goal attribute value
  #-release-sx
  "The delicate matter of where problem spaces (initially) go."
 (let ( (first-choice (pop copied-ps-locations)) )
   (cond (first-choice)
	 (t (pick-point :prompt "Pick a location for the new problem space"
			:target-window graphic-display-inner-window
			:window-title "graphical display")))))


(defun compute-next-goal-location (goal)
  #-release-sx
  "The delicate matter of where goals (initially) go."
 (declare (type kr:a-schema-type goal))
 (let* ( (object (or (g-value goal :latest-context-item)
                     goal))
         (apoint (g-value object :point)) )
   ;(format t "   *** ~s ~s ***" object apoint)
  (cons (- (car apoint) 10)
        (+ half-problem-space-size
           (cdr apoint))  )))

;  (cons (+ (car apoint) problem-space-size half-problem-space-size)
;        (cdr apoint))


;;;
;;;	VI.	blank
;;;


;;;
;;;	.	Trace functions
;;;
;;; We mean trace in more than one way.


;; ((OPERATOR (NAME OBJECT)) (GOAL (NAME IMPASSE ATTRIBUTE)))
(defun context-object-trace-name (object upcase-namep)
  ;; last is the name of the object, we think
  (declare (type kr:a-schema-type object) (type kr:logical upcase-namep))
  (let* ( (name (attribute-value object 'name))
          (alist (soar::nested-trace-attribute-values object))
          (rest  (if name
                     (delete name alist :test #'eq)
                     alist))
          (last-name (cond ((null name) nil)
                           ((symbolp name)
                            (if upcase-namep
                                (symbol-name name)
                                (string-downcase (symbol-name name))))
                           (t name))))
    ;(format t "~% ** name ~s alaist ~s rest ~s last-name ~s ~%"
    ;        name alist rest last-name)
    (cond ((and last-name rest)
           (format nil "~a~s" last-name
                   rest))
          ((stringp last-name)
           (format nil "~a" last-name))
          (last-name
           (format nil "~s" last-name))
          (rest (format nil "~s" rest))
          (t (symbol-name object))    )))

;(defun trace-sx ()
; (trace create-graphic-context-item  add-context-item
;        soar::signal-context-installation
;        soar::context-object-name
;        create-initial-goal
;        soar::compile-chunk
;        soar::compile-chunks
;        soar::build-external-chunk
;        find-problem-space
;        add-chunk
;               cleanup-goal  cleanup-problem-space  cleanup-operator
; ))


;;;
;;;	N.	Final code
;;;

;; if you are over-loading, reset the window
(if (and (boundp 'graphic-display-window)
         (schema-p graphic-display-window))
    (progn (init-soar)
           ;(make-sx)
           (create-graphic-display)))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/interactor-functions.lisp".
;;;; -*- Mode: Lisp; Package SX -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : interactor-functions.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jan  7 12:47:12 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:24:52 1992
;;;; Update Count    : 193
;;;; 
;;;; PURPOSE
;;;; 	Interators for sx windows.
;;;; TABLE OF CONTENTS
;;;;	i.	set up some variables and priority-level stuff
;;;;	I.	blank
;;;;	II.	garnet-inter-lam
;;;; 	III.	gdw-mover
;;;;	IV.	pick-point
;;;;	V.	pick-problem-space
;;;;	VI.	Pick-connector
;;;;	VII.	blank
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(integer double-click-time))
  (proclaim '(list *ps-locations*))

  (proclaim '(ftype (function (kr:a-schema-type) kr:a-schema-or-nil)
                     create-gdw-mover))
  (proclaim '(ftype (function (kr:a-schema-type kr:a-schema-type inter::event) kr:a-schema-or-nil)
                     sx-custom-gdw-mover-check-click))
;;  (proclaim '(ftype (function (kr:a-schema-type kr:a-schema-type inter::event) kr:a-schema-or-nil)
;;                     pick-point))
;;  (proclaim '(ftype (function (kr:a-schema-type kr:a-schema-type inter::event) kr:a-schema-or-nil)
;;                     pick-problem-space))
  (proclaim '(ftype (function (cons) kr:a-schema-or-nil)
                     find-ps-by-point))
;;  (proclaim '(ftype (function (kr:a-schema-type kr:a-schema-type inter::event) kr:a-schema-or-nil)
;;                     pick-connector))
  (proclaim '(ftype (function () nil)
                     create-graphic-display-inters))
)


;;;
;;;	i.	set up some variables and priority-level stuff
;;;



;;;
;;;	I.	blank
;;;



;;;
;;; 	III.	gdw-mover
;;; Mouse interactor for the graphic trace window.
;;;

(defvar double-click-time 1000
   "*Max time in ms for a double click to count as a double click.")
;; note: the numbers used here wrap every 49 days, could become a problem
;; if serverss stay up, hah.

;Original:
;(defun create-gdw-mover (window)
;  (create-instance 'gdw-mover inter:point-interactor
;    (:start-where (list :element-of graphic-display-window-agg 
;                        :type sx-problem-space)) ;context-item
;    (:window window)
;    (:point-p t)
;    (:grow-p nil)
;    (:double-click-action (sx-inter-lam (popup-pscm-examiner nil)))
;    (:time-stamp 0)
;    (:line-p nil)
;    (:waiting-priority soar-PRIORITY-LEVEL)
;    (:running-priority soar-PRIORITY-LEVEL)
;    (:final-function
;    #'(lambda (an-interactor new-obj points)
;        (declare (ignore points))
;        ;;(format t "~% got ~s ~s ~s ~%" an-interactor new-obj points)
;        (let ( (old-obj (g-value *sx* :selected-items))
;               (old-time (g-value an-interactor :time-stamp))
;               (new-time (inter:event-timestamp inter:*current-event*))
;               (new-goal (and (is-a-p new-obj sx-problem-space)
;                              (g-value new-obj :goal)))  )
;          (cond ((eq new-obj :none)
;                 (if old-obj (s-value old-obj :selected nil)))
;                ((eq old-obj new-obj)
;                 (if (< (- new-time old-time) double-click-time)
;                     (funcall (g-value an-interactor :double-click-action)
;                              new-obj)) )
;                (t (if old-obj (s-value old-obj :selected nil))
;                   (s-value new-obj :selected t)
;                   (s-value *sx* :selected-items new-obj)))
;          (if (is-a-p new-obj sx-problem-space)
;              (mapc #'(lambda (x) (recompute-formula x :point))
;                        (get-values new-obj :operators)))
;          ;; move the goal too if it's attatched to a ps
;          (if new-goal
;              (let ( (graphic (g-value new-goal :graphic))
;                     (cline (g-value new-goal :cline)) )
;                  (s-value new-goal :point (g-value new-obj :point))
;                  ;; something is fishy, this should be automatic...
;                  (recompute-formula graphic :top)
;                  (recompute-formula graphic :left)
;                  (if cline
;                      (progn
;                        (recompute-formula cline :x2)
;                        (recompute-formula cline :y2)))
;                  (opal:update (g-value new-goal :window))))
;          (s-value an-interactor :time-stamp new-time))))
;    (:attach-point :where-hit)
;    (:continuous t)
;    (:running-where t))
;  )

;(defun create-gdw-mover (window)
; (create-instance 'gdw-mover inter:point-interactor
;   (:start-where (list :leaf-element-of graphic-display-window-agg
;                       :type (list sx-triangle opal:circle opal:rectangle)))
;    (:window window)
;    (:point-p t)
;    (:grow-p nil)
;    (:double-click-action (sx-inter-lam (popup-pscm-examiner nil)))
;    (:time-stamp 0)
;    (:line-p nil)
;    (:waiting-priority soar-PRIORITY-LEVEL)
;    (:running-priority soar-PRIORITY-LEVEL)
;    (:running-action
;     #'(lambda (an-interactor raw-new-obj points)
;         (if (is-a-p raw-new-obj sx-triangle)
;             (inter::obj-or-feedback-change (g-value an-interactor :feedback-obj)
;                                            (g-value raw-new-obj :parent)
;                            points
;                            :point
;                            an-interactor)))
;    )
;    (:stop-action
;     #'(lambda (an-interactor raw-new-obj points)
;         (if (is-a-p raw-new-obj sx-triangle)
;             (inter::point-Int-Stop-Action an-interactor raw-new-obj points)
;               (inter::KR-Send an-interactor :final-function an-interactor
;                        raw-new-obj points))))
;   (:final-function
;    #'(lambda (an-interactor raw-new-obj points)
;        (declare (ignore points))
;        ;;(format t "~% got ~s ~s ~s ~%" an-interactor new-obj points)
;        (let* ( (new-obj (g-value raw-new-obj :parent))
;              (old-obj (g-value *sx* :selected-items))
;               (old-time (g-value an-interactor :time-stamp))
;               (new-time (inter:event-timestamp inter:*current-event*))
;               (new-goal (and (is-a-p new-obj sx-problem-space)
;                              (g-value new-obj :goal)))
;               )
;          (cond ;; ((eq new-obj :none)
;                ;;  (if old-obj (s-value old-obj :selected nil)))
;                ((eq old-obj new-obj)
;                 (if (< (- new-time old-time) double-click-time)
;                     (funcall (g-value an-interactor :double-click-action)
;                              new-obj)) )
;                (t (if old-obj (s-value old-obj :selected nil))
;                   (s-value new-obj :selected t)
;                   (s-value *sx* :selected-items new-obj)))
;;         (if (is-a-p new-obj sx-problem-space)
;;              (mapc #'(lambda (x) (recompute-formula x :point))
;;                       (get-values new-obj :operators)))
;          ;; move the goal too if it's attatched to a ps
;          (if new-goal
;              (let ( (graphic (g-value new-goal :graphic))
;                     (cline (g-value new-goal :cline)) )
;                  (s-value new-goal :point (g-value new-obj :point))
;                  ;; something is fishy, this should be automatic...
;                  (recompute-formula graphic :top)
;                  (recompute-formula graphic :left)
;                  (if cline
;                      (progn
;                        (recompute-formula cline :x2)
;                        (recompute-formula cline :y2)))
;                  (opal:update (g-value new-goal :window))))
;          (s-value an-interactor :time-stamp new-time))))
;    (:continuous t)
;    (:running-where t))
;  )
 


(defun create-gdw-mover (window)
  (declare (type kr:a-schema-type target-window))
  (create-instance 'gdw-mover inter:point-interactor
    ;; these are new:
    (:start-action #'(lambda (i o p)
       (let ( (old-obj (g-value *sx* :selected-items)) )
          (if old-obj (s-value old-obj :selected nil))
          (s-value o :selected t)
          (s-value *sx* :selected-items o))
        (if (is-a-p o sx-problem-space)
            (inter::point-int-start-action i o p))))
    (:stop-action #'(lambda (i o p)
                      (if (is-a-p o sx-problem-space)
                          (inter::point-int-stop-action i o p)
                          (KR-Send i :final-function i o p) )))
    (:running-action #'(lambda (i o p)
                         (if (is-a-p o sx-problem-space)
                             (inter::point-int-running-action i o p))))
    (:start-where nil)
    (:point-p t)
    (:grow-p nil)
    (:double-click-action (opal:g-inter-lam (popup-pscm-examiner nil)))
    (:time-stamp 0)
    (:line-p nil)
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:final-function
    #'(lambda (an-interactor new-obj points)
	(declare (ignore points) (type kr:a-schema-type an-interactor new-obj))
        ;;(format t "~% got ~s ~s ~s ~%" an-interactor new-obj points)
        (let ( (old-obj (g-value *sx* :selected-items))
	       (old-time (g-value an-interactor :time-stamp))
	       (new-time (inter:event-timestamp inter:*current-event*))
	       (new-goal (and (is-a-p new-obj sx-problem-space)
		              (g-value new-obj :goal)))  )
	  (cond ((eq old-obj new-obj)
		 (if (< (- new-time old-time) double-click-time)
		     (funcall (g-value an-interactor :double-click-action)
			      nil nil)) ))
	  (if (is-a-p new-obj sx-problem-space)
              (mapc #'(lambda (x) (recompute-formula x :point))
			(get-values new-obj :operators)))
	  ;; move the goal too if it's attatched to a ps
	  (if new-goal
	      (let ( (graphic (g-value new-goal :graphic))
		     (cline (g-value new-goal :cline)) )
		  (s-value new-goal :point (g-value new-obj :point))
	          ;; something is fishy, this should be automatic...
		  (recompute-formula graphic :top)
		  (recompute-formula graphic :left)
		  (if cline
		      (progn
			(recompute-formula cline :x2)
 		        (recompute-formula cline :y2)))
		  (opal:update (g-value new-goal :window))))
	  (s-value an-interactor :time-stamp new-time))))
    (:attach-point :where-hit)
    (:continuous t)
    (:running-where t))
  (s-value gdw-mover :start-where
           (list :custom graphic-display-window-agg
                 #'sx-custom-gdw-mover-check-click))
  (s-value gdw-mover :window window)  )

(defun sx-custom-gdw-mover-check-click (agg an-interactor event)
  (declare (type kr:a-schema-type agg an-interactor) (type inter::event event))
  (let ((results nil)
        (win (g-value an-interactor :window))
        (x (inter::event-x event))
        (y (inter::event-y event)))
  (opal:do-components agg
     #'(lambda (child)
         (when (and (eq (g-value child :window) win)
                    (and (inter::checkobjtype child sx-context-item)
                         (or (opal:point-in-gob (g-value child :graphic) x y)
                             (opal:point-in-gob (g-value child :name) x y))))
           #-release-garnet(inter::if-debug an-interactor
                              (format T " ** SUCCESS: ~s~%" child))
           (cond ((null results) (setq results child))
                 ((is-a-p child sx-problem-space) nil)
                 ((setq results child)))
       )))
    ; if get here, then didn't find anything, return NIL or :none
    ;(if (eq control :check-leaf-but-return-element-or-none)
    ;    :none
    ;    NIL)
  results))


;;;
;;;	IV.	pick-point
;;; Picks a point.
;;;

;; not sure how to proclaim this guy...
;;(eval-when (load eval compile)
;;   (proclaim '(ftype (function (kr:a-schema-type kr:a-schema-type event) kr:a-schema-or-nil)
;;                     pick-point)))

(defun pick-point (&optional &key target-window (prompt "Pick a point") 
                   (window-title "correct window") (graphic-query t)
                   (mouse-type :leftdown))  
#-release-sx"Picks a point in :TARGET-WINDOW (called :WINDOW-TITLE),
prompting with :PROMPT if :GRAPHIC-QUERY is T (the default), waiting
for :MOUSE-TYPE."
  (declare (string prompt window-title) (type kr:a-schema-or-nil target-window)
           (type kr:logical graphic-query) (symbol mouse-type))
  (opal:with-regularcursor-set target-window
  (unwind-protect (progn
    (s-value soar-priority-level :active nil)
    (let ( (old-ts (inter:event-timestamp inter:*current-event*))
           (prompt (format nil
                        "~%~a in the ~a: ~%(You can scroll the window first.)"
                          prompt window-title))
           (display (let ((win1 (caar (opal::get-table-contents))))
                      (if win1 (xlib:window-display win1)
                         opal::*default-x-display*))) )
    ;; extra incantation that should be unnecessary...
    ;; timestamp here used as unique id for events
    (opal::default-event-handler display :timeout 0)
    (if graphic-query (sgd-error prompt nil nil))
    (format t prompt)
    (prog ()
      start ;; call the event handler to get anything
      (opal::default-event-handler display :timeout 0)
      (sleep opal:grepl-loop-sleep-time)
      (if (= old-ts (inter:event-timestamp inter:*current-event*))
	  (go start))
      (if (and (or (not target-window)
		   (eq (inter:event-window inter:*current-event*)
		       target-window))
	       (or (not mouse-type)
		   (eq (inter:event-char inter:*current-event*)
	 	        mouse-type)))
	  ;; got the point
	  (progn ;; (format t "~%")
            (return (cons (inter:event-x inter:*current-event*)
	                  (inter:event-y inter:*current-event*))))
	  (progn ;(format t "~% You should click in the ~a:" window-title)
	 	(setq old-ts  (inter:event-timestamp inter:*current-event*))
    		(go start))))))
    ;; the protected actions
    (s-value soar-priority-level :active t)  )))

;; (defconstant normal-inter-handlers
;;  (list inter:high-priority-level inter:normal-priority-level))


;;;
;;;	V.	Pick-problem-space
;;;

(defun pick-problem-space (&optional &key (prompt "Pick a problem space")
			     (target-window graphic-display-inner-window) 
                             (graphic-query t) (modal-p nil))
#-release-sx"Pick a problem space."
  (declare (string prompt) (type kr:a-schema-or-nil target-window)
           (type kr:logical modal-p))
  (prog (point result)
    start
     (setf point (pick-point :prompt prompt :target-window target-window
                             :graphic-query graphic-query))
     (setf result (find-ps-by-point point))
     (cond (modal-p (if result
                        (go end))
                      (go start))
           (t (go end)))
   end
    (if result
    (let ((old-selected (g-value *sx* :selected-items)))
      (if old-selected (s-value old-selected :selected nil))
      (s-value result :selected t)
      (s-value *sx* :selected-items result)
      (opal:update graphic-display-window)))
    (return result)))

(defun find-ps-by-point (point)
#-release-sx"Given a point, find the ps."
  (declare (cons point))
  (let ( (x (car point))
         (y (cdr point)) )
  (do* ( (pss (get-values *sx* :problem-spaces))
	 (ps (pop pss) (pop pss))
         (result nil))
      ;stop if
      ((or result (not ps))
       result)
    (if (opal:point-in-gob ps x y)
	(setf result ps)))))


;;;
;;;	VI.	Pick-connector
;;;

(defun pick-connector (&optional &key (prompt "Pick a connector")
			     (target-window graphic-display-inner-window)
                             (graphic-query t)
                             (modal-p nil) )
#-release-sx  "Pick a connector."
  (declare (string prompt) (type kr:a-schema-or-nil target-window)
           (type kr:logical modal-p))
  (prog (point result)
    start
     (setf point (pick-point :graphic-query graphic-query
                             :prompt prompt :target-window target-window))
     ;; 14-Dec-91 - changed f/ find-connector-by-point, appeared to be same-FER
     (setf result (find-connector-by-point point))
     (cond (modal-p
            (if result
		(return result)
	       (go start)))
           (t (return result)))     ))

(defun find-connector-by-point (point)
#-release-sx"Given a point, find the connector."
  (declare (cons point))
  (let ( (x (car point))
         (y (cdr point)) )
  (do* ( (pss (get-values *sx* :static-connections))
	 (ps (pop pss) (pop pss))
         (result nil))
      ;stop if
      ((or result (not ps))
       result)
    (if (opal:point-in-gob ps x y)
	(setf result ps)))))

;;(eval-when (load eval compile)
;;   (proclaim '(ftype (function (cons) kr:a-schema-or-nil)
;;                     find-connector-by-point)))
;;
;;;; 14-Dec-91 -same as find-ps-by-point, replaced
;;(defun find-connector-by-point (point)
;;#-release-sx  "Given a point, find the connector."
;;  (declare (cons point))
;;  (let ( (x (car point))
;;         (y (cdr point)) )
;;  (do* ( (pss (get-values *sx* :problem-spaces))
;;	 (ps (pop pss) (pop pss))
;;         (result nil))
;;      ;stop if
;;      ((or result (not ps))
;;       result)
;;    (if (opal:point-in-gob ps x y)
;;	(setf result ps)))))


;;;
;;;	VII.	blank
;;;






;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/pscm-stats.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : pscm-stats.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Jan 28 15:26:33 1992
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:27:14 1992
;;;; Update Count    : 39
;;;; 
;;;; PURPOSE
;;;; 	|>Describe module's purpose<|
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1991, Carnegie Mellon University.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Status          : Unknown, Use with caution!
;;;; HISTORY
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(eval-when (load eval compile)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(integer max-pscm-count))
  (proclaim '(function pscm-print-self (kr:a-schema-type string integer string) nil))
  (proclaim '(function count-real-operators (list) integer))
  (proclaim '(function pscm-stats nil nil))
  (proclaim '(function reset-pscm-stats nil nil))
  )


;;;
;;;	I.	Utils
;;;

(define-method :apply-pscm-function sx-goal (schema function)
   (funcall function schema)
   (dolist (x (get-values schema :resolution-objects))
     (declare (type kr:a-schema-type x))
     (kr-send x :apply-pscm-function x function))   )

(define-method :apply-pscm-function sx-problem-space (schema function)
   (funcall function schema)
   (dolist (x (get-values schema :subgoals))
     (declare (type kr:a-schema-type x))
     (kr-send x :apply-pscm-function x function))
   (dolist (x (get-values schema :states))
     (declare (type kr:a-schema-type x))
     (kr-send x :apply-pscm-function x function))
   (dolist (x (get-values schema :operators))
     (declare (type kr:a-schema-type x))
     (kr-send x :apply-pscm-function x function)))

(define-method :apply-pscm-function sx-state (schema function)
   (funcall function schema)
   (dolist (x (get-values schema :subgoals))
     (declare (type kr:a-schema-type x))
     (kr-send x :apply-pscm-function x function))   )

(define-method :apply-pscm-function sx-operator (schema function)
   (funcall function schema)
   (dolist (x (get-values schema :subgoals))
     (declare (type kr:a-schema-type x))
     (kr-send x :apply-pscm-function x function))   )

;; maximum counter in the pscm-stats counters
(defparameter max-pscm-count 0)

(defun compute-max-pscm-count ()
  (if (and old-top-goal (schema-p old-top-goal))
      (kr-send old-top-goal :apply-pscm-function old-top-goal
           #'(lambda (x)
               (declare (type kr:a-schema-type x))
               (let ((value (g-value x :pscm-counter)))
                 (if (> value max-pscm-count)
                     (setf max-pscm-count value))))
           )
    0))

;;;
;;;	II.	Formal PSCM stats
;;;

;; assumes that there will not be more than 99 ops/ps
;; make S lines an option
(defun pscm-stats ()
  "*Print out stats on the ps computational model level."
  (compute-max-pscm-count)
 (let* ( (problem-spaces (get-values *sx* :problem-spaces))
        (total-ops 0)
        (ps-number (length problem-spaces))
        (fs (format nil "~~%~~~dd "
                    (1+ (floor (log (max 1 max-pscm-count) 10))))) )
  (mapc #'(lambda (x)
              (declare (type kr:a-schema-type x))
	      (let ( (ops (get-values x :operators)) )
        	(setq total-ops (+ total-ops (count-real-operators ops))) ))
	 problem-spaces)
  (format t "~%PSCM Level statistics on ~A~%" (soar::soar-date))
  (format t "~%~s problem space~a,"
          ps-number
          (if (> ps-number 1) "s" ""))
  (format t " with a total of ~s operators." total-ops)
  (format t "~%Ops  Problem space")
  (mapc #'(lambda (x)
              (declare (type kr:a-schema-type x))
	      (let ( (ops (get-values x :operators)) )
	      (format t "~%~2d   ~a"
                      (count-real-operators ops)
                      (g-value x :name-string))))
	 problem-spaces)
  (format t "~%~%The actual selection counts and calling orders:")
  (if (and old-top-goal (schema-p old-top-goal))
      (kr-send old-top-goal :print-pscm-stats old-top-goal 0 fs))
  (format t "~%")
  nil))

(defun count-real-operators (ops)
  (declare (list ops))
  (let ((result 0))
    (dolist (op ops)
      (if (eq (g-value op :is-a) sx-operator)
          (setf result (1+ result))))
    result))


;;;
;;;	III.	reset-pscm-stats
;;;

(defun reset-pscm-stats ()
  "*Reset the counters used in pscm-stats."
  (if (and old-top-goal (schema-p old-top-goal))
      (kr::kr-send sx::old-top-goal :apply-pscm-function sx::old-top-goal
           #'(lambda (x) (kr::s-value x :pscm-counter 0))))
  nil)


;;;
;;;	IV.	pscm-print-self
;;;

;; don't print identifiers
;; don't indent on problem-spaces

;The actual counts and calling orders:
; 1 G: G1 *top-goal*
; 1   P: top-space (0 chunks)
; 1   S: s5
; 1   O: browsing-task
; 1     G: g18 op nc
; 1       P: browsing (0 chunks)
; 1       S: s41
; 1       O: find-appropriate-help
; 1         G: g40 op nc
; 1           P: find-appropriate-help (0 chunks)
; 1           S: s65
; 1           O: define-search-criterion
; 1        

;; could make example identifiers printout optional
(defun pscm-print-self (schema label level format-string)
 (declare (type kr:a-schema-type schema) (string label level format-string))
 (let ((type-string (g-value schema :traced-name-string))
       (id (string-downcase (strip-package (format nil "~s"
                                                   (g-value schema :id)))))
       (name-string (string-downcase (g-value schema :name-string))) )
   (format t format-string (g-value schema :pscm-counter))
   (do ( (i 0 (+ i 1)))
       ((>= i level))
     (format t " "))
   (cond ((eq label 's)
          (let ((real-name (g-value schema :name-attribute)))
            (if real-name
                (format t "S: ~a (~a)" name-string id)
                (format t "S: ~a (no name)" name-string))))
         ((eq label 'g)
          (format t "G: ~a (~a)" (string-downcase type-string) name-string))
         ((eq label 'o)
          (format t "O: ~a (~a)" (string-downcase type-string) name-string))
         ((eq label 'p)
          (format t "P: ~a (~a)" (string-downcase type-string) name-string)))
    nil))


;;;
;;;	IV.	Methods for printing
;;;

(define-method :print-pscm-stats sx-goal (schema level format-string)
   (pscm-print-self schema 'g level format-string)
   ;; do resolution objects
   (dolist (x (get-values schema :resolution-objects))
     (declare (type kr:a-schema-type x))
     (kr-send x :print-pscm-stats x (1+ level) format-string))   )

(define-method :print-pscm-stats sx-problem-space (schema level format-string)
  (pscm-print-self schema 'p level format-string)
  ;; include chunks
  (format t " (~d chunks)" (length (get-values schema :chunks)))
  ;; print states
  (dolist (x (get-values schema :states))
    (declare (type kr:a-schema-type x))
    (kr-send x :print-pscm-stats x (1+ level) format-string))
  ;; print operators
  (dolist (x (get-values schema :operators))
    (declare (type kr:a-schema-type x))
    (kr-send x :print-pscm-stats x (1+ level) format-string))  )


(define-method :print-pscm-stats sx-state (schema level format-string)
  (pscm-print-self schema 's level format-string)
  (dolist (subgoal (get-values schema :subgoals))
     (kr-send subgoal :print-pscm-stats subgoal (1+ level) format-string))  )

(define-method :print-pscm-stats sx-operator (schema level format-string)
  (if (eq (g-value schema :is-a) sx-operator)
      (progn (pscm-print-self schema 'O level format-string)
         (dolist (subgoal (get-values schema :subgoals))
            (kr-send subgoal :print-pscm-stats subgoal
                     (1+ level) format-string)))  ))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/macrocycle-window.lisp".
;;;; -*- Mode: lisp; Package: sx --*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : macrocycle-window.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Wed Feb  6 19:41:19 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Sat Feb  1 18:12:24 1992
;;;; Update Count    : 124
;;;; Soar Version    : 5.2
;;;; TAQL Version    : 3.1.3
;;;; 
;;;; PURPOSE
;;;; 	Sets up the idea of a macrocycle that runs with the DSI, and elsewhere.
;;;;
;;;; TABLE OF CONTENTS
;;;;	i.	variables
;;;;	I.	window to change values for macrocycle
;;;;	II.	update-examiner-windows
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(special macrocycle-window))
  (proclaim '(type kr:a-schema-or-nil macrocycle-window))
  (proclaim '(function macrocycle-rb-selection (symbol symbol) symbol))
  (proclaim '(function macrocycle-trill-selection (symbol symbol) integer))
  (proclaim '(function macrocycle-max-number-trill-selection (symbol symbol) integer))
  (proclaim '(function update-examiner-windows () nil))
  (proclaim '(function update-graphic-windows () nil))
  )


;;;
;;;	ii.  Variables for the macrocycle window

;; (defvar macrocycle-window nil #-release-sx
;;  "Where the macrocycle dialog box lives.")

;;;
;;;	I.	window to change values for macrocycle
;;;

(defun macrocycle-rb-selection (g-object value)
  #-release-sx"Set values in *sx* based on the rb"
  (declare (ignore g-object))
  (setf soar::macrocycle-type value))

(defun macrocycle-trill-selection (g-object value)
  #-release-sx"Set values on the trill."
  (declare (ignore g-object))
  (setf soar:macrocycle-n value))

(defun macrocycle-max-number-trill-selection (g-object value)
  #-release-sx"Set values based on the trill."
    (declare (ignore g-object))
  (setf soar:macrocycle-max-dc value))

;;(defun create-macrocycle-window ()
;; "create a window for showing and setting macrocycle variables."
 ;; destroy it if it is already built.  Perhaps later we'll return it instead
 (if (and (boundp 'macrocycle-window)
          (schema-p macrocycle-window))
     (opal:destroy macrocycle-window))
 (create-instance 'macrocycle-window inter:interactor-window 
     (:position-by-hand nil)
     (:top 20)
     (:left 30)
     (:width 310)
     (:visible nil)  ;will gotot nil soon
     (:height 275)
     (:title "Set Macrocycle values")
     (:icon-title  "Macrocycle values")
     (:aggregate
	   (create-instance 'macrocycle-window-agg opal:aggregate
                            (:overlapping NIL)))     )
;; (Create-macrocycle-type-radio-buttons macrocycle-window-agg)
;; (Create-macrocycle-number-trills macrocycle-window-agg)
;; (Create-macrocycle-put-me-away macrocycle-window-agg)
;; (opal:update macrocycle-window)
;; t )


;;(defun Create-macrocycle-type-radio-buttons (window-agg)
;; "create the radio buttons for the type buttons"
 (create-instance 'macrocycle-type-text opal:text
    (:left 160)
    (:string "MC type:")
    (:top 20)
    (:font big-title-font))
 (create-instance 'macrocycle-type-RB gg:radio-button-panel
    (:left 160)
    (:text-on-left-p nil)
    (:h-align :left)
    (:top (+ 10 (g-value macrocycle-type-text :height)
	     (g-value macrocycle-type-text :top)))    
    (:selection-function #'macrocycle-rb-selection)
    (:items soar:macrocycle-ps-types))
 (g-value macrocycle-type-RB :value)
 (s-value macrocycle-type-RB :value soar:macrocycle-type)
 (opal:add-components macrocycle-window-agg macrocycle-type-RB
                      macrocycle-type-text)
;; )

;;(defun Create-macrocycle-number-trills (window-agg)
;; "Create the trill for the number of small cycles."
 (create-instance 'macrocycle-number-text opal:text
    (:string "N types/MC:")
    (:font big-title-font)    
    (:top 20)
    (:left (+ 10 left-soar-status-margin)))
 (create-instance 'macrocycle-number-trill gg:trill-device
    (:left (+ 10 left-soar-status-margin))
    (:val-1 1)
    (:val-2 nil)    
    (:selection-function #'macrocycle-trill-selection)    
    (:top (+ 10 (g-value macrocycle-number-text :height)
	     (g-value macrocycle-number-text :top))) )
 (g-value macrocycle-number-trill :value)
 (s-value macrocycle-number-trill :value soar::macrocycle-n)
 (create-instance 'macrocycle-max-number-text opal:text
    (:string "Max dc/MC:")
    (:font big-title-font)    
    (:top (+ 40 (g-value macrocycle-number-trill :height)
	     (g-value macrocycle-number-trill :top)))
    
    (:left (+ 10 left-soar-status-margin)))
 (create-instance 'macrocycle-max-number-trill gg:trill-device
    (:left (+ 10 left-soar-status-margin))
    (:val-1 1)
    (:val-2 nil)
    (:selection-function #'macrocycle-max-number-trill-selection)    
    (:top (+ 10 (g-value macrocycle-max-number-text :height)
       	     (g-value macrocycle-max-number-text :top))))
 (g-value macrocycle-max-number-trill :value)
 (s-value macrocycle-max-number-trill :value soar::macrocycle-max-dc)
 (opal:add-components macrocycle-window-agg macrocycle-number-trill
		      macrocycle-number-text macrocycle-max-number-text
		      macrocycle-max-number-trill)
;;)


;;;
;;; 	Id.   Create-macrocycle-put-me-away
;;;

;; (defun Create-macrocycle-put-me-away (window-agg)
;; "create the text button for closing the display"
 (create-instance 'macrocycle-put-me-away put-me-away-button
    (:additional-action
         #'(lambda (an-in points)
	     (declare (ignore an-in points))
           (sx-set-macrocycle-hook)
	   ;; why is this necessary?
	   (g-value gd-bottom-status-line :cycle-type :string)
	   (recompute-formula
	      (g-value gd-bottom-status-line :cycle-type)
	      :string)
	   (opal:update graphic-display-window)
            )))
  (opal:add-components macrocycle-window-agg macrocycle-put-me-away)
;; )


;;;
;;;	II.	update-examiner-windows
;;;
;;; you would do the other windows too, if there were any

(defun update-examiner-windows ()
  #-release-sx"Update all the examiners on the examiners list that should
be sent a special soar-update message."
  (dolist (examiner (get-values *sx* :examiners))
    ;; have to check all examiners all the time
    (if (and examiner  (schema-p examiner)
             (g-value examiner :window :visible))
        (progn
          (recompute-formula (g-value examiner :dead-head) :visible)
          ;; update iff examiner has a visible window & its tied to goal-stack
          (if (and (g-value examiner :window :visible)
                   (not (g-value examiner :dead-head :visible)))
              (kr-send examiner :soar-update examiner)
              )))   )
  ;; this way it gets called every macrocycle, or every elaboration cycle
  ;(if continuous-ms!
  ;    (emacs-ms))
  nil)

(defun update-graphic-windows ()
  #-release-sx"Name used in into soar5.2.1 code."
  (update-examiner-windows))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/static-tracing.lisp".
;;;; -*- Mode: Lisp; package: sx -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : static-tracing.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Apr 23 17:17:12 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:45:34 1992
;;;; Update Count    : 107
;;;; 
;;;; PURPOSE
;;;; 	Stuff to do static traces.
;;;; TABLE OF CONTENTS
;;;;	i.	Variables and constants
;;;;	I.	New instances
;;;;	II.	Interactive-create-operator and -problem-space
;;;;	III.	Tie and untie two-spaces-together
;;;;	IV.	Static-menu and its window
;;;;	V.	Write out static problem spaces
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  ;; (proclaim '(function interactive-create-operator () nil))
  (proclaim '(function find-or-create-ps-connector (kr:a-schema-type kr:a-schema-type
                                                             (or string nil))
                       kr:a-schema-type))
  (proclaim '(function find-ps-connector (kr:a-schema-type kr:a-schema-type) kr:a-schema-or-nil))
  (proclaim '(type kr:a-schema-type ps-connector))
  (proclaim '(string static-dump-directory static-dump-file))
  (proclaim '(function write-static-ps-file (kr:logical) nil))
  (proclaim '(function write-static-connections (list stream) nil))
  (proclaim '(function write-static-connection (kr:a-schema-type stream) nil))
  )


;;;
;;;	i.	Variables and constants
;;;

(defvar static-menu-expert nil
  "*If t (default is nil), user is assumed to know how to use static menu,
and is not prompted with what to do each time.")

(defvar static-dump-directory "/tmp/"
  "*Directory to put dumped file in.")

(defvar static-dump-file "demo"
  "*File to put dump into.")

(defvar static-numeric-extension "")
(defvar last-static-file static-dump-file
  #-release-sx"The last static file dumped.")

(defconstant static-file-extension "PSs")

(defconstant static-file-name-prompt
  "File or vers # for saving problem spaces into (no extension or \"'s):")

(defconstant static-final-message
  "Beep at click means you got it!")


;;;
;;;	I.	New instances
;;;

(create-instance 'ps-connector opal:aggregadget
;;  Nil items that don't have to be created at startup.
;  (:type )
;  (:ps1 )
;  (:ps2 )
  (:text-visible (o-formula (gv *sx* :show-static-text)))
  (:text-top (o-formula (+ (opal:gv-center-y (gvl :line)) -10)))
  (:text-left (o-formula (opal:gv-center-x (gvl :line) )))
  (:visible (o-formula (and (gvl :ps1 :visible)
			    (gvl :ps2 :visible)
			    (gv *sx* :show-static-links))) )
  (:parts `(
    (:line ,gg:arrow-line
      (:line-style ,static-line)
      (:filling-style ,opal:black-fill)
      (:open-p t)
      (:x1 ,(o-formula (+ (opal:gv-right (gvl :parent :ps1 :graphic)) -3)))

      (:y1 ,(o-formula (opal:gv-bottom (gvl :parent :ps1 :graphic))))
      (:x2 ,(o-formula (+ (opal:gv-right (gvl :parent :ps2 :graphic)) -3)))
      (:y2 ,(o-formula (+ (gvl :parent :ps2 :graphic :top) -1))))
    (:name-tag ,name-tag
      (:string ,(o-formula (gvl :parent :type))))
	    )))


;;;
;;;	II.	Interactive-create-operator and -problem-space
;;;

;;#-release-sx
;;(defun interactive-create-operator nil
;;  (format t "Can't do that yet."))

(defun interactive-create-problem-space (name point &key anchored)
 (declare (symbol name) (cons point) (type kr:logical anchored))
 ;; anchored should be yes or no
 ;; name can be a symbol or a string
 (if (not name)
     (setf name
           (dsi-query-using-labeled-box
            "Enter name of new space, then <CR>, then click on location."
	    "space")))
 (if (not (symbolp name))
     (setf name (intern (string-upcase (format nil "~a" name))
                        (find-package "SX"))))
 (if (not (consp point))
     (setf point (pick-point :target-window graphic-display-inner-window
                             :graphic-query nil)))
 (setf anchored
       (if (or (string-equal anchored "yes")
	       (equal anchored 'yes)
	       (eq t anchored))
	   t
	   nil))
  (let ( (result (create-problem-space nil nil name anchored)) )
    (s-value result :point point)
    (s-value result :traced-name-string (symbol-name name))
    (opal:add-component graphic-display-window-agg result
                        :behind gd-top-status-line)
    (s-value result :anchored anchored)
    (opal:update graphic-display-window)
    result))


;;;
;;;	III.	Tie and untie two-spaces-together
;;;	    

(defun tie-two-spaces-together (space1 space2 type)
  (declare (type kr:a-schema-or-nil space1 space2)
           (type (member string nil) type))
  (if (not space1)
      (progn (setf space1
                   (pick-problem-space :modal-p nil
                       :graphic-query (not static-menu-expert)
	               :prompt "Pick \"from\" and \"to\" problem spaces"))
        (setf space2 (pick-problem-space :modal-p nil :graphic-query nil))))
  (if (not (and space1 space2))
      (progn (sgd-error "You must pick two spaces." nil t)
             (return-from tie-two-spaces-together nil)))
  (if (eq space1 space2)
      (progn (sgd-error "We do not support tying a space to itself." nil t)
             (return-from tie-two-spaces-together nil)))  (if (not type)
      (setf type (gg:display-choice sgd-choice-gadget
                                    "Type of connection?"
                     '("Op Tie" "Op NC"
		       "State Tie" "State NC"
                       "PS Tie" "PS NC" "") nil)))
  (let ( (new-connector (find-or-create-ps-connector space1 space2 type)) )
    (push new-connector (g-value space1 :outgoing-connectors))
    (push new-connector (g-value space2 :incoming-connectors))
    (if (not (member new-connector (get-values *sx* :static-connections)))
        (append-value *sx* :static-connections new-connector))
    (opal:add-component graphic-display-window-agg new-connector
	  :behind space2)
    (opal:update graphic-display-window)  ))

(defun find-or-create-ps-connector (space1 space2 type)
  (declare (type kr:a-schema-type space1 space2) (type (member string nil) type))
  (let ( (old-connector (find-free-ps-connector)) )
    (if old-connector
       (progn (s-value old-connector :ps1 space1)
              (s-value old-connector :ps2 space2)
              old-connector)
       (create-instance nil ps-connector
          (:ps1 space1)
          (:ps2 space2)
          (:type type)))  ))

(defun find-ps-connector (space1 space2)
  (declare (type kr:a-schema-type space1 space2))
  (do* ( (connections (get-values *sx* :static-connections))
	 (c (pop connections)
	    (pop connections))
         (result nil) )
      ;; stop if
      ((or result (not c))
       result)
    (if (or (and (equal space1 (g-value c :ps1))
		 (equal space2 (g-value c :ps2)))
	    (and (equal space2 (g-value c :ps1))
		 (equal space1 (g-value c :ps2))))
	(setf result c))))


(defun find-free-ps-connector ()
  (do* ( (connections (get-values *sx* :static-connections))
	 (c (pop connections)
	    (pop connections))
         (result nil) )
      ;; stop if
      ((or result (not c))
       result)
    (if (and (not (g-value c :ps1))
             (not (g-value c :ps2)))
	(setf result c))))

(defun untie-two-spaces-together (space1 space2 type)
  (declare (type kr:a-schema-or-nil space1 space2)
           (ignore type)) ;ignore type for now
  ;; space1&2 are sx-problem-spaces, type should be a string
  (let ((connector nil) temp)
  ;; set up variables
  (if (not space1)
      (progn
        (setf connector
           (pick-connector :graphic-query (not static-menu-expert)
               :prompt "Click on the connector you wish to disconnect"))
        (if (not connector)
            (progn (sgd-error "You must pick a connector." nil t)
              (return-from untie-two-spaces-together nil)))
        (setf space1 (g-value connector :ps1))
        (setf space2 (g-value connector :ps2)))
      (progn (setf connector (find-ps-connector space1 space2))
        (if (not (member connector (g-value space1 :outgoing-connectors)))
            (progn (setf temp space1)
                   (setf space1 space2)
                   (setf space2 temp)))))
  (if connector  ;; you could still fail here....
      (progn (s-value space1 :outgoing-connectors
                      (remove connector (g-value space1 :outgoing-connectors)))
         (s-value space2 :incoming-connectors
                  (remove connector
                          (g-value space2 :incoming-connectors)))
         (s-value space1 :outgoing-connectors
                  (remove connector
                          (g-value space1 :outgoing-connectors)))
         (s-value connector :visible nil)
         (s-value connector :ps1 nil)
         (s-value connector :ps2 nil)
         (opal:remove-component graphic-display-window-agg connector)
         (opal:update graphic-display-window))) ))


;;;
;;;	IV.	Static-menu and its window
;;;

(proclaim '(special STATIC-MENU-WINDOW))

(gg:create-pop-up-menu
  :title "Build Static Items"
  :double-buffered-p opal:default-double-buffer-p
  :disappear-after-selection menus-disappear-after-selection
  :menu-window-name 'static-menu-window
  :after-action #'(lambda (x y) (declare (ignore x y))
                    (print-sx-prompt :newline nil))
  :items `(
  ("Create a problem space      " ,(opal:g-inter-lam
     		       (interactive-create-problem-space nil nil :anchored t)))

 ;; ("Create an operator          " ,(opal:g-inter-lam
	;;			       (interactive-create-operator)))

  ("Tie two spaces together     " ,(opal:g-inter-lam
                                    (tie-two-spaces-together nil nil nil)))
  ("Remove a connector          " ,(opal:g-inter-lam
                                    (untie-two-spaces-together nil nil nil)))
  ("Write a file of PSs out     " ,(opal:g-inter-lam (write-static-ps-file t)))
  ("Put away menu               " ,(opal:g-inter-lam
                                      (s-value static-menu-window :visible NIL)
                                        (opal:update static-menu-window)))
 )
 :icon-title  "Static Display Menu"
 :menu-event  :ANY-mouseDOWN
 :click-window nil
 :start-event nil)

(s-value static-menu-window :top 375)


;;;
;;;	V.	Write out static problem spaces
;;;

(defun write-static-ps-file (graphic-p)
 "*Dump a file that can recreate the PSs positions on the screen."
  (declare (type kr:logical graphic-p))
 (let ((default-file (format nil "~a~a"
			     last-static-file static-numeric-extension))  )
 (multiple-value-bind (full-file new-default)
     (dsi-get-file-name graphic-p static-file-name-prompt
                        static-dump-directory default-file
                        static-numeric-extension static-file-extension)
  (if (dsi-file-name-busy? graphic-p full-file)
      (return-from write-static-ps-file nil))
  (if new-default (setq last-static-file new-default))
  (with-open-file (stream full-file :direction :output)
    (format stream
            ";; Problem spaces written by the SX display to be reloadable.")
    (format stream "~2%(in-package \"SX\")~%")
    (dolist (ps (get-values *sx* :problem-spaces))
      (if (not (destroy-p ps))
	  (write-static-ps ps stream)))
    (dolist (connector (get-values *sx* :static-connections))
      (if (g-value connector :visible)
          (write-static-connection connector stream)))
    (format stream "~%"))

 (format t "~%;; Spaces written into ~s." full-file)
 nil)))

;; quote the cons cell that will be put here
(defconstant write-static-ps-template
  "~%(interactive-create-problem-space
    \"~a\"
     '~s  
     :anchored ~s)")

(defun write-static-ps (x &optional (stream t))
  (declare (type kr:a-schema-type x) (stream stream))
  (if (not (g-value x :visible))
      (return-from write-static-ps))
  (format stream write-static-ps-template
	  (g-value x :name-string)
	  (g-value x :point)
	  (g-value x :anchored)))

(defconstant write-static-connection-template
  "~%(tie-two-spaces-together
     ~a
     ~a
     ~s)")

(defun write-static-connection (x stream)
  (declare (type kr:a-schema-type x) (stream stream))
 (if (g-value x :visible)
     (format stream write-static-connection-template
    	(g-value x :ps1 :name-string)
        (g-value x :ps2 :name-string)
        (g-value x :type))  )
 nil)

#|

;; Examples:
;;

(interactive-create-problem-space
    "Space1"
    '(78 . 101)
     :anchored t)

(interactive-create-problem-space
    "Pick-ops"
    '(18 . 260)
    :anchored t)

(interactive-create-problem-space
    "Do-ops"
    '(222 . 268)
    :anchored t)

|#

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/restart-and-init.lisp".
;;;; -*- Mode: Lisp; package: sx -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : restart-and-init.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Wed Jan 22 11:54:20 1992
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Sat Mar  7 10:31:02 1992
;;;; Update Count    : 15
;;;; 
;;;; PURPOSE
;;;;	This file contains two functions: initialize-sx and restart-sx. 
;;;; They called by init-soar and restart-soar.
;;;; TABLE OF CONTENTS
;;;;	i.	Declarations & proclaims
;;;;	I.	Restart-sx
;;;;	II.	hide-invisible-windows
;;;;	III.	reset-sx
;;;; 
;;;; Copyright 1992, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; HISTORY
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: no doc-strings; no proclaim vars funs; no declares


;;;
;;;	i.	Declarations & proclaims
;;;

(eval-when (load eval compile)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(function restart-sx () t))
  (proclaim '(function hide-invisible-windows () t))
  )



;;;
;;;	I.	Restart-sx
;;;

(defun restart-sx ()
  #-release-sx"Set up the SX after a sysout comes up."
  (s-value sgd-error :string
	   (format nil "~a~%~a" "Surf's up!" error-string-postfix))
  (opal:reconnect-garnet)
  (soarresetsyntax)
  (attempt-to-load-lisp-init-file)
  (load-soar-init-file ".soar-init.lisp")
  (format t "~%; Attempting to load .sx-init.lisp from the home directory.")
  (load-soar-init-file ".sx-init.lisp")
  (update-with-sx-defaults)
  (s-value graphic-display-window :title
	   (format nil "Soar Graphic Display ~a @ ~a"  *sx-version*
                    (host-name)))
  (sx-banner)
  (hide-invisible-windows)
  (opal:update (g-value sgd-error :window))
  (s-value gdw-popup-menu-window
           :disappear-after-selection menus-disappear-after-selection)
  (s-value gdw-popup-menu-window :visible menus-disappear-after-selection)
  (soarsyntax)
  ;; sure seems to need this....3-Feb-92 -FER
  ;(format t "~% Hooking up text...")
  ;; these are magic 4-Feb-92 -FER
  ;(warm-up-display)
  ;(warm-up-display)
  ;(dolist (txt (opal::all-the-instances opal:text))
  ;  (if (and (g-value txt :window)
  ;           (g-value txt :font))
  ;      (recompute-formula txt :xfont)))
  t)

;(defun warm-up-display ()
;    (let ((display (let ((win1 (caar (opal::get-table-contents))))
;		       (if win1
;			   (xlib:window-display win1)
;                           opal::*default-x-display*))))
;        (cond ( (listen *standard-input*) 
;		(opal::garnet-lisp-repl) )
;	      ( (xlib:event-listen display)
;                ;; uses keyword based event-handler sent to Garnet Fall 90
;                (opal::default-event-handler display :timeout 0) )
;              ( t (sleep opal::grepl-loop-sleep-time) ))
;   (xlib:event-case (display :discard-p t :timeout 5) ; discard current event
;     (otherwise () t))))


;;;
;;;	II.	hide-invisible-windows
;;;

(defun hide-invisible-windows ()
  ;; to be honest, I'm not sure why this works, but the order of calling
  ;; the default even handler seems important.
  ;; seems to run better interpreted than compiled
   (let* ((win1 (caar (opal::get-table-contents)))
          (display (if win1
		       (xlib:window-display win1)
                       opal::*default-x-display*)))
   (sleep 4.5)
   (opal::default-event-handler display :timeout 0)     
   (format t "~%; Hiding invisible windows: ")
   (sleep 2.5)
   (mapc #'(lambda (x)
	    (s-value x :visible nil)
	    (opal:update x)
            (format t ".")
            (sleep 2.5))
        opal::*invisible-windows-which-have-been-closed*)
   (opal::default-event-handler display :timeout 0) 
   t))


;;;
;;;	III.	reset-sx
;;;

;(defun reset-sx (&optional (query-to-blast-window t))
;  "*Init-soar and if optional argument QUERY-TO-BLAST-WINDOW is t,
;recreate the SX graphic display."
;   (init-soar)
;   (if (and query-to-blast-window
;	    (y-or-n-p "Do you want to Destroy the graphic context window? "))
;       (sx:reinit-sx)))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/chunks.lisp".
;;;; -*- Mode: lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : chunks.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jan 28 11:23:53 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:13:03 1992
;;;; Update Count    : 117
;;;; Soar Version    : 5.2.2
;;;; Taql Version    : 3.1.2
;;;; 
;;;; PURPOSE
;;;; 	|>Description of module's purpose<|
;;;; TABLE OF CONTENTS
;;;;	i.	Inits
;;;;	I.	Chunk code
;;;;	II.	Pops & chunks
;;;;	III.	Setup existing chunks
;;;;	IV.	Cleanup chunks
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Optimizations:  doc-strings; declares; proclaims

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
 (proclaim '(list *chunk-pool* *pops*))
 (proclaim '(type kr:a-schema-or-nil sx-pop))
 (proclaim '(function unselect-chunks () nil))
 (proclaim '(function unfire-chunks () nil))
 )


;;;
;;;	i.	Inits
;;;

(defconstant chunk-size (idivide problem-space-size 12)
  #-:release-sx"Size of chunk in pixels.")

(defconstant 3chunk-size (* 3 chunk-size)
  #-:release-sx"Size of 3 chunks in pixels.")

(defconstant chunks-per-layer  (idivide problem-space-size chunk-size)
  #-:release-sx"Number of chunks per layer of wall.")

(defparameter *chunk-pool* nil
  #-:release-sx"Where unused chunks hang out.")


;;;
;;;	I.	Chunk code
;;;

(create-instance 'sx-chunk sx-context-item
 ;; point is top left
 ;; when they are created, they are noted as selected, and this is
 ;; then stored as latest-chunks (sp), but not really selected
 ;; as the :selected
 ;; slot of *sx*
 ;;
 ;; Variables initially NIL (so why initialize them?):
 ;; (:previous-chunk nil) ;the chunk graphically to your left
 ;; (:problem-space nil)
 ;; (:fired nil) ;after firing set to t for 1 cycle
 (:visible (o-formula (and (gvl :problem-space :visible)
                           (gvl :problem-space :graphic :window))))
 (:height (+ chunk-size (g-value name-tag :height)))
 (:text-visible (o-formula (and (gv *sx* :chunk-id-visible)
                                (or (gvl :fired) (gvl :selected)))))
 (:text-left (o-formula (gvl :graphic :left)))
 (:text-top (o-formula (- (gvl :graphic :top) (* 2 (gvl :size)))))
 (:row 0)  ;; now just used as a debugging flag... FER 29sept91
 ;; point is top-left
 (:point (o-formula
  (let ((starting-point (or (gvl :previous-chunk) (gvl :problem-space)))
        (first-chunkp (eq (gv :self)
                          (first (get-values (gvl :problem-space) :chunks)))))
    ;; (format t "~% sp: ~s fc: ~s " starting-point first-chunkp)
    ;; (format t "~% ~s ~s " (g-value starting-point :left)
    ;;        (gvl :problem-space :left) )
    ;; this should be split in two after debugged
   (cond ( (or first-chunkp  ;; initial chunk, or row too wide
               (> (+ (gv starting-point :left) 3chunk-size)
                  (+ (gvl :problem-space :left)
                     problem-space-size problem-space-size
                     quarter-problem-space-size)))
           ;; (format t "~% chunkp first-chunkp: ~s " (gv starting-point :row))
           (s-value (gv :self) :row (1+ (gv starting-point :row)))
           (cons (+ (gvl :problem-space :left)
                    problem-space-size ;problem-space-size
                    quarter-problem-space-size
                    (if (evenp (gvl :row)) 0 chunk-size))
                 (if first-chunkp
                     (+ -1 (gvl :problem-space :graphic :top)
                        problem-space-height)
                   (- (cdr (gv starting-point :point))
                      chunk-size))))
          ;; typical chunk
         (t (s-value (gv :self) :row  (gv starting-point :row))
            (cons (+ (car (gv starting-point :point))
                     chunk-size chunk-size)
                  (cdr (gv starting-point :point))))))))
  (:size chunk-size)
  (:parts `(
    (:name ,name-tag
        (:string ,(o-formula (gvl :parent :name-string))))
    (:graphic ,opal:rectangle
      (:left ,(o-formula (car (gvl :parent :point))))
      (:top ,(o-formula (cdr (gvl :parent :point))))
      ;(:width ,(o-formula (* (gvl :size) 2)))
      ;(:height ,(o-formula (gvl :size)))
      (:width ,(* chunk-size 2))
      (:height ,chunk-size)
      (:line-style ,(o-formula
                         (cond ;((and (gvl :parent :selected)
                               ;      (gvl :parent :fired))
                               ;  opal:line-8)
                               ((gvl :parent :selected) opal:line-3)
                               ((gvl :parent :fired) cline-style)
                                (t opal:thin-line))))
      (:filling-style ,(o-formula
                         (cond ((gvl :parent :selected) opal:white-fill)
                               ((gvl :parent :fired) opal:light-gray-fill)
                               (t opal:white-fill))))
      (:visible ,(o-formula (gvl :parent :visible)))
      (:size ,(o-formula (gvl :parent :size)))
     ))))

(eval-when (compile eval load)
  (proclaim '(ftype (function (symbol &optional kr:a-schema-type) t) add-chunk))
  (proclaim '(special chunk-spot spot2)))

(defun add-chunk (chunk-name &optional problem-space)
#-release-sx"Add a chunk to the graphic display."
  (declare (symbol chunk-name))
  (or problem-space
      (setf problem-space
            (let* ((ps-name (find-production-ps chunk-name))
                   (simple-ps (get-sx-item ps-name :problem-space)))
              (if simple-ps
                  simple-ps
                  (let ((nps (interactive-create-problem-space
                                (or ps-name 'top-ps)
                                default-point
                                *default-ps-anchored*))  )
                    (s-value nps :visible nil)
                    nps)))))
 (let ((no-window (not (g-value problem-space :window)))
       (no-visible (not (g-value problem-space :visible))) )
 ;; require the PS to be visible so that chunk has a proper birth
 (cond
   ( (or no-window no-visible)
     (if no-window
         (opal:add-component graphic-display-window-agg problem-space
                             :behind gd-top-status-line))
     (if no-visible (s-value problem-space :visible t))
     (if (not (g-value problem-space :point))
         (s-value problem-space :point default-point))
     (opal:update graphic-display-window)
     (add-chunk chunk-name problem-space)
     (s-value chunk-spot :selected nil)
     (g-value chunk-spot :graphic :line-style)
     (opal:update graphic-display-window)
     (opal:remove-component graphic-display-window-agg problem-space)
     (s-value problem-space :point nil)
     (opal:update graphic-display-window)
    )
   (t
    ;(format t "cunk pool is %s~%" *chunk-pool*)
    (let* ( (better-chunk-name
             (intern (symbol-name chunk-name)
                     (find-package "SX")))
              ;          (intern (string-upcase (format nil "~a" chunk-name))
              ;                  (find-package "SX"))
             (latest-chunk (g-value problem-space :latest-chunk))
             (result (or (set better-chunk-name (pop *chunk-pool*))
                         (create-instance better-chunk-name sx-chunk))))
      (setf (kr::schema-name result) better-chunk-name)
      (setf chunk-spot result)
      (if latest-chunk
          (s-value latest-chunk :following-chunk result))
      (s-value result :id chunk-name)
      (s-value result :name-string (symbol-name chunk-name))
      (s-value result :problem-space problem-space)
      (s-value result :previous-chunk latest-chunk)
      (append-value problem-space :chunks result)
      (s-value problem-space :latest-chunk result)
      (opal:add-component graphic-display-window-agg result
                          :behind gd-top-status-line)
      (append-value *sx* :latest-selected-chunks result)
      (s-value result :selected t)
      (g-value result :point) ;make it set its point
      (opal:update graphic-display-window)
      (push result *sx-chunks*)
      t))  )))

;(defun add-chunk (chunk-name &optional problem-space)
;  (declare (symbol chunk-name))
; "Add a chunk to the graphic display."
; (or problem-space
;     (setf problem-space
;           (let* ((ps-name (find-production-ps chunk-name))
;                  (simple-ps (get-sx-item ps-name :problem-space)))
;             (if simple-ps
;                 simple-ps
;                 (create-problem-space nil nil (or ps-name "top-ps") )))))
; ;; require the PS to be visible so that chunk has a proper birth
; (cond
;   ( (not (g-value problem-space :window))
;     (opal:add-component graphic-display-window-agg problem-space
;                        :behind gd-top-status-line)
;     (add-chunk chunk-name problem-space)
;     (s-value chunk-spot :selected nil)
;     (g-value chunk-spot :graphic :line-style)
;     (opal:remove-component graphic-display-window-agg problem-space))
;   ( (not (g-value problem-space :visible))
;     (s-value problem-space :visible t)
;     (add-chunk chunk-name problem-space)
;     (s-value chunk-spot :selected nil)
;     (g-value chunk-spot :graphic :line-style)     
;     (s-value problem-space :visible nil))
;   (t
;    (let* ( (better-chunk-name
;             (intern (symbol-name chunk-name)
;                     (find-package "SX")))
;            (latest-chunk (g-value problem-space :latest-chunk))
;            (result (or (pop *chunk-pool*)
;                        (create-instance better-chunk-name sx-chunk))) )
;      (s-value result :id chunk-name)
;      (s-value result :name-string (symbol-name chunk-name))
;      (s-value result :problem-space problem-space)
;      (setf chunk-spot result)
;      (s-value result :previous-chunk latest-chunk)
;      (s-value latest-chunk :following-chunk result)
;      (append-value problem-space :chunks result)
;      (s-value problem-space :latest-chunk result)
;      (opal:add-component graphic-display-window-agg result
;                          :behind gd-top-status-line)
;      (s-value result :selected t)
;      (append-value *sx* :latest-selected-chunks result)
;      (opal:update graphic-display-window)
;      (push result *sx-chunks*)
;      (g-value result :point) ;make it set its point
;      result))  ))


(eval-when (compile eval load)
           (proclaim '(ftype (function () t) sx-excise-chunks)))

(defun sx-excise-chunks ()
 (mapc 'excise-graphic-chunk *sx-chunks*)
 (setq *sx-chunks* nil)
 (mapc #'(lambda (x) (if x (progn (s-value x :latest-chunk nil)
                                  (set-values x :chunks nil)
                                  (mark-as-changed x :chunks) )))
       (get-values *sx* :problem-spaces))
 t)

(eval-when (compile eval load)
           (proclaim '(ftype (function (kr:a-schema-type) t) excise-graphic-chunk)))

(defun excise-graphic-chunk (achunk)
  (declare (type KR:A-SCHEMA-TYPE achunk))
  (if (not achunk) (return-from excise-graphic-chunk nil))
  (let* ( (ps (g-value achunk :problem-space))
          (previous-chunk (g-value achunk :previous-chunk))
          (following-chunk (g-value achunk :following-chunk)) )
    (if (not ps) (progn
                   (format t "~% ~s already excised." achunk)
                   (return-from excise-graphic-chunk nil)))
    (opal:remove-component graphic-display-window-agg achunk)
    (opal:remove-component ps achunk)
        (set-values ps :chunks (delete achunk (get-values ps :chunks)))
        (s-value achunk :problem-space nil)
        (cleanup-pop achunk)
        (cond ((and previous-chunk
                    (eq sx-chunk (g-value previous-chunk :is-a))
                    following-chunk
                    (eq sx-chunk (g-value following-chunk :is-a)))
               (s-value previous-chunk :following-chunk following-chunk)
               (s-value following-chunk :previous-chunk previous-chunk))
              ((and previous-chunk
                    (eq sx-chunk (g-value previous-chunk :is-a)))
               (s-value previous-chunk :following-chunk nil))
              ((and following-chunk
                    (eq sx-chunk (g-value following-chunk :is-a)))
               (s-value following-chunk :previous-chunk previous-chunk))
              (t ;; it was first chunk alone
               nil) )
        (if (eq achunk (g-value ps :latest-chunk))
            (s-value ps :latest-chunk previous-chunk))
	(unintern (find-symbol (g-value achunk :name :string))
		  (find-package "SX"))
        (push achunk *chunk-pool*))
   (opal:update graphic-display-window)
   t)

(eval-when (compile eval load)
  (proclaim '(ftype (function (kr:a-schema-type) KR::A-FORMULA) compute-next-chunk)))

(defun compute-next-chunk-location (problem-space)
#-release-sx "Compute where the point of the next chunk in PROBLEM-SPACE goes,
returns a formula that cons."
  (declare (type KR:A-SCHEMA-TYPE problem-space))
 ;packs them in a plain wall, no overlap yet
 (let* ( (latest-chunk  (g-value problem-space :latest-chunk))
         (starting-point (or latest-chunk
                             (g-value problem-space :chunk-wall)))   )
   (cond ( (not latest-chunk) ;1st chunk
           `(o-formula
               (cons (+ (car (gv ,starting-point :point))
                         chunk-size))
                     (- (cdr (gv ,starting-point :point)
                                chunk-size))))
         ;; too big, wrap
         ( (= 0 (mod (length (get-values problem-space :chunks))
                     chunks-per-layer))
           `(o-formula
            (cons (- (car (gv ,starting-point :point))
                               (gv problem-space :chunk-wall :size)))
                  (- (cdr (gv ,starting-point :point)
                                chunk-size))))
         ;; plain old
         ( t
           `(o-formula
            (cons   (+ (car (gv ,starting-point :point))
                               chunk-size))
                    (cdr (gv ,starting-point :point)))))  ))


;;;
;;;	II.	Pops & chunks
;;;

(defparameter *pops* nil
  #-release-sx"The pop pool.")
(defconstant initial-pops 5)

(eval-when (compile eval load)
  (proclaim '(ftype (function () t) intialize-chunks)))

(defun initialize-chunks ()
 "*Creates graphic-chunks for chunks that are on *chunks* that don't have them,
and calls ptrace on them too."
 (mapc #'find-or-add-chunk soar:*chunks*)
 (mapc #'(lambda(x) (eval (list 'ptrace x)))  soar:*chunks*)
 (unselect-chunks)
 (opal:update graphic-display-window)
 t)

(eval-when (compile eval load)
  (proclaim '(ftype (function (symbol) t) find-or-add-chunk)))

(defun find-or-add-chunk (achunk)
#-release-sx
 "Find or create a graphical chunk for ACHUNK."
  (declare (type KR:A-SCHEMA-TYPE achunk))
  (let ( (graphic-chunk (get-sx-item achunk nil)) )
    (if (not (and graphic-chunk
                  (g-value graphic-chunk :problem-space)))
        (add-chunk achunk)))
  t)


(eval-when (compile eval load)
  (proclaim '(ftype (function (string) t) fire-graphic-rule)))

(defun fire-graphic-rule (rule-name)
#-release-sx"Set the RULE-NAME to be selected for a cycle if its a chunk."
  (declare (string rule-name))
 (let* ( (sx-rule-name (sintern rule-name (find-package "SX")))
         (real-chunk (and (boundp sx-rule-name) (eval sx-rule-name)))  )
   #-release-sx(setq spot2 rule-name)
   (cond (real-chunk
          (s-value real-chunk :fired t)
          (append-value *sx* :latest-fired-chunks real-chunk)
          (give-pop real-chunk)
          (opal:update graphic-display-window)
          (if chunk-beep-on-fire
              (inter:beep)) ))
 t))

(eval-when (compile eval load)
  (proclaim '(ftype (function (kr:a-schema-type) t) give-pop)))

(defun give-pop (chunk)
#-release-sx "Give CHUNK an pop."
  (declare (type kr:a-schema-type chunk))
 (let ((pop (get-pop))
       (old-pop (g-value chunk :pop)) )
  (cond (old-pop 
         (cleanup-pop chunk)
         (give-pop chunk))
        (t (s-value chunk :pop pop)
           (s-value pop :chunk chunk)
           (s-value pop :point (g-value chunk :point))
           (opal:add-component graphic-display-window-agg pop
                               :behind gd-top-status-line))))
 t)

(eval-when (compile eval load)
  (proclaim '(ftype (function (kr:a-schema-type) t) cleanup-pop)))

(defun cleanup-pop (achunk)
#-release-sx"Clean up the pop of achunk, if any."
  (declare (type kr:a-schema-type chunk))
 (let ((pop (g-value achunk :pop)))
  (if (not pop) (return-from cleanup-pop nil))
  (push pop *pops*)
  (s-value pop :chunk nil)
  (s-value achunk :pop nil)
  (opal:remove-component graphic-display-window-agg pop))
 t)

(create-instance 'sx-pop opal:polyline
    ;; (:selected nil)
    ;; (:chunk nil) ;the chunk it is assigned to
    ;; point is top left point (it appears?)
    (:point (cons 150 50))
    (:filling-style opal:light-gray-fill)
    (:line-style (o-formula (if (gvl :selected)
                                line-6
                                opal:line-3)))
    (:point-list
        (o-formula 	  ;; assumes an 8 sized block
           (let* ( (start (gvl :point))
                   (x (car start))
                   (y (cdr start))    )
             (list (+ x -3) (+ y  9)  ; lower left
                   (+ x  2) (+ y 11)  ;2
                   (+ x  6) (+ y  8)  ;3
                   (+ x 11) (+ y 11)  ;4
                   (+ x 18) (+ y 12)  ;5
                   (+ x 17) (+ y  4)  ;6
                   (+ x 20) (+ y  2)  ;7
                   (+ x 16) (+ y -5)
                   (+ x 10) (+ y -1)
                   (+ x  5) (+ y -7)
                   (+ x -3) (+ y  0)
                   (+ x  0) (+ y  4)
                   ;; close it off
                   (+ x -3) (+ y  9)  ; lower left
             )))))

(eval-when (compile eval load)
  (proclaim '(ftype (function () kr:a-schema-type) get-pop)))

(defun get-pop ()
#-release-sx"Return an pop from the pool."
  (let ((exp (cond (*pops* (pop *pops*))
                   (t (create-instance nil sx-pop)))))
       (if (destroy-p exp)
           (get-pop)
           exp)))

(eval-when (compile eval load)
  (proclaim '(ftype (function () nil) init-pops)))

(defun init-pops ()
#-release-sx
 "Create the initial pop pool."
 (dotimes (i 1 initial-pops)
     (push (create-instance nil sx-pop)
           *pops*)))


;;;
;;;	III.	Setup existing chunks
;;;

;; check here to see if you are loading on a soar with chunks
(if soar::*chunks*
    (sx:initialize-chunks))


;;;
;;;	IV.	Cleanup chunks
;;;

(defun unfire-chunks nil
 #-release-sx"Clear out the fired chunks."
 (mapc #'(lambda (x) (cond (x (s-value x :fired nil)
                                (cleanup-pop x))))
       (get-values *sx* :latest-fired-chunks))
 (set-values *sx* :latest-fired-chunks nil)
 nil)

(defun unselect-chunks nil
 #-release-sx"Clear out the selected chunks"
 (mapc #'(lambda (x) (declare (type kr:a-schema-type x))
           (and x (s-value x :selected nil)))
       (get-values *sx* :latest-selected-chunks))
 (set-values *sx* :latest-selected-chunks nil)
 nil)

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/pscm-windows.lisp".
;;;; -*- Mode: lisp; Syntax: Common-Lisp; Package: sx; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : pscm-windows.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Jan 29 17:42:28 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:43:03 1992
;;;; Update Count    : 394
;;;; Soar Version    : 5.2
;;;; Taql Version    : 3.1.2
;;;; 
;;;; PURPOSE
;;;; 	Display examiners of problem spaces, to examine them, and edit? them.
;;;; TABLE OF CONTENTS
;;;;
;;;;	i.	Constants and variables
;;;;
;;;;	I.	Dead code
;;;;	II.	popup-pscm-examiner and its helpers
;;;;	III.	popup-ps-examiner and create-ps-examiner
;;;;    IV.	the pscm-examiner
;;;;    V.	the ps-examiner and methods
;;;;    VI. 	the goal-examiner
;;;;    VII. 	the state-examiner
;;;;    VIII. 	the op-examiner
;;;;	IX.	the wm-examiner
;;;;    X.	pscm-examiner methods
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares; lambda
;;;
;;; Problems/bugs/suggestions:
;;;
;;;

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(function wm-string-to-value (string) symbol))
  (proclaim '(function wm-selection-function (kr:a-schema-type kr:a-schema-type) nil))
  (proclaim '(function popup-pscm-examiner (kr:a-schema-or-nil) nil))
  (proclaim '(function find-pscm-examiner (kr:a-schema-type) kr:a-schema-or-nil))
  (proclaim '(function find-op-examiner (kr:a-schema-type) kr:a-schema-or-nil))
  (proclaim '(function popup-pscm-examiner-with-hour-glass (kr:a-schema-type)
              nil))
  (proclaim '(function toggle-anchored-button (kr:a-schema-type kr:logical)
              kr:logical))
  (proclaim '(function popup-ps-examiner (kr:a-schema-type) nil))
  (proclaim '(function create-ps-examiner (kr:a-schema-type) kr:a-schema-type))
  (proclaim '(function create-goal-examiner (kr:a-schema-type) kr:a-schema-type))
  (proclaim '(function popup-goal-examiner (kr:a-schema-type) nil))
  (proclaim '(function popup-object-y (kr:a-schema-type) integer))
  (proclaim '(function popup-object-x (kr:a-schema-type) integer))
  (proclaim '(function create-state-examiner (kr:a-schema-type) kr:a-schema-type))
  (proclaim '(function popup-state-examiner (kr:a-schema-type) nil))
  (proclaim '(function create-op-examiner (kr:a-schema-type) kr:a-schema-type))
  (proclaim '(function popup-op-examiner (kr:a-schema-type) nil))
  (proclaim '(list wm-examiner-examiners-list))
  (proclaim '(function create-wm-examiner (kr:a-schema-type) kr:a-schema-type))
  (proclaim '(function popup-wm-examiner (kr:a-schema-type integer integer) nil))
  (proclaim '(function find-wm-examiner (kr:a-schema-type) kr:a-schema-or-nil))

  )

;;;
;;;	i.	Constants and variables
;;;

(defconstant create-ps-examiner-not-ps-error-message
  "A problem space must
 first be selected.")

(defconstant popup-pscm-examiner-not-pscm-error-message
  "A PSCM level item must first be selected.")

;;;
;;;	ii.	helper funs
;;;

(defun wm-string-to-value (astring)
  (declare (string astring))
  (read-from-string astring nil 'error-wm-string-to-value
               :start (position  #\  astring)))


(defun wm-selection-function (item menu)
  (declare (type kr:a-schema-type item menu))
  (if (soar:wm-structure? (wm-string-to-value (g-value item :item)))
      (popup-wm-examiner (wm-string-to-value (g-value item :item))
          (mod (+ 15 (g-value menu :window :left)) opal::*screen-width*)
          (mod (+ 15 (g-value menu :window :top)) opal::*screen-height*))
      (inter:beep))
  nil)


;;;
;;;	I.	Dead code
;;;


;;;
;;;	II.	popup-pscm-examiner and its helpers
;;;

(defun popup-pscm-examiner (object)
  #-release-sx"Create a examiner to examine and poke at pscm components."
  (declare (type kr:a-schema-or-nil object))
  (let ( (pscm (or object (g-value *sx* :selected-items)) ))
    (cond ( (null pscm)
            (sgd-error popup-pscm-examiner-not-pscm-error-message nil t) )
          ( (is-a-p pscm sx-problem-space)
	    (popup-ps-examiner pscm))
	  ( (is-a-p pscm sx-goal)
	    (popup-goal-examiner pscm))
	  ( (is-a-p pscm sx-state)
	    (popup-state-examiner pscm))
	  ( (is-a-p pscm sx-operator)
	    (popup-op-examiner pscm))
          (t (sgd-error popup-pscm-examiner-not-pscm-error-message nil t)))
    ;; maybe invisible (on creation)
    (if (schema-p pscm)
        (progn (s-value (g-value pscm :examiner :window) :visible t)
           (recompute-formula *sx* :live-windows)
           ;;slight redundancy here, but small code
           (update-examiner-windows)
           (gg:popup-window (g-value pscm :examiner :window)
                            :pop-to-last-mouse nil)))
    nil))

(defun find-pscm-examiner (object)
  (declare (type kr:a-schema-type object))
  (let ( (examiner (g-local-value object :examiner)) )
    (cond ( (and examiner (not (destroy-p examiner)))
         ;; (gg:popup-window (g-value examiner :window) :pop-to-last-mouse nil)
	    examiner))))

(defun find-op-examiner (object)
  (declare (type kr:a-schema-type object))
  ;; if you are a daughter, use your father
  (if (not (eq sx-operator (g-value object :is-a)))
      (setf object (g-value object :is-a)))
  (let ( (examiner (g-local-value object :examiner)) )
    (cond ( (and examiner (not (destroy-p examiner)))
	    examiner))))

(defun popup-pscm-examiner-with-hour-glass (ps)
  (declare (type kr:a-schema-type ps))
  #-release-sx"Create a examiner with the hour-glass set."
   (opal:garnet-inter-unwind-stuff (popup-pscm-examiner ps))
   nil)


;;;
;;;	IV.	The pscm-examiner
;;;

(proclaim '(special pscm-examiner wm-examiner))
	  
(create-instance 'PSCM-EXAMINER opal:aggregadget
   ;; initially nil items:
   ;; (:wm-items) ;should be strings for now, set with get-wmparts
   ;; (:pscm-object) ;the sx object  hangs out here
   ;; (:parent-window NIL)    ;; The parent of the ps-examiner
   (:width 180)
   (:height 120)
   (:visible t)
   ;; If there is no parent window, the ps examiner is created @ (200,200).
   (:window-left 0) ;(o-formula (if (gvl :parent-window)
		                   ;(- (floor (gvl :parent-window :width) 2)
			           ;   (floor (gvl :window-width) 2))
                                   ;(opal:gv-right (gvl :pscm-object))))
   (:window-top 0) ;(o-formula (if (gvl :parent-window)
			;       (- (floor (gvl :parent-window :height) 2)
				;  (floor (gvl :window-height) 2))
			       ;(gvl :pscm-object :top)))
   (:window-width (o-formula (+ 16 (gvl :width))))    ; 10 on each side
   (:window-height (o-formula (+ 32 (gvl :height))))  ; 20 on top, bottom

   (:destroy 'PSCM-Examiner-Destroy)
   (:title (o-formula (format nil "~a (~a)"
			      (gvl :pscm-object :name-string)
			      (gvl :pscm-object :id))))
   (:parts `(
     ;; this indicates by a slash that the window should not be updated
     ;; b/c the object is dead
     (:dead-head ,opal:line
         (:line-style ,cline-style)
         ;; a slash from upper right to lower left
         (:x1 100)         (:y1 0)
         (:x2 0)           (:y2 100)
         (:visible ,(o-formula
                     (let ( (pscm-object (gvl :parent :pscm-object)) )
                       (cond ((is-a-p (gvl :parent) wm-examiner)
                              (not (wm-structure? pscm-object)))
                             ((destroy-p pscm-object) T)
                             (t (not (wm-structure? (gv pscm-object :id))))))))
         )
     (:put-me-away ,put-me-away-button)      )))


;;;
;;;	V.	the ps-examiner
;;;

;; NOTE:  If :parent-window is specified, then the parent window must already
;; have been opal:update'd when the instance of ERROR-GADGET is created.

(proclaim '(special ps-examiner))

(create-instance 'PS-EXAMINER pscm-examiner
  (:width 325)
  (:height 210)
  (:parts `(
    (:anchor-button ,gg:X-BUTTON
      (:text-on-left-p nil)
      (:left 10)
      (:top  ,(o-formula (- (gvl :parent :window :height) 5
	                    (gvl :height))))
      (:string "Anchored")
      (:shadow-offset 0) (:text-offset 5) (:gray-width 3)
      (:selection-function
        ,#'(lambda (&optional x y)
	     (toggle-anchored-button x y))))
    (:from-goal ,hot-text
      (:top 10)   (:left 10)  (:title "G:")
      (:object ,(o-formula (gvl :parent :pscm-object :goal))))
    (:state ,hot-text
       (:left 10)       (:title "S:")
       (:top ,(o-formula (+ 5 (opal:gv-bottom (gvl :parent :from-goal)))))
       (:object ,(o-formula (gvl :parent :pscm-object :latest-state))))
    (:operator ,hot-text
      (:left 10)      (:title "O:")
      (:top ,(o-formula (+ 5 (opal:gv-bottom (gvl :parent :state)))))
      (:object ,(o-formula (gvl :parent :pscm-object :latest-operator))))
    (:to-goal ,hot-text
       (:top ,(o-formula (+ 5 (opal:gv-bottom (gvl :parent :operator)))))
       (:left 10)    (:title "I:")
       (:object ,(o-formula (gvl :parent :pscm-object :goal :subgoal))))
    (:wm-menu ,pscm-examiner-scrolling-menu
      ; (:top ,(o-formula (+ 10 (opal:gv-bottom (gvl :parent :to-goal)))))
       (:top ,(o-formula (gvl :parent :possible-menu :top)))
       (:visible t)
       (:items ,(o-formula (or (gvl :parent :wm-items)
			       '(""))))
       (:title "Problem Space WMEs")
       (:menu-selection-function
	,#'(lambda (menu item)
	     (declare (type kr:a-schema-type menu item))
             (opal:garnet-inter-unwind-stuff
              (wm-selection-function item menu))))
         )
    (:proposed-menu ,pscm-examiner-scrolling-menu
       (:top 5)
       (:left ,(o-formula (+ 5 (opal:gv-right (gvl :parent :wm-menu)))))
       (:visible t) ;(o-formula (gvl :parent :show-proposed))
       (:items ,(o-formula (or (gvl :parent :proposed-operators)
			       '(""))))
       (:title "Operator Preferences"))
      ;;,(o-formula (+ 5 (or (opal:gv-bottom (gvl :parent :wm-menu))
      ;;                 (opal:gv-bottom (gvl :parent :to-goal)))))
    (:possible-menu ,pscm-examiner-scrolling-menu
      (:top ,(o-formula (+ 5 (opal:gv-bottom (gvl :parent :proposed-menu)))))
      (:left ,(o-formula (+ 5 (opal:gv-right (gvl :parent :wm-menu)))))
      (:title "Fired Operator Types")
      (:visible t) ;(o-formula (gvl :parent :show-possible))
      (:item-font ,opal:font-fixed-bold-medium)
      (:menu-selection-function
         ,#'(lambda (menu item)
              (declare (ignore menu) (type kr:a-schema-type item))
              (popup-pscm-examiner-with-hour-glass (g-value item :item)) ))
      (:item-to-string-function
	,#'(lambda (item)
             (declare (type kr:a-schema-type item))
	     (if (and item (not (stringp item)))
		 (g-value item :name-string)
		 "")))
      (:items ,(o-formula
                (progn 
                (gvl :parent :pscm-object :latest-operator)
		(or ;(and ;(format t "~% >> doing items with value ~s"
			  ;      (gvs (gvl :parent :pscm-object) :operators))
			; nil)
                    (mapcan #'(lambda (x)
                                (declare (type kr:a-schema-or-nil x))
			      (if (and x ; x can be nil?
				       (eq sx-operator (g-value x :is-a)))
				  (list x)))
			    (gvs (gvl :parent :pscm-object) :operators))
		   '(""))))))
   :put-me-away
   :dead-head)))

;    (:x-choices ,gg:x-set-function-button-panel
;      (:left 200)       (:top 2)
;      (:items ("ps-wmes"))
;      (:set-function ,#'(lambda (examiner)
;                          (s-value (g-value examiner :parent) :show-wmes t)))
;      (:unset-function ,#'(lambda (examiner)
;                     (s-value (g-value examiner :parent) :show-wmes nil))) )
;    (:x-choices2 ,gg:x-set-function-button-panel
;      (:left 200)       (:top 26)
;      (:items ("proposed ops"))
;      (:set-function ,#'(lambda (examiner)
;                      (s-value (g-value examiner :parent) :show-proposed t)))
;      (:unset-function ,#'(lambda (examiner)
;                    (s-value (g-value examiner :parent) :show-proposed nil))))
;    (:x-choices3 ,gg:x-set-function-button-panel
;       (:left 200)       (:top 50)
;       (:items ("Fired ops"))
;       (:set-function ,#'(lambda (examiner)
;                       (s-value (g-value examiner :parent) :show-possible t)))
;    (:unset-function ,#'(lambda (examiner)
;                   (s-value (g-value examiner :parent) :show-possible nil))))


(defun toggle-anchored-button (x y)
  (declare (type kr:a-schema-type x) (type kr:logical y))
  (s-value (g-value x :parent :pscm-object) :anchored y))

(define-method :soar-update ps-examiner (schema)
 ;; we're cas' at this point
 (let* ( (pscm-object-id (g-value schema :pscm-object :id))
         (pscm-object-goal (g-value schema :pscm-object :goal))
         (pscm-object-goal-id (if pscm-object-goal
                                  (g-value pscm-object-goal :id))) )
 (s-value schema :wm-items (soar::get-wmparts pscm-object-id))
 (s-value schema :proposed-operators
         (if pscm-object-goal-id
             (proposed-operators (g-value schema :pscm-object :goal :id))))
 ;;(format t " in :soar-update  ")
 (opal:notice-items-changed (g-value schema :wm-menu :menu-item-list))
 ;(opal:notice-items-changed (g-value schema :wm-menu :menu-item-list :items))
 (opal:notice-items-changed (g-value schema :proposed-menu :menu-item-list))
 (opal:notice-items-changed (g-value schema :possible-menu :menu-item-list)) 
 (opal:update (g-value schema :window)) ))


;;;
;;;	III.	popup-ps-examiner and create-ps-examiner
;;;  

(defun popup-ps-examiner (ps)
  (declare (type kr:a-schema-type ps))
  #-release-sx"Create a examiner to examine and poke at problem spaces."
  (cond ( (not (is-a-p ps sx-problem-space))  ; have to have a ps
          (sgd-error create-ps-examiner-not-ps-error-message nil t) )
        ( (let ((examiner (or (find-pscm-examiner ps)
                              (create-ps-examiner ps)))
                (start-y (popup-object-y ps))
                (goal (g-value ps :goal)))
            (s-value examiner :top start-y)
            (s-value examiner :window-top start-y)

            (s-value examiner :window-left (popup-object-x ps))
            (s-value examiner :wm-items (soar::get-wmparts (g-value ps :id)))
            (s-value examiner :proposed-operators
                     (if goal
                         (proposed-operators (g-value goal :id))
                         '("")))   )))
  nil)

(defun popup-object-x (object)
  (declare (type kr:a-schema-type object))
  (min (- opal::*screen-width*  (g-value object :width))
       (max 0
            (+ (g-value object :left)
               (g-value object :width)
               (g-value graphic-display-window :x-offset))))  )

(defun popup-object-y (object)
  (declare (type kr:a-schema-type object))
  ;; don'tb have to worry about y height, can always grab title bar
       (max 0
            (+ (g-value object :top)
               (g-value object :height)
               (g-value graphic-display-window :y-offset))))
           

(proclaim '(special new-pscm-examiner))

(defun create-ps-examiner (ps)
  (declare (type kr:a-schema-type ps))
 #-release-sx"Actually create the examiner for the selected PS."
 ;; ps-examiners are not real windows, they are examiners
 (let* ( (ps-name (g-value ps :name-string))
	 (ps-id (g-value ps :id))
 	 (combined-name  (format nil "~a-~a" ps-name ps-id))
         (examiner-name (intern (string-upcase (format nil "~a-EXAMINER"
						     combined-name))
			      (find-package "SX")))
         ; (display-name (o-formula (format nil "~a (~a)" ps-name ps-id)))
	 new-pscm-examiner new-window)
  (setf new-pscm-examiner (create-instance examiner-name PS-EXAMINER
                                           (:pscm-object ps) ))
  (s-value ps :examiner new-pscm-examiner)
  (setq new-window (g-value new-pscm-examiner :window))
  (push new-window opal:garnet-Hour-Glass-Windows)
  (append-value *sx* :examiners new-pscm-examiner)
  (append-value *sx* :examiner-windows new-window)

  ;; set up anchor button right
  (let ( (ab (g-value new-pscm-examiner :anchor-button))
	 (initial-val (g-value ps :anchored))  )
    (g-value ab :value)
    (s-value ab :value initial-val)    
    (kr-send ab :selection-function ab initial-val))
 new-pscm-examiner))


;;;
;;;    VI. 	the goal-examiner and methods
;;;

(proclaim '(special goal-EXAMINER))

(create-instance 'goal-EXAMINER pscm-examiner
   ;; If there is no parent window, then the window is created at (200, 200).
   ;(:pscm-object) ; this will be a goal
   (:parts `(
     (:wm-menu ,gg:scrolling-menu
       (:left 10)
       (:top 5)
       (:page-trill-p nil)      
       (:num-visible 6)
       (:title-font ,opal:default-font)
       (:v-spacing 2)
       (:menu-selection-function
	,#'(lambda (menu item)
	     (declare (type kr:a-schema-type item menu))
             (opal:garnet-inter-unwind-stuff
              (wm-selection-function item menu))))
       (:items ,(o-formula (or (gvl :parent :wm-items)
			       '(""))))
       (:title "Goal WMEs"))
      :dead-head
      :put-me-away)))

(defun create-goal-examiner (pscm-object)
  (declare (type kr:a-schema-type pscm-object))
 #-release-sx"Actually create the examiner for the pscm-object passed in."
 ;; ps-examiners are not real windows, they are examiners
 (let* ( (pscm-id (g-value pscm-object :id))
 	 (combined-name  (format nil "Goal-~a" pscm-id))
         (examiner-name (intern (string-upcase (format nil "~a-EXAMINER"
						     combined-name))
			      (find-package "SX")))
         (display-name (format nil "~a" pscm-id))
	 new-pscm-examiner new-window)
  (setq new-pscm-examiner
	(create-instance examiner-name goal-examiner
	  (:pscm-object pscm-object)
          (:title display-name)))
  (s-value pscm-object :examiner new-pscm-examiner)
  (setq new-window (g-value new-pscm-examiner :window))
  (push new-window opal:garnet-Hour-Glass-Windows)
  (append-value *sx* :examiner-windows new-window)
  (append-value *sx* :examiners new-pscm-examiner)
  new-pscm-examiner))

(define-method :soar-update goal-examiner (schema)
   ;; we're cas' at this point
   (s-value schema
	    :wm-items (soar::get-wmparts (g-value schema :pscm-object :id)))
   (opal:notice-items-changed (g-value schema :wm-menu :menu-item-list))
   (opal:update (g-value schema :window))   )

(defun popup-goal-examiner (goal)
  (declare (type kr:a-schema-type goal))
  #-release-sx"Create a examiner to examine and poke at problem spaces."
   (cond ( (not (is-a-p goal sx-goal))  ; have to have a goal
           (sgd-error "create-goal-examiner-not-goal-error-message" nil t) )
	 ( (let ((examiner (or (find-pscm-examiner goal)
                               (create-goal-examiner goal)))
                 (start-y (popup-object-y goal)))
	  (s-value examiner :top start-y)
          (s-value examiner :window-top start-y)

          (s-value examiner :window-left (popup-object-x goal))
	  (s-value examiner :wm-items
                   (soar::get-wmparts (g-value goal :id))))))
   nil)
             

;;;
;;;    VII. 	The state-examiner
;;;
(proclaim '(special state-examiner))

(create-instance 'state-EXAMINER pscm-examiner
   ;; If there is no parent window, the ps window is created at (200, 200).
   ; (:pscm-object) ; a state will be here
   (:parts `(
     (:wm-menu ,gg:scrolling-menu
       (:left 10)
       (:top 5)
       (:num-visible 6)
       (:page-trill-p nil)
       (:title-font ,opal:default-font)
       (:v-spacing 2)
       (:menu-selection-function
	,#'(lambda (menu item)
	     (declare (type kr:a-schema-type item menu))
             (opal:garnet-inter-unwind-stuff
              (wm-selection-function item menu))))
       (:items ,(o-formula (or (gvl :parent :wm-items)
			       '(""))))
       (:title "State WMEs"))
     :dead-head
     :put-me-away)))

(defun create-state-examiner (pscm-object)
  (declare (type kr:a-schema-type pscm-object))
 #-release-sx"Actually create the examiner for the pscm-object passed in."
 ;; ps-examiners are not real windows, they are examiners
 (let* ( (pscm-name (g-value pscm-object :name-string))
	 (pscm-id (g-value pscm-object :id))
 	 (combined-name  (format nil "~a-~a"  ;states don't really have names
                                 pscm-name
                                 pscm-id))
         (examiner-name (intern (string-upcase (format nil "~a-EXAMINER"
						     combined-name))
			      (find-package "SX")))
         (display-name (format nil "~a (~a)" pscm-name pscm-id))
         new-window
	 new-pscm-examiner  ;put this back into let when things are stable
         )
  (setq new-pscm-examiner
	(create-instance examiner-name state-examiner
	  (:pscm-object pscm-object)
          (:title display-name)))
  (s-value pscm-object :examiner new-pscm-examiner)
  (setq new-window (g-value new-pscm-examiner :window))
  (push new-window opal:garnet-Hour-Glass-Windows)
  (append-value *sx* :examiner-windows new-window)
  (append-value *sx* :examiners new-pscm-examiner)
  new-pscm-examiner))

(define-method :soar-update state-examiner (schema)
   ;; we're cas' at this point
   (s-value schema
	    :wm-items (soar::get-wmparts (g-value schema :pscm-object :id)))
   (opal:notice-items-changed (g-value schema :wm-menu :menu-item-list))
   (opal:update (g-value schema :window))   )

(defun popup-state-examiner (state)
  (declare (type kr:a-schema-type state))
  #-release-sx"Create a examiner to examine and poke at problem spaces."
   (cond ( (not (is-a-p state sx-state))  ; have to have a state
          (sgd-error "create-state-examiner-not-state-error-message" nil t) )
	 ( (let ((examiner (or (find-pscm-examiner state)
                               (create-state-examiner state)))
                 (start-y (popup-object-y state)))
             (s-value examiner :window-left (popup-object-x state))
             (s-value examiner :window-top start-y)
             (s-value examiner :top start-y)
             (s-value examiner :wm-items
                      (soar::get-wmparts (g-value state :id))))))
   nil)
;;                      (+ (g-value state :left)
;;                         (g-value state :width))

;;;
;;;    VIII. 	The op-examiner
;;;

(proclaim '(special op-examiner))

(create-instance 'op-EXAMINER pscm-examiner
   ;; If there is no parent window, the ps window is created at (200, 200).
   ; (:pscm-object) ; an operator will be here
   (:parts `(
     (:wm-menu ,gg:scrolling-menu
       (:left 10)
       (:top 5)
       (:num-visible 6)
       (:page-trill-p nil)      
       (:title-font ,opal:default-font)
       (:v-spacing 2)
       (:menu-selection-function
	,#'(lambda (menu item)
	     (declare (type kr:a-schema-type item menu))
             (opal:garnet-inter-unwind-stuff
              (wm-selection-function item menu))))
       (:items ,(o-formula (or (gvl :parent :wm-items)
			       '(""))))
       (:title "Op WMEs"))
    :dead-head
    :put-me-away)))

(defun create-op-examiner (pscm-object)
  (declare (type kr:a-schema-type pscm-object))
 #-release-sx"Actually create the examiner for the pscm-object passed in."
 ;; ps-examiners are not real windows, they are examiners
 (let* ( (pscm-name (g-value pscm-object :name-string))
	 (pscm-id (g-value pscm-object :id))
 	 (combined-name  (format nil "~a-~a" pscm-name pscm-id))
         (examiner-name (intern (string-upcase (format nil "~a-EXAMINER"
						     combined-name))
			      (find-package "SX")))
	 new-window new-pscm-examiner)
  (setq new-pscm-examiner
	(create-instance examiner-name op-examiner
	  (:pscm-object pscm-object)))
  (setq new-window (g-value new-pscm-examiner :window))
  (push new-window opal:garnet-Hour-Glass-Windows)
  (s-value pscm-object :examiner new-pscm-examiner)
  (append-value *sx* :examiner-windows new-window)  
  (append-value *sx* :examiners new-pscm-examiner)
 new-pscm-examiner))

(define-method :soar-update op-examiner (schema)
   ;; we're cas' at this point
   (s-value schema
	    :wm-items (soar::get-wmparts (g-value schema :pscm-object :id)))
   (opal:notice-items-changed (g-value schema :wm-menu :menu-item-list))
   (opal:update (g-value schema :window))   )

(defun popup-op-examiner (op)
  (declare (type kr:a-schema-type op))
  #-release-sx"Create a examiner to examine and poke at operators."
   (cond ( (not (is-a-p op sx-operator))  ; have to have a op
           (sgd-error "create-op-examiner-not-op-error-message" nil t) )
	 (   (let ((examiner (or (find-op-examiner op)
                                 (create-op-examiner op)))
                   (start-y (popup-object-y op)))
               (s-value examiner :top start-y)
               (s-value examiner :window-top start-y)
               (s-value examiner :window-left (popup-object-x op))
               (s-value examiner :wm-items
                        (soar::get-wmparts (g-value op :id))))))
   nil)


;;;
;;;	IX.	The wm-examiner-examiner
;;;

(defparameter wm-examiner-examiners-list nil
  #-release-sx"A list to help keep track of wm-examiner-examiners.")

(proclaim '(special wm-examiner))

(create-instance 'wm-EXAMINER pscm-examiner
   ;; If there is no parent examiner, the ps window is created at (200, 200).
   ; (:pscm-object) ; this is just a wme name
   (:parts `(
     (:wm-menu ,gg:scrolling-menu
       (:left 10)
       (:top 5)
       (:num-visible 5)
       (:page-trill-p nil)
       (:title-font ,opal:default-font)
       (:v-spacing 2)
       (:menu-selection-function
	,#'(lambda (menu item)
	     (declare (type kr:a-schema-type item menu))
             (opal:garnet-inter-unwind-stuff
              (wm-selection-function item menu))))
       (:items ,(o-formula (or (gvl :parent :wm-items)
			       '(""))))
       (:title "Wm WMEs"))
     :put-me-away
     :dead-head)))

(defun create-wm-examiner (pscm-object)
  (declare (type kr:a-schema-type pscm-object))
 #-release-sx"Actually create the examiner for the wm passed in."
 ;; ps-examiners are not real windows, they are examiners
 (let* ( (pscm-name  (caaar (get pscm-object 'soar::wmpart*)))
	 (pscm-id  pscm-object)
 	 (combined-name  (format nil "~a-~a" pscm-name pscm-id))
         (examiner-name (intern (string-upcase (format nil "~a-wm-EXAMINER"
						     combined-name))
			      (find-package "SX")))
         (display-name (format nil "~a (~a)" pscm-name pscm-id))
	 new-pscm-examiner new-window)
  (setq new-pscm-examiner
	(create-instance examiner-name wm-examiner
	  (:pscm-object pscm-object)
	  (:top 5)
          (:window-left 120)
          (:window-top 150)
          (:title display-name)))
  (push (cons pscm-object new-pscm-examiner)
        wm-examiner-examiners-list)
  (setq new-window (g-value new-pscm-examiner :window))
  (push new-window opal:garnet-Hour-Glass-Windows)
  (append-value *sx* :examiner-windows new-window)
  (append-value *sx* :examiners new-pscm-examiner)
  new-pscm-examiner))

(define-method :soar-update wm-examiner (schema)
   ;; we're cas' at this point
   (s-value schema :wm-items
	    (if (soar:wm-structure? (g-value schema :pscm-object))
		(soar::get-wmparts (g-value schema :pscm-object))
		'("")))
   (opal:notice-items-changed (g-value schema :wm-menu :menu-item-list))
   (opal:update (g-value schema :window))   )

(defun popup-wm-examiner (wm x y)
  #-release-sx"Create a examiner to examine and poke at problem spaces."
  (declare (type kr:a-schema-type wm) (integer x y))
   (cond ( (not (soar:wm-structure? wm))  ; have to have a wm
           (sgd-error "create-wm-examiner-not-wm-error-message" nil t) )
	 ( (let ((examiner (or (find-wm-examiner wm)
                               (create-wm-examiner wm))))
             (s-value examiner :wm-items (soar::get-wmparts wm))
             (s-value examiner :top y)
             (s-value examiner :window-top y)
             (s-value examiner :window-left x)
             (s-value (g-value examiner :window) :visible t)
             (gg:popup-window (g-value examiner :window)
                              :pop-to-last-mouse nil)
             )))
   (update-examiner-windows)
   nil)

(defun find-wm-examiner (awm)
  (declare (type kr:a-schema-type awm))
  (let* ( (result1 (assoc awm wm-examiner-examiners-list))
	  (result (if result1 (cdr result1))) )
    (cond ( result
	   (kr-send result :soar-update result)
        ;;(gg:popup-window (g-value result :window)
	;;		 :pop-to-last-mouse nil)
           result))))


;;;
;;;    X.	Pscm-examiner methods
;;;

(define-method :initialize PSCM-EXAMINER (new-examiner)
  ;; this will create a window for pscm-examiner
  (call-prototype-method new-examiner)
  (let ((window
	 (create-instance NIL inter:interactor-window
	    (:left (o-formula (gvl :aggregate :components :window-left)))
	    (:top (o-formula (gvl :aggregate :components :window-top)))
	    (:width (o-formula (gvl :aggregate :components :window-width)))
	    (:height (o-formula (gvl :aggregate :components :window-height)))
	    (:title (o-formula (gvl :aggregate :components :title)))
	    (:icon-title (o-formula (gvl :aggregate :components :title)))
	    (:parent (g-value new-examiner :parent-window))
	    (:visible nil)))
	(aggregate (create-instance NIL opal:aggregate)))
    (s-value window :aggregate aggregate)
    ;;; The :window slot of new-examiner is automatically set by add-component
    (opal:add-component aggregate new-examiner)
    (opal:update window)))

(define-method :soar-update pscm-examiner (schema)
   ;; we're cas' at this point
   (s-value schema
	    :wm-items (soar::get-wmparts (g-value schema :pscm-object :id)))
   (opal:notice-items-changed (g-value schema :wm-menu :menu-item-list))
   (opal:update (g-value schema :window))   )

(defun Pscm-Examiner-Destroy (pscm-examiner &optional erase)
  ;; first, remove the examiner from its window so when the window is
  ;; destroyed, the examiner will not be.  Then destroy the examiner itself
  ;; using call-prototype-method
  (let ((agg (g-value pscm-examiner :parent))
	(window (g-value pscm-examiner :window)))
    (set-values *sx* :examiners
		(remove pscm-examiner
			(get-values *sx* :examiners)))
    (set-values *sx* :examiner-windows
		(remove window
			(get-values *sx* :examiner-windows)))    
    (setq opal:garnet-Hour-Glass-Windows
          (remove window opal:garnet-Hour-Glass-Windows))
    (when agg
      (opal:remove-component agg pscm-examiner))
    ;; make sure window isn't already being destroyed
    (when (and window
	       (schema-p window)
	       (gethash (get-local-value window :drawable)
			opal::*drawable-to-window-mapping*))
      (opal:destroy window))
    (call-prototype-method pscm-examiner erase)))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/learn-window.lisp".
;;;; -*- Mode: soar; Package: sx -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : learn-window.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jan 13 14:41:03 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Sun Jan 19 18:08:13 1992
;;;; Update Count    : 39
;;;; Soar Version    : 5.2
;;;; Taql Version    : 3.1
;;;; 
;;;; PURPOSE
;;;; 	Provides a graphic listing of the status of learning in Soar.
#|
 it has:
  learning	radio buttons
     on/off
     all-goals/bottom-up
     print/noprint/full-print
     trace/untrace/full-trace

Items on dialog box are not set until finished is clicked on.
Items get reset to real values in soar each time dialog box gets popup-ed.

|#
;;;; TABLE OF CONTENTS
;;;;
;;;;	i.	Declarations & proclaims
;;;;	ii.  	Variables for the status window
;;;;	iii.	small functions
;;;;
;;;;	I.  	Create-learning-window
;;;;	IIa.	Create-learning-buttons
;;;;	IIb.	Create-learning-closers
;;;;	IIc.	Create-learning-window-methods
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares



;;;
;;;		i.	Declarations & proclaims
;;;

(eval-when (load eval compile)
    (in-package "SX"))
(eval-when (load eval compile)
    (proclaim '(type kr:a-schema-or-nil soar-learning-window)) )

;;;
;;;	ii.  Variables for the status window
;;;

;;(defparameter soar-learning-window nil
;;  #-release-sx"Where the learning-window lives.")

(defconstant left-learning-margin 5
      #-release-sx"Left margin for learning-window")
(defconstant learning-top-margin 5
  #-release-sx"Top of the taql-verbose button set.")
(defconstant middle-learning-margin 75
  #-release-sx"Top of the taql-verbose button set.")


;;;
;;;	iii.	Small functions
;;;



;;;
;;;	I.  	Create-learning-window
;;;


 ;; "create a window for showing and setting learning."
 ;; destroy it if it is already built.  Perhaps later we'll return it instead
 (if (and (boundp 'learning-window) (schema-p learning-window))
     (opal:destroy learning-window))
 (create-instance 'learning-window inter:interactor-window 
     (:visible nil)
     (:top 25)
     (:left 25)
     (:width 300)
     (:height 165)
     (:title  "Soar Learning Variables")
     (:icon-title  "Learning DBox")
     (:aggregate (create-instance 'learning-window-agg opal:aggregate
				  (:overlapping NIL)))     )

;;;
;;;	IIa.	Create-learning-buttons
;;;

  ;;   on/off
  (create-instance 'learning-on-RB gg:radio-button-panel
    (:left middle-learning-margin)
    (:h-align :left)
    (:direction :horizontal)
    (:font opal:font-fixed-bold-medium)
    (:text-on-left-p nil)
    (:top learning-top-margin)
    (:items '("on" "off"))
    (:button-diameter 18))

  ;; print/noprint/full-print
  (create-instance 'learning-print-RB gg:radio-button-panel
    (:left left-learning-margin)
    (:h-align :left)
    (:text-on-left-p nil)
    (:top (+ (g-value learning-on-RB :top) 15
             (g-value learning-on-RB :height)))
    (:items '( "print" "noprint" "full-print"))
    (:button-diameter 18))

 ;;  all-goals/bottom-up
 (create-instance 'learning-type-RB gg:radio-button-panel
    (:top (g-value learning-print-RB :top))
    (:left (+ left-learning-margin 5
	      (g-value learning-print-RB :width)))
    (:text-on-left-p nil)
    (:h-align :left)
    (:items '( "all-goals" "bottom-up"))
    (:button-diameter 18))

  ;; trace/untrace/full-trace
  (create-instance 'learning-trace-RB gg:radio-button-panel
    (:left (+ (g-value learning-type-rb :left) 10
	      (g-value learning-type-RB :width)))
    (:text-on-left-p nil)
    (:h-align :left)
    (:top (g-value learning-type-RB :top))
    (:items '("trace" "notrace" "full-trace"))
    (:button-diameter 18))
  ;; set up the formulas in the value slots
  (g-value learning-on-rb :value)
  (g-value learning-type-rb :value)
  (g-value learning-trace-rb :value)  
  (g-value learning-print-rb :value)    

  ;; add to big window
  (opal:add-components learning-window-agg
	learning-on-RB
	learning-print-RB
	learning-trace-RB
	learning-type-RB)


;;;
;;;	IIb.	Create-learning-closers
;;;

 (create-instance 'learning-execute  put-me-away-button
   (:additional-action
     #'(lambda (an-in points)
         (declare (ignore an-in points))
	 (soar::learn-aux (list
	  (sintern (g-value LEARNING-on-RB :value) (find-package "SOAR"))
       	  (sintern (g-value LEARNING-print-RB :value) (find-package "SOAR"))
   	  (sintern (g-value LEARNING-TRACE-RB :value) (find-package "SOAR"))
       	  (sintern (g-value LEARNING-type-RB :value) (find-package "SOAR"))) )
         (print-sx-prompt))))

  (create-instance 'learning-abort put-me-away-button
    (:left (+ middle-learning-margin 20))
    (:gray-width 0)
    (:string "Abort"))
  (opal:add-components learning-window-agg
	LEARNING-execute
	learning-abort)


;;;
;;;	IIc.	Create-learning-window-methods
;;;

 (define-method :update-yourself learning-window (window)
  #-release-sx"Update the learning window's buttons."
  (declare (ignore window))
  ;; should be called every time window is poped
  (s-value learning-on-RB :value (if soar::*learning* "on" "off"))
  (s-value learning-type-RB :value (if soar::*always-learn*
					"all-goals"
					"bottom-up"))
  (s-value learning-trace-RB :value (if (and soar::*ltrace* soar::*tracep*)
					"full-trace"
					(if soar::*tracep*
					    "trace"
					    "notrace")))
  (s-value learning-print-RB :value (if (eql soar::*print-learn* 0)
					"print"
					(if soar::*print-learn*
					    "full-print"
					    "noprint"))))

 (kr-send learning-window :update-yourself learning-window)
 (opal:update learning-window) 

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/cms-window.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            :cms-window.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Thu Feb 21 11:44:46 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Mon Feb  3 09:57:40 1992
;;;; Update Count    : 26
;;;; 
;;;; PURPOSE
;;;; 	Put a ms window to show the match set.
;;;; TABLE OF CONTENTS
;;;; 	|>Contents of this module<|
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings; declares; proclaims

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))



;;;
;;;	I.	emacs-ms
;;;

(eval-when (compile eval load)
  (proclaim '(ftype (function () t) emacs-ms)))

(defconstant cms-leader 
  "~%~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")

(defun emacs-ms ()
  (send-to-emacs "ms-hook"
		 (progn (format t cms-leader)
                        (format t "~%****Match set for ~s:~s ****"
				(decision-cycle-count)
				(elaboration-cycle-count))
			(or (ms) (format t "~%NIL"))
			))
  t)

(eval-when (compile eval load)
  (proclaim '(ftype (function () nil) continuous-ms)))

(defun continuous-ms ()
  "*Toggle Always printing out ms to emacs each m-cycle"
  (cond ( (not continuous-ms!)
          (setf continuous-ms! t)
	  (format t "~%; Continuous-ms is ON.  ~a"
                (if (g-value *sx* :update-live-windows-always)
                    "Always Update Windows is T, so run every elaboration."
                    "Always Update Windows is nil, so run every macrocyle.")))
	(t (setf continuous-ms! nil)
           (format t "~%;; Turning OFF continuous-ms."))) )

(setf (symbol-function 'cms)
      (symbol-function 'continuous-ms))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/sx-popup-menu.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : sx-popup-menu.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Sun Jun 16 17:49:53 1991
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:45:49 1992
;;;; Update Count    : 90
;;;; Soar Version    : 5.2.1
;;;; TAQL Version    : 3.1.4
;;;; 
;;;; PURPOSE
;;;; 	The DSI's popup-menu.
;;;; TABLE OF CONTENTS
;;;;	I.  Future home of a pull-down menu
;;;; 	II. create-gdw-popup-menu
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings;  proclaim vars funs;  declares



(eval-when (load eval compile)
 ;; make sure to avoid soarsyntax changes
  (and (soarsyntax) (soarresetsyntax))
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(ftype (function () t) create-gdw-pop-menu))
  (proclaim '(type kr:a-schema-type gdw-popup-menu-window))
  (proclaim '(special gdw-popup-menu-window))
  )

;;;
;;;	I.  Future home of a pull-down menu
;;; It's pop-up 'till then.


#|
SX		RUN		INSPECT		EDIT (prod)
==============================================================
about		d		status window	Excise
help		run		cs		print
save-win-conf	init		pgs		pbreak
		restart		sp		matches
quit		pop-goal	PS Graph trace	trace production
		excise-chunks

Status window will take up a lot of functionality, showing what the
state is, and also letting users modify the status.

|#


;;;
;;; 	II. create-gdw-popup-menu
;;;

;; done with proclaims above.
;; (defparameter gdw-popup-menu-window nil)

;; this would be a hard function to get rid of, it needs to tie the menu to
;; the window if it recreated...
(defun create-gdw-popup-menu ()
 (gg:create-pop-up-menu
  :title "Soar Interface MENU"
  :double-buffered-p opal:default-double-buffer-p
  :disappear-after-selection menus-disappear-after-selection
  :menu-window-name 'gdw-popup-menu-window
  :after-action #'(lambda (x y) (declare (ignore x y))
                    (print-sx-prompt :newline nil))
  :items `(                            
  ("1 Elaboration              r |:r" ,(opal:g-inter-lam (run 1)))
  ("1 Decision                 d | N" ,(opal:g-inter-lam (d 1)))
  ("Macrocycle             m,SPC| :m" ,(opal:g-inter-lam
                                          (macrocycle)))
  ("Continuous run              |(d)" ,(opal:g-inter-lam
                                         (steier-d)))
  ("--------------------------------" ,(opal:g-inter-lam nil))
  ("Set MacroC...  |(set-macrocycle)" ,(opal:g-inter-lam
               				 (gg:popup-window macrocycle-window
     					       :pop-to-last-mouse nil)))
  ("Examine selected item       e|:e" ,(opal:g-inter-lam
                                        (popup-pscm-examiner nil)))
  ("Init Soar                i|:init" ,(opal:g-inter-lam (init-soar)))
  ("Toggle Contin. Match set   |:cms" ,(opal:g-inter-lam (continuous-ms)))
  ("--------------------------------" ,(opal:g-inter-lam nil))
  ("Set DSI & Soar parameters...    " ,(opal:g-inter-lam
     				       (gg:popup-window soar-status-window
						     :pop-to-last-mouse nil)))
  ("Set learning...         |(learn)" ,(opal:g-inter-lam
     				       (gg:popup-window learning-window
     					      :pop-to-last-mouse nil)))
#-Release-sx
  ("Write N1 trace                  " ,(opal:g-inter-lam (write-n1-trace)))
  ("Take snapshot...          |:snap" ,(opal:g-inter-lam (sx-snapshot t)))
#-Release-sx
  ("Toggle taking protocol          " ,(opal:g-inter-lam
      				       (toggle-taking-protocol :graphic t)))
  ("Load TAQL           |(load-taql)" ,(opal:g-inter-lam
                                         (load-taql)) )
  ("Build static items... " ,(opal:g-inter-lam (gg:popup-window static-menu-window)))
  ("Help... " ,(opal:g-inter-lam
				       (sgd-error msg:dsi-help-comment
					     "The DSI is giving you help!"
                                             nil)))
  ("Put away menu "                  ,(opal:g-inter-lam
                                        (s-value gdw-popup-menu-window
                                                 :visible NIL)
                                        (opal:update gdw-popup-menu-window)))
 )
 :click-window graphic-display-inner-window
 :icon-title  "DSI Menu"
 :menu-event  :ANY-mouseDOWN
 :start-event :middledown)
 (s-value gdw-popup-menu-window :visible menus-disappear-after-selection)
t)


(defun steier-d ()
  (format t "Type a CR on the display or to the Soar buffer to stop.")
  (d))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/sxsetup.lisp".
;;;;-*-mode: lisp; package: sx -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : sxsetup.lisp
;;;; Resides in      : /afs/cs/project/soar/4.5/src/sx/new/sx.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Tue Jul 10 10:40:28 1990
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Feb 28 19:41:49 1992
;;;; Update Count    : 238
;;;; Soar Version    : 5.1
;;;; TAQL Version    : 3.0
;;;; 
;;;; PURPOSE
;;;;		i.	Abstract
;;;;
;;;;	This file handles the CLX package and is the call point for the 
;;;; the Soar Graphic Interface.
;;;;
;;;; TABLE OF CONTENTS
;;;;
;;;;		ii.	Table of Contents
;;;;
;;;;	i.	Abstract
;;;;	ii.	Table of Contents
;;;;	iii.	Declarations
;;;;	I.	Defstruct SX
;;;;	II.	Create-SX & Setup-sx-machine-display
;;;;	III.	Destroy-SX
;;;;	IV.	SX - top level function for the SX.
;;;;	V.	blank
;;;;	VI.	blank
;;;;	VII.	dump-sx
;;;;	VIII.   
;;;;     IX.    SX-banner
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations:  doc-strings; proclaim vars funs;  declares



(eval-when (load eval compile)
 ;; make sure to avoid soarsyntax changes
  (and (soarsyntax) (soarresetsyntax))
  (in-package "SX"))


(eval-when (load eval compile)
  (proclaim '(special *sx*))
  (proclaim '(type kr:logical default-goal-id-visible
                           default-problem-space-id-visible
                           default-state-id-visible
                           default-operator-id-visible
                           default-show-static-links
                           default-graphic-display-p
                           default-trace-goal
                           default-trace-problem-space
                           default-trace-state
                           cleanup-chunks
                           *quit-sx*
                   ))
  (proclaim '(type kr:a-schema-or-nil  *sx*))
  ;; (proclaim '(function make-sx () nil))
  (proclaim '(function update-with-sx-defaults () nil))
  (proclaim '(function clear-sx () nil))
  (proclaim '(function create-sx () nil))
  (proclaim '(inline create-sx () ()))
  (proclaim '(function setup-sx-machine-display () nil))
  (proclaim '(function destroy-sx () ()))
  ;;; VII.
  (proclaim '(string *default-sx-image-name*))
  (proclaim '(function init-sx () nil))
  ;; (proclaim '(function reinit-sx () nil))
  )

;;;
;;;		iii.	Declarations
;;;

(defvar default-goal-id-visible t
  "initial value")

(defvar default-problem-space-id-visible t
  "initial value")

(defvar default-state-id-visible nil
  "initial value")

(defvar default-chunk-id-visible nil
  "initial value")

(defvar default-operator-id-visible t
  "initial value")

(defvar default-show-static-links t
  "initial value")

(defvar default-show-static-text t
  "initial value")

(defvar default-graphic-display-p t 
  "initial value")

(defvar default-trace-goal t 
  "initial value")

(defvar default-trace-problem-space t
  "initial value")

(defvar default-trace-state t
  "initial value")

(defvar default-trace-operator t  "initial value")

(defvar cleanup-chunks nil   #-release-sx
  "Signals the 1st time through cycling so that chunks, if any,
should be cleaned up.")
  ;; implements letting chunks stay up for a whole decision cycle rather
  ;; than a preference cycle

(defvar *sx* nil #-release-sx"The info on current status of the soar interface.
The sx defstruct of the current sx.")

(defparameter *quit-sx* nil   #-release-sx
  "Set to t when the user wants out of the sx.")


;;;
;;;		II.	Defstruct SX
;;;
;;;	This defstruct builds an almost the entire SX for you, but you need to 
;;; call create-sx to make the defstruct so that it can do some extra
;;; initialization.

;; this could all be in an eval-when(load),  but that's already the default

;; (defun make-sx ()    #-release-sx
;; "Call the kr stuff to make the *sx* structure."
 (cond (*sx* (mapc #'(lambda (ps) (and ps (opal:destroy  ps)))
                   (get-values *sx* :problem-spaces))
             (destroy-schema *sx*)))
 (setf soar::graphic-display? default-graphic-display-p )
 (setf cleanup-chunks t)
 (create-schema '*sx*        ;no name necc. here
    ;; First the nil slots which we leave alone for now
    ;; initially nil items can be just not declared, they default to nil
    ;(:latest-context-item nil)
    ;(:latest-goal nil)
    ;(:latest-problem-space nil)
    ;(:latest-state nil)
    ;(:latest-operator nil)
    ;(:latest-state-or-operator nil)
    ;(:latest-fired-chunks)
    ;(:latest-selected-chunks)
    ;(:initial-context nil)
    ;(:selected-items )      ;items to be acted on, a list or single item
    ;(:context-elements nil)
    ;(:problem-spaces)
    ;(:goals)
    ;(:graphic-display-inner-window nil)
    ;(:examiner-windows nil) ; alist of examiner windows
    ;(:protocol-on nil)
    ;(:examiners) ; a list of the examiner gadgets
    (:soar-syntax (soarsyntaxp))
    (:auto-scroll t)
    (:watch soar::*watch-level*)
    (:decision-cycle 0)
    (:goal-id-visible default-goal-id-visible)
    (:problem-space-id-visible default-problem-space-id-visible)
    (:state-id-visible default-state-id-visible)
    (:chunk-id-visible default-chunk-id-visible)
    (:operator-id-visible default-operator-id-visible)
    (:graphic-display-goal default-trace-goal)
    (:graphic-display-problem-space default-trace-problem-space)
    (:graphic-display-state default-trace-state)
    (:graphic-display-operator default-trace-operator)
    ;; later add dialog boxes as appropriate
    (:live-windows
      (o-formula (append (gvs *sx* :examiner-windows)
                         (list (gvl :graphic-display-inner-window)
                               GDW-POPUP-MENU-WINDOW))))
    (:macrocycle-number soar:macrocycle-n)
    (:macrocycle-type soar:macrocycle-type)
    (:macrocycle-max-dc soar:macrocycle-max-dc)
    (:show-static-text default-show-static-text)
    (:show-static-links default-show-static-links) ; show static links b/t PSs
    (:update-live-windows-always t))
    ;;*Update live windows every D or R if t.
;;    nil)

(defun update-with-sx-defaults ()
#-:release-sx "Reset user-settable settings"
;; these things can't be plain old variables, for if their value changes,
;; the graphic display has to be notified.
  (s-value *sx* :goal-id-visible default-goal-id-visible)
  (s-value *sx* :problem-space-id-visible default-problem-space-id-visible)
  (s-value *sx* :state-id-visible default-state-id-visible)
  (s-value *sx* :chunk-id-visible default-chunk-id-visible)
  (s-value *sx* :operator-id-visible default-operator-id-visible)
  (s-value *sx* :show-static-links default-show-static-links)
  (s-value *sx* :show-static-text default-show-static-text)
  (sx-set-macrocycle-hook) ; reset this if things have changed
  (if gdw-popup-menu-window
      (s-value gdw-popup-menu-window
           :disappear-after-selection menus-disappear-after-selection))
;  (s-value *sx* :graphic-display-p default-graphic-display-p)
;  (s-value *sx* :trace-goal default-trace-goal)
;  (s-value *sx* :graphic-display-problem-space default-trace-problem-space)
;  (s-value *sx* :graphic-display-state default-trace-state)
;  (s-value *sx* :graphic-display-operator default-trace-operator)
 nil )

(defun clear-sx ()  #-release-sx
 "Clear all the slots of *SX* that are timely."
 ;; called through init-soar
 (s-value *sx* :latest-context-item   nil)
 (s-value *sx* :latest-goal   nil)
 (s-value *sx* :latest-problem-space   nil)
 (s-value *sx* :latest-state   nil)
 (s-value *sx* :latest-operator   nil)
 (s-value *sx* :latest-state-or-operator   nil)
 (s-value *sx* :initial-context   nil)
 (s-value *sx* :context-elements   nil)
 (unselect-chunks)
 (unfire-chunks)
 (set-values *sx* :latest-fired-chunks nil)
 (set-values *sx* :latest-selected-chunks nil)
 (set-values *sx* :selected-items nil)
 (s-value *sx* :decision-cycle (soar::cycle-count 'quiet))
 (setf opal:unrun-garnet-commands nil)
)

(defun print-sx (param &optional (stream t) print-level)
 #-release-sx"Prints a sx instance nicely."
 (declare (ignore print-level param) (stream stream))
 (format stream "#s{an SX structure}"))


;;;
;;;		III.	Create-sx & Setup-sx-machine-display
;;;
;;; Creates the sx structure(s) if they are needed. -fer 6/90

(defun create-sx ()
  ;; Clear the event table, before I make my windows.
  (and (not *machine-display*)
       (setup-sx-machine-display))
  ;; (cond ( (not *sx*)
  ;;        (make-sx) ))
  ;; clear out any input you may have.
  (sx-clear-events3)
  ;; The current trace is set to the diagnostic trace window.
)

(defun setup-sx-machine-display ()
  #-release-sx"Setup the *machine-display* variable and associated vars" 
 ;; let garnet set up display.  Machine-display should go away anyhow
 (setq *machine-display* opal::*default-x-display*)
)


;;;
;;;		IV.	Destroy-sx
;;;
;;; To destroy the sx, call destroy on all of its windows.

(defun destroy-sx ()
  (opal:destroy *sx*)
  (setq *sx* nil)  )


;;;
;;;		IV.	SX - top level function for the SX.
;;;

(defun sx (&optional commands)
  (declare (list commands))
  (create-sx)
  (soar::run-hooks commands)
  (opal:grepl))


;;;
;;;		V.	blank
;;;


;;;
;;;		VI.	blank
;;;



;;;
;;;	VII.	dump-sx
;;;

(defvar *default-sx-image-name* "/usr/ritter/images/Soar5+sx.acli")

(defun dump-sx (&optional incoming-image-name)
 "*Dump the sx in a clever way that it can start up Garnet and itself again."
 ;; note the clever way we wrap the before and after image actions
 ;; in a cond so we avoid having to use each lisp's before/after actions
 ;; (although they get used if they exist)
 (declare (string incoming-image-name))
 (in-package "USER")
 (let ( (image-name (or incoming-image-name
                        (query-string "File to dump image into (w/o \"s)"
                                   *default-sx-image-name*))  ))
  (cond ( (not (probe-file image-name))
	  (format t "~%; Resetting the default image name to be ~a" image-name)
	  (setq *default-sx-image-name* image-name)
          (format t "~%; ~%; Attempting to dump sx into ~a..." image-name)
          (opal:disconnect-garnet)
          (sx-gc)
          (sx-dump-image image-name)
          (format t "~%; The DSI is born again! ~%; ~%")
	  ;; calls reconnect for both sysout and contuing system...
          (restart-sx)
          (sx) )
        (t (format t "~% It would be best to delete ~a and try again"
                     image-name)
           (if (y-or-n-p (format nil "Should I delete ~a ? [y/n]" image-name))
               (delete-file image-name)))  )))

(setf (symbol-function 'sx-dump)
      (symbol-function 'dump-sx))



;; really is query-string, found in utils.lisp
;(defun uquery-string (prompt default)
; "Read in a string with prompting w/ PROMPT and DEFAULT as the default value."
;  (format t "~0&~a (w/o \"s): [~a] " prompt default)
;  (let ((result (read-line)))
;   (if (> (length result) 0) result default)))



;;;
;;;		VIII.	blank
;;;


;;;
;;;		IX.	SX-banner
;;;

(defun sx-banner (&optional (astream t)) #-release-sx
 "Print the soar banner and then some stuff on sx."
 (declare (stream astream))
 (soarsyntax)
 ;; taken out for demo
 (if (fboundp 'user::taql-greeting) (user::taql-greeting))
 (Terse-sx-banner astream)
 (soar-print-lisp-banner)
 (if *machine-display*
    (multiple-value-bind (major minor)
	 (display-protocol-version *machine-display*)
       (format astream "~%;    X ~a-~a." major minor)))
 (format astream "~%; Bug reports should be sent to soar-bugs@cs.cmu.edu.")
 (format astream "~%; Send comments on the interface to Ritter@cs.cmu.edu.")
 (format astream "~%; Soarsyntax set on.")
 (format astream
         "~%; If SX prompt not visible, startup SX with (sx) or <esc> x sx."))

(defun terse-sx-banner (&optional (astream t))
 (declare (stream astream))
 (format astream "~%; This ~a version of the SX includes:  " *sx-version*)
 (format astream "~%;    Garnet version ~a." user::Garnet-Version-Number)
 #+sem(format astream "~%;    SEM version ~a."  sem::*sem-version*))

(defun init-sx ()
  #-release-sx "Set up the sx graphic display."
  ;; set up variables
  ;(make-sx) ;; called in next function
  (create-sx)
  (create-graphic-display)
  (initialize-chunks)
  (excise-chunks)
  (setf opal:garnet-Hour-Glass-Windows
        (list graphic-display-inner-window gdw-popup-menu-window
              LEARNING-WINDOW ;SGD-LABELED-BOX-WINDOW
              STATIC-MENU-WINDOW macrocycle-window))
  (sx-banner)
  nil)

;(defun reinit-sx ()  #-release-sx
;  "Reset the SX graphic display."
;  ;; set up variables
;  (create-sx)
;  (create-graphic-display)
;  (initialize-chunks)
;  t)



;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/snapshot.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : snapshot.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Thu Feb 21 15:11:51 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Mar 27 12:58:15 1992
;;;; Update Count    : 72
;;;; 
;;;; PURPOSE
;;;; 	Takes snapshots of screen.
;;;; TABLE OF CONTENTS
;;;;
;;;;	i.	Variables and constants
;;;;
;;;;	I.	sx-snapshot
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings;  proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  (proclaim '(string snap-print-command
                     snap-dump-directory
                     snap-file
                     snap-basic-command
                     snap-numeric-extension
                     last-snap-file))
  (proclaim '(function sx-snapshot (kr:logical) nil))
  (proclaim '(function snap-hide-stuff (kr:logical) nil))
  (proclaim '(function dsi-get-file-name (kr:logical string string
                                          string string string)
              string string))
  (proclaim '(function dsi-file-name-busy? (kr:logical string) kr:logical))
  )


;;;
;;;	i.	Variables and constants
;;;

;;;
;;; User variables
;;;

(defvar snap-print-command "lpr"
  "*Command to print out snap files.")

(defvar snap-dump-directory "/tmp/"
  "*Directory to put dumped file in.")

(defvar snap-dump-file "sx-dump"
  "*File to put dump into.")

(defvar snap-basic-command "xwd -frame"
  "Command to take snapshot. optional -frame puts window frame on.")

;;;
;;; System variables
;;;

(defvar snap-numeric-extension "")

(defvar last-snap-file snap-dump-file
  #-release-sx"The last file printed.")

(defconstant snap-file-extension "ps")

(defconstant snap-extended-command "| xpr -device ps -output")

(defconstant snap-file-name-prompt
  "File or vers # for saving (no extension or \"'s):")

(defconstant snap-graphic-ok-prompt
    "Click on Ready when ready, then wait for
crosshairs to click on window your want, or background
for the whole screen.")

(defconstant snap-final-message
  "Beep at click *and* two beeps after means you got it!")

(defconstant snap-hide-question
  "Hide non-essential parts such as dc counter?")


;;;
;;;	I.	sx-snapshot
;;;

(defun sx-snapshot (graphic-p)
 "*Take an X snapshot of the screen or window."
 (declare (type kr:logical graphic-p))
 (let ((command nil)
       (hide-stuff nil)
       (default-file (format nil "~a~a"
			     last-snap-file snap-numeric-extension))  )
 ;; turn on title
 (s-value *sx* :show-titles-p t)
 ;; get file name
 (multiple-value-bind (full-file new-default)
    (dsi-get-file-name graphic-p snap-file-name-prompt
                       snap-dump-directory default-file
                       snap-numeric-extension snap-file-extension)
    (if (dsi-file-name-busy? graphic-p full-file)
        (return-from sx-snapshot nil))
    (if new-default
        (setq last-snap-file new-default))
 (setf snap-dump-directory
       (subseq full-file 0 (- (length full-file) 1 ;for "."
                              (length last-snap-file)
                              (length snap-numeric-extension)
                              (length snap-file-extension))))
 (if (cond (graphic-p (gg:graphic-yes-or-no-p sgd-choice-gadget
	               snap-hide-question))
           (t (y-or-n-p snap-hide-question)))
     (setf hide-stuff t)
     (setf hide-stuff nil))
 (if hide-stuff (snap-hide-stuff nil))
 (cond (graphic-p (if (string= "Abort"
			     (gg:display-choice sgd-choice-gadget
				   snap-graphic-ok-prompt '("Ready" "Abort")))
                    (progn (if hide-stuff (snap-hide-stuff t))
                           (return-from sx-snapshot))))
       (t (format t "Carriage return(s) when ready: ") (read-line)
          (format t "~%Wait for crosshairs and then click (any button) on ~a~%"
                    "the window you want saved.")) )
 ;; call cursor
 (opal:update graphic-display-window)
 (check-sx-x-server )
 (setq command (format nil "~a~a ~a" snap-basic-command snap-extended-command
                       full-file))
 (soar-run-shell-command command)
 
 (if graphic-p
     (sgd-error snap-final-message nil t)
     (format t "~a~%" snap-final-message))
 ;; print it
 (if (if graphic-p
         (gg:graphic-yes-or-no-p sgd-choice-gadget
              (concatenate 'string "Print "
			   full-file " with " snap-print-command "? "))
	 (y-or-n-p (concatenate 'string "Print "
			   full-file " with " snap-print-command "? ")))
     (progn (format t "Please wait while printing...")
            (soar-run-shell-command (concatenate 'string 
                                          snap-print-command " " full-file))
            (if graphic-p
		(sgd-error "Finished printing." nil nil)
		(format t "Finished printing..~%"))))
 ;; turn off titles, cleanup
 (s-value *sx* :show-titles-p nil)
 (if hide-stuff (snap-hide-stuff t)) 
 (opal:update graphic-display-window)
 nil)))

(defun dsi-movie (N)
 (let ((command nil)
       (full-file-name nil)  )
 (dotimes (i N)
   (macrocycle 1)
   ;; call cursor
   (opal:update graphic-display-window)
   (check-sx-x-server)
   (setq full-file-name
     (format nil "~a~a-~a.~a" snap-dump-directory last-snap-file
            (g-value *sx* :decision-cycle) snap-file-extension))
   (setq command (format nil "~a~a ~a" snap-basic-command 
                         snap-extended-command
                         full-file-name))
   (format t "Going to snap ~a" full-file-name)
   (inter:beep)
   (soar-run-shell-command command))
 nil))

(defun snap-hide-stuff (visible)
  (declare (type kr:logical visible))
  (s-value gd-top-status-line :visible visible)
  (s-value gd-bottom-status-line :visible visible)
;  (s-value gd-title :visible visible)
  nil)

(defun dsi-get-file-name (graphic-p file-name-prompt dump-directory
                          default-file numeric-extension file-extension)
  (declare (type kr:logical graphic-p) (string file-name-prompt dump-directory
                          default-file numeric-extension file-extension))
  (cond (graphic-p
         (let ((raw-full-name
                  (dsi-query-using-labeled-box file-name-prompt
                        (format nil "~a~a~a.~a"
                                dump-directory numeric-extension default-file
                                file-extension))))
           (values raw-full-name
                   (subseq raw-full-name
                           (1+ (position #\/ raw-full-name :from-end t))
                           (position #\. raw-full-name :from-end t)))))
       (t (let ((file nil))
            (format t "~a [~a] > " file-name-prompt default-file)
            (setq file (read-line))   
            ;; munge the file name
            (cond ((string= file "") (setq file default-file))
                  ((numberp (read-from-string file))
                   (setq numeric-extension file)
                   (setq file default-file))
                  (t (setq numeric-extension "")))
            (values (format nil "~a~a~a.~a"
                            dump-directory file numeric-extension
                            file-extension)
              file))))
     )

(defun dsi-file-name-busy? (graphic-p full-file)
 (declare (type kr:logical graphic-p) (string full-file))
 ;; delete old file iff necc.
 (if (probe-file full-file) 
     (if (if graphic-p
	     (gg:graphic-yes-or-no-p sgd-choice-gadget
				     (format nil "Delete ~a ?" full-file))
	     (y-or-n-p (concatenate 'string "Delete " full-file " ? ")))
         (progn (delete-file full-file) nil)
         (progn (if graphic-p
		    (sgd-error (format nil "Can't overwrite ~a, quiting.~%"
                                       full-file) nil t)
		    (format t "Can't overwrite ~a, quiting.~%" full-file))
                (s-value *sx* :show-titles-p nil)
                (opal:update graphic-display-window)
                t))
   nil))

; (cond (graphic-p
;         (setq full-file
;               (format nil "~a~a~a.~a" 
;                                 snap-dump-directory file snap-numeric-extension
;                                 snap-file-extension))
;         (setq full-file
;               (dsi-query-using-labeled-box snap-file-name-prompt
;                                            full-file)))
;       (t (format t "~a [~a] > " snap-file-name-prompt default-file)
;          (setq file (read-line))
;          ;; munge the file name
;          (cond ((string= file "") (setq file last-snap-file))
;                ((numberp (read-from-string file))
;                 (setq snap-numeric-extension file)
;                 (setq file last-snap-file)) 
;                (t (setq snap-numeric-extension "")))
;          (setq last-snap-file file)
;          (setf full-file (format nil "~a~a~a.~a" 
;                                 snap-dump-directory file snap-numeric-extension
;                                 snap-file-extension)) ))

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/startup-sx.lisp".
;;;; -*- Mode: Lisp -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : startup-sx.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Wed Jun 26 18:02:33 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Jan 31 17:05:56 1992
;;;; Update Count    : 18
;;;; 
;;;; PURPOSE
;;;; 	Start up the DSI when loading files.  Last file loaded.
;;;; TABLE OF CONTENTS
;;;;	I.	load-soar-init-file
;;;;	II.	Start up SX
;;;; 
;;;; Copyright 1991, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))

(eval-when (load eval compile)
  )


;;;
;;;	I.	load-soar-init-file
;;;

(eval-when (eval load)
  (load-soar-init-file *sx-init-file-name*)
  (update-with-sx-defaults)
)


;;;
;;;	II.	Start up SX
;;;

(eval-when (eval load)
  (init-sx)
  )

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/interactors.lisp".
;;;; -*- Mode: Lisp; Package SX -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : interactors.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Mon Jan  7 12:47:12 1991
;;;; Last Modified By: Frank Ritter
;;;; Last Modified On: Fri Feb 21 14:54:38 1992
;;;; Update Count    : 164
;;;; 
;;;; PURPOSE
;;;; 	Interators for sx windows.
;;;; TABLE OF CONTENTS
;;;;	i.	blank
;;;;	I.	blank
;;;;	II.	blank
;;;; 	III.	blank
;;;;	IV.	blank
;;;;	V.	blank
;;;;	VI.	blank
;;;;	VII.	create graphic display inters
;;;; 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: doc-strings; proclaim vars funs; declares

(eval-when (load eval compile)
  (soarresetsyntax)
  (in-package "SX"))


;;;
;;;	i.	blank
;;;


;;;
;;;	I.	blank
;;;


;;;
;;;	II.	blank
;;;


;;;
;;; 	III.	blank
;;;


;;;
;;;	IV.	blank
;;;


;;;
;;;	V.	blank
;;;


;;;
;;;	VI.	blank
;;;


;;;
;;;	VII.	create graphic display interactors.
;;;
;;; You might be able to make these take up less room by making these
;;; all instances of a new prototype.  But might run slower....22-Jan-92 -FER

;;(defun create-graphic-display-inters ()
;;#-release-sx"Put interactors on gd windows."
  ;; later do d and r

 (create-instance 'd-inter inter:button-interactor
    (:start-where t)
    (:window    ; T 
        (o-formula (gv *sx* :live-windows)))
    (:start-event '(#\d #\D))
    (:final-function (opal:g-inter-lam
		         (eval (d 1))) )
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)    
    (:continuous nil))
 (create-instance 'i-inter inter:button-interactor
    (:start-where t)
    (:window    ; T 
        (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\i #\I))
    (:final-function (opal:g-inter-lam (init-soar)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)    
    (:continuous nil)) 
  (create-instance 'm-inter inter:button-interactor
    (:start-where t)
    (:window    ; T 
        (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\m #\M #\space))
    (:final-function (opal:g-inter-lam (soar:macrocycle)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

  (create-instance 'e-inter inter:button-interactor
    (:start-where t)
    (:window    ; T 
        (o-formula (gv *sx* :live-windows)))
    (:start-event '(#\e #\E))
    (:final-function (opal:g-inter-lam
                          (popup-pscm-examiner
                               (g-value *sx* :selected-items))))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

 (create-instance 'r-inter inter:button-interactor
    (:start-where t)
    (:window    ; T 
        (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\r #\R))
    (:final-function (opal:g-inter-lam (eval (run 1))))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

 (create-instance 'g-inter inter:button-interactor
    (:start-where t)
    (:window (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\g #\G))
    (:final-function (opal:g-inter-lam (next-g 1)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

 (create-instance 'p-inter inter:button-interactor
    (:start-where t)
    (:window (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\p #\P))
    (:final-function (opal:g-inter-lam (next-p 1)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

 (create-instance 's-inter inter:button-interactor
    (:start-where t)
    (:window (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\s #\S))
    (:final-function (opal:g-inter-lam (next-s 1)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

 (create-instance 'o-inter inter:button-interactor
    (:start-where t)
    (:window (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\o #\O))
    (:final-function (opal:g-inter-lam (next-o 1)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))

 (create-instance 'ret-inter inter:button-interactor
    (:start-where t)
    (:window (o-formula (gv *sx* :live-windows)))    
    (:start-event '(#\RETURN))
    (:final-function #'(lambda (x y)
                         (declare (ignore x y))
                         (setf soar::*break-p* t)))
    (:waiting-priority soar-PRIORITY-LEVEL)
    (:running-priority soar-PRIORITY-LEVEL)
    (:continuous nil))
;; )

;;; Concatenated from type module "sx" module-version "new".

;;; Concatenated from file "/afs/cs.cmu.edu/project/soar/5.2/src/sx/new/status-window.lisp".
;;;; -*- Mode: lisp; Package: sx -*- 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; File            : status-window.lisp
;;;; Author          : Frank Ritter
;;;; Created On      : Fri Jul 13 14:41:03 1990
;;;; Last Modified By: Thomas McGinnis
;;;; Last Modified On: Tue Mar 17 15:45:42 1992
;;;; Update Count    : 208
;;;; Soar Version    : 5.2
;;;; Taql Version    : 3.1
;;;; 
;;;; PURPOSE
;;;; 	Provides a graphic listing of the status of Soar.
;;;; It has:
;;;;  soar-syntax,	radio button
;;;;     soar, lisp syntax
;;;;  watch		radio buttons
;;;;     -1, no trace
;;;;      0, PS
;;;;     .5  productions
;;;;     1   wm time tag
;;;;     1.5 wm elements
;;;;     2   wm elements and time tags
;;;;     3   preferences
;;;;  taql-verbose  radio buttons
;;;;      on/off                             
;;;;  decide-trace	
;;;;  user-select   
;;;;
;;;;  Printed on it:
;;;;    soar-version
;;;;    taql-version
;;;;
;;;; TABLE OF CONTENTS
;;;;
;;;;	i.	Declarations
;;;;	ii.  	Variables for the status window
;;;;	iii.	small functions
;;;;
;;;;	I.  Create-soar-status-window
;;;; 	Ia.	Create-status-x-buttons
;;;;	Ib.	Create-status-x-trace-buttons
;;;;	Ic. 	Create-status-radio-buttons
;;;;	II.	{deleted}
;;;; 
;;;; Copyright 1990, Frank Ritter.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Optimizations: no doc-strings; no proclaim vars funs; no declares

(eval-when (load eval compile)
  (in-package "SX")
  (soarresetsyntax))


;;;
;;;		i.	Declarations
;;;

(eval-when (load eval compile)
  (proclaim '(function sx-watch0 (symbol symbol) nil))
  (proclaim '(function sx-watch5 (symbol symbol) nil))
  (proclaim '(function sx-watch-1 (symbol symbol) nil))
  (proclaim '(function sx-watch1 (symbol symbol) nil))
  (proclaim '(function sx-watch15 (symbol symbol) nil))
  (proclaim '(function sx-watch2 (symbol symbol) nil))
  (proclaim '(function sx-watch3 (symbol symbol) nil))
  (proclaim '(type kr:a-schema-type soar-status-window))
  )

;;;
;;;	ii.  Variables for the status window
;;;

;; (defparameter soar-status-window nil
;;  #-release-sx"Where the graphic-status-window lives.")


;;;
;;;	iii.	Small functions
;;;

(defun sx-watch0 (&optional x y)
 (declare (symbol x y))
 (watch 0))

(defun sx-watch5 (&optional x y)
 (declare (ignore x y))
 (watch .5))

(defun sx-watch-1 (&optional x y)
 (declare (ignore x y))
 (watch -1))

(defun sx-watch1 (&optional x y)
 (declare (ignore x y))
 (watch 1))

(defun sx-watch15 (&optional x y)
 (declare (ignore x y))
 (watch 1.5))

(defun sx-watch2 (&optional x y)
 (declare (ignore x y))
 (watch 2))

(defun sx-watch3 (&optional x y)
 (declare (ignore x y))
 (watch 3))


;;;
;;;	I.  Create-soar-status-window
;;;

;; (defun create-soar-status-window ()
;;  #-release-sx
;;  "Create a window for showing and setting soar variables."
;; ;; destroy it if it is already built.  Perhaps later we'll return it instead
;;  (if (and (boundp 'soar-status-window)
;;           (schema-p soar-status-window))
;;      (opal:destroy soar-status-window))
 (create-instance 'soar-status-window inter:interactor-window 
     (:top 20)
     (:left 20)
     (:width 300)
     (:visible nil)  ;will gotot nil soon
     (:height 280)
     (:title (format nil "DSI & Soar parameters:  DSI ~a  Soar ~a.~a"
		     *sx-version*
                     soar::*version-number* soar::*release-number*))
     (:icon-title  "Status DBox")
     (:aggregate
	   (create-instance 'soar-status-window-agg opal:aggregate
                            (:overlapping NIL)))
     )
;;  (Create-status-x-buttons soar-status-window-agg)
;;  (Create-status-X-trace-buttons soar-status-window-agg)
;;  (Create-status-radio-buttons soar-status-window-agg)
;;  (Create-status-put-me-away soar-status-window-agg)
;; (opal:update soar-status-window) moved to end
;; t)
 

;;;
;;; 	I.a	Create-status-x-buttons
;;;

;; (defun Create-status-x-buttons (window-agg)
;; "create the x buttons for the status buttons"
;;  ; (soarresetsyntax)
 (create-instance 'status-XB-gd-font gg:x-set-function-button-panel
    (:left left-soar-status-margin)
    (:top  status-x-buttons-top-margin)
    (:items '("Use BIG fonts"))
    (:set-function #'(lambda (x)
		      (declare (ignore x))
		      (s-value name-tag :set-font name-tag-font)))
    (:unset-function #'(lambda (x)
		      (declare (ignore x))
		      (s-value name-tag :set-font opal:default-font))) )
  (g-value status-xb-gd-font :value)
  (s-value status-XB-GD-FONT
	   :value (if (eq (g-value name-tag :font) name-tag-font)
                      '("Use BIG fonts")))

 (create-instance 'status-XB-syntax garnet-gadgets:x-set-function-button-panel
    (:left left-soar-status-margin)
    (:text-on-left-p nil)
    (:shadow-offset 0)
    (:top (+ (g-value status-XB-gd-font :top) 
             (g-value status-XB-gd-font :height)))
    (:items '("Soar syntax"))
    (:set-function #'(lambda (x) (declare (ignore x))
		       (soarsyntax) (print-sx-prompt)))
    (:unset-function #'(lambda (x) (declare (ignore x))
		       (soarresetsyntax) (print-sx-prompt))) )
  (g-value status-xb-syntax :value)
  (s-value status-XB-syntax
	   :value (if (g-value *sx* :soar-syntax)
                      '("Soar syntax")))

  (create-instance 'status-XB-taql-verbose
                   garnet-gadgets:x-set-function-button-panel
    (:left left-soar-status-margin)
    (:text-on-left-p nil)
    (:top (+ (g-value status-XB-syntax :top) 
             (g-value status-XB-syntax :height)))
    (:items '("TAQL Verbose"))
    (:set-function #'(lambda (x)
		       (declare (ignore x))
		       (if (fboundp 'user::taql-verbose)
                           (progn (eval '(user::taql-verbose :on))
                                  (format t "TAQL-verbose turned ~s "
                                          (eval '(user::taql-verbose)))
                                  (print-sx-prompt)))))
    (:unset-function #'(lambda (x)
		       (declare (ignore x))
                       (if (fboundp 'user::taql-verbose)
                           (progn (eval '(user::taql-verbose :off))
                             (format t "TAQL-verbose turned ~s "
                                     (eval '(user::taql-verbose)))
                             (print-sx-prompt))))))
  (g-value status-XB-taql-verbose :value)
  (s-value status-XB-taql-verbose
	   :value (if (and (fboundp 'user::taql-verbose)
                           (eq :on '(eval (user::taql-verbose))))
                      '("TAQL Verbose")))
  (opal:add-components soar-status-window-agg  ;window-agg
		       status-XB-gd-font
                       status-XB-syntax
                       status-XB-taql-verbose)
;; )


;;;
;;;	Ib.	Create-status-x-trace-buttons
;;;

;; (defun Create-status-x-trace-buttons (window-agg)
;;  "Create the x buttons for the tracing buttons."
;; 
 (create-instance 'status-XB-gd gg:x-variable-button-panel
   (:left middle-soar-status-margin)
   (:top status-x-buttons-top-margin)
   (:items '("Graphic display?"))
   (:variable 'soar::graphic-display?))

 (create-instance 'status-xb-id-text opal:text
   (:left (+ middle-soar-status-margin 5))
   (:top (+ 3 status-x-buttons-top-margin (g-value status-XB-gd :height)))
   (:string "Show IDs of:"))

 (create-instance 'status-XB-gd-goal gg:x-set-function-button-panel
   (:left (+ middle-soar-status-margin 5))
   (:top (+ (g-value status-xb-Id-Text :top)
            (g-value status-XB-id-text :height)))
   (:items '("Goal"))
   (:set-function #'(lambda (x)
		     (declare (ignore x))
		     (s-value *sx* :goal-id-visible t)))
   (:unset-function #'(lambda (x)
			(declare (ignore x))
			(s-value *sx* :goal-id-visible nil))))

  (create-instance 'status-XB-gd-problem-space gg:x-set-function-button-panel
    (:left (+ middle-soar-status-margin 5))
    (:top (+ (g-value status-XB-gd-goal :top) 
             (g-value status-XB-gd-goal :height)))
    (:items '("Problem-Space"))
    (:set-function #'(lambda (x)
		      (declare (ignore x))
		      (s-value *sx* :problem-space-id-visible t)))
    (:unset-function #'(lambda (x)
		       (declare (ignore x))
		       (s-value *sx* :problem-space-id-visible nil))))

  (create-instance 'status-XB-gd-state gg:x-set-function-button-panel
    (:left (+ middle-soar-status-margin 5))
    (:top (+ (g-value status-XB-gd-problem-space :top) 
             (g-value status-XB-gd-problem-space :height)))
    (:items '("State"))
    (:set-function #'(lambda (x)
		       (declare (ignore x))
		       (s-value *sx* :state-id-visible t)))
    (:unset-function #'(lambda (x)
		        (declare (ignore x))
		        (s-value *sx* :state-id-visible nil))))

  (create-instance 'status-XB-gd-operator gg:x-set-function-button-panel
    (:left (+ middle-soar-status-margin 5))
    (:top (+ (g-value status-XB-gd-state :top) 
             (g-value status-XB-gd-goal :height)))
    (:items '("Operator"))
    (:set-function #'(lambda (x)
		      (declare (ignore x))
		      (s-value *sx* :operator-id-visible t)))
    (:unset-function #'(lambda (x)
		      (declare (ignore x))
		      (s-value *sx* :operator-id-visible nil))))

  (create-instance 'status-XB-gd-chunk gg:x-set-function-button-panel
    (:left (+ middle-soar-status-margin 5))
    (:top (+ (g-value status-XB-gd-operator :top) 
             (g-value status-XB-gd-goal :height)))
    (:items '("Chunk"))
    (:set-function #'(lambda (x) (declare (ignore x))
		      (s-value *sx* :chunk-id-visible t)))
    (:unset-function #'(lambda (x) (declare (ignore x))
		      (s-value *sx* :chunk-id-visible nil))))
  (create-instance 'status-XB-static-links gg:x-set-function-button-panel
    (:left middle-soar-status-margin)
    (:top (+ (g-value status-XB-gd-chunk :top) 5
             (g-value status-XB-gd-goal :height)))
    (:items '("Show static links"))
    (:set-function #'(lambda (x) (declare (ignore x))
		      (s-value *sx* :show-static-links t)))
    (:unset-function #'(lambda (x) (declare (ignore x))
		      (s-value *sx* :show-static-links nil))))
  (create-instance 'status-XB-static-text gg:x-set-function-button-panel
    (:left middle-soar-status-margin)
    (:top (+ (g-value status-XB-static-links :top)
             (g-value status-XB-gd-goal :height)))
    (:items '("Show static text"))
    (:set-function #'(lambda (x) (declare (ignore x))
		      (s-value *sx* :show-static-text t)))
    (:unset-function #'(lambda (x) (declare (ignore x))
		      (s-value *sx* :show-static-text nil))))
  (create-instance 'status-xb-disappear-after-select gg:x-set-function-button-panel
    (:left middle-soar-status-margin)
    (:top (+ (g-value status-XB-static-text :top)
             (g-value status-XB-gd-goal :height)))
    (:items '("Menus be static"))
    (:set-function #'(lambda (x)
		      (declare (ignore x))
                  (let* ( (menu (g-value gdw-popup-menu-window :menu))
			  (menu2 (g-value static-menu-window :menu)))
                    (setf menus-disappear-after-selection nil)
        (s-value menu :disappear-after-selection nil)
	(s-value menu2 :disappear-after-selection nil))))
    (:unset-function #'(lambda (x)
		      (declare (ignore x))
                  (let* ( (menu (g-value gdw-popup-menu-window :menu))
			 (menu2 (g-value static-menu-window :menu)))
                    (setf menus-disappear-after-selection t)
        (s-value menu :disappear-after-selection t)
	(s-value menu2 :disappear-after-selection t)))))
  (g-value status-xb-disappear-after-select :value)
  (s-value status-xb-disappear-after-select
           :value (if (and (boundp 'gdw-popup-menu-window)
                           (schema-p gdw-popup-menu-window))
                      (if (not (g-value gdw-popup-menu-window :menu
                                :disappear-after-selection))
                          '("Menus be static")
                          )))
  (g-value status-xb-disappear-after-select :value)
  (create-instance 'status-xb-update-live-windows-always
		   gg:x-set-function-button-panel
    (:left middle-soar-status-margin)
    (:top (+ (g-value status-xb-disappear-after-select :top)
             (g-value status-XB-gd-goal :height)))
    (:items '("Always update windows"))
    (:set-function #'(lambda (x) (declare (ignore x))
                      (format t "; always-update turned on")
                      (print-sx-prompt)
                      (s-value *sx* :update-live-windows-always t)))
    (:unset-function #'(lambda (x)  (declare (ignore x))
                      (format t "; always-update turned off")
                      (print-sx-prompt)
                      (s-value *sx* :update-live-windows-always nil))))
  (g-value status-xb-update-live-windows-always :value)

;; phony
  (create-instance 'status-xb-auto-scroll gg:x-set-function-button-panel
    (:left middle-soar-status-margin)
    (:top (+ (g-value status-xb-update-live-windows-always :top)
             (g-value status-XB-gd-goal :height)))
    (:items '("Auto scroll"))
    (:set-function #'(lambda (x) (declare (ignore x))
                      (format t "; auto-scroll turned on")
                      (print-sx-prompt)
                      (s-value *sx* :auto-scroll t)))
    (:unset-function #'(lambda (x)  (declare (ignore x))
                      (format t "; auto-scroll turned off")
                      (print-sx-prompt)                      
                      (s-value *sx* :auto-scroll nil))))
  (g-value status-xb-auto-scroll :value)
  (s-value status-xb-auto-scroll
           :value (if (g-value *sx* :auto-scroll) '("Auto scroll")))

  (s-value status-XB-gd 
           :value (if soar::graphic-display? '("Graphic display?")))
  (s-value status-XB-gd-goal 
           :value (if (g-value *sx* :goal-id-visible) '("Goal")))
  (s-value status-XB-gd-problem-space 
           :value (if (g-value *sx* :problem-space-id-visible) 
                       '("Problem-Space")))
  (s-value status-XB-gd-state 
           :value (if (g-value *sx* :state-id-visible) '("State")))
  (s-value status-XB-gd-operator 
           :value (if (g-value *sx* :operator-id-visible) '("Operator")))
  (s-value status-XB-gd-chunk 
           :value (if (g-value *sx* :chunk-id-visible) '("Chunk")))
  (s-value status-XB-static-links
           :value (if (g-value *sx* :show-static-links) '("Show static links")))
  (s-value status-XB-static-text
           :value (if (g-value *sx* :show-static-text) '("Show static text")))

  (g-value status-xb-update-live-windows-always :value)
  (s-value status-xb-update-live-windows-always :value
           (if (g-value *sx* :update-live-windows-always)
	       '("Always update windows")))

  (opal:add-components soar-status-window-agg
                       status-XB-gd
                       status-XB-gd-goal
                       status-XB-gd-problem-space
                       status-XB-gd-state
                       status-XB-gd-operator
		       status-XB-gd-chunk
                       status-XB-static-links
                       status-XB-static-text 
		       status-xb-id-text
                       status-xb-disappear-after-select
		       status-xb-update-live-windows-always
                       status-xb-auto-scroll
                       )
;; )


;;;
;;;	Ic. 	Create-status-radio-buttons
;;;

;; (defun Create-status-radio-buttons (window-agg)
;;  "Create the radio buttons for the status buttons."
 (create-instance 'status-xb-watch-text opal:text
    (:left left-soar-status-margin)
    (:top (+ (g-value status-XB-taql-verbose :top) 5
             (g-value status-XB-taql-verbose :height)))
    (:string "Watch level:"))
 (create-instance 'status-RB-watch gg:radio-button-panel
    (:left left-soar-status-margin2)
    (:value (o-formula (format nil "~a" (gv *sx* :watch))))
    (:text-on-left-p nil)
    (:h-align :left)    
    (:top (+ (g-value status-xb-watch-text :top) 5
             (g-value status-xb-watch-text :height)))
    (:items '( ("-1" sx-watch-1)   ("0" sx-watch0) 
               ("0.5" sx-watch5)   ("1" sx-watch1)
               ("1.5" sx-watch15)  ("2" sx-watch2)
               ("3" sx-watch3)
              ))
    (:button-diameter 18))
 (opal:add-components soar-status-window-agg  ; window-agg
                      status-xb-watch-text
                      status-RB-watch  )
;; )


;;; 	Id.  Create-status-put-me-away
;;;
;;;

;; (defun Create-status-put-me-away (window-agg)
;;  "create the text button for closing the display"
 (create-instance 'status-put-me-away  put-me-away-button)
 (opal:add-components soar-status-window-agg  ; window-agg
                      status-put-me-away)
;; )

(eval-when (load eval)
 (push soar-status-window opal:garnet-Hour-Glass-Windows)
 (opal:update soar-status-window)
)
