;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-


(proclaim '(special *gtrace* *otrace* *decide-count* *subgoal-tabs*))

(defvar last-time nil)
(defvar first-time nil)
(defvar statistics-interval nil)

(defun print-statistics (decision-cycle)
  (let (old-time)
    (stop-elapsed-time)

    (when (= 0 decision-cycle)
      (setq last-time nil)
      (setq first-time nil)
      )

    (traceterpri)
    (setq old-time last-time)
    (setq last-time (time))
    (traceprinc (format nil "[~7D]"
			(if (null first-time)
			    (progn
			      (setq first-time last-time)
			      0
			      )
			    (progn
			      (time-difference last-time first-time)
			      )
			    )
			)
		)
    (traceprinc (format nil "[~7D]"
			(if (numberp old-time)
			    (time-difference last-time old-time)
			    0
			    )
			)
		)

    (when (and (numberp statistics-interval) (= 0 (mod decision-cycle statistics-interval)))
      (memories)
      (traceterpri)
      (setq old-time last-time)
      (setq last-time (time))
      (traceprinc (format nil "[~7D]"
			  (if (null first-time)
			      (progn
				(setq first-time last-time)
				0
				)
			      (progn
				(time-difference last-time first-time)
				)
			      )
			  )
		  )
      (traceprinc (format nil "[~7D]"
			  (if (numberp old-time)
			      (time-difference last-time old-time)
			      0
			      )
			  )
		  )
      )
    (start-elapsed-time)
    )
)

(defun trace-object (type id depth) ; Randy.Gobbel 12-Sep-86 12:06 
       (cond ((or (and (not *gtrace*)
		       (not *otrace*))
		  (not (trace-problem-space?))
		  (eq id 'undecided)))
	     ((and *otrace* id)

	      (print-statistics *decide-count*)

	      (traceterpri)
				      
	      (traceprinc *decide-count*)
	      (cond ((and *subgoal-tabs* (not (eqp depth 0))
			  (eq type 'goal))
		     (do-tabto (plus 2 (times depth 3))
			       (trace-file))
		     (traceprinc '==>))
		    (*subgoal-tabs* (do-tabto (plus 5 (times depth 3))
					      (trace-file)))
		    (t (do-tabto 5 (trace-file))
		       (traceprinc3 "(" depth ")")
		       (do-tabto 11 (trace-file))))
	      (traceprinc2 (cond ((eq type 'goal)
				  'g)
				 ((eq type 'problem-space)
				  'p)
				 ((eq type 'state)
				  's)
				 ((eq type 'operator)
				  'o))
			   ": ")
	      (print-id id))))
