;;; -*- Mode:Common-Lisp; Package:User; Fonts:(CPTFONT HL12B HL12BI); Base:10 -*-


;.................................
;ASK-FOR-CHOICE
;calls SOAR-MENU-SELECT
;.................................
(defun ask-for-choice (choice-list) ; Randy.Gobbel 31-Jul-86 15:16 
       (prog (choice)
	     (stop-elapsed-time)
	     (setq choice (soar-menu-select "Select one" choice-list))
	     (start-elapsed-time)
	     (return choice)))


						
;.................................
;SOAR-MENU-SELECT
;build a menu using the trace-attributes of the choice-list
;.................................
(defun soar-menu-select (header choice-list)
  (let (result
	;build a choice list with documentation of trace-attributes for the
	;choice objects
	(new-choice-list (build-choice-list choice-list))	
	)
    (setf result (tv:menu-choose new-choice-list header))
    (cond (result				;if result of choosing from the menu
	   result)				;was non-nil, use it.
	  (t					;else
	   (car choice-list))			;just take the first choice
	  )
    )
  )						;end SOAR-MENU-SELECT



;.................................
;BUILD-CHOICE-LIST
;For each item in the choice-list, add documentation that consists
;of its trace-attributes.
;.................................
(DEFUN build-choice-list (choice-list)
  (COND ((NULL choice-list)
	 nil
	 )
	((ATOM choice-list)
	 `(,choice-list :value ,choice-list
	   :documentation ,(print-id-2 choice-list))	;print-id-2 puts the
						;trace-attributes into a string
	 )
	(t					;a list
	 (CONS (build-choice-list (CAR choice-list))
	       (build-choice-list (CDR choice-list)))
	 )
	)
  )						;end BUILD-CHOICE-LIST




;.................................
;PRINT-INSTANCE-STRING
;given a stream, print the trace-attributes of id to the stream.  The point of
;this function is that PRINT-INSTANCE just would print to stdoutput each part of
;the attributes as it came to it, which is no good if you want to collect it all in
;one place.  This stream can then be converted to a string. 
;.................................
(defun print-instance-string
  (id result-stream) ; John.Laird 15-Nov-85 16:00 
  (prog
    (flag flag2 )
    (cond
      ((and (symbolp id)
	    (get id 'instance))
       (setq flag nil flag2 nil )
       (soarmapc
	 #'(lambda (object)
		   (cond ((and (symbolp object)
			       (get object 'name))
			  (cond ((neq '! (get object 'name))
				 (cond ((or flag flag2)
					(princ " " result-stream))
				       
				       (t (princ " (" result-stream)
					  (setq flag t)))
				 (princ (get object 'name) result-stream)
				 (cond ((not (soarmemq object 
						     *print-attribute-list*))
					(soarpush object *print-attribute-list*)
					(print-instance-string object result-stream))))))
			 (t (cond (*full-print-id*
				    (cond (flag (princ " " result-stream))
					  (t (princ "(" result-stream)
					     (setq flag t)))
				    (princ object result-stream)))
			    (cond ((not (soarmemq object *print-attribute-list*)
					)
				   (soarpush object *print-attribute-list*)
				   (setq flag2 (print-instance-string object result-stream)))))))
	 (get id 'instance))
       (and flag (princ ")" result-stream))
       (return result-stream)))))







;.................................
;PRINT-ID-2
;using print-instance-string, get the trace-attributes of an id in a string
;by calling print-instance-string with a string output stream.  
;.................................
(defun print-id-2 (id) ; John.Laird 10-Oct-85 10:23
  (LET ((string-str (MAKE-STRING-OUTPUT-STREAM))
	)
;       (soarprinc2 id " ")
       (FORMAT string-str "~a " id)
       (cond ((and id (atom id)
		   (neq id 'undecided))
	      (and (get id 'name)
		   (princ (get id 'name) string-str))
	      (setq *print-attribute-list* (list id))
	      (print-instance-string id string-str)	;print into string stream
	      (setq *print-attribute-list* nil)
	      (GET-OUTPUT-STREAM-STRING string-str)	;produce the string from the string stream
	      )
	     )
       )
  )						;end PRINT-ID-2



;.................................
;PRINT-ID-3
;Similar to print-id-2, but 
;this version doesn't print the id itself, just the attribute info.
;.................................
(defun print-id-3 (id) ; John.Laird 10-Oct-85 10:23
  (LET ((string-str (MAKE-STRING-OUTPUT-STREAM))
	)
       (cond ((and id (atom id)
		   (neq id 'undecided))
	      (and (get id 'name)
		   (princ (get id 'name) string-str))
	      (setq *print-attribute-list* (list id))
	      (print-instance-string id string-str)
	      (setq *print-attribute-list* nil)
	      (GET-OUTPUT-STREAM-STRING string-str)
	      )
	     )
       )
  )						;end PRINT-ID-3


;;
;; [RMW, 6/15/87] modified to print what the choices were along
;; with the selected one
;;
(defun process-results (results id) ; John.Laird 19-May-86 15:27  ; RETURN 
 ; ONE RESULT 
  (let (pick)
       (cond ((null (cdr results))
	      (car results))
	     ((and (soarlistp id)
		   (soarmemq (car id)
			     results))
	      (car id))
	     ((soarmemq id results)
	      id)
	     ((eq *select-equal* 'first)
	      (show-choices results)
	      (setq pick (car results))
	      (show-pick pick)
	      pick)
	     ((soarlistp *select-equal*)
	      (cond ((setq pick (find-selected-result (pop *select-equal*)
					   results))
		     (show-choices results)
		     (show-pick pick)
		     pick)
		    (t (setq *select-equal* t)
		       (setq pick (ask-for-choice results))
		       (show-choices results)
		       (show-pick pick)
		       pick)))
	     (*select-equal* (setq pick (ask-for-choice results))
			     (show-choices results)
			     (show-pick pick)
			     pick)
	     (t (setq pick (soarnth (random (1- (length results)))
				     results))
		(show-choices results)
		(show-pick pick)
		pick))))

(defun show-choices (results)
  (soarterpri)
  (soarprinc "Choosing from:")
  (mapcar #'(lambda (id)
	      (soarterpri)
	      (soarprinc (print-id-2 id))
	  )
	  results
  )
)

(defun show-pick (pick)
  (soarterpri)
  (soarprinc "Chose:")
  (soarprinc (print-id-2 pick))
)
