
(defun diff (x y)
  (not (equal x y)))

#|
(defun object-room-p (obj room)
  (if (member (list 'inroom obj room) (give-me-nice-pos-state)
	      :test #'equal) t nil))


(defun object-room-p (obj room)
  (eq room (get-object-rooom obj)))

(defun get-object-room (obj)
  (let ((inroom-hash (gethash 'in-room 
			      (p4::problem-space-assertion-hash
			       *current-problem-space*))))
    (do ((assertions inroom-hash (cdr assertions)))
	((or (null assertions)
	     (member obj (p4::literal-arguments (car assertions))))
	 (cond ((null assertions)
		(error "~% ROOM OF OBJECT ~A is missing." obj))
	       (t (second (p4::literal-arguments (car assertions)))))))))

(defun adjacent-room-p (obj to-room from-room)
  (let ((adjacent-rooms
	 (mapcar #'(lambda (x) (fourth x))
		 (remove-if-not #'(lambda (x) (and (eq (car x) 'connects)
						   (eq (third x) to-room)))
				(give-me-nice-pos-state))))
	(obj-current-room
	 (third
	  (find-if #'(lambda (x) (and (eq (car x) 'inroom)
				      (eq (second x) obj)))
		   (give-me-nice-pos-state)))))
    (if (member obj-current-room adjacent-rooms)
	(eq obj-current-room from-room)
	(if (member from-room adjacent-rooms) t nil))))

(defun adjacent-door-p (obj door room)
  (let ((rooms-of-door 
	 (mapcar #'(lambda (x) (third x))
		 (remove-if-not #'(lambda (x) (and (eq (car x) 'dr-to-rm)
						   (eq (second x) door)))
				(give-me-nice-pos-state))))
	(obj-current-room
	 (third
	  (find-if #'(lambda (x) (and (eq (car x) 'inroom)
				      (eq (second x) obj)))
		   (give-me-nice-pos-state)))))
    (if (member obj-current-room rooms-of-door)
	(eq obj-current-room room)
	(if (member room rooms-of-door) t nil))))

(defun robot-room-p (room)
  (if (member (list 'inroom 'robot room) (give-me-nice-pos-state)
	      :test #'equal) t nil))

(defun type-of-p (inst type)
  (if (or (is-in-p inst type)
	  (isa-p (pa-class-of inst) type))
      t nil))

(defun prefer-robot-room-p (door room)
  (let ((rooms-of-door 
	 (mapcar #'(lambda (x) (third x))
		 (remove-if-not #'(lambda (x) (and (eq (car x) 'dr-to-rm)
						   (eq (second x) door)))
				(give-me-nice-pos-state))))
	(robot-current-room 
	 (third
	  (find-if #'(lambda (x) (and (eq (car x) 'inroom)
				      (eq (second x) 'robot)))
		   (give-me-nice-pos-state)))))
    (if (member robot-current-room rooms-of-door)
	(eq robot-current-room room)
	t)))
|#