#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))

	
;--------------------------------------------------------------------------
	

;;; Returns the node that is the virtual pre-parent of node
;;;
(defun v-pre-parent (node)
  (node-parent (leftmost-clone node)))


;;; Returns the node that is the last virtual post-parent of node
;;;
(defun v-post-parent (node)
  (car (node-children (rightmost-clone node))))

;--------------------------------------------------------------------------

;;; Returns the left clone of node
;;;
(defun left-clone (node)
  (node-left-clone node))


;;; Returns the nth right clone of node, lower number is newer.
;;; NOTE: will produce an error if n < 1.
;;;
(defun right-clone (node n)
  (nth (1- n) (node-right-clones node)))


;;; Returns the leftmost clone of node
;;;
(defun leftmost-clone (node)
  (cond ((null (left-clone node))
          node)
        (t
          (leftmost-clone (left-clone node)))))


;;; Returns the newest rightmost clone of node
;;;
(defun rightmost-clone (node)
  (cond ((null (right-clone node 1))
          node)
        (t
          (rightmost-clone (right-clone node 1)))))

;--------------------------------------------------------------------------

;;; Returns the nth virtual child of node (note that a child that is
;;; an applied node is not a virtual child).
;;; NOTE: error results if n < 1.
;;;
(defun v-child (node n)
  (let ((child (nth (1- n) (node-children node))))
    (cond ((node-applied-node child) nil)
          (t child))))
 
;--------------------------------------------------------------------------

;;; Prints the clone-tree to the right of a node starting at indent level
;;;
(defun clone-tree (node level)
  (cond ((not (node-p node)) nil)
        (t
          (print-node node 'current level)
          (dolist (right-clone (node-right-clones node) 
		               (node-right-clones node))
		  (clone-tree right-clone (1+ level))))))


