#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))

(proclaim 
    '(special *FAILURE-RECORDING* *INFERENCES-ONLY*
	      *CAND-NODES* *CURRENT-NODE*
	      *SCR-NODE-SELECT-RULES*  *SCR-GOAL-SELECT-RULES* 
	      *SC-TIME-COUNTER* *CACHED-CANDS*
	      *SCR-OP-SELECT-RULES* *SCR-BINDINGS-SELECT-RULES*
	      *SCR-NODE-REJECT-RULES*  *SCR-GOAL-REJECT-RULES* 
	      *SCR-OP-REJECT-RULES* *SCR-BINDINGS-REJECT-RULES*
	      *SCR-NODE-PREFERENCE-RULES* *SCR-GOAL-PREFERENCE-RULES* 
	      *SCR-OP-PREFERENCE-RULES* *SCR-BINDINGS-PREFERENCE-RULES*
	      *RESTORE-VALUES-MODE* *ACTIVATE-EBL* *MIN-MATCH-TIME*))

;  This file contains the code for Prodigy's control mechanisms.
; 
; All 4 ordering functions work the same way. Each of these
; calls a recursive function which finds a best candidate,
; ie. a candidate is best if there does not exist another candidate
; which is preferred over it. Note that if there is a cycle, no
; candidate in the cycle will be considered best. (Returns nil)

;  ------------------ Random Local Stuff  ---------------------

; ONLY-ONE is used as a shorthand, just local to this file

(defmacro only-one (l)
    (list 'not (list 'cdr l)))

; Gives you all the members of list l1 that aren't members of list l2
; make this a private function

(defun ldifference (l1 l2)
    (cond ((null l2) l1)
          (t (rec-ldifference l1 l2))))
	  
(defun rec-ldifference (l1 l2)
    (cond ((null l1) nil)
          ((member (car l1) l2 :test #'equal) (rec-ldifference (cdr l1) l2))
	  (t (cons (car l1) (rec-ldifference (cdr l1) l2)))))
	

(defun record-scntrls (node rule bls objs node-prop)
   (let ((info (mapcar #'(lambda (b ob) (list rule b ob)) bls objs)))
     (case node-prop
       ('select-node-hst
	(setf (node-select-node-hst node)
	      (nconc info (node-select-node-hst node))))
       ('reject-node-hst 
	(setf (node-reject-node-hst node)
	      (nconc info (node-reject-node-hst node))))
       ('select-goal-hst
	(setf (node-select-goal-hst node)
	      (nconc info (node-select-goal-hst node))))
       ('reject-goal-hst
	(setf (node-reject-goal-hst node)
	      (nconc info (node-reject-goal-hst node))))
       ('select-op-hst
	(setf (node-select-op-hst node)
	      (nconc info (node-select-op-hst node))))
       ('reject-op-hst
	 (setf (node-reject-op-hst node)
	       (nconc info (node-reject-op-hst node))))
       ('select-bindings-hst
	(setf (node-select-bindings-hst node) 
	      (nconc info (node-select-bindings-hst node))))
       ('reject-bindings-hst
	(setf (node-reject-bindings-hst node) 
	      (nconc info (node-reject-bindings-hst node)))))))


(defun record-pref (node rule best bls objs node-prop)
  (let ((info (mapcar #'(lambda (b ob) (list rule best b ob)) bls objs)))
    (case node-prop 
      ('node-pref-hst
       (setf (node-node-pref-hst node)
	     (nconc info (node-node-pref-hst node))))
      ('goal-pref-hst 
       (setf (node-goal-pref-hst node) 
	     (nconc info (node-goal-pref-hst node))))
      ('op-pref-hst 
       (setf (node-op-pref-hst node) 
	     (nconc info (node-op-pref-hst node))))
      ('bindings-pref-hst 
       (setf (node-bindings-pref-hst node) 
	     (nconc info (node-bindings-pref-hst node)))))))


; can speed up..., used for EBL utility analysis
; This is only called if *EBL-FLAG* is true (indicating that 
; the ebl sybsystem has been loaded. Only actually add time
; if ebl has been activated.

(defun record-sc-time (rule-nm start stop)
  (if *ACTIVATE-EBL*
      (let ((new-time (- stop start))
	    (prev-time (scr-match-time rule-nm)))
	(cond ((< new-time *MIN-MATCH-TIME*)
	       (setf (scr-match-time rule-nm)
		     (+ *MIN-MATCH-TIME* prev-time)))
	      (t (setf (scr-match-time rule-nm)
		     (+ new-time prev-time)))))))


; ------------------- NODE DECISIONS -----------------

;  Node decisions needs to be rewritten -- right now the only thing
;  that really works is reject-nodes.



(defun scr-choose-nodes (cand-nodes)

  "SCR-CHOOSE-NODES takes the current set of nodes, decides if the first node
   (ie. the child just generated) should be selected or rejected. A node is
   only selected or rejected once; if it is selected, it becomes the sole 
   candidate in the set of candidate noes; if rejected, it is  deleted from
   the set of candidate-nodes.  The scr-order nodes picks out the best node
   and puts it at the head of the list of cand-nodes, which is then returned."

  (cond (*WHAT-IF-FLAG*
	 (setq *WHAT-IF-FLAG* nil)
	 (push *WHAT-IF-NODE* cand-nodes))
	((null cand-nodes) nil)
	((endp (cdr cand-nodes))
	 (setq cand-nodes (scr-reject-nodes cand-nodes)))
	(t 
	 (setq cand-nodes 
	            (scr-reject-nodes (scr-select-nodes cand-nodes)))
         (setq cand-nodes (scr-order-nodes cand-nodes))))
  (let ((node (pop cand-nodes)))
    (values node cand-nodes)))


(defun scr-select-nodes (cand-nodes)
  (setq *CAND-NODES* cand-nodes) 
  (g-loop (init rules *SCR-NODE-SELECT-RULES*
		rule-nm nil bindings-lists nil 
		selected-nodes nil new-selections nil)
	  (while  (setq rule-nm (car (pop rules))))
	  (do (setq bindings-lists 
		    (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
	      (cond (bindings-lists
		     (setq new-selections
			   (mapcar #'(lambda (b)
				       (caddr (subst-bindings 
					       (scr-rhs rule-nm)
					       b)))
				   bindings-lists))
		     (dolist (node new-selections)
		       (unless (member node selected-nodes :test #'equal)
			 (push node selected-nodes))
		       (record-scntrls (car selected-nodes)
				       rule-nm  bindings-lists 
				       selected-nodes 'select-node-hst)))))
	  (result (or selected-nodes cand-nodes))))
	  
; should move the format statement in this fn to output.lisp

(defun scr-reject-nodes (cand-nodes)
  (setq *CAND-NODES* cand-nodes)
  (g-loop (init rules *SCR-NODE-REJECT-RULES*
		rule-nm nil bindings-lists nil rejected-nodes nil)
	  (while (and (setq rule-nm (car (pop rules))) cand-nodes))
	  (do 
	      (and *EBL-FLAG*
		   (setq *SC-TIME-COUNTER* (get-internal-run-time)))
	      (setq bindings-lists 
		    (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
	    (if  *EBL-FLAG* 
		(record-sc-time rule-nm *SC-TIME-COUNTER*
				 (get-internal-run-time)))
            ; will probably only reject one node at at time, but written
            ; to be able to reject multiple nodes. Should rewrite for elegance.
	    (g-loop (while bindings-lists)
		    (do (push (subst-bindings (caddr (scr-rhs rule-nm))
					      (car bindings-lists))
			      rejected-nodes)
			; yuck, change this
			(cond ((member (car rejected-nodes)
					 (cdr rejected-nodes))
				 (pop rejected-nodes))
				(t (if *EBL-FLAG* ; should move this to output!
				       (format t "~2%SCR rejected node: ~a ~a~% -------------------------------" rule-nm (car rejected-nodes)))
                                   (record-scntrls (car rejected-nodes) 
						  rule-nm (list (car bindings-lists))
						  (list (car rejected-nodes))
						  'reject-node-hst))))
		    (next bindings-lists (cdr bindings-lists))))
	  (until (and *EBL-FLAG* rejected-nodes)) ; with EBL, can only
						  ; reject primary-cand-node
	  (result (if-del-memq-list rejected-nodes cand-nodes))))



(defun scr-order-nodes (cand-nodes)
    (setq *CAND-NODES* cand-nodes)
    "See notes on ordering functions at the beginning of this file"
    (cond ((cdr cand-nodes)
	   (let ((best (recur-order-nodes (car cand-nodes) 
			   (list (car cand-nodes)) -1 cand-nodes)))
		(cond (best (cons best (del-eq best cand-nodes)))
		      (cand-nodes))))
	  (cand-nodes)))
	    
; travel up Directed Graph looking for a best guy, such that the chain from 
; bottom to top is never rising in priority, and no repeats.

; if priority cycle, uncommit, if regular cycle, stay with guy and look
; for a better one.


; returns best guy, or nil if a high priority rule recommends someone
; better (in which case there must be a cycle of sorts), 

;  PREF-GRAPH = ((node rule-nm (preferred-node1 preferred-node2..))....)


(defun recur-order-nodes (best previously-considered orig-priority cand-nodes)
    "returns the best guy (or nil if there are cycles)"
    (g-loop (init rules *SCR-NODE-PREFERENCE-RULES* cached-cands nil
		  cands nil rule-nm nil bindings-lists nil ret-val nil)
	    (while (setq rule-nm (car (pop rules))))
	    (do (setq bindings-lists
		      (scr-match rule-nm (scr-lhs rule-nm) 
			  (rhs-meta-bindings best 
			      (cadddr (scr-rhs rule-nm)))))
		(setq cached-cands (get-cached-cands rule-nm best cand-nodes
				       *NODE-PREF-GRAPH*))
;		(and cached-cands (format t "CACHED: ~A" cached-cands))
		(cond ((or bindings-lists cached-cands)
		       (setq cands (mapcar #'(lambda (b) 
						     (subst-bindings 
							(caddr (scr-rhs rule-nm))
							b))
					   bindings-lists))
		       (and cands
  		          (setq *NODE-PREF-GRAPH*
			     (cons (list best rule-nm cands)
				   *NODE-PREF-GRAPH*)))
		       (setq cands (remove-duplicates (append cands
							      cached-cands)))
		       (record-pref best rule-nm best
			   (append bindings-lists (make-n-cached-signs
						      (length cached-cands)))
			   cands 'node-pref-hst)
		       (cond ((< (scr-priority rule-nm) orig-priority)
			      (return nil)))
		       (g-loop (init cand nil)
			       (while (setq cand (pop cands)))
			       (do (cond ((member cand previously-considered
						  :test #'equal))
					 ((setq ret-val 
						(recur-order-nodes
						    cand 
						    (cons cand previously-considered)
						    (scr-priority rule-nm)
						    cand-nodes)))
					 ((push cand previously-considered))))
			       (until ret-val)))))
	    (until ret-val)
	    (result (progn (set-latest-node-pref best (car *all-nodes*))
			   (or ret-val best)))))


;  need this so analyze facility will have equal number of bindings for 
; cands

(defun make-n-cached-signs (n)
    (g-loop (init ret-val nil)
	    (while (> n 0))
	    (do (push '((<all-vars> cached)) ret-val))
	    (next n (- n 1))
	    (result ret-val)))

(defun get-cached-cands (rule-nm best cand-nodes graph)
    (cond  (*CACHED-CANDS* ; set by meta-function NODE-PREF-NOT-CAHCED
	       (setq *CACHED-CANDS* nil)
	       (g-loop (init ret-val nil entry nil)
		       (while (setq entry (pop graph)))
		       (do (cond ((and (equal (car entry) best)
				       (equal (cadr entry) rule-nm))
				  (setq ret-val (append (caddr entry) ret-val)))))
		       (result (intersection ret-val cand-nodes))))))
						


; -------------- GOAL DECISIONS -------------------

(defun scr-choose-goals (cand-goals node)
    (setq *CURRENT-NODE* node)
    (cond ((null cand-goals) cand-goals)
	  ((null (cdr cand-goals)) 
	   (scr-reject-goals node cand-goals))
	  (t 
	     (scr-reject-goals node
		 (scr-select-goals node cand-goals)))))

    
;  This can probably be improved.

(defun scr-select-goals (node cand-goals)
  (setf (node-candidate-goals node) cand-goals)
  (g-loop (init rules *SCR-GOAL-SELECT-RULES*
		rule-nm nil bindings-lists nil 
		selected-goals nil new-selections nil)
	  (while (and (setq rule-nm (car (pop rules))) cand-goals))
	  (do (and *EBL-FLAG*
		   (setq *SC-TIME-COUNTER* (get-internal-run-time)))
	      (setq bindings-lists 
		    (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
	    (and *EBL-FLAG* 
		 (record-sc-time rule-nm *SC-TIME-COUNTER*
				 (get-internal-run-time)))
	    (cond (bindings-lists
		   (setq new-selections
			 (mapcar #'(lambda (b)
				     (caddr (subst-bindings 
					     (scr-rhs rule-nm) 
					     b)))
				 bindings-lists))
		   (record-scntrls node rule-nm bindings-lists new-selections
				   'select-goal-hst)
		   (setq cand-goals
			 (if-del-member-list new-selections cand-goals))
		   (setf (node-candidate-goals node) cand-goals)
		   (dolist (goal new-selections)
		     (cond ((not (member goal selected-goals 
					 :test #'equal))
			    (push goal selected-goals)))))))
	  (result (or selected-goals cand-goals))))


(defun scr-reject-goals (node cand-goals)
    (setf (node-candidate-goals node) cand-goals)
    (g-loop (init rules *SCR-GOAL-REJECT-RULES*
		  rule-nm nil bindings-lists nil new-rejections nil)
	    (while (and (setq rule-nm (car (pop rules))) cand-goals))
	    (do (and *EBL-FLAG*
		     (setq *SC-TIME-COUNTER* (get-internal-run-time)))
		(setq bindings-lists 
		      (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
		(and *EBL-FLAG* 
		     (record-sc-time rule-nm *SC-TIME-COUNTER*
				     (get-internal-run-time)))
		(cond (bindings-lists
			  (setq new-rejections
				(mapcar #'(lambda (b)
						  (caddr (subst-bindings 
							     (scr-rhs rule-nm) 
							     b)))
					bindings-lists))
			  (record-scntrls node rule-nm bindings-lists new-rejections
			      'reject-goal-hst)
			  (setq cand-goals 
				(if-del-member-list new-rejections cand-goals))
			  (setf (node-candidate-goals node) cand-goals))))
	    (result cand-goals)))
 
; See notes on ordering functions at the beginning of this file

(defun scr-order-goals (node cand-goals)
    (cond ((only-one cand-goals) (car cand-goals))
	  (t
	     (setf (node-candidate-goals node) cand-goals)
	     (or (recur-order-goals (car cand-goals) 
		     (list (car cand-goals)) node -1)
		 (car cand-goals)))))



; returns the best guy (or nil if there are cycles)
    
(defun recur-order-goals (best previously-considered node orig-priority)
    (g-loop (init rules *SCR-GOAL-PREFERENCE-RULES* cands nil 
		  cand nil rule-nm nil bindings-lists nil ret-val nil)
	    (while (setq rule-nm (car (pop rules))))
	    (do (and *EBL-FLAG*
		     (setq *SC-TIME-COUNTER* (get-internal-run-time)))
		(setq bindings-lists
		      (scr-match rule-nm (scr-lhs rule-nm) 
			  (rhs-meta-bindings best (cadddr (scr-rhs rule-nm)))))
		(and *EBL-FLAG* 
		     (record-sc-time rule-nm *SC-TIME-COUNTER*
				     (get-internal-run-time)))
		(cond (bindings-lists 
			  (setq cands (mapcar #'(lambda (b)
							(subst-bindings 
							    (caddr (scr-rhs rule-nm))
							    b))
					      bindings-lists))
			  (record-pref node rule-nm best bindings-lists cands
			      'goal-pref-hst)
			  (cond ((< (scr-priority rule-nm) orig-priority)
				 (return nil)))
			  (g-loop (while (setq cand (pop cands)))
				  (do (cond ((member cand previously-considered
						     :test #'equal))
					    ((setq ret-val
						   (recur-order-goals cand 
						       (cons cand previously-considered)
						       node (scr-priority rule-nm))))
					    ((push cand previously-considered))))			  
				  (until ret-val)))))
	    (until ret-val)
	    (result (or ret-val best))))


;  ------------------ OPERATOR DECISIONS  ------------------

(defun scr-choose-ops (cand-ops goal node)
    (setq *CURRENT-NODE* node)
    (setf (node-current-goal node) goal)
    (cond ((null (cdr cand-ops))
	   (scr-reject-ops node cand-ops))
	  ((scr-reject-ops node
	       (scr-select-ops node cand-ops)))))

 
;  I can speed this up, special case for ops!

(defun scr-select-ops (node cand-ops)
    (setf (node-candidate-ops node) cand-ops)
    (g-loop (init rules *SCR-OP-SELECT-RULES*
		   rule-nm nil bindings-lists nil
		   num-cand-ops (length cand-ops)
		   selected-ops nil new-selections nil)
	     (while (and (setq rule-nm (car (pop rules))) cand-ops))
	     (do (and *EBL-FLAG*
		      (setq *SC-TIME-COUNTER* (get-internal-run-time)))
	         (setq bindings-lists 
		       (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
	         (and *EBL-FLAG* 
		   (record-sc-time rule-nm *SC-TIME-COUNTER*
				   (get-internal-run-time)))
		 (cond (bindings-lists
		           (setq new-selections 
			         (mapcar #'(lambda (b)
				              (caddr (subst-bindings 
					               (scr-rhs rule-nm) b)))
			                   bindings-lists))
			   (record-scntrls node rule-nm bindings-lists new-selections
                                           'select-op-hst)
			(setq cand-ops
			      (if-del-memq-list new-selections cand-ops))
			   (setf (node-candidate-ops node) cand-ops)
		           (dolist (op new-selections)
			           (cond ((not (member op selected-ops 
				                :test #'eq))
					  (push op selected-ops)))))))
	     (until (and  selected-ops *EBL-FLAG*))
	     (result (or selected-ops cand-ops))))
; if-del-memq used to delete cause their can be doubles -- an scr
; can fire with more than one set of bindings. Inefficient...

(defun scr-reject-ops (node cand-ops)
    (setf (node-candidate-ops node) cand-ops)
    (g-loop (init rules *SCR-OP-REJECT-RULES*
		  rule-nm nil bindings-lists nil 
		  new-rejections nil)
	    (while (and (setq rule-nm (car (pop rules))) cand-ops))
	    (do (and *EBL-FLAG*
		     (setq *SC-TIME-COUNTER* (get-internal-run-time)))
		(setq bindings-lists 
		      (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
		(and *EBL-FLAG* 
		     (record-sc-time rule-nm *SC-TIME-COUNTER*
				     (get-internal-run-time)))
		(cond (bindings-lists
			  (setq new-rejections
				(mapcar #'(lambda (b)
						  (caddr (subst-bindings 
							     (scr-rhs rule-nm) b)))
					bindings-lists))
			  (record-scntrls node rule-nm bindings-lists new-rejections
			      'reject-op-hst)
			  (setq cand-ops (if-del-memq-list new-rejections cand-ops))
			  (setf (node-candidate-ops node) cand-ops))))
	    (result cand-ops)))

(defun scr-order-ops (goal node cand-ops)
    (cond ((only-one cand-ops) (car cand-ops))
	  (t
	    (setq *CURRENT-NODE* node)
	    (setf (node-current-goal node) goal)
	    (setf (node-candidate-ops node) cand-ops)
	    (or (recur-order-ops (car cand-ops) 
		    (list (car cand-ops)) node -1)
		(car cand-ops)))))
    


(defun recur-order-ops (best previously-considered node orig-priority)
    (g-loop (init rules *SCR-OP-PREFERENCE-RULES* 
		  rule-nm nil bindings-lists nil ret-val nil 
		  rhs nil lhs nil new-rhs-guy nil cands nil cand nil)
	    (while (and (setq rule-nm (car (pop rules)))
			(setq lhs (scr-lhs rule-nm))
			(setq  rhs (scr-rhs rule-nm))))
	    (do (and *EBL-FLAG*
		     (setq *SC-TIME-COUNTER* (get-internal-run-time)))
		(setq bindings-lists
		      (scr-match rule-nm lhs 
			  (rhs-meta-bindings best (cadddr rhs))))
		(and *EBL-FLAG* 
		     (record-sc-time rule-nm *SC-TIME-COUNTER*
				     (get-internal-run-time)))
		(cond (bindings-lists
			  (setq new-rhs-guy (caddr (scr-rhs rule-nm)))
			  (setq cands 
				(cond ((is-variable new-rhs-guy)
				       (mapcar #'(lambda (b)
							 (cadr (assoc new-rhs-guy
								      b)))
					       bindings-lists))
				      ((list new-rhs-guy))))
			  (record-pref node rule-nm best bindings-lists cands
			      'op-pref-hst)
			  (cond ((< (scr-priority rule-nm) orig-priority)
				 (return nil)))
			  (g-loop (while (setq cand (pop cands)))
				  (do (cond ((member cand previously-considered
						     :test #'equal))
					    ((setq ret-val
						   (recur-order-ops cand 
						       (cons cand previously-considered)
						       node (scr-priority rule-nm))))
					    ((push cand previously-considered))))
				  (until ret-val)))))
	    (until ret-val)
	    (result (or ret-val best))))

 
;  ----------------  BINDINGS-DECISIONS --------------

; note: bindings are alternatively represented as vals-lists, a list
; of values for the variables in an operator, ordered in the same
; way that they appear in the operators params list
; Eg: if op has variables (<a> <b> <c> <d>) you might see a 
; vals-list like (3 5 <c> 8) to represent a partial set of bindings.

; Now that we're using params instead of vars list, may get

;(defun bindings-to-vals-list (bindings vars)
;    (subst-bindings vars bindings))

(defun vals-list-to-bindings (vals vars)
    (mapcan #'(lambda (val var)
		      (cond ((not (is-variable val))
			     (list (list var val)))
			    (t nil)))
	    vals vars))


; SCR-GENERATE-BINDINGS does bindings selections, but this is
; called in engine to act as a generator of bindings, unlike
; the other selection mechanisms, which take a list of candidates.
; Note that he partial bindings handed in come from the fact
; that the bindings are already partially instantiated in engine
; (either from matching the rhs of the operator, or from a 'reset-alt).

(defun scr-generate-bindings (partial-bindings op goal node)
  (setq *CURRENT-NODE* node)
  (setf (node-current-goal node) goal)	 
  (setf (node-current-op node) op)
  (scr-select-bindings op node partial-bindings nil 
	               *SCR-BINDINGS-SELECT-RULES*))


; Recurs over the set of selection rules, creating the bindings
; indicated by the selection rules.  It is passed in an initial
; partial set of bindings obtained by matching the goal with the rhs
; of a rule.  Then it matches the lhs of the rule to augment the
; partial bindings.  Finally, determine-bindings creates the final
; set of selected bindings using the rhs of the selection rule.
;
(defun scr-select-bindings (op node partial-b result-blsts rules)
  (cond ((null rules) result-blsts)
	(t (let* ((rule-nm (caar rules))
		  (sc-time-counter (get-internal-run-time))
		  (bindings-lists
		   (scr-match rule-nm (scr-lhs rule-nm) 
			      (or partial-b '((nil nil))))))
	     (if *EBL-FLAG* (record-sc-time rule-nm sc-time-counter
					    (get-internal-run-time)))
	     (if bindings-lists
		 (record-scntrls node rule-nm bindings-lists 
		       (mapcar #'(lambda (b)
				(subst-bindings (caddr (scr-rhs rule-nm)) b))
			      bindings-lists)
				 'select-bindings-hst))
	     (scr-select-bindings op node partial-b 
				  (nreverse 
				   	(determine-bindings op result-blsts 
							    bindings-lists
							    rule-nm))
				  (cdr rules))))))

;
;
; 
; Given the set of partial bindings from the rhs of the operator and
; the left hand side of the control rule, applies the rhs of the
; control to create a set of new-bindings.  It checks that this 
; new binding set does not conflict with the partial set of bindings.
; This may happen if the selection rule attempts to specify a differnt
; value for a bound variable.  In that case the binding is discarded.
;
(defun determine-bindings (op result-blsts bindings-lists rule-nm)
  (cond ((null bindings-lists) result-blsts)
	(t (let ((new-bindings
		  (vals-list-to-bindings (subst-bindings 
					  (caddr (scr-rhs rule-nm))
					  (car bindings-lists))
					 (op-params op))))
	     (cond ((or (member new-bindings result-blsts :test #'equal)
			;  subsumption check currently not implmented
			; (is-subsumed new-bindings result-blsts)
			(conflicting-bindings (car bindings-lists) 
					      new-bindings))
		    (determine-bindings op result-blsts 
					(cdr bindings-lists) rule-nm))
		   (t (determine-bindings op (cons new-bindings result-blsts)
					  (cdr bindings-lists) rule-nm)))))))

;
;
; Two bindings conflict if they both contain a variable bound to 
; different values.
;
(defun conflicting-bindings (binding-list new-bindings)
  (cond ((null binding-list) nil)
	(t (let ((binding (assoc (caar binding-list) new-bindings)))
	     (cond ((and binding 
			 (not (equal (cadar binding-list) (cadr binding)))))
		   (t (conflicting-bindings (cdr binding-list) 
					    new-bindings)))))))



(defun scr-reject-bindings (op goal node cand-alts)
    (and cand-alts
	 (setq *CURRENT-NODE* node)
	 (setf (node-current-goal node) goal)
	 (setf (node-current-op node) op)
	 (g-loop (init rules *SCR-BINDINGS-REJECT-RULES*
		       rule-nm nil bindings-lists nil 
		       rejections-found nil 
		       params-length (length (op-params op))
		       cand-bindings (g-map (alt in cand-alts)
					    (save (header params-length
							  (alt-vars alt))))
		       new-rejections nil)
		 (before-starting (setf (node-candidate-bindings node) cand-bindings))
		 (while (setq rule-nm (car (pop rules))))
		 (do (and *EBL-FLAG*
			  (setq *SC-TIME-COUNTER* (get-internal-run-time)))
		     (setq bindings-lists 
			   (scr-match rule-nm (scr-lhs rule-nm) '((nil nil))))
		     (and *EBL-FLAG* 
			  (record-sc-time rule-nm *SC-TIME-COUNTER* (get-internal-run-time)))
		     (cond (bindings-lists
			       (setq rejections-found t)
			       (setq new-rejections
				     (mapcar #'(lambda (b)
						       (subst-bindings 
							   (caddr (scr-rhs rule-nm)) b))
					     bindings-lists))
			       (record-scntrls node rule-nm bindings-lists new-rejections
				   'reject-bindings-hst)
			       ; inefficient, but better than mult rules firings per binding
			       (setq cand-bindings 
				     (if-del-member-list new-rejections cand-bindings))
			       (setf (node-candidate-bindings node) cand-bindings))))
		 (result (cond (rejections-found
				   (g-map (alt in cand-alts)
					  (when (member (vars-to-params op 
							    (alt-vars alt))
							cand-bindings
							:test #'equal))
					  (save alt)))
			       (cand-alts))))))
		    

; returns only those vars that are params (ordered).
; Remember -- first N vars are params.

(defun vars-to-params (op vars)
     (header (length (op-params op)) vars))		    


;(defun filter-bindings (cand-bindings rej-bindings)
;    (g-loop (init ret-val nil)
;	      (while cand-bindings)
;	      (do (g-loop (init temp-reject rej-bindings)
;		           (while temp-reject)
;			   (do (and (consistent-bindings (car temp-reject)
;							 (car cand-bindings))
;				    (return)))
;			   (next temp-reject (cdr temp-reject))
;			   (result (push (car cand-bindings) ret-val))))
;	      (next cand-bindings (cdr cand-bindings))
;	      (result ret-val)))


; returns t if bindings list b1 is consistent with b2.

;(defun consistent-bindings (b1 b2)
;    (g-loop (while b1)
;	     (do (or (member (pop b1) b2 :test #'equal)
;		     (return)))
;	     (result t)))
    

; See notes on ordering functions at the beginning of this file

(defun scr-order-bindings (op goal node cand-vals-for-vars)
    (cond ((only-one cand-vals-for-vars)
	   (car cand-vals-for-vars))
	  ((let ((params-length (length (op-params op)))
		 (cand-vals-list nil))
	        (setq *CURRENT-NODE* node)
		(setq cand-vals-list 
		      (g-map (vals-lst in cand-vals-for-vars)
			     (save (header params-length vals-lst))))
		(setf (node-candidate-bindings node) cand-vals-list)
		(setf (node-current-goal node) goal)
		(setf (node-current-op node) op)
		; potential optimization -- best should now always be true, so
		; remove test.
		(let ((best (recur-order-bindings 
				(list (car cand-vals-list))
				node -1)))
		     (cond (best
				(g-loop (while cand-vals-for-vars)
					(do (and (same-first-members best
						     (car cand-vals-for-vars))
						 (return (car cand-vals-for-vars))))
					(next cand-vals-for-vars (cdr cand-vals-for-vars))
					(result (error "Cand find vals"))))
			   ((car cand-vals-for-vars))))))))


(defun same-first-members (small big)
    (cond ((null small) t)
	  ((equal (car small) (car big))
	   (same-first-members (cdr small) (cdr big)))
	  (nil)))

(defun recur-order-bindings (previously-considered node orig-priority)
    (g-loop (init rules *SCR-BINDINGS-PREFERENCE-RULES* cand nil cands nil
		  best (car previously-considered) op (node-current-op node)
		  rule-nm nil bindings-lists nil ret-val nil)
	    (while (setq rule-nm (car (pop rules))))
	    (do (and *EBL-FLAG*
		     (setq *SC-TIME-COUNTER* (get-internal-run-time)))
		(setq bindings-lists
		      (scr-match rule-nm (scr-lhs rule-nm) 
			  (vals-list-to-bindings best 
			      (cadddr (scr-rhs rule-nm)))))
		(and *EBL-FLAG* 
		     (record-sc-time rule-nm *SC-TIME-COUNTER*
				     (get-internal-run-time)))
		(cond (bindings-lists
			  (setq cands 
				(mapcar #'(lambda (b)
						  (subst-bindings 
						      (caddr (scr-rhs rule-nm)) 
						      b))
					bindings-lists))
			  (record-pref node rule-nm  best bindings-lists cands 
			      'bindings-pref-hst)
			  (cond ((< (scr-priority rule-nm) orig-priority)
				 (return nil)))
			  (g-loop (while (setq cand (pop cands)))
				  (do (cond ((member cand previously-considered 
						     :test #'equal))
					    ((setq ret-val
						   (recur-order-bindings 
						       (cons cand previously-considered)
						       node (scr-priority rule-nm))))
					    ((push cand previously-considered))))
				  (until ret-val)))))
	    (until ret-val)
	    (result (or ret-val best))))
 
 
(defun rhs-meta-bindings (best rhs-guy)
    (cond ((atom rhs-guy)
	   (cond ((is-variable rhs-guy) 
                  (list (list rhs-guy best)))
		 ((eq best rhs-guy)
		  '((nil nil)))))
	  ((lit-match rhs-guy best))))
    


