#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#




(proclaim
 '(special *EXP-TRACING* *MATCHER-TRACE* *EBL-FLAG*
	   *ACTIVATE-EBL* *EBL-PRINTING* *STATIC-STATE-PREDS*))
(proclaim  '(fixnum *VAR-COUNTER*))



;--------------------------------------------------------------------------


(defvar *STOP* nil)
(defvar *TRACE-TEXT-FLAG* t "Controls the printing of problems solving trace.")
(defvar *STATE-TEXT-FLAG* t "Controls the printing of inital messages and warnings and final solution.")
(defvar *DOMAIN-GRAPHICS* nil)
(defvar *TREE-GRAPHICS* nil)
(defvar *VAR-COUNTER* 0 "This is the counter for the internal
variables used by the matcher")
(defvar *GC-BEFORE-RUN* nil "If not nil should be a function of no
args that will be called at the end of reclaim.")
(defvar *SURROUNDING-GRAPHICS* nil)
(defvar *MATCHER-TRACING* nil)
(defvar *SCR-TRACING* nil "Flag for search control rule tracing")
(defvar *OP-TRACING* nil "Flag for operator tracing")
(defvar *PRINT-TRACING* nil "Flag for printing text trace.")
(defvar *PRINT-ALTS* t)
(defvar *PRINT-PREFS* nil)
(defvar *PREFERENCES* nil)
(defvar *QUIET-LOAD* t)
(if (not (boundp '*EBL-FLAG*)) (setq *EBL-FLAG* nil))
(defvar *TIME-COUNTER* 0 "Time each cntrl loop begins.")
(defvar *WM-FLAG* nil) ;; WORLD-MODELERS interface flag...used in engine.lisp
(defvar *INCR-LEARNING* nil)
(defvar *NODE-CUTOFF* 'n2500)  ; Prodigy halts at the cutoff
(defvar *PRODIGY-TIME-BOUND* 300 "Time limit to halt problem.")
		 ; Prodigy halts after 5 minutes of cpu time.
(defvar *ABSTRACTION-LEVEL* nil "Current abstraction level.")
(defvar *PREV-ABS-LEVEL* nil "Previous abstraction level.")
(defvar *ABS-PRINT-FLAG* nil "Abstraction trace initially off.")
(defvar *SCR-NODE-SELECT-RULES* nil "Node select rules for current domain.")
(defvar	*SCR-GOAL-SELECT-RULES* nil "Goal select rules for current domain.")
(defvar	*SCR-OP-SELECT-RULES* nil "Operator select rules for current domain.")
(defvar	*SCR-BINDINGS-SELECT-RULES* nil "Binding select rules for current domain.")
(defvar	*SCR-NODE-REJECT-RULES*  nil "Node reject rules for current domain.")
(defvar	*SCR-GOAL-REJECT-RULES*  nil "Goal reject rules for current domain.")
(defvar	*SCR-OP-REJECT-RULES* nil "Operator reject rules for current domain.")
(defvar	*SCR-BINDINGS-REJECT-RULES* nil "Binding reject rules for current domain.")
(defvar	*SCR-NODE-PREFERENCE-RULES* nil "Node preference rules for current domain.")
(defvar	*SCR-GOAL-PREFERENCE-RULES*  nil "Goal preference rules for current domain.")
(defvar	*SCR-OP-PREFERENCE-RULES* nil "Operator preference rules for current domain")
(defvar	*SCR-BINDINGS-PREFERENCE-RULES*  nil "Binding preference rule for current domain.")
(defvar *OPERATORS* nil "List of current domains operators.")
(defvar *INFERENCE-RULES* nil "List of current domains inference rules.")
(defvar *CURRENT-DOMAIN* nil  "Last domain loaded by interface.")
(defvar *CURRENT-PROBLEM* nil "Last problem loaded by interface.")
(defvar *PROBLEM-GOAL* nil)
(defvar *ACTIVE-FACILITIES* nil "List of active facilites")
(defvar *ALL-NODES* nil "List of all nodes created in a run.")
(defvar *TREE-NODES* nil "Reverse list of *all-nodes* created for analyze.")
(defvar *NODE-LIST* nil)
(defvar *EXPL-NODE* nil "?Current node in analysis facility.")
(defvar *CHANGED-DOMAIN-FLAG* nil)
(defvar *CHANGED-PROBLEM-FLAG* nil)
(defvar *AUTODEFINED-FUNCTION-PREDS* nil) ;; used in load-domain.lisp
(defvar *AUTODEFINE-STATIC-FUNCTIONS* nil) ;; used in load-domain.lisp
(defvar *PREDICATE-ARITIES* nil) ;; used in load-domain for arity checking.
(defvar *ALLOW-ACHIEVED-GOALS* nil) ;; used in engine.lisp [execute-operator]
(defvar *ALLOW-REPEATED-STATES* nil);; used in engine.lisp [execute-operator]
(defvar *WHAT-IF-FLAG* nil ";; used in scntrl.lisp, commands.lisp")
(defvar *WHAT-IF-NODE* nil " ;; used in scntrl.lisp, commands.lisp")
(defvar *WHAT-IF-ADVICE* nil ";; used in engine.lisp, commnds.lisp")
(defvar *TAKE-ADVICE* nil "Flag to turn on advise facitiy.  Used in pop-best-alt in engine.lisp.")
(defvar *DIRECTORY-SEPARATOR* #+:coral ":" 
	    #+(or :cmu :lucid :unix :bsd) "/"
"The correct seperator for mac or unix.  Used in commands.lisp"
) ;; used in commands.lisp
					       ;; :bsd is for franz in unix
(defvar *FUNCTION-PREDS* nil 
"List of all predicates that are defined as functions in an operator of the current domain or any rule in the system.")
(defvar *STATIC-STATE-PREDS* nil "List of predicates not implemented as functions in the current domain.")

(defvar *DOMAIN-DIM-X* 0 "X dimension of domain window")
(defvar *DOMAIN-DIM-Y* 0 "Y dimension of domain window")
(defvar *DISCARD-FAILURE-BRANCHES* nil "Flag to indicate if failure branches should be deleted from search tree.")

(defvar *AUTO-BREADTH-FIRST* '(

(BREADTH-FIRST-SEARCH
    (PRIORITY 0)
    (LHS (AND (CANDIDATE-NODE <node1>)
	      (CANDIDATE-NODE <node2>)
	      (NODE-PREF-NOT-CACHED <node1> <node2>)
	      (SHALLOWER <node1> <node2>)))
     (RHS (PREFER NODE <node1> <node2>)))

node-pref)
"Control rule used in breadth-first search."
)

(defvar *AUTO-DEPTH-FIRST-INTERATIVE-DEEPENING* '(

(DFID-SEARCH
          (LHS (AND (CURRENT-NODE <node>)
                    (BELOW-DEPTH-LIMIT <node>)
                    (CANDIDATE-GOAL <node> <goal>)))
          (RHS (REJECT GOAL <goal>)))

goal-reject)
"Control rule used in depth first iterative deepening."
)

(defvar *AUTO-BREADTH-FIRST-FLAG* nil "Flag that indicates if the breadth first control rule has been loaded.")
(defvar *AUTO-DFID-FLAG* nil "Flag that indicates if the depth-first iterative deepening has been turned on.")
(defvar *CURRENT-PROBLEM-SET* nil "This is the name of the current problem set.  If it is nil then there is no current problem set.")
(defvar *TEST-PROBS* NIL "THIS IS the value of the current problem set.")
(defvar *CHANGED-PROBLEM-SET-FLAG* nil "Flag that is set when a new problem set is loaded.")
(defvar *PROB-NM* nil "Name of current problem from set")
(defvar *REMOVE-UNUSED-PREDS-FLAG* nil "Flag to signal that unused predicates in the start state should be delete from the state, rather then issueing a warning.")
(defvar *DEFAULT-DELAY* .2 "Default number of seconds to sleep between movie frames.")
(defvar *FONT-STRING* "6x10" "Name of font to use in X11.  (see xlsfonts program)")
(defvar *INIT-DOMAIN-X* 575      "X position of domain window")
(defvar *INIT-DOMAIN-Y* 0        "Y position of domain window")
(defvar *INIT-DOMAIN-WIDTH* 450  "Width of domain window")
(defvar *INIT-DOMAIN-HEIGHT* 350 "Height of domain window")

;;; For new systems don't forget to add the system name keyword to 
;;; the #- below to prevent reseting the var (on some systems defvar
;;; prevents this, anyway). (new systems are other then cmu and allegro).
;;; *DISPLAY-ENV is only used here set the var *DISPLAY-SERVER-NAME*

#+:cmu (defvar *DISPLAY-ENV* (cdr (assoc :display user::*environment-list*))
    "The value to pass to open the right x-server")
#+:franz-inc
       (defvar *DISPLAY-ENV* (system:getenv "DISPLAY")
   "The value to pass to open the right x-server")

#-(or :cmu :franz-inc)
       (defvar *DISPLAY-ENV* nil "Not using CLX.")

(defvar *DISPLAY-SERVER-NAME*
     (if (null *DISPLAY-ENV*) nil ; no X windows
        (subseq *DISPLAY-ENV* 0 (position #\: *DISPLAY-ENV*))
     )
"This is the name of the display server to be passed to open-display"
)

;;; This will prevent graphics from being inited twice, but will not prevent errors.


