#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


; ======================================================================
; File:  commands.lisp		Version: 1.1 	     Created:  6/3/88
; Locked by: nobody                                 Modified:  6/4/88
;
; Purpose:   This file contains command definitions for the user 
;            interface facilities.
;
; ======================================================================


;(provide 'command-definitions)
;(require 'prodigy-command-interface)
;(in-package 'command-definitions)
;(export '())
;(import '())


(proclaim 
 '(special *TRACE-TEXT-FLAG* *PROBLEM-GOAL* *CHANGED-PROBLEM-FLAG*
	   *ACTIVE-FACILITIES* *CURRENT-PROBLEM* *CURRENT-DOMAIN*
	   *EXPL-NODE* *NODE-NUM* *MATCH-EXPLANATION* *MATCHER-TRACE*
	   *EXPLAIN-MATCH-FAILURES* *FALSIFY-RELEVANCE-TABLE* 
	   *TRUIFY-RELEVANCE-TABLE* *OPERATORS* *INFERENCE-RULES* n1 
	   *DOMAIN-GRAPHICS* *TREE-GRAPHICS* *NODE-LIST* *TREE-WINDOW*
	   *SURROUNDING-GRAPHICS*  *OP-TRACING* *SCR-TRACING*
	   *SCR-NODE-SELECT-RULES*  *SCR-GOAL-SELECT-RULES*
	   *SCR-OP-SELECT-RULES*	*SCR-BINDINGS-SELECT-RULES*
	   *SCR-NODE-REJECT-RULES*  *SCR-GOAL-REJECT-RULES*
	   *SCR-OP-REJECT-RULES*	*SCR-BINDINGS-REJECT-RULES*
	   *SCR-NODE-PREFERENCE-RULES*  *SCR-GOAL-PREFERENCE-RULES*
	   *SCR-OP-PREFERENCE-RULES*  *SCR-BINDINGS-PREFERENCE-RULES*
	   *DOMAINS-PATH* *ALL-NODES* *WORLD-PATH* *CHANGED-DOMAIN-FLAG*
	   *AUTODEFINED-FUNCTION-PREDS* *WHAT-IF-FLAG* *WHAT-IF-NODE*
	   *AUTODEFINE-STATIC-FUNCTIONS* *TAKE-ADVICE*  *WHAT-IF-ADVICE*
	   *DIRECTORY-SEPARATOR* *INITIAL-STATE-PREDS* *STATIC-STATE-PREDS*
	   *NODE-CUTOFF* *PRINT-TRACING* *QUIET-LOAD* *PRODIGY-TIME-BOUND*
	   *ACTIVATE-EBL*  *LAST-LOAD-DOMAIN-TIME*  *LOAD-EBL-TIME*
           *EXPAND-ALL* *EBL-PRINTING* *EBL-FLAG* *ABS-PRINT-FLAG*))

; ----------------------------------------------------------------------

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))
 


; ======================================================================
;                       COMMAND    DEFINITIONS
; ======================================================================


(defun the-abs-up-command ()
    (declare (special *EXPL-NODE* *ALL-TREES*))
    (cond ((node-abstract-parent *EXPL-NODE*)
	   (reset-display-tree)
	   (display-tree (find-tree (node-abstract-parent *EXPL-NODE*)
				    *ALL-TREES*))
	   (move-and-refresh (node-abstract-parent *EXPL-NODE*)))
	  (t (let ((new-tree (find-tree (node-abstract-parent
				       (find-head *EXPL-NODE* *ALL-TREES*))
					*ALL-TREES*)))
	       (display-tree new-tree)
	       (move-and-refresh (car new-tree))))))
	     
(defun the-abs-down-command ()
    (declare (special *EXPL-NODE* *ALL-TREES*))
    (cond ((node-abstract-child *EXPL-NODE*)
	   (reset-display-tree)
	   (display-tree (find-tree (node-abstract-child *EXPL-NODE*)
				    *ALL-TREES*))
	   (move-and-refresh (node-abstract-child *EXPL-NODE*)))
	  (t (let ((new-tree (find-tree (node-abstract-child
				       (find-head *EXPL-NODE* *ALL-TREES*))
					*ALL-TREES*)))
	       (reset-display-tree)
	       (display-tree new-tree)
	       (move-and-refresh (car new-tree))))))

(defun move-and-refresh (node)
  (move-to-node node)
  (refresh-tree node))

(defun find-head (node trees)
  "Finds the head node of the tree containing node"
  (car (find-tree node trees)))

(defun find-tree (node trees)
  "Returns the tree which contains node"
  (find-if #'(lambda (x) (member node x)) trees))
; ======================================================================

(defun the-advise-command ()
  (toggle-take-advice)
  (format t "~%  Manual selection of alternatives is now ~
    ~:[disabled~;enabled~]." *TAKE-ADVICE*))
  

(defun toggle-take-advice ()
  "Toggles the user selection of node alternatives."
  (cond (*TAKE-ADVICE*
	 (setq *TAKE-ADVICE* nil)
	 'Taking_advice_is_now_disabled)
	(t (setq *TAKE-ADVICE* t)
	   'Taking_advice_is_now_enabled)))



; ======================================================================



(defun  the-alts-command ()
  (when (current-node-exists) 
    (print-all-alts *EXPL-NODE*)))



(defun print-all-alts (node)
  (dolist (n (node-children node))
    (format t "~%Node ~A: "(node-name n))
    (print-op (alt-op (node-generating-alt n))
	      (alt-vars (node-generating-alt n))))
  (format t "~%Remaining ")
  (print-alts (node-alternatives node) 'all 0 nil))

; ======================================================================


(defun the-analyze-command (node environment)
  (if (or (numberp node) (node-p node))
      (analyze node environment)
      (analyze nil environment)))



; ======================================================================


(defun the-apropos-command (keyword help-table)
  "displays all commands with instances of the keyword in the
   terse description field, return sa list of those commands"
  (cond ((null keyword)
	 (setq keyword (car (get-args keyword 1 '("  Enter a keyword: "))))
	 (if keyword (the-apropos-command keyword help-table)))
	((not (or (symbolp keyword) (stringp keyword)))
	 (the-apropos-command (format nil "~A" keyword) help-table))
	((or (symbolp keyword) (stringp keyword))
	 (setq keyword (string-downcase (string keyword)))
	   (or (delete
		nil
		(mapcar 
		 #'(lambda (x)
		     (cond ((or (search keyword (string-downcase (string x)))
				(search keyword 
					(string-downcase 
					 (get-hlp x 'TERSE-TEXT help-table))))
			    (display-terse-description x help-table)
			    x)))
		 (get-hlp 'ALL 'COMMANDS help-table)))
		(format t "~%  No instances of ``~A'' were found." keyword)))))



; ======================================================================

(defun the-back-command (args)
  (when (current-node-exists)
    (let* ((no-of-nodes (if (null args) 1
                            (car (get-args args 1
                                    '("  How many nodes back? ")))))
           (where2 *EXPL-NODE*)
           (where (dotimes (n no-of-nodes where2)
                          (setf where2 (or (node-parent where2) n1)))))
       (move-to-node where))))

; ======================================================================

(defun the-backtrack-command (args)
  (when (current-node-exists)
    (let ((where (name-to-node (car (get-args args 1 
				      '("  Backtrack from which node?"))))))
       (show-backtrack-path where))))

;; Remove the following code if the new definition works well.

#|(defun the-backtrack-command (args)
  (when (current-node-exists)
    (let ((where (name-to-node (car (get-args args 1 
				      '("  Backtrack from which node?"))))))
       (cond (*TREE-GRAPHICS* (show-backtrack-path where))
	     (t (move-to-node where))))))
|#

(defun show-backtrack-path (node)
  "Collapses the path originating from the node's active sibling and
   expands the path leading from the given node."
  (draw-backtrack-path node *EXPL-NODE*)
  (if (on-current-path node) (move-to-node node)
      (move-to-node *EXPL-NODE*)))

;; Remove the following code if the new definition works well.

#|(defun show-backtrack-path (node)
  "Collapses the path originating from the node's active sibling and
   expands the path leading from the given node."
  (if *TREE-GRAPHICS* (draw-backtrack-path node *EXPL-NODE*))
  (if (on-current-path node) (move-to-node node)
      (move-to-node *EXPL-NODE*)))|#
  
; ======================================================================
(defun the-breadth-first-command ()
   (declare (special *AUTO-BREADTH-FIRST-FLAG*))
   (toggle-breadth-first-search)
   (format t "~% The breadth first search is ~:[off~;on~]." 
						*AUTO-BREADTH-FIRST-FLAG*))

(defun toggle-breadth-first-search ()
   (declare (special *AUTO-BREADTH-FIRST-FLAG* *AUTO-DFID-FLAG*))
   "Toggles the breadth first search control rule."
   (cond (*AUTO-DFID-FLAG*
	 (format t "~%  WARNING:  You must turn off dfid first.")
	 (format t "~%            Breadth-first not turned on."))
	 (*AUTO-BREADTH-FIRST-FLAG*
            (remove-breadth-first-control-rule)
	    (setf *AUTO-BREADTH-FIRST-FLAG* nil)
	    'Breadth_first_search_now_turned_off)
	 (t (add-breadth-first-control-rule)
	    (setf *AUTO-BREADTH-FIRST-FLAG* t)
	    (format t 
		"~%  WARNING:  A breadth-first search can take a long time.")
	    'Breadth_first_search_now_turned_on)))


(defun add-breadth-first-control-rule ()
     (declare (special *AUTO-BREADTH-FIRST*))
     (apply 'load-new-scntrl-rule *AUTO-BREADTH-FIRST*))

(defun remove-breadth-first-control-rule ()
     (declare (special *AUTO-BREADTH-FIRST*))
     (apply 'delete-control-rule *AUTO-BREADTH-FIRST*))

; ======================================================================

(defun the-children-command ()
  (when (current-node-exists)
    (terpri)
    (princ (node-names (node-children *EXPL-NODE*)))))

; ======================================================================

(defun the-clones-command ()
  "Prints all clones for this node."
  (when (current-node-exists)
    (format t "~2%  Left clones for node ~A: ~A~
                ~%  Right clones: ~A"
		   (node-name *EXPL-NODE*)
		   (get-all-left-clones *EXPL-NODE*)
		   (get-right-clone-tree *EXPL-NODE*))))

; ======================================================================



(defun the-context-command (node)
  (when (and (current-node-exists) node)
    (format t "~2%You are at node  ~A~%Working on goal: ~A~
    ~%Using Operator:  ~A"
	    (node-name node)
	    (node-current-goal node)
	    (cond ((failure-node node)
		   (get-op-list (get-predicate (get-top-goal node))))
		  ;   print relevance list: true or false,
		  (t (alt-op (node-generating-alt
			      (find-active-child (node-children node)))))))
    (cond ((get-all-doing-clones node)
	   (format t "~2%Done so far:")
	   (print-all-doing-clones node)))
    (cond ((failure-node node) (print-expl-failure-message node))
	  ((did? (next-node node))
	   (format t "~2%Doing at this node: ")
	   (print-done (next-node node))))
    (terpri)
    (let* ((next (next-node node)))
      (when (and (node-p next)
		 (alt-unmatched-conds (node-generating-alt next)))
	(print-list "Unmatched conditions: "
		    (alt-unmatched-conds (node-generating-alt next)))
	(terpri)))))

; ======================================================================


(defun the-detailed-alts-command (&optional (which nil))
  (when (current-node-exists)
    (if (and which (listp which))
	(dolist (w which) (the-detailed-alts-command w))
	(let ((n 0)
	      (explored-alts (mapcar #'node-generating-alt
				     (node-children *EXPL-NODE*)))
	      (remaining-alts (node-alternatives *EXPL-NODE*))
	      (all-alts nil))
	  (terpri) (terpri)
	  (cond
	   ((not (or explored-alts remaining-alts))
	    (format t "  There are no alternatives for node ~:(~A~)." 
		    (node-name *EXPL-NODE*)))
	   (which 
	    (setq all-alts (append explored-alts remaining-alts))
	    (if (<= 1  which (length all-alts))
		(detailed-alt (nth (1- which) all-alts) which)
		(format t "  Invalid alt number. Must be ~:[between 1 ~
		          and ~D~;1~].~%"
			(= (length all-alts) 1) (length all-alts))))
	   (t
	    (cond (explored-alts
		   (format t "  Alternative~P explored...~2%" 
			   (length explored-alts))
		   (dolist (alt explored-alts) 
		     (detailed-alt alt (incf n)))))
	    (cond (remaining-alts
	       (format t "~%  Alternative~P remaining...~2%"
		       (length remaining-alts))
	       (dolist (alt remaining-alts)
		 (detailed-alt alt (incf n)))))))))))
  


(defun detailed-alt (alt &optional (num nil))
  (let* ((ttab 2) (ntab 2) (tab (+ ntab ttab)))
    (if num
	(format t "~VT~VD." ttab ntab num)
	(format t "~VT " tab))
    (format t " Goal:      ~S" (alt-goal alt))
    (format t "~%~VT  Operator:  ~S" tab (alt-op alt))
    (format t "~%~VT  Variables: ~S" tab (alt-vars alt))
    (format t "~%~VT  Post cond: ~S" tab (alt-post-cond alt))
    (format t "~%~VT  Failed on: ~S" tab (alt-failed-cond alt))
    (format t "~%~VT  Unmatched: ~S~2%" tab (alt-unmatched-conds alt))))
  

; ======================================================================
(defun the-dfid-command ()
   (declare (special *AUTO-DFID-FLAG*))
   (toggle-dfid)
   (format t "~% Depth first iterative deepening is now ~:[off~;on~]."
						*AUTO-DFID-FLAG*))

(defun toggle-dfid ()
    (declare (special *AUTO-DFID-FLAG* *AUTO-BREADTH-FIRST-FLAG*))
    "Toggles the dfid control rule and flag."
    (cond (*AUTO-BREADTH-FIRST-FLAG*
	 (format t "~%  WARNING:  You must turn off breadth-first first.")
	 (format t "~%            DFID not turned on."))
	  (*AUTO-DFID-FLAG*
	   (remove-dfid-control-rule)
	   (setf *AUTO-DFID-FLAG* nil)
	   'DFID_is_now_off)
	  (t (add-dfid-control-rule)
	     (setf *AUTO-DFID-FLAG* t)
	     'DFID_is_now_on)))

(defun add-dfid-control-rule ()
   (declare (special *AUTO-DEPTH-FIRST-INTERATIVE-DEEPENING*))
   (apply 'load-new-scntrl-rule *AUTO-DEPTH-FIRST-INTERATIVE-DEEPENING*))

(defun remove-dfid-control-rule ()
   (declare (special *AUTO-DEPTH-FIRST-INTERATIVE-DEEPENING*))
   (apply 'delete-control-rule *AUTO-DEPTH-FIRST-INTERATIVE-DEEPENING*))

; ======================================================================


(defun the-domain-command (&optional (cd nil))
  "load a domain"
  (cond ((null cd)
	 (format *QUERY-IO* "~2%  The available domains are...~3%")
	 (let* ((dp  (namestring *DOMAINS-PATH*))
		(domains  (printsubdirs dp)))
	   (loop
	     (format *QUERY-IO* "~2%  Select a domain: ")
	     (finish-output *QUERY-IO*)
	     (setq cd (string-trim '(#\SPACE #\TAB #\") (read-line *QUERY-IO*)))
	     (cond ((null-string cd) (return nil))
		   ((member cd domains :test #'equal)
		    (return (set-the-domain dp cd)))
		   (t (format *QUERY-IO* "~2%  The domain \"~A\" is not on path: ~A.~
		   ~%  Select another domain or hit [ENTER] to cancel."
			      cd (directory-namestring *DOMAINS-PATH*)))))))
	((stringp cd)
	 (let* ((dp  (namestring *DOMAINS-PATH*))
		(domains (directory-subdir-list dp)))
	   (if (member cd domains :test #'equal)
	       (set-the-domain dp cd)
	       (format *QUERY-IO* "~2% ERROR: Domain ~A not found~%" cd))))
	((not (stringp cd))
	 (format *QUERY-IO* "~2% ERROR: the argument to domain must be a string"))))



(defun set-the-domain (thepath thedomain)
  (setq thepath (string thepath) thedomain (string thedomain))
  (setq *WORLD-PATH* (concatenate 'string thepath thedomain))
  (if (string/= *DIRECTORY-SEPARATOR* (seq-last *WORLD-PATH*))
      (setq *WORLD-PATH* (concatenate 'string *WORLD-PATH* 
					      *DIRECTORY-SEPARATOR*)))
  (let ((files (directory-lispfile-list *WORLD-PATH*))
	(old-path *WORLD-PATH*) ; save for future reference
	(domain-startup-file (get-startup-file *WORLD-PATH*)))
    (cond ((member "startup" files :test #'equal)
	   (unless (equal thedomain *CURRENT-DOMAIN*)
	     (setq *CHANGED-DOMAIN-FLAG* t)
	     (setq *CHANGED-PROBLEM-FLAG* nil))
	   (setq *CURRENT-DOMAIN* thedomain)
	   (systemic-ramifications-of-this-command)
	   (funcall 'load (concatenate 'string *WORLD-PATH* domain-startup-file))
	   (if (not (equal old-path (directory-namestring *WORLD-PATH*)))
		(format t "~% WARNING: *WORLD-PATH* is ~A~%      and is not a directory in ~A~%" *WORLD-PATH* *DOMAINS-PATH*)
	   ))
	  (t (format  t "~2% ERROR: `startup' file not found.")
	     nil))))


; The pathname passed must have the trailing / to work.

(defun get-startup-file (path)
   (cond ((member :coral *features* :test #'eq) "startup")
        ((probe-file (merge-pathnames path "cmu-startup.lisp")) "cmu-startup.lisp")
	(t "startup.lisp")
   )
)


; ======================================================================

(defun toggle-dspf ()
  (if *AUTODEFINE-STATIC-FUNCTIONS*
      (progn
	(setf *AUTODEFINE-STATIC-FUNCTIONS* nil)
	(map nil #'fmakunbound *AUTODEFINED-FUNCTION-PREDS*)
	(setf *AUTODEFINED-FUNCTION-PREDS* nil))
      (setq *AUTODEFINE-STATIC-FUNCTIONS* t))
  (format t "~2%  Static predicates will ~:[not ~;~]be defined as functions."
	  *AUTODEFINE-STATIC-FUNCTIONS*)
  (format t "~%  ~:[Load~;Reload~] a problem from the domain to ~
             ~:[disable~;enable~].~%" *CURRENT-PROBLEM* 
	     *AUTODEFINE-STATIC-FUNCTIONS*))


; ======================================================================

(defun the-environment-command ()
  (declare (special *CURRENT-PROBLEM-SET*))
  (format t "~2%Current Domain:   ~:[unspecified~;~:*~A~]."
	  *CURRENT-DOMAIN*)
  (if *CURRENT-PROBLEM-SET*
      (format t "~%Problem Set:      ~A" *CURRENT-PROBLEM-SET*))
  (format t  "~%Current Problem:  ~:[unspecified~;~:*~A~]."
	  *CURRENT-PROBLEM*)
  (maintain-facilities)
  (format t  "~%Active Switches:~:[  none~;~:*~{  ~A~}~]."
	  *ACTIVE-FACILITIES*))


(defun add-facility (which)
  (pushnew which *ACTIVE-FACILITIES*))


(defun del-facility (which)
  (setq *ACTIVE-FACILITIES* (delete which *ACTIVE-FACILITIES*)))


(defun maintain-facilities ()
  (declare (special *DISCARD-FAILURE-BRANCHES* *AUTO-DFID-FLAG*
		    *AUTO-BREADTH-FIRST-FLAG*))
  (if *AUTODEFINE-STATIC-FUNCTIONS* (add-facility 'dspf) (del-facility 'dspf))
  (if *TAKE-ADVICE*  (add-facility 'advise)  (del-facility 'advise))
  (if *TREE-GRAPHICS* (add-facility 'tree) (del-facility 'tree))
  (if *DOMAIN-GRAPHICS* (add-facility 'picture) (del-facility 'picture))
  (if *TRACE-TEXT-FLAG* (add-facility 'text) (del-facility 'text))
  (if *ABS-PRINT-FLAG* (add-facility 'abs-text) (del-facility 'abs-text))
  (if *OP-TRACING* (add-facility 'trace-ops) (del-facility 'trace-ops))
  (if *SCR-TRACING* (add-facility 'trace-scrs) (del-facility 'trace-scrs))
  (if (and (boundp '*ACTIVATE-EBL*) *ACTIVATE-EBL*)
		    (add-facility 'ebl) (del-facility 'ebl))
  (if (and (boundp '*EBL-PRINTING*) *EBL-PRINTING*)
		    (add-facility 'ebl-text) (del-facility 'ebl-text))
  (if (and (boundp '*EXPAND-ALL*) *EXPAND-ALL*)
		    (add-facility 'expand-all) (del-facility 'expand-all))
  (if *DISCARD-FAILURE-BRANCHES* (add-facility 'discard) 
					(del-facility 'discard))
  (if *AUTO-BREADTH-FIRST-FLAG* (add-facility 'breadth-first)
					(del-facility 'breadth-first))
  (if *AUTO-DFID-FLAG* (add-facility 'dfid) (del-facility 'dfid)))


; ======================================================================

(defun the-eval-command (args)
  (format t "~%  ~A" (eval (car args))))

; ======================================================================

; This function will move the analyze facility ahead N nodes (where N
; is specified at the user interface) on the current path.  It used to
; do strange things if no tree graphics were being used, but that has
; all finally been corrected.

(defun the-forward-command (args)
  "Move forward 1 node if args is nil, or (car args) otherwise.  Args
   must be a list beginning with a number or nil."
  (when (current-node-exists)
    (let* ((no-of-nodes (if (null args) 1
			   (car (get-args args 1
					  '("  How many nodes forward? "))))))

       (move-to-node (ith-node-ahead-on-path no-of-nodes *EXPL-NODE*))
)))

(defun ith-node-ahead-on-path (ith node)
   (dotimes (w ith node)
     (setf node (or (find-active-child (node-children node))
		    node))))
; ======================================================================

(defun the-go-command (args)
  (when (current-node-exists)
    (move-to-node (name-to-node 
		   (car (get-args args 1 '("  Go to what node? ")))))))

; ======================================================================

(defun the-goal-command ()
  (format t "~%  ~:[Cannot show a goal, a problem does not exist.~;~
              Problem Goal: ~A~]" *CURRENT-PROBLEM* *PROBLEM-GOAL*))

; ======================================================================


(defun the-help-command (topic help-table)
  "display a menu, submenu, or terse description of a particular topic"
  (cond 
   ((null topic) (the-help-command 'help help-table))
   ((listp topic) (dolist (x topic) (the-help-command x help-table)))
   ((get-hlp topic 'menu-text help-table)
    (display-menu topic help-table))
   ((get-hlp topic 'submenu-text help-table)
    (display-submenu topic help-table))
   ((get-hlp topic 'terse-text help-table)
    (display-terse-description topic help-table))
   (t (format t "~2%  No help available on `~(~A~)' -- try using~
                  ~%  the `apropos' command, or just type `help all'."
	      topic))))




(defun display-menu (topic help-table)
  "prints the topic heading, and enumerse terse descriptions of 
   the available submenus, allowing the user to select one of the
   submenus for further elaboration.  The user can opt to abort
   the process by typing 0 (zero) at the submenu prompt."
  (format t "~2% ~A~2%~A~%"
	  (string-upcase (string topic))
	  (get-hlp topic 'menu-text help-table))
  (do* ((n 1 (1+ n))
	(sms (get-hlp topic 'submenus help-table) (cdr sms)))
       ((null sms))
    (format t "~%      ~D) ~:(~A~) ~A" 
	    n (car sms) (get-hlp (car sms) 'terse-text help-table)))
  (terpri)
  (do* ((sms (get-hlp topic 'submenus help-table))
	(nsms (length sms))
	(reply nil))
       ((and (numberp reply) (<= 0 reply nsms))
	(cond ((zerop reply))
	      ((<= 1 reply nsms)
	       (display-submenu (nth (1- reply) sms) help-table)
	       (terpri))))
    (format t "~%  Which class would you like to see (0 for none)? ")
    (unless (and (numberp (setq reply (car (read-atoms))))
		 (<= 0 reply nsms))
	(format  t "~%  Enter a number between 0 and ~D.~%" nsms))))
  



(defun display-submenu (topic help-table)
  "prints the topic heading, text for the submenu, and 
   terse descriptions of the associated commands"
  (format t "~2% ~:(~A~) Commands~2%~A~%" 
	  topic 
	  (get-hlp topic 'submenu-text help-table))
  (dolist (cmd (get-hlp topic 'commands help-table))
    (display-terse-description cmd help-table))
  (terpri))



(defun display-terse-description (topic help-table)
  "show a onel line summary of the command or menu listing"
  (format t "~%  ~A ~A" topic (get-hlp topic 'terse-text help-table)))




; ======================================================================

(defun the-inference-command (ir)
  "print all inference rules, or a specified inference rule."
  (cond ((or (null ir) (eql ir 'all)) (print-all-infs))
	((symbolp ir)
	 (format t "~2%Inference rule ~:(~A~) " ir)
	 (setq ir (get-orig-inf ir))
	 (format t "~:[does not exist~;:~2%    ~:*~A~%~]" ir))
	(t (format t "~2%  The argument to `inference' must be a symbol."))))
  
(defun print-all-infs ()
  "print all inference rules."
  (format t "~%  ~:[There are no inference rules.~;~
                 Available inference rules are:~%~{~%    ~:(~A~)~}~
	    ~2%  Type ``inference <inference-rule-name>'' to see an inference ~
                  rule.~]"
	     *INFERENCE-RULES* (mapcar #'car *INFERENCE-RULES*)))


(defun get-orig-inf (inference)
  "return an inference rule, given the rule name {inf-rule}."
  (assoc inference *INFERENCE-RULES* :test #'eql))



; ======================================================================

(defun the-initial-command ()

(cond ((not (boundp '*initial-state-preds*))
  (format t "~2% There is no initial state."))

      (t
  (format t "~2%  ~:[There are no initial non-static predicates.~;~
                The non-static predicates in the initial state are ...~2%~
                ~:*~{~10T~(~A~)~%~}~]~%" *initial-state-preds*))))
             

; ======================================================================

(defun the-last-command ()
  (move-to-node (cadr *ALL-NODES*)))

; ======================================================================

(defun the-left-command (args)
  (when (current-node-exists)
    (let* ((no-of-nodes (if (null args) 1
			    (car (get-args args 1 
					   '("  How many nodes left? ")))))
	   (lc (reverse (get-all-left-clones *EXPL-NODE*)))
	   (lenlc (length lc)))
      (cond ((null lc) (format t "~%  No left clones exist."))
	    ((> no-of-nodes lenlc)
	     (format t "~%  Only moving left ~D clones." lenlc)
	     (move-to-node (nth (1- lenlc) lc)))
	    (t (move-to-node (nth (1- no-of-nodes) lc)))))))

; ======================================================================

(defun the-leftmost-command ()
  (when (current-node-exists)
    (move-to-node (leftmost-clone *EXPL-NODE*))))

; ===================================================================
;
(defun the-movie-command ()
	(show-movie)
)

; ===================================================================
; These commands set the variable *NODE-CUTOFF* to a node.
; No error check is done on the input.

(defun the-node-cutoff-command (node)
	(set-node-cutoff node t)
)

(defun set-node-cutoff (node &optional stream)
        "Sets the variable *NODE-CUTOFF to the argument."
    (if (symbolp node)
         (format stream "The cut-off node used to be ~A.~%The cut-off node is now ~A" (string *NODE-CUTOFF*) (string (setq *NODE-CUTOFF* node)))

	 (format stream "The argument must be a symbol, not a ~A." 
						(string (type-of node)))
    )
)

; ======================================================================

(defun the-not-unique-command ()
  (format t "~%  That abbreviation does not identify a unique command.~
             ~%  Provide more letters, complete the command word, or~
             ~%  try ``apropos <abbreviation>'' for possibilities."))

; ======================================================================

(defun the-operator-command (op)
  "print all operators, or the specified operator."
  (cond ((or (null op) (eql op 'all)) (print-all-ops))
	((symbolp op)
	 (format t "~2%  Operator ~:(~A~) " op)
	 (setq op (get-orig-op op))
	 (format t "~:[does not exist~;:~2%    ~:*~A~%~]" op))
	(t (format t "~2%  The argument to `operator' must be a symbol."))))


(defun print-all-ops ()
  "print all operators."
  (format t "~%  ~:[There are no operators.~;~
                 Available operators are:~%~{~%    ~:(~A~)~}~
	    ~2%  Type ``operator <operator-name>'' to view an operator.~]"
	     *OPERATORS* (mapcar #'car *OPERATORS*)))


(defun get-orig-op (operator)
  "return an operator, given the operator name."
  (assoc operator *OPERATORS* :test #'eql))

; ======================================================================


(defun the-opfail-command ()
  (when (current-node-exists)
    (cond ((not *OP-TRACING*)
	   (format t "~%  Operator tracing is currently disabled.  Use~
	              ~%  the `optrace' command to enable, before running~
		      ~%  or continuing the planner, otherwise this~
		      ~%  information is not stored."))
	  (t (g-map (entry in (look-for-op-matches 
				  (process-matcher-trace *MATCHER-TRACE*)
				  (node-name *EXPL-NODE*)))
		    (do (print-failure-record-entry entry)))))))



(defun look-for-op-matches (new-matcher-trace node-nm)
  "runs through matcher trace, looking for places where an
   op was matched at node-nm."
  (g-loop (init entry nil ret-val nil)
	  (while (setq entry (pop new-matcher-trace)))
	  (do (and (eq node-nm (node-name (car entry)))
		   (setq ret-val (append (g-map (exp-record in (cadr entry))
						(when (is-op-precondition-exp
							    (car exp-record)))
						(save exp-record))))))
	  (result ret-val)))




(defun is-op-precondition-exp (exp)
     (g-map (rule in (append *OPERATORS* *INFERENCE-RULES*))
	   (when (equal exp (get (car rule) 'preconds)))
	   (save exp)))

; ======================================================================

(defun the-opseq-command ()
  (when (current-tree-exists)
    (print-op-list 
     "  Operator Sequence:"
     (find-op-seq (cadr *ALL-NODES*));; changed from (car *NODE-LIST*)
     NIL)))

; ======================================================================

(defun the-optrace-command ()
  (declare (special *DISCARD-FAILURE-BRANCHES* *OP-TRACING*))
  (toggle-op-tracing)
  (format t "~%  Operator tracing is now ~:[off~;on~]." *OP-TRACING*))


(defun toggle-op-tracing ()
  "Toggles the operator tracing facility during planning."
  (cond (*OP-TRACING*
	 (setq *OP-TRACING* nil)
	 'Operator_tracing_now_turned_off)
	(t (setq *OP-TRACING* t)
	   (if *DISCARD-FAILURE-BRANCHES*
	       (format t 
		       "WARNING:  Doing operator failure tracing will degrade the~
                        perfmance of node discarding.~%"))
	   'Operator_tracing_now_turned_on)))


; ======================================================================

(defun the-parent-command ()
 (when (current-node-exists) 
   (terpri)
   (princ (node-name-robust (node-parent *EXPL-NODE*)))))


; ======================================================================

(defun the-partial-command (args)
  (when (current-node-exists)
    (print-partial-sequence
     (cond ((null args) *EXPL-NODE*)
	   (T (get-args args 1 '("  Partial for which node?")))))))


(defun print-partial-sequence (node)
  (print-op-list 
   (format nil "  Partial Solution for ~@(~S~):" node)
   (find-op-seq node)
   t))


; ======================================================================





(defun the-path-command (&optional (dp nil))
  "set the domains directory to one specified by the user."
  (cond 
   ((null dp)
    (format *QUERY-IO* "~2% Current path: ~A" (directory-namestring *DOMAINS-PATH*))
    (format *QUERY-IO* "~2% Set path to:  ")
    (setq dp (string-trim '(#\SPACE #\TAB #\") (read-line *QUERY-IO*)))
    (if (null-string dp) nil (set-the-directory dp)))
   ((not (stringp  dp))
    (format *QUERY-IO* "~2% ERROR: the argument to path must be a string"))
   (t (set-the-directory dp))))
   

; If the CMU Common Lisp directory command receives a path name
; that doesn't exists it signals an error.  I have been told that
; that almost every other common lisp returns nil.  This problem exists
; because an ambiguity exists in Common Lisp:  The language.

(defun set-the-directory (thedir)
  (setq thedir (string thedir))
  (if (string/= (seq-last thedir) *DIRECTORY-SEPARATOR*)
      (setq thedir (concatenate 'string thedir *DIRECTORY-SEPARATOR*)))

         			; The first if for CMU COMMON LISP
  (cond ((and (member :cmu *features*) (ignore-errors (directory thedir))) 
	 (setq *DOMAINS-PATH* (pathname thedir)))
				; This for the rest of the world
        ((and (not (member :cmu *features*)) (directory thedir))
	 (setq *DOMAINS-PATH* (pathname thedir)))
	(t (format t "~2% ERROR: Invalid directory ~A ~%" thedir)))); Error

; ======================================================================


(defun the-picture-command ()
  (and (toggle-domain-graphics)
       *DOMAIN-GRAPHICS*
       *EXPL-NODE*
       (display-domain-graphics *EXPL-NODE*))
  (format t "~%  Domain graphics are now ~:[off~;on~]." *DOMAIN-GRAPHICS*))



(defun toggle-domain-graphics ()
  "Toggles the domain graphics flag.  Turning on the domain graphics will
   automatically fire up a graphics window in the upper right-hand corner of
   your screen.  The graphics will not appear in the window, however, until
   PRODIGY begins to run.  Turning off the domain graphics will destroy the
   window."
  (cond (*DOMAIN-GRAPHICS*
	 (setq *DOMAIN-GRAPHICS* nil)
	 (kill-domain-graphics)
	 'Domain_graphics_now_turned_off)
	(t (setq *DOMAIN-GRAPHICS* t)
	   (set-up-domain-window)
	   'Domain_graphics_now_turned_on)))

;  ====================================================================
;  These commands set the variable *PRINT-TRACING* to node.
; No error check is done on the value of node.
(defun the-print-tracing-command (node)
	    (set-print-tracing node t)
)

(defun set-print-tracing (node &optional stream)
	"Set the node at which the trace will start.
	 Nil means no trace and t means trace all."
    (if (symbolp node)
	    (format stream "The tracing used to begin at ~A.~%It will begin at node ~A" (string *PRINT-TRACING*) (string (setq *PRINT-TRACING* node)))

	(format stream "The argument must be a SYMBOL, not ~A." 
 						(string (type-of node)))
     )
)

; ======================================================================
(defun the-problem-command (&optional (cp nil))
  (declare (special *CURRENT-PROBLEM-SET*))
  "lists available problems for the current domain, then loads a problem"
  (cond
   ((not *CURRENT-DOMAIN*)
    (format *QUERY-IO* "~%  You must specify a domain before selecting a problem.")
    (finish-output *QUERY-IO*))
   (*CURRENT-PROBLEM-SET* (load-problem-from-set cp))
   (t (load-problem-file cp))))

(defun load-problem-file (cp)
   "Loads a single problem file."
(cond ((null cp)
    (format *QUERY-IO* "~2%  The problems for ~:(~A~) are...~2%"
	    *CURRENT-DOMAIN*)
    (let* ((cd (concatenate 'string  (namestring *WORLD-PATH*)
			 "probs" *DIRECTORY-SEPARATOR*))
	   (probs (printlispdir cd)))
      (loop 
	(format *QUERY-IO* "~2%  Enter a problem: ")
	(finish-output *QUERY-IO*)
	(setq cp (string-trim '(#\SPACE #\TAB #\") (read-line *QUERY-IO*)))
	(cond
	 ((null-string cp) (return nil))
	 ((member cp probs :test #'equal)
	  (return (set-the-problem cd cp)))
	 (t 
	  (format
	   *QUERY-IO* "~2%  The problem ~A does not exist in ~A.~
	   ~%  Select another problem or hit [ENTER] to cancel.~%"
	   cp *CURRENT-DOMAIN*))))))
   ((stringp cp)
    (let* ((cd (concatenate 'string  (namestring *WORLD-PATH*)
				 "probs" *DIRECTORY-SEPARATOR*))
	   (probs (directory-lispfile-list cd)))
      (if (member cp probs :test #'equal)
	  (set-the-problem cd cp)
	  (format *QUERY-IO* "~% Problem `~A' does not exist in `~A'"
		  cp *CURRENT-DOMAIN*))))
   ((not (stringp cp))
    (format *QUERY-IO* "~2% ERROR: the argument to problem must be a string"))))

(defun set-the-problem (thedir theprob)
  (setq thedir (string thedir) theprob (string theprob))
  (unless (equal theprob *CURRENT-PROBLEM*)
    (setq *CHANGED-PROBLEM-FLAG* t))
  (setq *CURRENT-PROBLEM* theprob)
  (setq *CHANGED-DOMAIN-FLAG* nil)
  (systemic-ramifications-of-this-command)
  (funcall 'load (concatenate 'string thedir theprob)))

;------- Load a problem from a problem set
;;; The symbol name-never-used-for-prob is used to distinguish between
;;; not entering a problem (just pressing return) and entering an
;;; incorrect problem.  Nil is considered "valid," but we cannot have
;;; a nil the first time around the loop.

(defun load-problem-from-set (&optional (prob-name nil))
    (declare (special *CURRENT-PROBLEM-SET*))
    "This function assumes a problem set has been loaded and prompts
     the user for a problem."

		;convert prob-name to a symbol, if needed
     (if (stringp prob-name) (setf prob-name (read-from-string prob-name)))

     (do ((selected-prob (or prob-name 'name-never-used-for-prob) 
						(car (read-atoms)))
          (probs (list-problem-set)))
         ((good-prob-p selected-prob probs) 
	  (if selected-prob (getprob selected-prob) nil))

     (if (not (eq selected-prob 'name-never-used-for-prob))
         (format t "~%~S is not a valid probem in the set ~A" 
					selected-prob *CURRENT-PROBLEM-SET*))

     (format *QUERY-IO* "~2%  The problems in set ~:(~A~) are...~2%" 
				*CURRENT-PROBLEM-SET*)
     (prinmat-list (mapcar #'symbol-name probs))
     (format *QUERY-IO* "~2%  Enter a problem: ")
     (finish-output *QUERY-IO*)

))


(defun list-problem-set ()
   (declare (special *TEST-PROBS*))
   "Returns a list of the names of each of the problems in the
    current problem set."
   (mapcar #'car *TEST-PROBS*))    


(defun load-next ()
    (declare (special *TEST-PROBS* *START-STATE* *END-TIME* *PROB-NM*))
    "Loads first prob in the *TEST-PROBS* list and pops it off.  Its
     never actually used in the interface, but is useful for scripts."
    (or *TEST-PROBS* (error "no more probs"))
    (setq *PROB-NM* (caar *TEST-PROBS*))
    (load-goal (cadar *TEST-PROBS*))
    (load-start-state (caddar *TEST-PROBS*))
    (cond ((assoc 'last-time *START-STATE*)
	   (setq *END-TIME* (cadr (assoc 'last-time *START-STATE*)))))
    (pop *TEST-PROBS*))


; Some access macros that help make the code more readable.
(defmacro prob-name (p)
   `(car ,p))

(defmacro prob-goal (p)
   `(cadr ,p))

(defmacro prob-start-state (p)
    `(caddr ,p))

(defun getprob (p)
   (declare (special *TEST-PROBS* *START-STATE* *END-TIME* *PROB-NM*)
           (symbol p))
  "Gets a problem from the current problem set without destroying
   *TEST-PROBS*. It returns its arg, but not for any reason."
  (let* ((prob (find p *TEST-PROBS* :test #'eq :key #'car)))
     (cond  (prob 
 	     (setf *PROB-NM* p)
	     (load-goal (prob-goal prob))
	     (load-start-state (prob-start-state prob))
	     (unless (equal (symbol-name p) *CURRENT-PROBLEM*)
	             (setf *CHANGED-PROBLEM-FLAG* nil)
	             (setf *CURRENT-PROBLEM* (symbol-name p)))
	     (setf *CHANGED-DOMAIN-FLAG* nil)
	     (systemic-ramifications-of-this-command)
	     (cond ((assoc 'last-time *START-STATE*)
                (setq *END-TIME* (cadr (assoc 'last-time *START-STATE*))))))
     ))
p)

(defun load-probset (probset) 
   (declare (special *TEST-PROBS*))
   "This function can be put in a file to load a whole
    set of problems."
(setf *TEST-PROBS* probset))

(defun good-prob-p (prob probs)
    "This is return t for a valid prob or a nil, but nil for an invalid
     prob."
    (cond ((or (not prob) 
	       (member prob probs)) t)
	  (t nil)))

(defun load-problem ()
  (declare (special *CURRENT-PROBLEM-SET*))
  "Loads a problem from the current set if it exists, else load from 
   normal directory."
(cond (*CURRENT-PROBLEM-SET* (load-problem-from-set))
(t 
  (format *QUERY-IO* "~2%  Select one of the following problems...~2%")
  (let* ((cd (concatenate 'string  (namestring *WORLD-PATH*)
			  "probs" *DIRECTORY-SEPARATOR*))
	 (probs (printdir cd))
	 (cp nil))
    (loop 
      (format *QUERY-IO* "~2%  Enter a problem: ")
      (setq cp (string-trim '(#\SPACE #\TAB #\") (read-line *QUERY-IO*)))
      (cond ((null-string cp) (return nil))
	    ((member cp probs :test #'equal)
	     (return (set-the-problem cd cp)))
	    (t (format
		*QUERY-IO* "~2%  The problem ~A does not exist in ~A.~
		~%  Select another problem or hit [ENTER] to cancel.~%"
		cp cd))))))
)
)

; =====================================================================
;  Code for loading PROBLEM SETS.
; =====================================================================

(defun the-problem-set-command (&optional (cp nil))
  "lists available problem sets for the current domain, then loads a problem set"
  (cond
   ((not *CURRENT-DOMAIN*)
    (format *QUERY-IO* "~%  You must specify a domain before selecting a problem set.")
    (finish-output *QUERY-IO*))
   ((null cp)
    (let ((cd (concatenate 'string  (namestring *WORLD-PATH*)
			 "probsets" *DIRECTORY-SEPARATOR*)))
    (cond ((ignore-errors (directory cd))
    (format *QUERY-IO* "~2%  The problem sets for ~:(~A~) are...~2%" 
	    *CURRENT-DOMAIN*)
      (let ((probs (printlispdir cd)))
           (setf cp (query-for-good-problem probs cd))
      )) ; 
    (t (format *QUERY-IO* "~%There is set directory for ~A." 
	                                                *CURRENT-DOMAIN*))
    )))
   ((stringp cp)
    (let* ((cd (concatenate 'string  (namestring *WORLD-PATH*)
				 "probsets" *DIRECTORY-SEPARATOR*))
	   (probs-sets (directory-lispfile-list cd)))
      (if (member cp probs-sets :test #'equal)
	  (set-the-problem-set cd cp)
	  (format *QUERY-IO* "~% Problem set `~A' does not exist in `~A'"
		  cp *CURRENT-DOMAIN*))))
   ((not (stringp cp))
    (format *QUERY-IO* "~2% ERROR: the argument to problem must be a string"))))

(defun query-for-good-problem (probs cd &aux cp)
 (loop
   (format *QUERY-IO* "~2%  Enter a problem set (type ``none'' to choose no problem set): ")
   (finish-output *QUERY-IO*)
   (setq cp (string-trim '(#\SPACE #\TAB #\") (read-line *QUERY-IO*)))
   (cond
   ((null-string cp) (return nil))
   ((or (member cp probs :test #'equal) (equalp cp "NONE")) 

       (return (set-the-problem-set cd cp)))
   (t 
      (format
          *QUERY-IO* "~2%  The problem set ~A does not exist in ~A.~
          ~%  Select another problem or hit [ENTER] to cancel.~%"
	   cp *CURRENT-DOMAIN*))))
cp)  

(defun set-the-problem-set (thedir theprob-set)
     (declare (special *CURRENT-PROBLEM-SET* *CHANGED-PROBLEM-SET-FLAG*))
(cond ((equalp theprob-set "NONE") (setf *CURRENT-PROBLEM-SET* nil))
       (t (unless (eq *CURRENT-PROBLEM-SET* theprob-set)
           (setf thedir (string thedir) theprob-set (string theprob-set)) 
           (setf *CURRENT-PROBLEM-SET* theprob-set)
;           (setf *CHANGED-DOMAIN-FLAG* nil)
	   (setf *CURRENT-PROBLEM* nil)
	   (setf *CHANGED-PROBLEM-SET-FLAG* nil)
	   ;  (systemic-ramifications-of-this-command)
	   (funcall 'load (concatenate 'string thedir theprob-set))))))


(defun load-problem-set ()
  (format *QUERY-IO* "~2%  Select one of the following problems...~2%")
  (let* ((cd (concatenate 'string  (namestring *WORLD-PATH*)
                          "probsets" *DIRECTORY-SEPARATOR*))
         (probs (printdir cd))
         (cp nil))
    (loop
      (format *QUERY-IO* "~2%  Enter a problem set: ")
      (setq cp (string-trim '(#\SPACE #\TAB #\") (read-line *QUERY-IO*)))
      (cond ((null-string cp) (return nil))
            ((member cp probs :test #'equal)
             (return (set-the-problem-set cd cp)))
            (t (format
                *QUERY-IO* "~2%  The problem set ~A does not exist in ~A.~
                ~%  Select another problem set or hit [ENTER] to cancel.~%"
                cp cd))))))




; =====================================================================
(defun the-quiet-load-command ()
  (toggle-quiet-load)
  (format t "~%  The prodigy quiet load is now ~:[off~;on~]."
	  *QUIET-LOAD*))



(defun toggle-quiet-load ()
  "Toggles the quiet load flag.  When it is OFF prodigy will print out
   informative messages about the domain being loaded. When quiet loading is
   ON it will only print warning and error messages during loading.  The
   default is on."
  (cond (*QUIET-LOAD*
	 (setq *QUIET-LOAD* nil)
	 'Quiet_load_now_turned_off)
	(t (setq *QUIET-LOAD* t)
             'Quiet_load_now_turned_on)))

; ======================================================================

(defun the-quit-command ()
  (format t "~%Type ``(prodigy)'' to begin another session.~2%")
  'BYE)


; ======================================================================


(defun the-raw-command ()
  "Prints the contents of a node."
  (when (current-node-exists)
    (print-node-struct *EXPL-NODE*)
    (pp-plist-of (node-name *EXPL-NODE*))
  )
)



(defun print-node-struct (node)
  "This function is necessary since the default print function for a node
   is set to be (node-name node) (see function `make-node' in data-types.lisp)
   to prevent LISP from trying to print out a circular node structure.
   There is a flag, *print-circle*, to turn off circular printing but the
   result is still unreadable."

   (format t "NODE- ~A"            (node-name node)) (terpri)
   (format t " :parent ~A"         (node-name-robust (node-parent node))) 
							(terpri)
   (format t " :children ~A"	   (node-names (node-children node))) (terpri)
;   (format t " :recur-parent ~A"     (node-recur-parent node)) (terpri)
;   (format t " :recur-children ~A"   (node-recur-children node)) (terpri)
   (format t " :depth ~D"	     (node-depth node)) (terpri)
   (format t " :state ~A"	   (state-name (node-state node))) (terpri)
   (format t " :succeeded ~A"	   (node-succeeded node)) (terpri)
   (format t " :current-goal ~A"   (node-current-goal node)) (terpri)
   (format t " :current-op ~A"	   (node-current-op node)) (terpri)
   (format t " :candidate-goals ~A"     (node-candidate-goals node)) (terpri)
   (format t " :candidate-ops ~A"       (node-candidate-ops node))  (terpri)
   (format t " :candidate-bindings ~A" (node-candidate-bindings node))(terpri)
   (format t " :last-goal ~A"	   (node-last-goal node)) (terpri)
   (format t " :last-op ~A"	   (node-last-op node)) (terpri)
   (format t " :goal-stack ~A"	   (node-goal-stack node)) (terpri)
   (format t " :alternatives ")    (print-alternatives (node-alternatives node))
                                   (terpri)
   (format t " :reset-alt ") (cond ((alternative-p (node-reset-alt node))
                                    (print-alternative (node-reset-alt node)))
				   (t (princ (node-reset-alt node))))
                             (terpri)
   (format t " :generating-alt ")  (print-alternative (node-generating-alt 
						       node))
                                   (terpri)
   (format t " :applied-node ~A"   (node-applied-node node)) (terpri)
   (format t " :left-clone ~A"	   (node-left-clone node)) (terpri)
   (format t " :right-clones ~A"   (node-names (node-right-clones
						node))) 
                                   (terpri)
   (format t " :failure-reason ~A"	 (node-failure-reason node))(terpri)
;   (format t " :history-for-ebl ~A"      (node-history-for-ebl node)) (terpri)
;   (format t " :match-count ~A"	         (node-match-count node)) (terpri)
   (format t " :expanded ~A"	         (node-expanded node)) (terpri)
   (format t " :time ~A " (node-time node)))


(defun print-alternatives (alts)
  (cond ((null alts) (princ nil))
        (t (dolist (alt alts) (print-alternative alt)))))

(defun print-alternative (alt)
  (terpri)  (format t "  ALT- :goal ~A" (alt-goal alt))
  (terpri)  (format t "       :op ~A"   (alt-op alt))
  (terpri)  (format t "       :unmatched-conds ~A" (alt-unmatched-conds alt))
  (terpri)  (format t "       :failed-conds ~A" (alt-failed-cond alt)) 
  (terpri)  (format t "       :vars ~A"  (alt-vars alt))
  (terpri)  (format t "       :post-cond ~A" (alt-post-cond alt)))

(defun pp-plist-of (sym)
   (declare (symbol sym))
   "Pretty prints the plist of a symbol"
    (pppl (symbol-plist sym)))

(defun pppl (lst)
     "Pretty prints a property list."

  (do* ((reduced-list lst (cddr reduced-list))
	(prop-name (first reduced-list) (first reduced-list))
	(prop-val (second reduced-list) (second reduced-list)))
        ((null prop-name) nil) 
				; finish when nil, return nil.


      (when (eql (symbol-package prop-name) (find-package 'user))
      	  (format t "~% :~A ~A" prop-name prop-val)
      )
  )
)

(defun node-name-robust (node)
  (if (node-p node) (node-name node) node)
)

(defun node-names (list-of-nodes)
(when (and (listp list-of-nodes) list-of-nodes)
    (mapcar #'node-name-robust list-of-nodes)))
  
; ======================================================================


(defun the-refresh-command ()
  (cond ((not (current-node-exists)))
	((null *TREE-GRAPHICS*)
	 (FORMAT T "~%  Tree graphics not turned on.  Use the ~
	            ~%  `tree' command to activate graphics."))
	(t (refresh-tree *EXPL-NODE*))))
      

; ======================================================================


(defun the-right-command (args)
  (when (current-node-exists)
    (let* ((no-of-nodes (if (null args) 1
			   (car (get-args args 1
					  '("  How many nodes right?")))))
	   (rc (remove nil (get-right-clone-list *EXPL-NODE*)))
	   (nrc (length rc)))
      (cond ((null rc)
	     (format t "~%  No right clones exist."))
	    ((> no-of-nodes nrc)
	     (format t "~%  Only moving right ~D clones." nrc)
	     (move-to-node (nth (1- nrc) rc)))
	    (t (move-to-node (nth (1- no-of-nodes) rc)))))))

; ======================================================================


(defun the-rightmost-command ()
  (when (current-node-exists)
    (move-to-node (rightmost-clone *EXPL-NODE*))))

; ======================================================================


(defun the-scfail-command ()
  (when (current-node-exists)
    (cond ((not *SCR-TRACING*)
	   (format t "~%  Search control tracing is currently disabled.  Use~
	              ~%  the `sctrace' command to enable, before running or~
		      ~%  continuing the planner, otherwise this information~
		      ~%  is not stored."))
	  (t (g-map (entry in 
			   (find-matches-at-node 
			    *EXPL-NODE*
			    (process-matcher-trace *MATCHER-TRACE*)))
		    (do (print-failure-record-entry entry)))))))


(defun process-matcher-trace (matcher-trace)
  "Functions for using *MATCHER-TRACE*, answering why-failed questions
   *MATCHER-TRACE* = ((failed-lit bindings)....(``expression'' exp)... node...)
   where node is pushed first onto the trace, then expression,
   then f-record...hierarchical structure left implicit on the list
   after processing, 
   new-matcher-trace = ((node (exp ((failed-lit bindings)
                                    (failed-lit bindings)...)..)"
    (g-loop (init entry nil ret-val nil lits nil exps nil)
	    (while (setq entry (pop matcher-trace)))
	    (do (cond ((node-p entry)
		       (and lits (error "bad matcher-trace"))
		       (push (list entry exps) ret-val)
		       (setq exps nil))
		      ((eq (car entry) 'expression)
		       (push (list (cadr entry) lits) exps)
		       (setq lits nil))
		      (t (push entry lits))))
	    (result ret-val)))



(defun print-failure-record-entry (entry)
 " entry = (exp ((lit bindings) (lit bindings)..))"
    (cond ((null (cadr entry)) t) 	;  didn't fail, do nothing
	  (t 
	     (terpri)
	     (terpri)
	     (format t "~2%  While matching expression:  ~A" (car entry))
	     (g-map (lit-and-bindings in (cadr entry))
		    (do (progn
			      (terpri)
			      (format t "  Matcher Failed on: ~A" 
				      (car lit-and-bindings))
			      (terpri)
			      (format t "  bindings: ~A" 
					 (cadr lit-and-bindings)))))
	     (terpri))))



(defun find-matches-at-node (n new-matcher-trace)
  "Find-scr-matches-at-node looks through each set of bindings in each 
   f-record to see if node n was bound, and if it finds that n was bound,
   returns the entry (exp (lit bindings) (lit bindings)
   Note: doesn't pick up operators, since n is only bound by meta-preds.."
  (g-map (entry in (toss-nodes new-matcher-trace))
	 (when (g-loop (init f-records (cadr entry) bindings nil 
			     node-nm (node-name n))
		       (while f-records)
		       (do (setq bindings (cadar f-records))
			   (if (node-is-bound node-nm bindings)
			       (return t)))
		       (next f-records (cdr f-records))))
	 (save entry)))	


(defun toss-nodes (new-m-trace)
    (g-loop (init ret-val nil)
	    (while new-m-trace)
	    (do (setq ret-val (append (cadar new-m-trace) ret-val)))
	    (next new-m-trace (cdr new-m-trace))
	    (result ret-val)))



(defun node-is-bound (node-nm bindings)
    (g-loop (init pair nil)
	    (while (setq pair (pop bindings)))
	    (do (if (and (node-p (cadr pair))
			 (eq node-nm (node-name (cadr pair))))
		    (return t)))
	    (return nil)))



; ======================================================================

(defun the-schst-command (args)
  (when (current-node-exists)
    (cond ((null args) (print-schst-table *EXPL-NODE*))
	  ((symbolp args) (schst-info (list args)))
	  ((<= (length args) 2) (schst-info args))
	  (t (schst-info `(,(car args) ,(cadr args)))))))



(defun print-schst-table (node)
; for a node {node} print a table indicating number of search control 
; rules fired under all rule categories. 
  (let* ((rb (length (node-reject-bindings-hst node)))
	 (ro (length (node-reject-op-hst node)))
	 (rg (length (node-reject-goal-hst node)))
	 (rn (length (node-reject-node-hst node)))
	 (ra (+ rn rg ro rb))
	 (pb (length (node-bindings-pref-hst node)))
	 (po (length (node-op-pref-hst node)))
	 (pg (length (node-goal-pref-hst node)))
	 (pn (length (node-node-pref-hst node)))
	 (pa (+ pn pg po pb))
	 (sb (length (node-select-bindings-hst node)))
	 (so (length (node-select-op-hst node)))
	 (sg (length (node-select-goal-hst node)))
	 (sn (length (node-select-node-hst node)))
	 (sa (+ sn sg so sb))
	 (ab (+ sb pb rb))
	 (ao (+ so po ro))
	 (ag (+ sg pg rg))
	 (an (+ sn pn rn))
	 (aa (+ sa pa ra)))
    (if (zerop aa)
	(format t "~%~%  No search control rules fired at ~S." (node-name node))
	(progn
	  (format t "~%                Search Control History for ~@(~S~)~%"
		  node)
	  (format t "~%               -----------------------------------")
	  (format t "~%              | select | reject | prefer |  all   |")
	  (format t "~%   -----------+--------+--------+--------+--------|")
	  (format t "~%  |   nodes   |~@{ ~6,' D |~}" sn rn pn an)
	  (format t "~%  |-----------+--------+--------+--------+--------|")
	  (format t "~%  |   goals   |~@{ ~6,' D |~}" sg rg pg ag)
	  (format t "~%  |-----------+--------+--------+--------+--------|")
	  (format t "~%  | operators |~@{ ~6,' D |~}" so ro po ao)
	  (format t "~%  |-----------+--------+--------+--------+--------|")
	  (format t "~%  |  bindings |~@{ ~6,' D |~}" sb rb pb ab)
	  (format t "~%  |-----------+--------+--------+--------+--------|")
	  (format t "~%  |    all    |~@{ ~6,' D |~}" sa ra pa aa)
	  (format t "~%   -----------------------------------------------~%")
	  (format t "~%  Type `schst <row-name> <column-name>' ~
	                  for more information.")))))



(defun schst-info (args)
  "parse the arguments for the name of the row and/or column 
   then print the specified category of rules."
  (let* ((row-name (get-schst-row-or-column-name (car args)))   
	 (col-name (get-schst-row-or-column-name (cadr args)))
	 (groupings (intersection 
		     (schst-rule-groupings row-name) 
		     (schst-rule-groupings col-name)))
	 (fired (expand-schst-groupings  groupings *EXPL-NODE*)))
    (cond ((not (or row-name col-name))
	   (format t "~%  Bad arguments to schst. ~
	              ~%  Type `help schst' for correct usage."))
	  ((null fired)
	   (format t "~%  No ~@[~(~A~)~]~@[~( ~A~)~] rules ~
	   fired at ~@(~S~)." row-name col-name (node-name *EXPL-NODE*)))
	  (t (format t "~%  ~@[~@(~A~)~]~@[~( ~A~)~] rules ~
	  fired at ~@(~S~) :~%" row-name col-name (node-name *EXPL-NODE*))
	     (dolist (x fired) (print-schst-rule x))))))




(defun get-schst-row-or-column-name (word)
  "returns the name of a row or column given a partial word"
  (if (symbolp word) (setq word (string-downcase (string word))))
  (if (>= (length word) 2) (setq word (subseq word 0 2)))
  (car (remove  'nil 
		(mapcar #'(lambda (x) (if (or (string-equal word (caar x))
					      (string-equal word (cadar x)))
					  (cadr x)))
			'((("s" "se") select)  (("p" "pr") prefer)
			  (("r" "re") reject)  (("a" "al") all)
			  (("b" "bi") binding) (("o" "op") operator)
			  (("g" "go") goal)    (("n" "no") node))))))


(defun schst-rule-groupings (which)
  "for the keyword {which} this function returns a list of group names."
  (let* ((ra '(rn rg ro rb))   (pa '(pn pg po pb))
	 (sa '(sn sg so sb))   (ab '(sb pb rb))
	 (ao '(so po ro))      (ag '(sg pg rg))
	 (an '(sn pn rn))      (aa (append sa pa ra)))
    (declare (special rn rg ro rb sn sg so sb pn pg po pb))
    (case (or which 'all)
      (select sa)(reject ra)(prefer pa)(node an)
      (goal ag)(operator ao)(binding ab)(all aa))))
  



(defun expand-schst-groupings (groups node)
  "append the search control information lists for each item in groups.
   i.e. cons the values [should be lists] of all the elements of the
   list `groups'."
  (when (and groups (listp groups))
    (let* ((rb (node-reject-bindings-hst node))
	   (ro (node-reject-op-hst node))
	   (rg (node-reject-goal-hst node))
	   (rn (node-reject-node-hst node))
	   (ra `(,@rn ,@rg ,@ro ,@rb))
	   (pb (node-bindings-pref-hst node))
	   (po (node-op-pref-hst node))
	   (pg (node-goal-pref-hst node))
	   (pn (node-node-pref-hst node))
	   (pa `(,@pn ,@pg ,@po ,@pb))
	   (sb (node-select-bindings-hst node))
	   (so (node-select-op-hst node))
	   (sg (node-select-goal-hst node))
	   (sn (node-select-node-hst node))
	   (sa `(,@sn ,@sg ,@so ,@sb))
	   (ab `(,@sb ,@pb ,@rb))
	   (ao `(,@so ,@po ,@ro))
	   (ag `(,@sg ,@pg ,@rg))
	   (an `(,@sn ,@pn ,@rn))
	   (aa (append sa pa ra))
	   (result nil))
      (declare (special rb ro rg rn ra pb po pg pn pa 
			sb so sg sn sa ab ao ag an aa))
      (dolist (x groups result)
	(setq result (append result (eval x)))))))


(defun print-schst-rule (r)
; print one search control rule, which can have multiple bindings
    (cond
     ((get-orig-scr-prefer (car r))
      (print-schst-list-item  "     Rule name:     " (car r))
      (print-schst-list-item  "     Previous best: " `((,(cadr r))))
      (print-schst-list-item "     New Preferred: " (list (last r)))
      (print-schst-list-item "     Bindings:      " (car (nth 2 r))))
     ((get-orig-scr-select (car r))
      (print-schst-list-item  "     Rule name:     " (car r))
      (print-schst-list-item  "     Selected:      " (list (last r)))
      (print-schst-list-item  "     Bindings:      " (cadr r)))
     ((get-orig-scr-reject (car r))
      (print-schst-list-item"     Rule name:     " (car r)) 
      (print-schst-list-item "     Rejected:      " (list (last r)))
      (print-schst-list-item "     Bindings:      " (cadr r))))
  (terpri))



(defun print-schst-list-item (txt itm)
  (format t "~%~A" txt)
  (p-schst-l-i (length txt) itm nil))



(defun p-schst-l-i (tab itm nline)
  (cond ((null itm) nil)
	((not (listp itm)) (princ itm))
	(t (cond ((or (numberp (car itm)) (symbolp (car itm)))
		  (if nline (format t "~%~VT" tab))
		  (format t "~S ~S" (car itm) (cadr itm))
		  (p-schst-l-i tab (cddr itm) t))
		 ((and (listp (car itm)) (remove nil (car itm)))
		  (if nline (format t "~%~VT" tab))
		  (format t "~{~S   ~}" (car itm))
		  (p-schst-l-i tab (cdr itm) t))))))


; ======================================================================


(defun the-scrule-command (scr)
  "print all search control rules, or the specified rule."
  (cond ((or (null scr) (eql scr 'all)) (print-all-scrs))
	((symbolp scr)
	 (format t "~2%  Search Control Rule  ~:(~A~) " scr)
	 (setq scr (get-orig-scr scr))
	 (format t "~:[does not exist~;:~2%    ~:*~A~%~]" scr))
	(t (format t "~2%  The argument to `scrule' must be a symbol."))))

(defun print-all-scrs ()
  "print all operators."
  (let ((scrs (append 
	       *SCR-NODE-SELECT-RULES*  *SCR-GOAL-SELECT-RULES*
	       *SCR-OP-SELECT-RULES*	*SCR-BINDINGS-SELECT-RULES*
	       *SCR-NODE-REJECT-RULES*  *SCR-GOAL-REJECT-RULES*
	       *SCR-OP-REJECT-RULES*	*SCR-BINDINGS-REJECT-RULES*
	       *SCR-NODE-PREFERENCE-RULES*  *SCR-GOAL-PREFERENCE-RULES*
	       *SCR-OP-PREFERENCE-RULES*  *SCR-BINDINGS-PREFERENCE-RULES*)))
    (format t "~%  ~:[There are no search control rules.~;~
                   Available search control rules are:~%~{~%    ~:(~A~)~}~
	      ~2%  Type ``scrule <search-control-rule-name>'' to ~
	       ~%  view a specific search control rule.~]"
	    scrs (mapcar #'car scrs))))


(defun get-orig-scr (sc-rule)
; given the name of a search control rule, return the rule.
  (or (get-orig-scr-select sc-rule)
      (get-orig-scr-reject sc-rule)
      (get-orig-scr-prefer sc-rule)))

; ======================================================================


(defun the-sctrace-command ()
  (declare (special *SCR-TRACING* *DISCARD-FAILURE-BRANCHES*))
  (toggle-scr-tracing)
  (format t "~%  Search control tracing is now ~:[off~;on~]." *SCR-TRACING*))



(defun toggle-scr-tracing ()
  (declare (special *SCR-TRACING*))
  "Toggles the search control tracing facility during planning."
  (cond (*SCR-TRACING*
	 (setq *SCR-TRACING* nil)
	 'Search_control_tracing_now_turned_off)
	(t (setq *SCR-TRACING* t)
	   (if *DISCARD-FAILURE-BRANCHES*
	       (format t 
		       "WARNING:  Doing SCR failure tracing will degrade the~
                        perfmance of node discarding.~%"))
	   'Search_control_tracing_now_turned_on)))

; ======================================================================

(defun the-show-command (args)
  (cond ((not (current-node-exists)))
	((null *TREE-GRAPHICS*)
	 (FORMAT T "~%  Tree graphics not turned on.  Use the ~
	            ~%  `tree' command to activate graphics."))
	(t (show-node (name-to-node (car 
				     (get-args args 1
					       '("  Show which node?"))))))))

(defun show-node (node)
  "Shifts the tree so that the virtual pre-parent of the given
   node appears in the upper left-hand corner of the window."
  (if (and *TREE-GRAPHICS* (on-current-path node))
      (redisplay-tree node))
  (move-to-node node))
  
; ======================================================================

(defun the-solution-command ()
  (when (current-tree-exists)
    (print-op-list 
     "  Problem Solution:"
;     (find-op-seq (cadr *ALL-NODES*));; changed from (car *NODE-LIST*)
;   changed again because cadr *all-nodes* is not always on the solution path,
; if something other then depth-first is done.  Also the when prevents 
;  *finish* from appearing in the solution seq.

      (if (eq '*FINISH* (alt-op (node-generating-alt (car *ALL-NODES*))))
	  (find-op-seq (node-parent (car *ALL-NODES*)))
	  (find-op-seq (car *ALL-NODES*))
      )
     t)))


; ======================================================================

(defun the-solve-command ()
  (cond 
   ((not *CURRENT-DOMAIN* )
    (format t "~2%  Before solving a problem you must specify the~
                ~%  domain and problem you wish to solve, using~
		~%  the ``domain'' and ``problem'' commands."))
   ((and *CURRENT-DOMAIN* (not *CURRENT-PROBLEM*))
    (format t "~2%  You have not specified a problem to solve. use~
                ~%  the ``problem'' command to select a problem."))
   ((and *CHANGED-DOMAIN-FLAG* (not *CHANGED-PROBLEM-FLAG*))
    (format t "~2%  Whenever you change the domain, you must~
                ~%  (re)select a problem from the new domain's~
		~%  problems. This provides that both domain~
		~%  and problem predicates are consistent."))
   ((and *CHANGED-DOMAIN-FLAG* *CHANGED-PROBLEM-FLAG*
	 *CURRENT-DOMAIN* *CURRENT-PROBLEM*)
    (psetq *CHANGED-DOMAIN-FLAG* nil
	   *CHANGED-PROBLEM-FLAG* nil)
    (run-or-dfid))
   ((and *CURRENT-DOMAIN* *CURRENT-PROBLEM*) (run-or-dfid))))

(defun run-or-dfid ()
   (declare (special *AUTO-DFID-FLAG*))
       (if (not *AUTO-DFID-FLAG*)
	(run)
	(dfid-run)))

; ======================================================================


(defun the-stack-command ()
  "Prints out the stack at a node"
  (when (current-node-exists)
    (print-list
     "Goal Stack: "
     (add-node-numbers
      *EXPL-NODE*
      (cons (node-current-goal *EXPL-NODE*)
	    (node-goal-stack *EXPL-NODE*))))))



(defun add-node-numbers (node gs)
  (cond ((eq (leftmost-clone node) n1) (list (cons 'n1 gs)))
        (t (cons (list (node-name node) (car gs))
                 (add-node-numbers (leftmost-clone (v-pre-parent node))
		     (cdr gs))))))

; ======================================================================

(defun the-state-command ()
  (when (current-node-exists)
  (terpri) (terpri)
    (print-explicit-state *EXPL-NODE*)))


(defun print-explicit-state (node)
  (print-list 
    (concatenate 'string 
		 "True in state " 
                 (princ-to-string (state-name (node-state node))) ": ")
    (state-true-assertions (node-state node))))


; ======================================================================

(defun the-static-command ()
  (format t "~2%  ~:[There are no static predicates in the initial state.~;~
                  The following predicates are static: ~:*~2%~
             ~{~10T~(~A~)~%~}~
             ~:[~;~%  These predicates were defined as functions.~]~]~%"
          *STATIC-STATE-PREDS* 
          *AUTODEFINED-FUNCTION-PREDS*))



; ======================================================================

(defun the-surrounding-command ()
  (when (current-node-exists)
    (create-surrounding-graphics *EXPL-NODE*)))



(defun create-surrounding-graphics (node)
  (and node (print-ex-picture (get-ex-p-shape node) node)))



(defun get-ex-p-shape (node)
  (cond ((not (node-p (left-clone node)))
         (cond ((and (no-right-clones node) 
	             (node-p (next-node node))
                     (up-node (next-node node)))
               'XPH)
               (t 'XPR)))
        ((and (no-right-clones node) 
              (up-node (next-node node)))
         'XPL)
        (t 'XPM)))


(defun print-ex-picture (shape node)
  (case shape
    (XPR (ex-p-right (intern (concatenate 'string "<" 
				 (princ-to-string (node-name node)) ">"))
                     (previous-node node)
                     (node-children node)
                     (node-right-clones node)))
    (XPL (ex-p-left (intern (concatenate 'string "<" 
				 (princ-to-string (node-name node)) ">"))
                    (next-node node)
                    (previous-node node)
                    (left-clone node)))
    (XPM (ex-p-man (intern (concatenate 'string "<" 
				 (princ-to-string (node-name node)) ">"))
                   (previous-node node)
                   (node-children node)
                   (left-clone node)
                   (node-right-clones node)))
    (XPH (ex-p-hang (intern (concatenate 'string "<" 
				 (princ-to-string (node-name node)) ">"))
                    (previous-node node)
                    (next-node node)))))


(defun ex-p-right (node nu nd nr)
    (terpri)
    (terpri) (format t "     ~A" nu)
    (terpri) (format t "       * ")
    (terpri) (format t "        ~A -- ~A" node nr)
    (terpri) (format t "          *  ")
    (terpri) (format t "           ~A" nd)
    (terpri))


(defun ex-p-left (node nu nd nl)
    (terpri)
    (terpri) (format t "              ~A" nu)
    (terpri) (format t "             * ")
    (terpri) (format t "    ~A -- ~A" nl node)
    (terpri) (format t "         *")
    (terpri) (format t "       ~A" nd)
    (terpri))


(defun ex-p-man (node ndl ndr nl nr)
    (terpri) 
    (terpri) (format t "     ~A -- ~A -- ~A" nl node nr)
    (terpri) (format t "           *  * ")
    (terpri) (format t "         ~A  ~A" ndl ndr)
    (terpri))


(defun ex-p-hang (node nul nur)
    (terpri) 
    (terpri) (format t "     ~A   ~A" nul nur)
    (terpri) (format t "       *  *")
    (terpri) (format t "        ~A" node)
    (terpri))

 
; ======================================================================

(defun the-text-command ()
  (toggle-trace-text)
  (format t "~%  The problem solving trace text is now ~:[off~;on~]."
	  *TRACE-TEXT-FLAG*))



(defun toggle-trace-text ()
  "Toggles the text flag.  This flag determines whether or not PRODIGY will
   print the text of the problem solving trace.  If the flag is on, then it
   will print information as it explores each node.  If the flag is off,
   then it will only print the goal, start state, and solution (if one is
   found)"
  (cond (*TRACE-TEXT-FLAG* 
	 (setq *TRACE-TEXT-FLAG* nil)
	 'Text_now_turned_off)
	(t (setq *TRACE-TEXT-FLAG* t)
	   (setq *STATE-TEXT-FLAG* t)
             'Text_now_turned_on)))


(defun toggle-trace-abs ()
  "Toggles the user selection of node alternatives."
  (cond (*ABS-PRINT-FLAG*
	 (setq *ABS-PRINT-FLAG* nil)
	 (setq *TRACE-TEXT-FLAG* nil)
	 'Abstraction_tracing_is_now_disabled)
	(t (setq *ABS-PRINT-FLAG* t)
	   (setq *TRACE-TEXT-FLAG* t)
	   (setq *STATE-TEXT-FLAG* t)
	   'Abstraction_tracing_is_now_enabled)))


; ====================================================================

(defun the-discard-command ()
     (declare (special *DISCARD-FAILURE-BRANCHES* *OP-TRACING* *SCR-TRACING*))
     (toggle-discard)
     (format t "~%  Discarding failure paths is now ~:[off~;on~]."
		*DISCARD-FAILURE-BRANCHES*)
)

(defun toggle-discard ()
   (declare (special *DISCARD-FAILURE-BRANCHES*))
   "Toggles the throw away flag.  This flag enables the system to erase paths
   in the search tree that have terminated.  This will work with any kind 
   of searching control rules, but is primarily designed to throw away nodes
   in searches such as breadth first that examine a large percentage of the
   search space."

   (cond (*DISCARD-FAILURE-BRANCHES*
	    (setf *DISCARD-FAILURE-BRANCHES* nil)
	        'Discard__failure_paths_no_turned_off)
	    (t (setf *DISCARD-FAILURE-BRANCHES* t)
	       (if *OP-TRACING*
		   (format t 
			   "WARNING:  Doing operator failure tracing will degrade the~
                           perfmance of node discarding.~%"))
	       (if *SCR-TRACING*
		   (format t 
			   "WARNING:  Doing SCR failure tracing will degrade the~
                            perfmance of node discarding.~%"))
	 	'Discard_failure_paths_now_turned_on))
)


; ====================================================================
; These commands set the variable *PRODIGY-TIME-BOUND*.
; No error check is done on the argument.
(defun the-time-bound-command (time-bound)
	(set-time-bound time-bound t)
)

(defun set-time-bound (time-bound &optional stream)
    "Sets the variable *PRODIGY-TIME-BOUND* to the argument."
     (if (numberp time-bound)
	    (format stream "The time bound used to be ~D CPU seconds.~%The time bound is now ~D CPU seconds." *PRODIGY-TIME-BOUND*
	(setq *PRODIGY-TIME-BOUND* time-bound))

	(format stream "Argument must be of type FIXNUM, not ~A."
					      (string (type-of time-bound)))
     )
)

; ======================================================================

(defun the-togsurrounding-command ()
  (toggle-surrounding-graphics)
  (format t "~%  The surrounding graphics is now ~:[off~;on~]."
	  *SURROUNDING-GRAPHICS*)
  (and *SURROUNDING-GRAPHICS* *EXPL-NODE*
       (create-surrounding-graphics *EXPL-NODE*)))



(defun toggle-surrounding-graphics ()
  "Toggles the surrounding graphics flag.  This flag determines whether or not
   prodigy will print a picture of the local nodes using simple character
   graphics upon entering the analysis facility. If the flag is on, then 
   the picture will be shown upon entry into the analysis facility, and 
   through subsequent movement through the node hierarchy during analysis. 
   If the flag is off, then no picture is drawn, and a picture may only be
   drawn.  Note the drawing of character graphics is mutually exclusive with
   the drawing of the tree-graphics, with the tree-graphics having priority. 
   This flag (and facility) can be considered an aid to those users who do
   not have the tree-graphics facilities. "

  (cond (*SURROUNDING-GRAPHICS*
	 (setq *SURROUNDING-GRAPHICS* nil)
	 'Picture_graphics_now_turned_off)
	(t (setq *SURROUNDING-GRAPHICS* t)
	   'Picture_graphics_now_turned_on)))


; ======================================================================




(defun the-tree-command ()
  (when (current-tree-exists)
    (toggle-tree-graphics-old)
    (format t "~%  Tree graphics are now ~:[off~;on~]." 
	    *TREE-GRAPHICS*)))

(defun the-tree-command-message ()
    (toggle-tree-graphics)
)


(defun toggle-tree-graphics-old ()
  "Toggles the tree graphics flag.  The tree graphics flag controls the 
   window associated with the explanation facility.  If this flag is on, then
   the explanation facility will fire up a window in the lower right-hand 
   corner of the screen which will display the tree structure of the problem 
   solving trace.  If the flag is off, then this window will not appear."
  (cond (*TREE-GRAPHICS*
	 (setq *TREE-GRAPHICS* nil)
	 (kill-tree-graphics)
	 'Tree_graphics_now_turned_off)
	(t (setq *TREE-GRAPHICS* t)
	   (create-tree)
	   'Tree_graphics_now_turned_on)))

(defun toggle-tree-graphics ()
   "Changes philosophy of Tree Graphics"
   (format t "The TOGGLE-TREE-GRAPHICS functions has been removed~%~
	      from prodigy.  Tree graphics may now only be used from~%~
	      the ANALYZE facility."))

; ======================================================================

(defun the-whatif-command (node environment)
  (when (current-node-exists)
    (setq node (cond ((integerp node)
		      (setq node (concat "N" node))
		      (cond ((boundp node) (eval node)) (t node)))
		     ((node-p node) node)
		     ((and node (listp node) (node-p (car node)))
		      (car node))
		     ((null node) *EXPL-NODE*)))
    (cond  ((not (member node *NODE-LIST*))
	    (format
	     t 
	     "~2%  The optional parameter to WHAT-IF is an existing node ~
	     ~%  number. `~A' is an invalid parameter for WHAT-IF.~%" node))
	   ((null (node-alternatives node))
	    (format t "~2%  There are no alternatives for node ~:(~A~)." node))
	   (t
	    (setq *WHAT-IF-FLAG* t)
	    (setq *WHAT-IF-ADVICE* t)
	    (setq *WHAT-IF-NODE* node)
	    (cond ((equal environment "the problem solver")
		   'continue)
		  (t 
		   (format t "~2% Running Prodigy in What-If Mode...")
		   (cntrl node '(done))
		   (initialize-vars)
		   (display-tree)
		   (cond ((eq (node-current-op (cadr *ALL-NODES*))
			'*FINISH*)
			  ; set phony node to nil
			  (set (node-name (car *ALL-NODES*)) nil)  
			  ; and delete it from list
			  (setq *NODE-LIST* (cdr *ALL-NODES*))) 
			(t (setq *NODE-LIST* *ALL-NODES*)))
		   (format t "~2% ... Returning to Analysis Facility")
		   (and *TREE-GRAPHICS*
			(redisplay-tree (node-parent node)))))))))


; ======================================================================
;                     FUNCTION   DEFINITIONS 
; ======================================================================


(defun systemic-ramifications-of-this-command ()
  (declare (special *CURRENT-PROBLEM-SET*))
  (when (or *CHANGED-DOMAIN-FLAG* *CHANGED-PROBLEM-FLAG*)
    (reclaim) 
    (when *CHANGED-DOMAIN-FLAG* (setf *CURRENT-PROBLEM* nil
				      *CURRENT-PROBLEM-SET* nil))
    (when *tree-graphics* (toggle-tree-graphics))))

; ----------------------------------------------------------------------


(defun current-tree-exists ()
  (format t "~:[~%  A search tree does not exist, you must solve~
                ~%  a problem before using this command.~;~]"
	  *ALL-NODES*)
  *ALL-NODES*)



(defun current-node-exists ()
  (format t "~:[~%  There is no current node, you must solve~
                ~%  a problem before using this command.~;~]"
	  *EXPL-NODE*)
  *EXPL-NODE*)


; ----------------------------------------------------------------------

(defun did? (node)
  "DID? just sees if something happened at a node, i.e. applied node."
    (cond ((and node (node-applied-node node)) t)
	  (t nil)))

(defun failure-node (node)
  (null (node-children node)))
 

(defun get-all-doing-clones (node)
; prints out whats done so far for this particular goal (at node)
  (remove nil
   (mapcar #'(lambda (el) 
		      (cond ((and (up-node el) (did? el)) el)
			    (t nil)))
	   (append (get-all-left-clones node) (list node)))))


(defun up-node (node)
  (let ((previous (if (node-p node) (previous-node node) nil)))
       (cond (previous 
               (< (length (node-goal-stack node)) 
	          (length (node-goal-stack previous))))
             (t nil))))




; ----------------------------------------------------------------------


(defun print-all-doing-clones (node)
  (dolist (n (get-all-doing-clones node))
    (terpri)
    (format t "Node ~A: " (node-name-robust (previous-node n)))
    (print-done n)))


(defun print-expl-failure-message (node)
  (format t "~2%This is a failure node. ~%")
  (dolist (o (get-op-list (get-predicate (get-top-goal node))))
    (format t "~%~A tried: ~A" o (cons-op-print node o)))
  (print-failure-reason node nil)
  (let* ((next-node-name (concat "N" (1+ (node-to-number node))))
       (next-node (if (boundp next-node-name)
                      (eval next-node-name) 
		      nil)))
    (cond ((node-p next-node)
  (format t "~%Prodigy continued at node ~A." (node-name next-node)))
	  (t (format t "~%No next node.")))))


(defun cons-op-print (node op)
; should distinguish between failures, generating alts, and successes (nil)
    (terpri) (terpri)
    (format t "considered operator ~A at node ~A" op (node-name node))
;    (find-failures op node)
    (cond (*MATCH-EXPLANATION*
	      (print-list "Failure reason(s): " *MATCH-EXPLANATION*))
	  ((did? (next-node node))
	   (print-doing (next-node node) 5))
	  (t (terpri) (format t "Reset-alt ")))
;    (setq *MATCH-EXPLANATION* nil)
;    (setq *NODE-LIST* (cdr *NODE-LIST*))
    nil)

; ----------------------------------------------------------------------

(defun get-op-list (predicate)
  (cond ((eq (car predicate) '~)
         (cdr (assoc (cdr predicate) *FALSIFY-RELEVANCE-TABLE*
		                     :test #'equal)))
        (t (cdr (assoc (car predicate) *TRUIFY-RELEVANCE-TABLE*
                       :test #'equal)))))


(defun get-predicate (goal)
  (cond ((not (eq (car goal) '~)) (list (car goal)))
        (t (cons '~ (cadr goal)))))


(defun get-top-goal (node)
  (node-current-goal node))

; ----------------------------------------------------------------------

(defun get-all-left-clones (node)
  (cond ((not (node-p (left-clone node))) nil)
        (t (append (get-all-left-clones (left-clone node))
		   (list (left-clone node))))))


(defun get-right-clone-tree (node)
  (cond ((not (node-p node)) nil)
        ((no-right-clones node) (list node))
        (t (cons-node-with-rest node
             (get-rest-clone-tree (node-right-clones node))))))
 

(defun no-right-clones (node)
  (or (null (node-right-clones node))
      (equal (node-right-clones node) '(nil))))
 

(defun get-right-clone-list (node)
  "gives a list of right clones on the current path"
  (do* ((clones nil)
	(clone (right-clone-on-path node)
	       (right-clone-on-path clone)))
       ((null clone) (reverse clones))
     (push clone clones)))


(defun right-clone-on-path (node)
   (find-if #'(lambda (x) (and x (on-current-path x)
			         (not (backtrack-node-p x))))
	    (node-right-clones node)))



(defun cons-node-with-rest (node node-list)
; should return a list of node-lists
  (cond ((null node-list) nil)
        ((null (cdr node-list)) (cons node (car node-list)))
        (t (cons (cons node (car node-list))
                 (list (cons-node-with-rest node (cdr node-list)))))))


(defun get-rest-clone-tree (node-list)
  (cond ((null node-list) nil)
        (t (cons (get-right-clone-tree (car node-list))
		 (get-rest-clone-tree (cdr node-list))))))

; ----------------------------------------------------------------------


(defun previous-node (node)
   (node-parent node))
 

(defun next-node (node)
  (car (node-children node)))
  

; ----------------------------------------------------------------------

(defun move-to-node (node)
  (declare (special *NODE-LIST* *EXPL-NODE* *TREE-GRAPHICS*
		    *SURROUNDING-GRAPHICS* *DOMAIN-GRAPHICS*))
  "Moves the explanation facility and the tree graphics to the given node.
   This node will be highlighted in the tree window and the tree will shift
   to show the node if it does not already  appear or fit completely in the
   tree window."
  (let ((new-node (if (node-p node) node (name-to-node node))))
    (when (member new-node *NODE-LIST*)
      (cond (*TREE-GRAPHICS*
	     (if *EXPL-NODE* (unhighlight-node *EXPL-NODE*))
	     (cond ((and (not (on-current-path new-node)) *EXPL-NODE*)
		    (format t "Node ~A is not on the current path!" new-node)
		    (terpri))
		   (t (setq *EXPL-NODE* new-node)))
	     (cond ;((null (mapped-nodes))
		    ;(create-tree))
		   ((or (not (is-mapped *EXPL-NODE*))
			(not (fully-in-tree-window *EXPL-NODE*)))
		    (redisplay-tree *EXPL-NODE*)))
	     (highlight-node *EXPL-NODE*))
	    ;
	    ; update the picture graphics if the tree graphics does not exist.
	    ;
	    (*SURROUNDING-GRAPHICS*
	     (setq  *EXPL-NODE* new-node)
	     (create-surrounding-graphics *EXPL-NODE*))
	    ;
	    ; otherwise do nothing.
	    ;
	    (t (setq *EXPL-NODE* new-node)))
      ;
      ; update the domain graphics
      ;
      (cond (*DOMAIN-GRAPHICS* 
	     (display-domain-graphics *EXPL-NODE*)))
      (the-context-command *EXPL-NODE*))))
  
; ----------------------------------------------------------------------


(defun name-to-node (name)
; NOTE: (boundp nil) --> T  so we must check that the name is not nil
  (cond ((integerp name)
	 (let ((node (concat "N" name)))
	       (cond ((boundp node) (eval node))
                     (t *EXPL-NODE*))))
	((null name) *EXPL-NODE*)
        ((boundp name) (eval name))
	(t *EXPL-NODE*)))



(defun concat (str num)
;    Concatenates the given string with the given number and coerces
; the result into a new symbol.  This is used primarily to produce node names
; from a node number, i.e.  (concat "n" 3) => n3
    (intern (concatenate 'string str (princ-to-string num))))



(defun node-to-number (node)
  "transforms from a node name in the format n3 to 3"
  (cond ((node-p node) (n-t-n node))
        ((equalp (char (princ-to-string node) 0) #\n) 
	 (parse-integer (princ-to-string node) :start 1)) 
        (t node)))
 

(defun n-t-n (node)
   (declare (type node node))
  "Takes a node of the form n# and returns #, i.e. n19 -> 19
   It uses parse-integer to parse out the number starting at the 2nd
   character in the string."
    (let ((n (parse-integer (princ-to-string (node-name node)) :start 1)))
	 (cond ((> n (length *NODE-LIST*)) 1)
	       (t n))))

; ----------------------------------------------------------------------

(defun get-orig-scr-select (sc-rule)
; given the name of a select rule {sc-rule}, returns the rule. 
  (or 
   (eq sc-rule 'ABS-SELECT-BINDINGS)
   (assoc sc-rule *SCR-NODE-SELECT-RULES*)
   (assoc sc-rule *SCR-GOAL-SELECT-RULES*)
   (assoc sc-rule *SCR-OP-SELECT-RULES*)
   (assoc sc-rule *SCR-BINDINGS-SELECT-RULES*)))

(defun get-orig-scr-reject (sc-rule)
; given the name of a reject rule {sc-rule}, return the rule. 
  (or
   (eq sc-rule 'ABS-REJECT-OPERATOR)
   (assoc sc-rule *SCR-NODE-REJECT-RULES*)
   (assoc sc-rule *SCR-GOAL-REJECT-RULES*)
   (assoc sc-rule *SCR-OP-REJECT-RULES*)
   (assoc sc-rule *SCR-BINDINGS-REJECT-RULES*)))

(defun get-orig-scr-prefer (sc-rule)
; given the name of a preference rule {sc-rule}, return the rule. 
  (or
   (assoc sc-rule *SCR-NODE-PREFERENCE-RULES*)
   (assoc sc-rule *SCR-GOAL-PREFERENCE-RULES*)
   (assoc sc-rule *SCR-OP-PREFERENCE-RULES*)
   (assoc sc-rule *SCR-BINDINGS-PREFERENCE-RULES*)))
      

; ======================================================================
;                  File and Directory Print Functions
; ======================================================================
  
(defun prinmat-list (list &optional (indent 0) (max-column-width 80))
  "prints a list in matrix format."
  (let* ((i 0) (j 0) (k 0) (item nil) (items list)
	 (quant (length items)) 
	 (col-width (progn 
		      (psetq j 0 k 0)
		      (+ 3 (dolist (item items k) 
			     (setq j (length item))
			     (if (> j k) (setq k j))))))
	 (width (- max-column-width indent))
	 (cols (max (truncate width col-width) 1))
	 (lines (ceiling quant cols)))
    (declare (fixnum cols lines width col-width quant i j k)
	     (list items) (simple-string item)
		(ignore i))
    (format t "~VT" indent)
    (dotimes (i lines)
      (dotimes (j cols nil)
	(when (setq item (nth (+ i (the fixnum (* j lines))) items))
	  (format t "~VA" col-width item))
	(when (= j (1- cols))  (terpri) (format t "~VT"indent))))))


; ----------------------------------------------------------------------


(defun printdir (dir &optional (indent 2)
		     &aux (direct (directory-list dir)))
  "print a directory given a string."
  (prinmat-list direct indent)
  direct)



(defun directory-list (d)
  (delete "" (mapcar #'file-namestring (my-directory d)) :test #'equal))



(defun my-directory (name)
 "returns a list of pathnames for all files and subdirectories"
#+:coral (append (directory (concatenate 'string name "*:"))
                 (directory (concatenate 'string name "**")))
#-:coral (directory name)
)

; ----------------------------------------------------------------------

(defun printlispdir (dir &optional (indent 2)
			 &aux (direct (directory-lispfile-list dir)))
  "print a directory of lisp files given a string."
  (prinmat-list direct indent) 
  direct)


(defun directory-lispfile-list (d)
  "returns a list of all the .lisp, .lsp, or .l files in a directory"
  (delete "" (mapcar #'lispfile-namestring
		     (my-directory d)) :test #'equal))


(defun lispfile-namestring (pathname)
  "returns a truncated lisp file name, or the entire file name for non-lisp
  for non lisp files."
  (setq pathname (file-namestring pathname))
  (if (or (string-equal ".lisp" (seq-last pathname 5)) 
	  (string-equal ".fasl" (seq-last pathname 5)))
      (seq-butlast pathname 5)
      pathname))

; ----------------------------------------------------------------------


(defun printsubdirs (dir &optional (indent 2) &aux 
			 (subdirs (directory-subdir-list dir)))
  ;; print a subdirectory given a directory name
  (prinmat-list subdirs indent)
  subdirs)


(defun directory-subdir-list (d)
  (delete nil (delete "" (mapcar #'subdir-namestring 
				 (my-directory d)) :test #'equal)))

(defun subdir-namestring (pathname)
  #-(or :lucid :franz-inc) (when 
         (string-equal "" (file-namestring pathname))
    (setq pathname (seq-butlast (namestring pathname)))
    (subseq pathname (1+ (search *DIRECTORY-SEPARATOR* pathname 
				:from-end t :test #'equal))))

  #+(or :lucid :franz-inc) (file-namestring pathname)

)


; ======================================================================
;                       EBL   MODULE    DEFINITIONS
; ======================================================================


;  THE-ACTIVATE-EBL-COMMAND toggles the EBL learning on or off

(defun toggle-ebl ()
  (if (boundp '*ACTIVATE-EBL*)
      (progn
	(setq *ACTIVATE-EBL* (not *ACTIVATE-EBL*))
	(format t "~%  Learning system is now ~:[disabled~;enabled~]."
		*ACTIVATE-EBL*)
	(cond ((and *ACTIVATE-EBL* (boundp '*LAST-LOAD-DOMAIN-TIME*)
                   (< *LAST-LOAD-DOMAIN-TIME* *LOAD-EBL-TIME*))
	       (format t "~%  Domain was loaded before EBL module.")
	       (format t "~%  Reloading domain for you...")
	       (load-domain))))
    (format t "~2%  ERROR: Learning module has not been loaded.")))


; ======================================================================


;  THE-EBL-PRINTING-COMMAND toggles verbose printing in EBL on or off

(defun toggle-ebl-text ()
  (if (boundp '*EBL-PRINTING*)
      (progn
	(setq *EBL-PRINTING* (not *EBL-PRINTING*))
	(format t
	 "~% Verbose display of EBL information is now ~:[disabled~;enabled~]."
	 *EBL-PRINTING*))
    (format t "~2%  ERROR: Learning module has not been loaded.")))



; ======================================================================


; THE-EXPAND-ALL-COMMAND

(defun toggle-expand ()
  (if (boundp '*EXPAND-ALL*)
      (progn
	(setq *EXPAND-ALL* (not *EXPAND-ALL*))
	(format t
	 "~%  Expansion of all nodes is now ~:[disabled~;enabled~]."
	 *EXPAND-ALL*))
    (format t "~2%  ERROR: Learning module has not been loaded.")))



; ======================================================================


; THE-SHOW-RULES-COMMAND will display the active rules in the EBL system

(defun the-show-rules-command ()
  (if *EBL-FLAG*
      (show-rules)
    (format t "~2%  ERROR: Learning module has not been loaded.")))



; ======================================================================


; THE-FORGET-RULES-COMMAND has three possibile inputs:
; 'ALL -- delete all of the rules
; #### -- a number representing the number of rules to forget
; Ri Rj ... Rz -- a list of rule names to be deleted


(defun the-forget-rules-command (args)
  (if (null *EBL-FLAG*)
      (format t "~2%  ERROR: Learning module has not been loaded.")
    (apply #'forget-rules args)))


; ======================================================================


(defun the-read-rules-command (filenm)
  (cond ((null *ebl-flag*)
	 (format t "~2%  ERROR: Learning module has not been loaded."))
	((null filenm)
	 (format t "~2%  Try: read-rules \"filename\""))
	((stringp filenm) (read-rules filenm))
	(t (format
	    t "~2%  ERROR: The argument to read-rules must be a string"))))



; ======================================================================


(defun the-write-rules-command (filenm)
  (cond ((null *ebl-flag*)
	 (format t "~2%  ERROR: Learning module has not been loaded."))
	((null filenm)
	 (format t "~2%  Try: write-rules \"filename\""))
	((stringp filenm) (write-rules filenm))
	(t (format
	    t "~2%  ERROR: The argument to write-rules must be a string"))))



; ======================================================================
;               END   OF   FILE    commands.lisp 
; ======================================================================
