#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *ALL-NODES* *LEARNED-RULES-IN-SYS* *TRIM-FACTOR* 
	     *RULE-LST-NMS* *LAST-TRIMMED-RULES* *LEARNING-MODE*))


(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


(defun utility-est (h exp est-cost)
  (if (and (not (get h 'dont-make-rule))
	   (not (has-funny-preds exp)))
      (let*  ((tc-nm (car (get h 'te)))
	      (est-savings (apply (get tc-nm 'savings-estimator) (list h))))
	(setf (get h 'est-savings) est-savings) 
	(setf (get h 'est-cost) est-cost)
	(> est-savings est-cost))))

; if a expression has one of these predicates, then it is automatically
; estimated to be not useful. (These predicates only show up for results
; that are obviously intermediate results -- we are assuming that the
; final results should be easily human readable).

(defun has-funny-preds (exp)
  (or (r-memq 'previous-state-diff exp)
      (r-memq 'alt-on-deck exp)))

; currently node times are nil for nodes added after planning 
; (i.e. nodes added to check that an interaction exists).

(defun sum-savings (nodes)
  (g-loop (init ret-val 0)
	  (while nodes)
	  (do (setq ret-val (+ ret-val (or (node-cum-time (car nodes)) 0))))
	  (next nodes (cdr nodes))
	  (result ret-val)))

(defun max-node-time (nodes)
  (g-loop (init ret-val 0)
	  (while nodes)
	  (do (cond ((> (or (node-cum-time (car nodes)) 0)
			ret-val)
		     (setq ret-val (node-cum-time (car nodes))))))
	  (next nodes (cdr nodes))
	  (result ret-val)))


; gives nodes saved
(defun fails-sav-est (h)
    (sum-savings (list (getn h))))
	  

; sum of children savings, plus estimate of time taken to generate children

(defun goal-fails-sav-est (h)
  (let ((subchildren 	
	 (g-map (c in (get h 'children))
		(when (equal (alt-goal (node-generating-alt c))
			     (get h 'h-goal)))
		(save c))))
    (+ (sum-savings subchildren)
       (/ (* (node-time (getn h)) (length subchildren))
	  (length (get h 'children))))))


(defun op-fails-sav-est (h)
  (let* ((op (cadddr (get h 'te)))
	 (goal (caddr (get h 'te)))
	 (subchildren
	    (g-map (c in (get h 'children))
		   (when (and (eq op (alt-op (node-generating-alt c)))
			      (equal goal (alt-goal (node-generating-alt c)))))
		   (save c))))
    (+ (sum-savings subchildren)
       (/ (* (node-time (getn h)) (length subchildren))
	  (length (get h 'children))))))



(defun bindings-fail-sav-est (h)
    (+ (/ (node-time (getn h)) (length (node-children (getn h))))
       (sum-savings
	   (list (get h 'the-child-with-bindings)))))


(defun sole-goal-sav-est (h)
  (let ((subchildren 	
	 (g-map (c in (get h 'children))
		(when (not (equal (alt-goal (node-generating-alt c))
				  (get h 'h-goal))))
		(save c))))
    (+ (sum-savings subchildren)
       (/ (* (node-time (getn h)) (length subchildren))
	  (length (get h 'children))))))


(defun sole-op-sav-est (h)
  (let* ((op (cadddr (get h 'te)))
	 (goal (caddr (get h 'te)))
	 (subchildren
 	    (g-map (c in (node-children (getn h)))
		   (when (and (not (eql op (alt-op (node-generating-alt c))))
			      (equal goal (alt-goal (node-generating-alt c)))))
		   (save c))))
    (+ (sum-savings subchildren)
       (/ (* (node-time (getn h)) (length subchildren))
	  (length (node-children (getn h)))))))


(defun goal-succeeds-sav-est (h)
    (let* ((goal (caddr (get h 'te)))
	   (subchildren
	       (g-map (c in (node-children (getn h)))
		      (when (not (equal goal (alt-goal (node-generating-alt c)))))
		      (save c))))
	 (+ (sum-savings subchildren)
	    (/ (* (node-time (getn h)) (length subchildren))
		  (length (node-children (getn h)))))))

(defun op-succeeds-sav-est (h)
    (let* ((op (cadddr (get h 'te)))
	   (goal (caddr (get h 'te)))
	   (subchildren
	     (g-map (c in (node-children (getn h)))
		   (when (and (not (eql op (alt-op (node-generating-alt c))))
			      (equal goal (alt-goal (node-generating-alt c)))))
		     (save c))))
	 (+ (sum-savings subchildren)
	    (/ (* (node-time (getn h)) (length subchildren))
		  (length (node-children (getn h)))))))


(defun bindings-succeed-sav-est (h)
    (let ((subchildren (g-map (c in (node-children (getn h)))
		              (when (not (node-success-child c)))
		              (save c))))
	 (+ (sum-savings subchildren)
	    (/ (* (node-time (getn h)) (length subchildren))
		  (length (node-children (getn h)))))))



; This code is not currently used, because node preference rules
; were not implemented in version1 prodigy, and I haven't yet tested
; the utility of these rules for version2. (See the selection heuristic
; for node-interacts in select.lisp").
	
(defun interacts-sav-est (h)
    (let ((good-brother (get-succ-node-with-no-interact 
			    (node-children (node-parent (getn h))))))
	 (cond ((null good-brother)
		(format t "~%interacts-sav-est: can't find good brother")
		(warning-stop))
	       ((node-failure-reason (getn h))
		(sum-savings (list (getn h))))
         ; +20 is fixed factor -- should change this obviously
	       (t (+ 20 (- (sum-savings (list (getn h)))
			   (sum-savings (list good-brother))))))))

; gets a brother node that succeeded without an interaction

(defun get-succ-node-with-no-interact (nodes)
    (g-loop (while nodes)
	  (do (and (node-success-child (car nodes))
		   (eq 'no (node-gi-label (car nodes)))
		   (return (car nodes))))
	  (next nodes (cdr nodes))))

		
(defun goal-interacts-sav-est (h)
  (prog (goal good-guy bad-guys failures failure-savings shorter-savings)
	(setq goal (caddr (get h 'te)))
	(setq good-guy 
	      (car (g-map (c in (node-children (getn h)))
			  (when (and (eq 'no (node-gi-label c))
				     (node-success-child c)
				     (not (equal goal
						 (alt-goal
						  (node-generating-alt c))))))
			  (save c))))
	(dolist (c (node-children (getn h)))
		(cond ((equal goal (alt-goal (node-generating-alt c)))
		       (cond ((node-failure-reason c)
			      (push c failures))
			     (t (push c bad-guys))))))
	(cond ((or (null good-guy)
		   (and (null bad-guys)
			(null failures)))
	       (format t "~%goal interacts-sav-est: can't find somebody")
	       (warning-stop)))
	(cond ((not-shorter-path good-guy bad-guys)
	       (format t "~%interaction path is as short")
	       (return 0)))
	(setq failure-savings ; hack estimate
	      (or (and failures (/ (sum-savings failures) 2))
		  0))
        (setq shorter-savings
	      (or (if bad-guys (- (max-node-time bad-guys)
			          (get-total-node-time good-guy)))
		  0))
        (return (cond ((plusp shorter-savings)
		       (+ shorter-savings failure-savings))
		      (t failure-savings)))))

		

(defun op-interacts-sav-est (h)
  (prog (op goal good-guy bad-guys failures failure-savings shorter-savings)
	(setq op (cadddr (get h 'te)))
	(setq goal (caddr (get h 'te)))
	(setq good-guy 
	      (car (g-map (c in (get h 'children))
			  (when (and (eq 'no (node-gi-label c))
				     (node-success-child c)
				     (not (eq op (alt-op (node-generating-alt c))))
				     (equal goal (alt-goal (node-generating-alt c)))))
			  (save c))))
	(dolist (c (get h 'children))
		(cond ((and (eq op (alt-op (node-generating-alt c)))
			    (equal goal (alt-goal (node-generating-alt c))))
		       (cond ((node-failure-reason c)
			      (push c failures))
			     ((and (eq 'yes (node-gi-label c))
				   (not (node-eql c good-guy)))
			      (push c bad-guys))))))
	(cond ((not-shorter-path good-guy bad-guys)
	       (format t "~%interaction path is as short")
	       (return 0)))
	(cond ((or (null good-guy)
		   (and (null bad-guys)
			(null failures)))
	       (format t "~%op interacts-sav-est: can't find somebody")
	       (warning-stop)))
	;; use avr case for failures, optomistic so no fixed val added
	;; if there are failures.
	(setq failure-savings 
	      (or (and failures (/ (sum-savings failures) 2))
		  0))
        (setq shorter-savings
	      (or (if bad-guys (- (max-node-time bad-guys)
			          (get-total-node-time good-guy)))
		  0))
        (return (cond ((plusp shorter-savings)
		       (+ shorter-savings failure-savings))
		      (t failure-savings)))))



(defun bindings-interact-sav-est (h)
  (let* ((bindings-child (get h 'the-child-with-bindings))
	 (good-guy 
	  (car (g-map (c in (get h 'children))
		      (when (and (eq 'no (node-gi-label c))
				 (node-success-child c)
				 (not (node-eql c bindings-child))))
		      (save c)))))
    (cond ((null good-guy)
	   (format t "~%bindings interacts-sav-est: can't find somebody")
	   (warning-stop))
	  ((not-shorter-path good-guy (list bindings-child))
	   (format t "~%interaction path is as short")
	   0)
	  ;; use avr case for failures, optimistic so no fixed val added
	  ((node-failure-reason bindings-child)
	   (sum-savings (list bindings-child)))
	  ((plusp (- (sum-savings (list bindings-child))
		     (get-total-node-time good-guy)))
	   (- (sum-savings (list bindings-child))
	      (get-total-node-time good-guy)))
	  (t 0))))



(defun not-shorter-path (good-guy bad-guys)
  (let ((good-length (get-s-path-length good-guy)))
    (some  #'(lambda (bad-guy) 
	       (and (node-success-child bad-guy)
		    (not (< good-length 
			    (get-s-path-length bad-guy)))))
	   bad-guys)))



(defun get-s-path-length (n)
    (cond ((null n) (error "get-s-path-length"))
	  ((is-final-success-node n) 0)
	  ((node-applied-node n)
	   (1+ (get-s-path-length (node-success-child n))))
	  ((get-s-path-length (node-success-child n)))))
	

(defun is-final-success-node (n)
    (and (eq '*FINISH* (alt-op (node-generating-alt n)))
	 (node-applied-node n)))
    


(setq *RULE-LST-NMS*
      '(*SCR-NODE-SELECT-RULES*  
	*SCR-GOAL-SELECT-RULES*  
	*SCR-OP-SELECT-RULES*  
	*SCR-BINDINGS-SELECT-RULES*
	*SCR-NODE-REJECT-RULES*  
	*SCR-GOAL-REJECT-RULES*  
	*SCR-OP-REJECT-RULES*  
	*SCR-BINDINGS-REJECT-RULES*
	*SCR-NODE-PREFERENCE-RULES* 
	*SCR-GOAL-PREFERENCE-RULES* 
	*SCR-OP-PREFERENCE-RULES*  
	*SCR-BINDINGS-PREFERENCE-RULES*))


(defun utility-validation ()
  (mark-success-in-tree (eval 'N1))
  (mark-failure-reasons-in-tree (eval 'N1))
  (g-map (n in *ALL-NODES*)
	 (do (add-savings-times-for-node n)))
  (trim-learned-rules))

      
(defun trim-learned-rules ()
    (setq *LAST-TRIMMED-RULES* nil)
    (g-loop (init tmp-rule-lst-nms *RULE-LST-NMS* r nil trimmed-rules nil)
	  (while tmp-rule-lst-nms)
	  (do (g-loop (init rules (eval (car tmp-rule-lst-nms)))
		    (while (setq r (car (pop rules))))
		    (do (cond ((not (get r 'was-learned)))
			      ((< *TRIM-FACTOR*
				      (- (or (get r 'match-time) 0)
					 (get r 'cum-savings)))
			       (format t "~%rule failed utility validation: ~a" r)
			       (push r trimmed-rules))))))
	  (next tmp-rule-lst-nms (cdr tmp-rule-lst-nms))
	  (result (progn (setq *LAST-TRIMMED-RULES* trimmed-rules)
			 (dolist (nm trimmed-rules)
				 (remove-scr nm))
			 (setq *LEARNED-RULES-IN-SYS* 
			       (del-memq-list trimmed-rules 
				   *LEARNED-RULES-IN-SYS*))
			 (format t "~%REMOVED ~a" trimmed-rules))))
    t)
				
				
(defun show-times ()
    (format t "~%Type:~11@TName:~20@TCum Match Time:~5@TCum Savings:")
    (format t "~%-----~11@T-----~20@T---------------~5@T------------")
    (g-map (rule-lst-nm in *RULE-LST-NMS*)
	  (do (g-loop (init rules (eval rule-lst-nm) r nil)
		    (while (setq r (car (pop rules))))
		    (do (show-time r rule-lst-nm)))))
    (terpri) t)
		    
(defun show-time (r lst-nm)
  (prog (type-nm est-savings cum-match-time additional-match-time
		   cum-savings additional-savings)
    (setq type-nm (subseq (symbol-name lst-nm) 5 16))
    (setq est-savings  (float (/ (or (get r 'est-savings) 0)
				 internal-time-units-per-second)))
    (setq cum-match-time (float (/ (or (get r 'match-time) 0)
				 internal-time-units-per-second)))
    (setq additional-match-time
	  (float (/
		  (- (or (get r 'match-time) 0)
		     (or (get r 'last-match-time) 0))
		  internal-time-units-per-second)))
    (setf (get r 'last-match-time) (or (get r 'match-time) 0)) 
    (setq cum-savings (float (/ (or (get r 'cum-savings) 0)
				internal-time-units-per-second)))
    (setq additional-savings
	  (float (/ (- (or (get r 'cum-savings) 0)
		       (or (get r 'last-savings-time) 0))
		    internal-time-units-per-second)))
    (setf (get r 'last-savings-time) (or (get r 'cum-savings) 0))
    (format t "~&~A    ~A ~4F ~39T ~5F ~45T + ~5F ~58T ~5F ~65T + ~4F "
	    type-nm r est-savings cum-match-time additional-match-time 
	    cum-savings additional-savings)))


(defun backup-times ()
    (g-map (rule-lst-nm in *RULE-LST-NMS*)
	  (do (g-loop (init rules (eval rule-lst-nm) r nil)
		    (while (setq r (car (pop rules))))
		    (do (setf (get r 'match-time)
			      (get r 'last-match-time)))))) 
    (terpri) t)



(defun add-savings-times-for-node (n)
  (dolist (entry (node-reject-node-hst n))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (node-select-goal-hst n))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (node-reject-goal-hst n))
	  (add-savings-for-rule (car entry) entry n)) 
  (dolist (entry (convert-to-old-form (node-goal-pref-hst n)))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (node-select-op-hst n))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (node-reject-op-hst n))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (convert-to-old-form (node-op-pref-hst n)))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (node-select-bindings-hst n))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (node-reject-bindings-hst n))
	  (add-savings-for-rule (car entry) entry n))
  (dolist (entry (convert-to-old-form (node-bindings-pref-hst n)))
	  (add-savings-for-rule (car entry) entry n)))

; had to put this in because commonlisp version of PRODIGY stores
; preferences a bit differently. Each bindings-list for each firing 
; of a rule is stored separately. Convert to store all firings in one entry
; old entry = (rule best bindings object)
; new entry = (rule best bls objs)

(defun convert-to-old-form (entries)
   (g-loop (init ret-val nil)
	   (while entries)
	   (do (g-loop (init rule (caar entries)
			     best (cadar entries)
			     bls nil objs nil)
		       (while (and entries
			           (eq (car (car entries)) rule)
				   (eq (cadr (car entries)) best)))
		       (do (push (caddr (car entries)) bls)
			   (push (cadddr (car entries)) objs))
		       (next entries (cdr entries))
		       (result (push (list rule best
					   (reverse bls) (reverse objs))
					  ret-val))))
	   (result (reverse ret-val))))

	   
	    
(defun add-savings-for-rule (nm entry n)
  (cond ((not (get nm 'was-learned)))
	((and (eq 'prefer (car (get nm 'rhs)))
	      ;; assume all interaction rules are correct
	      (member (car (get nm 'unique-sig)) 
		      '(bindings-succeed op-succeeds
					 goal-succeeds node-succeeds))
	      (pref-was-wrong nm entry n))
	 (format t "~%Pref was wrong ~a ~a" nm n))
	(t (format t "~%Adding savings for rule: ~a at node ~a"
		   nm (node-name n))
	   (setf (get nm 'cum-savings)
		 (+ (get nm 'cum-savings)
		    (get nm 'est-savings))))))
		 

; or at least it didn't help (used for succeeds preferences)

; the tests I left out for goal (and op) are hard to get right.
; the vars in the unique sig aren't necessarily in the rule.

(defun pref-was-wrong (nm entry n)
  (let ((cand-type (cadr (get nm 'rhs)))
	(rec-bad (cadr entry))
	(rec-goods (cadddr entry)))
    (cond ((eq cand-type 'operator)
	   (or (g-map (c in (node-children n))
		      (when (and (eq rec-bad
				     (alt-op (node-generating-alt c)))
				 (node-success-child c)
				 (eq 'no (node-gi-label c))))
		      
		      (save c))
	       (null (g-map (c in (node-children n))
			    (when (and (node-success-child c)
				       ;; dont bother testing for interaction
				       ;; should test for goal
				       (member (alt-op (node-generating-alt c))
					       rec-goods)))
			    (save c)))))
	  ((eq cand-type 'bindings)
	   (null (g-map (c in (node-children n)) 
			(when (and (node-success-child c)
					;should test for goal & op,
				   (one-consistent-bindings rec-goods c)))
			(save c))))
	  ((eq cand-type 'goal)
	   (null (g-map (c in (node-children n))
			(when (and (node-success-child c)
				   (member (alt-goal (node-generating-alt c))
					   rec-goods :test #'equal)))
			(save c))))
	  ((error "nyet impl")))))
    

(defun one-consistent-bindings (vals-lists c)
  (some #'(lambda (vals-list) (is-consistent-bindings vals-list
				   (alt-vars (node-generating-alt c))))
	vals-lists))

(defun is-consistent-bindings (vals-list1 vals-list2)
     (every #'(lambda (v1 v2) (or (is-variable v1)
			          (equal v1 v2)))
	      vals-list1 vals-list2))


