#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

; Contains Proof schemas (i.e. axioms) for Unique-alternative 
; (i.e. sole-alternative) target concepts.

(setq *U-SCHEMAS* '(

(def-uniquely-succeeds-goal
    (sole-goal <node> <u-goal>)
    (forall (<goal>) (candidate-goal <node> <goal>)
        (unique-goal-or-fails <node> <goal> <u-goal>)))


; should be able to make bettet
(def-is-u-goal
    (unique-goal-or-fails <node> <g> <u-goal>)
    (let (<g>) (is-goal-literal <goal>)
	 (and (is-equal <g> <u-goal>)
	      (matches <goal> <g>))))

(def-cached-goal-fails-for-unique
    (unique-goal-or-fails <node> <g> <u-goal>)
    (and (not-equal <g> <u-goal>)
	 (goal-fails <node> <g>)))

(def-regular-goal-fails-for-unique
    (unique-goal-or-fails <node> <g> <u-goal>)
    (and (not-equal <g> <u-goal>)
         (goal-fails <node> <g>)))

;  ---------------------------------------

(def-uniquely-succeeds-op
  (sole-op <node> <goal> <u-op>)
  (forall (<op>) (is-op <op>) 
      (unique-op-or-fails <node> <goal> <op> <u-op>)))

(def-is-u-op
    (unique-op-or-fails <node> <goal> <op> <u-op>)
    (is-equal <op> <u-op>))

(def-cached-op-fails-for-unique
    (unique-op-or-fails <node> <goal> <op> <u-op>)
    (op-fails <node> <goal> <op>))

(def-regular-op-fails-for-unique
    (unique-op-or-fails <node> <goal> <op> <u-op>)
    (let (<g>) (is-goal-literal <g>)
      (and (matches <goal> <g>)
	   (op-fails <node> <g> <op>))))



		 ))
