#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *INCR-LEARNING* *OPTIMIZE-MODE* *ALL-NODES*
                    *NUM-NODES-ADDED*  *HALT-PROBLEM-SOLVER*
		    *MAX-NODES-TO-ADD*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))

; File contains all EBL module fns that invoke the planner.



(defun interaction-check (node)
    (prog (found-no orig-children)
	  (if (member (node-gi-label node) '(above failure))
  	      (return nil))
	  ;  the reverse is a hack to enable me to show an optimal path, and
	  ;  have it look at original children before discovering this path
	  (g-loop (init c nil  children (reverse (node-children node)))
		  (while (setq c (pop children)))
		  (do (interaction-check c)
		      (cond ((eq 'no (node-gi-label c))
			     (setq found-no t))))
		  (until found-no))
	  (cond ((and found-no 	
		      (node-alternatives node)
                      (some #'(lambda (c) (eq 'yes (node-gi-label c)))
                           (node-children node)))
                 ; no interaction at node but has children that did interact
		 (format t "~%Looking for goal, op, or bindings interactions at ~a" node)
		 (setq orig-children (node-children node))
		 (add-nodes-to-tree node)
                 ; have to label new nodes that have been added, and reset
                 ; default candidate-goals
		 (dolist (c (node-children node))
			 (cond ((not (member c orig-children))
                                (reset-candidate-goals c)
                                (mark-success-in-tree c)
                                (mark-failure-reasons-in-tree c))))
 		 (dolist (c (node-children node))
 			 (mark-gi-instances-in-tree c)))
 		 (found-no 
		    (setf (node-gi-label node) 'no))
		((eq 'maybe (node-gi-label node))
		 (setq orig-children (g-map (cc in (node-children node))
					    (save cc)))
		 (add-nodes-to-tree node)
		 (dolist (c (node-children node))
			 (cond ((not (member c orig-children))
                                (reset-candidate-goals c)
                                (mark-success-in-tree c)
                                (mark-failure-reasons-in-tree c))))
		 (setf (node-gi-label node) nil) ; reset gi-label
		 (mark-gi-instances-in-tree node)))))



(defun add-nodes-to-tree (node)
    (format t "~%RESTARTING PROBLEM SOLVER TO VERIFY INTERACTION AT ~a" (node-name node))
    (setf (node-added-nodes-for-gi node) t)
    (setq *INCR-LEARNING* t)
    (setq *OPTIMIZE-MODE* t)
    (setq *NUM-NODES-ADDED* 0)
    (setq *HALT-PROBLEM-SOLVER* nil) ; might be set interactively 
    ; before. should move this into engine.
    (cntrl node '(done))
    ; have to correct for failure reasons added when they shouldnt be..
    (if (node-succeeded node)
	(setf (node-failure-reason node) nil))
    (setq *INCR-LEARNING* nil)
    (setq *HALT-PROBLEM-SOLVER* nil)
    (setq *OPTIMIZE-MODE* nil))




(defun expand-all ()
  (g-loop (init ns *ALL-NODES*)
	  (while ns)
	  (do (cond ((node-alternatives (car ns))
		     (format t "~%Expanding: ~a~%" (car ns))
		     (cntrl (car ns) '(done))))
	      (cond ((null (node-alternatives (car ns)))
		     (setq ns (cdr ns))))))
;; must re-mark success and failure, and reset candidate goals, since 
;; we've added nodes.
  (reset-candidate-goals (eval 'N1))
  (mark-success-in-tree (eval 'N1))
  (mark-failure-reasons-in-tree (eval 'N1)))


; This is called by planner. At the current time, it doesnt invoke the
; incremental learning, just verifies interactions.

; hack city
;  have to make brother checks before expanding nodes...

(defun incremental-ebl-learning (parent child current-alt nodes)
    (and *OPTIMIZE-MODE*
	 child
	 (setf (node-added-after-restart child) t)
	 (setq *NUM-NODES-ADDED* (+ 1 *NUM-NODES-ADDED*))
	 (not (node-failure-reason child))
	 (cond ((hist-protection-violation child t)
		(format t "~%Protection-violation ~a ~a"
		     (node-name child)
		     (node-protection-violation child))
		(setf (node-optimize-mode-failure child) t)
		(setf (node-expanded child) t) 
		(setf (node-expanded child) t) ;just in case
		(setf (node-alternatives child) nil)
		(setf (node-alternatives child) nil))
	       ((and (not-top-level-node child)
		     (hist-prerequisite-violation child  ; wrong - doesnt get
			 ; goal for applied nodes, but OK
			 (car (alt-unmatched-conds ;  ususual 1 goal assumption
				  (node-generating-alt child))) t))
		(format t "~%Prerequisite-violation ~a ~a" (node-name child)
		     (node-prerequisite-violation child))
		(setf (node-optimize-mode-failure child) t)
		(setf (node-expanded child) t)
		(setf (node-expanded child) t)
 		(setf (node-alternatives child) nil)
 		(setf (node-alternatives child) nil))
	       ((and (is-top-level-node child)
		     (g-loop (init g nil gs (alt-unmatched-conds
					      (node-generating-alt child)))
			   (while (setq g (pop gs)))
			   (do (and (hist-prerequisite-violation child g t)
				    (return t)))))
		(format t "~%Prerequisite-violation ~a ~a" (node-name child)
		     (node-prerequisite-violation child))
		(setf (node-optimize-mode-failure child) t)
		(setf (node-expanded child) t) 
		(setf (node-expanded child) t)
		(setf (node-alternatives child) nil)
 		(setf (node-alternatives child) nil))
	       ((> *NUM-NODES-ADDED* *MAX-NODES-TO-ADD*); try this number
		(format t "~%Over node adding limit: ~a" *NUM-NODES-ADDED*)
                (format t "  Cutting off children")
		(pop nodes))))
    nodes)

		
		    
