#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *TP-FNS* *TP-TIME-BOUND* *PROOF-RULES*))

(eval-when (compile) 
	   (load-path *PLANNER-PATH* "g-loop")
	   (load-path *PLANNER-PATH* "g-map")
	   (load-path *PLANNER-PATH* "data-types")
	   (load-path *EBL-PATH*     "ebl-data-types"))

; Note:
; pxp = p-exp
; qxp = q-exp

; note: path is later nconced, so make sure it is consed together

(defun dn-match-pxp (pxp exp path)
  (nconc (match-pxp pxp exp path)
	 (cond ((eq (car exp) 'known)
		(dn-match-pxp pxp (caddr exp) (cons exp path)))
	       ((atomic-formula-p exp) nil)
	       ((member (car exp) '(and or))
		(g-map (sub in (cdr exp))
		       (splice (dn-match-pxp pxp sub (cons exp path)))))
	       ((negated-p exp) nil)
	       ((eq (car exp) 'forall)
		(dn-match-pxp pxp (get-exp exp) (cons exp path)))
	       ((eq (car exp) 'exists)
		(nconc (dn-match-pxp pxp (get-gen-exp exp) (cons exp path))
		       (dn-match-pxp pxp (get-exp exp) (cons exp path)))))))

	 

; returns list of ((exp bindings path)...)

(defun match-pxp (pxp exp path)
  (cond ((not (eql (car pxp)(car exp))) nil)
	((eq (car pxp) 'or)
	 (and (quick-or-match-test pxp exp)
	      (g-map (b in (or-match-pxp (cdr pxp) (cdr exp) '((nil nil))))
		     (save (list exp b path)))))
	((lit-match pxp exp)
	 (list (list exp (lit-match pxp exp) path)))))



(defun quick-or-match-test (pxp exp)
  (if (not (< (length exp) (length pxp)))
      (g-loop (init pxps (cdr pxp) 
		    exp-preds (g-map (pred in (cdr exp))
				     (save (if (eq (car pred) 'known)
					       (caaddr pred)
					     (car pred)))))
	      (while pxps)
	      (do (if (null (member (caar pxps) exp-preds))
		      (return nil)))
	      (next pxps (cdr pxps))
	      (result t))))



; assumes exp is disjunctive
; returns bls

(defun or-match-pxp (pxps exps bindings)
  (g-loop (init orig-exps exps new-bindings nil ret-val nil new-bls nil)
	  (while exps)
	  (do (setq new-bindings 
		    (lit-match2 (car pxps) (if (eq 'known (caar exps))
					       (caddar exps)
					     (car exps))
				bindings))
	      (cond ((null new-bindings)
		     (setq ret-val (nconc new-bls ret-val)))
		    ((null (cdr pxps))
		     (setq new-bls (list new-bindings)))
		    (t
		     (setq new-bls
			   (or-match-pxp (cdr pxps)
					 (del-eq (car exps) orig-exps)
					 new-bindings)))))
	  (next exps (cdr exps))
	  (result ret-val)))

(defun is-implied (exp path)
  (cond ((atom exp) exp)
	((eq (car exp) 'known)
	 (is-implied (caddr exp) path))
	((atomic-formula-p exp)
	 (is-implied-lit exp path))
	((negated-p exp)
	 (if (atomic-formula-p (cadr exp))
	     (is-implied-lit exp path)))
	((eq (car exp) 'and)
	 (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (if (null (is-implied (car exp) path))
			 (return nil)))
		 (result t)))	  
	((eq (car exp) 'or)
	 (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (if (is-implied (car exp) path)
			 (return t)))))))


; right now assume only 1 tp-var per expression

(defun only-tp-vars-is-equals (intermed)
  (and (listp intermed)
       (eq (car intermed) 'is-equal)
       (or (is-tp-variable (cadr intermed))
	   (is-tp-variable (caddr intermed)))
       t))


;  returns t or nil

(defun is-implied-lit (exp path)
  (cond ((assoc (car exp) *TP-FNS*)
	 (apply (car exp) (cons path (cdr exp))))
	((and (not (negated-p exp)) ; what should be done if negated?
	      (assoc (car exp) *SINGLETON-PREDS*)
	      (let ((result (dn-singleton-simplify exp path))
		    intermed)
		(cond ((eq t result) t)
		      ((eq exp result) nil)
		      (t (setq intermed (inner-simplify result path))
			 (cond ((eq t intermed) t)
			       ((eq nil intermed) nil)
			       ((only-tp-vars-is-equals intermed))))))))
	(t (let ((new-exp
		  (cond ((negated-p exp)
			 (cond ((not (member (caadr exp) *META-FUNCTIONS*))
				(list 'known (find-the-node (car (last path)))
				      exp))
			       (exp)))
			((not (member (car exp) *META-FUNCTIONS*))
			 (list 'known (find-the-node (car (last path)))
			       exp))
			(t exp))))
	     (or (eq t (tp-redundancy-elimination new-exp path))
		 (and (negated-p exp)
		      (neg-implied-by-goal (cadr exp) path)))))))


(defun tp-redundancy-elimination (lit path)
  (g-loop (init level nil orig-path path)
	  (while (setq level (pop path)))
	  (do (if (tp-redundant-lit lit level orig-path)
		  (return t)))))



(defun tp-redundant-lit (lit level orig-path)
  (cond ((eq (car level) 'and)
	 (check-for-tp-match lit level))
	((eq (car level) 'forall)
	 (if (atomic-formula-p (get-gen-exp level))
	     (check-for-tp-match  lit (list (get-gen-exp level)))
	   (tp-redundant-lit lit (get-gen-exp level) orig-path)))
	((eq (car level) 'or)
	 (cond ((eq (car lit) 'known)
		(cond ((and (negated-p (caddr lit))
			    (or (closed-predicate (cadr (caddr lit)))
				(function-p (cadr (caddr lit)))))
		       (check-for-tp-match (cadr (caddr lit)) level))
		      ((or (closed-predicate (caddr lit))
			   (function-p  (caddr lit)))
		       (check-for-tp-match (negate (caddr lit)) level))
		      (t (check-for-tp-match (negate lit) level))))
	       ((eq (car lit) 'not-equal)
		(and (assoc 'is-equal level)
		     (or (member (cons 'is-equal (cdr lit)) level
				 :test #'equal)
			 (member (list 'is-equal (caddr lit) (cadr lit))
				 level :test #'equal))))
	       (t (check-for-tp-match (negate lit) level))))))



; assume lit is an atomic formula that is not a meta-fn

(defun check-for-tp-match (lit exp)
  (g-loop (init sub nil)
	  (while (setq sub (pop exp)))
	  (do (and (listp sub)
		   (cond ((eq 'known (car sub))
			  (cond ((eq 'known (car lit))
				 (and (tp-match (caddr lit) (caddr sub))
				      (return t)))
				((tp-match lit (caddr sub))
				 (return t))))
			 ((eq 'known (car lit))
			  (if (tp-match (caddr lit) sub)
			      (return t)))
			 ((tp-match lit sub)
			  (return t)))))))

(defun is-tp-variable (atm)
  (if (symbolp atm)
      (eql '#\$ (char (symbol-name atm) 1))))

(defun tp-match (spec obj)
  (cond ((eq (car spec) '~)
	 (if (eq (car obj) '~)
	     (tp-match (cadr spec)(cadr obj))))
	((eq (car spec)(car obj))
	 (setq spec (cdr spec))
	 (setq obj (cdr obj))
	 (g-loop (init binding-pair nil bindings nil)
		 (while spec)
		 (do (cond ((equal (car spec)(car obj)))
			   ((null (is-tp-variable (car spec)))
			    (return nil))
			   ((setq binding-pair (assoc (car spec) bindings))
				; note eq for efficiency, could be wrong...
			    (if (null (eq (cadr binding-pair) (car obj)))
				(return nil)))
			   (t
			    (push (list (car spec)(car obj)) bindings))))
		 (next spec (cdr spec) obj (cdr obj))
		 (result t)))))


; put path in so simplifier works right...
; right now time includes gc-time...

(defun top-level-tp (exp path)
  (let* ((init-time (get-internal-run-time))
	 (new-exp (tp-provable exp path init-time *TP-TIME-BOUND*))
	 (now-time (get-internal-run-time)))
    (if (> (-  now-time init-time) *TP-TIME-BOUND*)
	(format t "~%TP Time out!!~%"))
    new-exp))


; right now I'm only going to cycle through all rules once.
; An alternative scheme is to record failed (rule exp) pairs, where
; exp is the exp the rule is backchaining against

(defun tp-provable (exp path init-time time-limit)
  (g-loop (init rules *PROOF-RULES* new-exp nil now-time nil)
	  (while rules)
	  (do (setq new-exp (tp-provable-by-rule
			     (car rules) exp path init-time time-limit))
	      (if (eq new-exp 'nope)
		  (setq rules (cdr rules))
		(setq exp (inner-simplify new-exp path)))
	      (setq now-time (get-internal-run-time)))
	  (until (or (atom exp)
		     (> (-  now-time init-time) time-limit)))
	  (result exp)))

		    

; returns 'nope or new exp. have to distinguish between new-exp and nil

(defun tp-provable-by-rule (rule exp path init-time time-limit)
  (g-loop (init pxp-matches (dn-match-pxp (get rule 'p-exp) exp nil)
		pxp-match nil known-cond nil prove-cond nil
		simple-prove-cond nil new-path nil)
	  (while (setq pxp-match (pop pxp-matches)))
	  (do (setq known-cond (subst-bindings (get rule 'known-cond)
					       (cadr pxp-match)))
	      (setq new-path (append (caddr pxp-match) path))
	      (and (is-implied known-cond new-path)
		   (setq prove-cond 
			 (subst-bindings (get rule 'prove-cond)
					 (cadr pxp-match)))
		   (setq simple-prove-cond 
			 (inner-simplify prove-cond new-path))
		   (or (eq t simple-prove-cond)
		       (eq t (tp-provable prove-cond new-path init-time
					  time-limit)))
		   (return (subst-sub-exp 
			    (subst-bindings 
			     (known-convert (get rule 'q-exp) exp)
			     (cadr pxp-match))
			    (car pxp-match) exp 
			    (subst-bindings (get rule 'p-exp) (cadr pxp-match))
			    new-path))))
	  (result 'nope)))

(defun known-convert (qxp exp)
  (if (all-meta-preds qxp)
      qxp
    (known-simplify 
     (list 'known (or (find-the-node exp) (error "couldnt find node")) qxp))))

; just finds a node in the expression...

(defun find-the-node (exp)
  (cond ((atom exp) nil)
	((atomic-formula-p exp)
	 (cond ((member (car exp) '(primary-candidate-goal known current-goal
							   is-top-level-goal))
		(cadr exp))))
	((member (car exp) '(exists forall))
	 (or (find-the-node (get-gen-exp exp))
	     (find-the-node (get-exp exp))))
	((negated-p exp) (find-the-node (cadr exp)))
	(t
	 (g-loop (init ret-val nil)
		 (next exp (cdr exp))
		 (while exp)
		 (do (setq ret-val (find-the-node (car exp)))
		     (if ret-val (return ret-val)))))))



; places a known around non-meta-predicates

(defun all-meta-preds (exp)
  (cond ((atom exp) t)
	((atomic-formula-p exp)
	 (meta-level-p exp))
	((member (car exp) '(exists forall))
	 (and (all-meta-preds (get-gen-exp exp))
	      (all-meta-preds (get-exp exp))))
	((member (car exp) '(and or))
	 (g-loop (next exp (cdr exp))
		 (while exp)
		 (do (if (null (all-meta-preds (car exp)))
			 (return nil)))
		 (result t)))
	((negated-p exp) (all-meta-preds (cadr exp)))
	((error "all-meta-preds, bad exp type"))))


(defun subst-sub-exp (qxp real-pxp big-exp rule-pxp path)
  (r-subst-sub-exp qxp real-pxp big-exp rule-pxp (cons real-pxp path)))

(defun r-subst-sub-exp (qxp real-pxp big-exp rule-pxp path)
  (cond ((null (eq real-pxp big-exp))
	 (g-loop (init orig-big-exp big-exp)
		 (while big-exp)
		 (do (if (member (car big-exp) path)
			 (return (my-subst (r-subst-sub-exp
					    qxp real-pxp (car big-exp)
					    rule-pxp path)
					   (car big-exp) orig-big-exp))))
		 (next big-exp (cdr big-exp))
		 (result (error "r-subst-sub-exp: no find"))))
	((atomic-formula-p real-pxp) qxp)
	((negated-p real-pxp) qxp)
	((null (eq (car real-pxp) 'or))
	 (error "r-subst-sub-exp: nyet handled"))
	((eq (length real-pxp) (length rule-pxp)) qxp)
	((eq t qxp) qxp) ; not needed, just fast
	(t (cons 'or (cons qxp (g-map (sub in (cdr real-pxp))
				      (when (null (member sub rule-pxp
							  :test #'equal)))
				      (save sub)))))))



;  does an eq test, only on the top-level
(defun my-subst (new old big)
  (cond ((null big) (error "MY-SUBST: null big"))
	((eq old (car big))
	 (cons new (cdr big)))
	(t (cons (car big) (my-subst new old (cdr big))))))

; should really move this into simplifier!

(defun only-single-mention (path var)
  (if (is-variable var)
      (< (r-only-single-mention var (car (last path))) 2)))

(defun r-only-single-mention (var exp)
  (cond ((atom exp) 0)
	((atomic-formula-p exp)
	 (cond ((eq 'known (car exp))
		(r-only-single-mention var (caddr exp)))
	       ((r-memq var exp) 1)
	       (t 0)))
	((negated-p exp)
	 (r-only-single-mention var (cadr exp)))
	((member (car exp) '(exists forall))
	 (+ (r-only-single-mention var (get-gen-exp exp))
	    (r-only-single-mention var (get-exp exp))))
	(t (g-loop (init sum 0)
		   (next exp (cdr exp))
		   (while exp)
		   (do (setq sum
			     (+ sum (r-only-single-mention var (car exp)))))
		   (result sum)))))


; scope of quantifications is COMPLETELY gen-pred.

; eg. (forall (<obj>) (object <obj>) (and (p <obj>)(q <obj>)) 
; is good for <obj> starting from p or q.
; however, shouldnt fire for (forall (<obj>) (object <obj>)
;				     (or (c <obj>) (and (p <obj>)(q <obj>)))


(defun complete-univ-quantified-var (path var gen-pred)
  (g-loop (init exp nil)
	  (while (setq exp (pop path)))
	  (do (if (and (eq (car exp) 'forall)
		       (or (eq (car (get-gen-exp exp)) gen-pred)
			   (and (eq (car (get-gen-exp exp)) 'known)
				(eq (caaddr (get-gen-exp exp)) gen-pred)))
		       (member var (get-vars-lst exp)))
		  (return t)
		(if (eq (car exp) 'or) (return nil))))))

; scope test takes two vars, tests that v1 is outside scope of v2
; where v1 is existential and v2 is universal

(defun f-outside-scope (path v1 v2)
  (r-outside-scope (reverse path) v1 v2))

(defun r-outside-scope (r-path v1 v2)
  (let ((path-exp (car r-path)))
				; exists must be single var, do one at a time
    (cond ((and (eq (car path-exp) 'exists)
		(member v1 (get-vars-lst path-exp)))
	   t)
	  ((and (eq (car path-exp) 'and) ; wrong assumes order can't effect
					 ; quantifiers....
		(g-loop (init subexps (cdr path-exp))
			(while subexps)
			(do (cond ((eq (car subexps) (cadr r-path)))
				  ((member (caar subexps) '(forall or)))
				  ((eq (caar subexps) 'known)
				   (and (member v1 (caddar subexps))
					(return t)))
				  ((r-memq v1 (car subexps))
				   (return t))))
			(next subexps (cdr subexps)))))
	  ((and (eq 'forall (car path-exp))
		(member v2 (get-vars-lst path-exp)))
	   nil)
	  ((null path-exp)
	   (error "cant find vars!"))
	  (t (r-outside-scope (cdr r-path) v1 v2)))))
